/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.portlet.admin.mbeans.tasks.PDDPUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PDProviderEntryGenerator;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class PDUNDeploy {
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private Properties configProps = null;

    public PDUNDeploy(Properties pdconfigProp) throws PortletDeployerException {
        this.configProps = pdconfigProp;
    }

    public void process(AdminDPContext dadc, String dn, boolean global, String warName, boolean verbose, Logger logger) throws PortletDeployerException {
        String ddLocation;
        if (verbose) {
            logger.info("PSPL_CSPPAMT0003");
        }
        if (!new File(ddLocation = this.configProps.getProperty(DD_LOCATION), warName + ".war").exists()) {
            Object[] tokens = new Object[]{warName};
            throw new PortletDeployerException("errorInvalidWebAppName", tokens);
        }
        String ddName = warName + DD_SUFFIX;
        FileInputStream in = null;
        File portletFile = null;
        try {
            portletFile = new File(ddLocation, ddName);
            in = new FileInputStream(portletFile);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ddLocation + File.separator + ddName, warName + ".war"};
            throw new PortletDeployerException("errorStreamReadWhileUndeploy", ioe, tokens);
        }
        if (verbose) {
            logger.info("PSPL_CSPPAMT0008");
        }
        PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(in, null, this.configProps, warName);
        List providerNames = providerGen.getProviderNames();
        try {
            ((InputStream)in).close();
        }
        catch (IOException ioe) {
            throw new PortletDeployerException("errorStreamClose", ioe);
        }
        if (verbose) {
            logger.info("PSPL_CSPPAMT0011");
        }
        PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose, logger);
        dpUpdater.removeProviders(providerNames);
        if (portletFile != null) {
            portletFile.delete();
        }
    }
}

