/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.portlet.admin.mbeans.tasks.PDDPUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PDProviderEntryGenerator;
import com.sun.portal.portlet.admin.mbeans.tasks.PDWarUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PDWebAppUpdater;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class PDDeploy {
    private static final String WEB_XML = "web.xml";
    private static final String PORTLET_XML = "portlet.xml";
    private static final String EXT_XML = "sun-portlet.xml";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private static final String WAR_SUFFIX = ".war";
    private Properties configProps = null;

    public PDDeploy(Properties pdconfigProp) throws PortletDeployerException {
        this.configProps = pdconfigProp;
    }

    public String[] process(AdminDPContext dadc, String dn, boolean global, File warFile, Properties rolesProperties, Properties userinfoProperties, boolean verbose, Logger logger) throws PortletDeployerException {
        PDWarUpdater pdwr = null;
        JarFile jar = null;
        String warName = warFile.getName();
        String portletAppName = warName.substring(0, warName.indexOf(46));
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        String[] filesModified = new String[2];
        if (verbose) {
            logger.info("PSPL_CSPPAMT0002");
        }
        try {
            pdwr = new PDWarUpdater(warFile, this.configProps);
            jar = pdwr.getJarFile();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{warName};
            throw new PortletDeployerException("errorGettingJarFile", ioe, tokens);
        }
        if (verbose) {
            logger.info("PSPL_CSPPAMT0003");
        }
        InputStream in = null;
        try {
            int bytesRead;
            ZipEntry portletXMLEntry = jar.getEntry("WEB-INF/portlet.xml");
            in = jar.getInputStream(portletXMLEntry);
            InputStream portletIn = jar.getInputStream(portletXMLEntry);
            String ddName = portletAppName + DD_SUFFIX;
            filesModified[0] = ddLocation + File.separatorChar + ddName;
            File portletFile = new File(ddLocation, ddName);
            portletFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(portletFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = portletIn.read(buffer)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{portletAppName + DD_SUFFIX};
            throw new PortletDeployerException("errorStreamRead", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new String[]{"WEB-INF/portlet.xml"};
            throw new PortletDeployerException("invalidWar", ex, tokens);
        }
        if (verbose) {
            logger.info("PSPL_CSPPAMT0004");
        }
        InputStream webXMLStream1 = null;
        List roles = new ArrayList();
        try {
            ZipEntry webXMLEntry = jar.getEntry("WEB-INF/web.xml");
            webXMLStream1 = jar.getInputStream(webXMLEntry);
            roles = PDWebAppUpdater.getRoles(webXMLStream1);
        }
        catch (IOException ioe) {
            throw new PortletDeployerException("errorGettingRoles", ioe);
        }
        catch (PortletDeployerException pde) {
            throw new PortletDeployerException("errorGettingRoles", pde);
        }
        catch (Exception ex) {
            Object[] tokens = new String[]{"WEB-INF/web.xml"};
            throw new PortletDeployerException("invalidWar", ex, tokens);
        }
        InputStream extStream = null;
        try {
            ZipEntry extXMLEntry = jar.getEntry("WEB-INF/sun-portlet.xml");
            if (extXMLEntry != null) {
                extStream = jar.getInputStream(extXMLEntry);
            }
        }
        catch (IOException ioe) {
            throw new PortletDeployerException("errorGettingExtension", ioe);
        }
        catch (Exception ex) {
            Object[] tokens = new String[]{"WEB-INF/sun-portlet.xml"};
            throw new PortletDeployerException("invalidWar", ex, tokens);
        }
        PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(in, extStream, this.configProps, portletAppName);
        List providerElements = providerGen.createProviderElements(rolesProperties, userinfoProperties, roles);
        if (verbose) {
            logger.info("PSPL_CSPPAMT0005");
        }
        File newWebXMLFile = null;
        InputStream webXMLStream2 = null;
        try {
            ZipEntry webXMLEntry = jar.getEntry("WEB-INF/web.xml");
            webXMLStream2 = jar.getInputStream(webXMLEntry);
            newWebXMLFile = PDWebAppUpdater.addWebAppParam(webXMLStream2, this.configProps, portletAppName);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletDeployerException("errorUpdatingWebApp", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{portletAppName};
            throw new PortletDeployerException("errorUpdatingWebApp", ex, tokens);
        }
        try {
            webXMLStream1.close();
            webXMLStream2.close();
            in.close();
        }
        catch (IOException ioe) {
            throw new PortletDeployerException("errorStreamClose", ioe);
        }
        String warFileName = portletAppName + WAR_SUFFIX;
        try {
            File newWarFile = pdwr.getUpdatedWarFile(newWebXMLFile);
            if (newWarFile == null) {
                Object[] tokens = new Object[]{warFileName};
                throw new PortletDeployerException("errorJarUpdate", tokens);
            }
            File destFile = new File(ddLocation, warFileName);
            PDDeploy.copyFile(newWarFile, destFile, true, false);
            newWarFile.delete();
            warFileName = destFile.getAbsolutePath();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{warFileName};
            throw new PortletDeployerException("errorJarUpdate", ioe, tokens);
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{warFileName};
            throw new PortletDeployerException("errorJarUpdate", ex, tokens);
        }
        if (verbose) {
            logger.info("PSPL_CSPPAMT0006");
        }
        PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose, logger);
        dpUpdater.addProviders(providerElements);
        filesModified[1] = warFileName;
        return filesModified;
    }

    public static void copyFile(String sourceFile, String destFile) throws IOException {
        PDDeploy.copyFile(new File(sourceFile), new File(destFile), false, true);
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if (!(parent = new File(destFile.getParent())).exists()) {
                parent.mkdirs();
            }
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                out.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            in.close();
            out.close();
            if (preserveLastModified) {
                destFile.setLastModified(sourceFile.lastModified());
            }
        }
    }
}

