/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class PDDPUpdater {
    private AdminDPContext dadc = null;
    private String dn = null;
    private boolean verbose = false;
    private boolean global = false;
    private static Logger logger;
    public static final int CONTEXT_LINE_NUM = 5;
    XMLDPFactory dpf = XMLDPFactory.getInstance();

    public PDDPUpdater(AdminDPContext dadc, String dn, boolean global, boolean verbose, Logger logger) {
        this.dadc = dadc;
        this.dn = dn;
        this.global = global;
        this.verbose = verbose;
        PDDPUpdater.logger = logger;
    }

    public void addProviders(List providerElements) throws PortletDeployerException {
        DPRoot dpr = this.getDPRoot();
        dpr.setDummy(false);
        for (int i = 0; i < providerElements.size(); ++i) {
            Element element = (Element)providerElements.get(i);
            dpr = this.addProvider(dpr, element);
        }
        if (this.verbose) {
            logger.info("PSPL_CSPPAMT0007");
        }
        String dpDoc = null;
        try {
            dpr = this.setDirty(dpr);
            dpDoc = dpr.toString();
            this.dpf.createRoot((DPContext)this.dadc, dpDoc);
        }
        catch (DesktopError de) {
            Throwable wrapped = de.getCause();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens = new Object[]{PDDPUpdater.getLines(new StringReader(dpDoc), linenum)};
                throw new PortletDeployerException("errorInvalidXMLText", de, tokens);
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorInvalidXML", ex);
        }
        this.storeDPDocument(dpr);
    }

    public DPRoot addProvider(DPRoot dpr, Element element) throws PortletDeployerException {
        if (this.verbose) {
            Object[] tokens = new Object[]{element.getAttribute("name")};
            logger.log(Level.INFO, "PSPL_CSPPAMT0006", tokens);
            logger.info("PSPL_CSPPAMT0009");
        }
        DPProvider p = null;
        try {
            p = this.dpf.getProvider((DPContext)this.dadc, dpr, element);
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorCreateDPProvider", ex);
        }
        if (this.verbose) {
            Object[] tokens = new Object[]{p.getName()};
            logger.log(Level.INFO, "PSPL_CSPPAMT0010", tokens);
        }
        boolean dupFound = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            boolean bl = dupFound = xdpr.getChannelFromThis(p.getName()) != null;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(p.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorCheckDupName", ex);
        }
        if (dupFound) {
            Object[] tokens = new Object[]{p.getName()};
            logger.log(Level.FINEST, "PSPL_CSPPAMT0014", tokens);
        } else {
            try {
                dpr.addProvider(p);
            }
            catch (Throwable ex) {
                Object[] tokens = new Object[]{p.getName()};
                throw new PortletDeployerException("errorAddProvider", ex, tokens);
            }
        }
        return dpr;
    }

    public void removeProviders(List providers) throws PortletDeployerException {
        String name;
        int i;
        DPRoot dpr = this.getDPRoot();
        for (i = 0; i < providers.size(); ++i) {
            boolean exists;
            name = (String)providers.get(i);
            String portletName = name.substring(name.indexOf(46) + 1, name.length());
            try {
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                exists = xdpr.getProviderFromThis(name) != null;
            }
            catch (Throwable ex) {
                Object[] tokens = new Object[]{name};
                throw new PortletDeployerException("errorLookupProvider", ex, tokens);
            }
            if (exists) continue;
            Object[] tokens = new Object[]{name, portletName, this.global ? "global" : this.dn};
            logger.log(Level.FINEST, "PSPL_CSPPAMT0015", tokens);
            throw new PortletDeployerException("errorFindProviderAndPortlet", tokens);
        }
        for (i = 0; i < providers.size(); ++i) {
            name = (String)providers.get(i);
            dpr = this.removeProvider(dpr, name);
        }
        dpr = this.setDirty(dpr);
        this.storeDPDocument(dpr);
    }

    public DPRoot removeProvider(DPRoot dpr, String name) throws PortletDeployerException {
        if (this.verbose) {
            Object[] tokens = new Object[]{name};
            logger.log(Level.INFO, "PSPL_CSPPAMT0011", tokens);
        }
        if (this.verbose) {
            logger.info("PSPL_CSPPAMT0012");
        }
        boolean exists = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            exists = xdpr.getProviderFromThis(name) != null;
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new PortletDeployerException("errorLookupProvider", ex, tokens);
        }
        if (!exists) {
            String portletName = name.substring(name.indexOf(46) + 1, name.length());
            Object[] tokens = new Object[]{name, portletName, this.global ? "global" : this.dn};
            logger.log(Level.FINEST, "PSPL_CSPPAMT0015", tokens);
            throw new PortletDeployerException("errorFindProviderAndPortlet", tokens);
        }
        try {
            dpr.removeProvider(name);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{name};
            throw new PortletDeployerException("errorRemoveProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot getDPRoot() throws PortletDeployerException {
        String doc = null;
        try {
            doc = !this.global ? this.dadc.getDPDocument(this.dn) : this.dadc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{this.global ? "<global>" : this.dn};
            throw new PortletDeployerException("errorRetrieveDP", ex, tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = doc == null ? this.dpf.createRoot((DPContext)this.dadc) : this.dpf.createRoot((DPContext)this.dadc, doc);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{this.dn};
            throw new PortletDeployerException("errorCreateDPRoot", ex, tokens);
        }
        return dpr;
    }

    private void storeDPDocument(DPRoot dpr) throws PortletDeployerException {
        if (this.verbose) {
            logger.info("PSPL_CSPPAMT0013");
        }
        try {
            if (!this.global) {
                this.dadc.storeDPDocument(this.dn, dpr.toString());
            } else {
                this.dadc.storeGlobalDPDocument(dpr.toString());
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorStoreDP", ex);
        }
    }

    private DPRoot setDirty(DPRoot dpr) throws PortletDeployerException {
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
        }
        catch (Throwable ex) {
            throw new PortletDeployerException("errorSetDirty", ex);
        }
        return dpr;
    }

    public static String getLines(Reader reader, int linenum) {
        StringBuffer buf = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(reader);
        try {
            int i = 1;
            int beg = linenum - 5;
            int end = linenum + 5;
            buf.append("\n");
            while ((line = br.readLine()) != null) {
                if (i == linenum) {
                    buf.append("(*)").append(line).append("\n");
                } else if (i >= beg && i <= end) {
                    buf.append("   ").append(line).append("\n");
                }
                ++i;
            }
            buf.append("\n");
        }
        catch (IOException ioe) {
            return "";
        }
        return buf.toString();
    }
}

