/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.common.util.UploadDownloadException;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.desktop.admin.mbeans.tasks.DPHelper;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.context.AdminDPContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portlet.admin.mbeans.PortletAdminMBean;
import com.sun.portal.portlet.admin.mbeans.tasks.DPRegister;
import com.sun.portal.portlet.admin.mbeans.tasks.DPUNRegister;
import com.sun.portal.portlet.admin.mbeans.tasks.PDDeploy;
import com.sun.portal.portlet.admin.mbeans.tasks.PDUNDeploy;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import com.sun.portal.taskadmin.PortletTaskAdmin;
import com.sun.portal.taskadmin.TaskAdminException;
import com.sun.portal.util.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class PortletAdmin
extends PSResource
implements PortletAdminMBean {
    private static final String MSG_PREFIX = "portlet.";
    private static final String HOST_INSTANCE_SEPARATOR = "_";
    private static final String DD_LOCATION = "DDFileLocation";
    private String psPortalID;
    private String psDomainID;
    private PSConfigContext cc = null;
    private Properties pconfProperties = null;
    private static final String WAR_SUFFIX = ".war";
    private static final String DD_SUFFIX = ".xml";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$portlet$admin$mbeans$PortletAdmin == null ? (class$com$sun$portal$portlet$admin$mbeans$PortletAdmin = PortletAdmin.class$("com.sun.portal.portlet.admin.mbeans.PortletAdmin")) : class$com$sun$portal$portlet$admin$mbeans$PortletAdmin));
    private ObjectName myName = null;
    static /* synthetic */ Class class$com$sun$portal$portlet$admin$mbeans$PortletAdmin;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.cc = cc;
            this.psDomainID = (String)path.get(2);
            this.psPortalID = (String)path.get(1);
            this.myName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.PortletAdmin", (List)path);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "MBean initialization failed", e);
            throw new RuntimeException(e);
        }
    }

    private Properties getPortletConfigProperties() {
        Properties pConf = null;
        try {
            ResourceLoader rcl = ResourceLoader.getInstance((String)this.psPortalID);
            pConf = rcl.getProperties("PDConfig.properties");
        }
        catch (IOException ioe) {
            pConf = null;
            logger.log(Level.SEVERE, "PSPL_CSPPAM0005", ioe);
        }
        return pConf;
    }

    private AdminDPContext getAdminDPContext() throws PSMBeanException {
        AdminDPContext adpContext = null;
        try {
            DPHelper dpHelper = DPHelper.getDPHelper((PSConfigContext)this.getPSConfigContext(), (SSOToken)AdminServerUtil.getSSOToken(), (String)this.psPortalID);
            adpContext = (AdminDPContext)DPHelper.getAdminDPContext((String)this.psPortalID);
            adpContext.init(AdminServerUtil.getSSOToken(), null, this.psPortalID);
        }
        catch (DesktopDataException de) {
            logger.log(Level.SEVERE, "PSPL_CSPPAM0001" + (Object)((Object)de));
            throw new PSMBeanException("portlet.errorDesktopData", (Throwable)de);
        }
        return adpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deployAll(String dn, Boolean global, String warFile, Properties roles, Properties userinfo, Boolean verbose, List instanceList, Boolean toContinue, Boolean nodeploy) throws PSMBeanException {
        block29: {
            instances = null;
            isContinue = toContinue;
            if (nodeploy.booleanValue()) {
                this.deploy(dn, global, warFile, roles, userinfo, verbose, instances, toContinue, nodeploy);
                return;
            }
            if (instanceList == null) {
                try {
                    instances = this.getInstanceNames();
                }
                catch (Exception e) {
                    this.logMessage("PSPL_CSPPAM0009", new String[]{this.psPortalID}, e);
                    throw new PSMBeanException("portlet.errorGettingPortalInstances", (Object[])new String[]{this.psPortalID});
                }
            } else {
                instances = instanceList;
            }
            hostsList = this.getHostNames(instances);
            iter = hostsList.iterator();
            while (iter.hasNext()) {
                hostName = (String)iter.next();
                try {
                    if (!AdminUtil.isLocal((String)hostName)) continue;
                    this.deploy(dn, global, warFile, roles, userinfo, verbose, instances, toContinue, nodeploy);
                    return;
                }
                catch (UnknownHostException uhe) {
                    PortletAdmin.logger.log(Level.SEVERE, "PSPL_CSPPAM0005", uhe);
                    tokens = new String[]{hostName};
                    throw new PSMBeanException("portlet.errorUnknownHost", tokens);
                }
            }
            iter = hostsList.iterator();
            signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.util.Properties", "java.util.Properties", "java.lang.Boolean", "java.util.List", "java.lang.Boolean", "java.lang.Boolean"};
            connector = null;
            mbsc = null;
            while (true) {
                if (!iter.hasNext()) {
                    return;
                }
                hostName = (String)iter.next();
                try {
                    connector = AdminServerUtil.getJMXConnector((String)hostName);
                    mbsc = connector.getMBeanServerConnection();
                }
                catch (IOException ioe) {
                    tokens = new String[]{hostName};
                    this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
                    if (isContinue) continue;
                    throw new PSMBeanException("portlet.errorConnectingToHost", tokens);
                }
                nameId = null;
                try {
                    nameId = AdminClientUtil.uploadFile((MBeanServerConnection)mbsc, (String)this.psDomainID, (File)new File(warFile), (int)0);
                }
                catch (UploadDownloadException upde) {
                    tokens = new String[]{nameId[1], hostName};
                    this.logMessage("PSPL_CSPPAM0011", tokens, (Exception)upde);
                    if (isContinue) continue;
                    throw new PSMBeanException("portlet.errorUploadingToHost", tokens);
                }
                try {
                    try {
                        params = new Object[]{dn, global, nameId[1], roles, userinfo, verbose, instances, toContinue, nodeploy};
                        mbsc.invoke(this.myName, "deploy", params, signature);
                        var23_28 = null;
                        break;
                    }
                    catch (MBeanException me) {
                        tokens = new String[]{nameId[1], hostName};
                        this.logMessage("PSPL_CSPPAM0012", tokens, me);
                        if (!isContinue) {
                            pme = (PSMBeanException)me.getTargetException();
                            throw new PSMBeanException(pme.getErrorKey(), pme.getTokens());
                        }
                        var23_28 = null;
                        try {
                            AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)nameId[0]);
                        }
                        catch (UploadDownloadException upe) {
                            // empty catch block
                        }
                        this.closeConnector(connector);
                    }
                    catch (Exception e) {
                        block27: {
                            tokens = new String[]{nameId[1], hostName};
                            this.logMessage("PSPL_CSPPAM0012", tokens, e);
                            if (!isContinue) {
                                throw new PSMBeanException("portlet.errorDeploy", tokens);
                            }
                            var23_28 = null;
                            ** try [egrp 6[TRYBLOCK] [10 : 648->664)] { 
lbl82:
                            // 1 sources

                            AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)nameId[0]);
                            break block27;
lbl84:
                            // 1 sources

                            catch (UploadDownloadException upe) {
                                // empty catch block
                            }
                        }
                        this.closeConnector(connector);
                    }
                }
                catch (Throwable var22_31) {
                    block28: {
                        var23_28 = null;
                        ** try [egrp 6[TRYBLOCK] [10 : 648->664)] { 
lbl93:
                        // 1 sources

                        AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)nameId[0]);
                        break block28;
lbl95:
                        // 1 sources

                        catch (UploadDownloadException upe) {
                            // empty catch block
                        }
                    }
                    this.closeConnector(connector);
                    throw var22_31;
                }
            }
            ** try [egrp 6[TRYBLOCK] [10 : 648->664)] { 
lbl102:
            // 1 sources

            AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)nameId[0]);
            break block29;
lbl104:
            // 1 sources

            catch (UploadDownloadException upe) {
                // empty catch block
            }
        }
        this.closeConnector(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployAll(String dn, Boolean global, String warName, Boolean verbose, List instanceList, Boolean toContinue) throws PSMBeanException {
        List instances = null;
        boolean isContinue = toContinue;
        if (instanceList == null) {
            try {
                instances = this.getInstanceNames();
            }
            catch (Exception e) {
                this.logMessage("PSPL_CSPPAM0009", new String[]{this.psPortalID}, e);
                throw new PSMBeanException("portlet.errorGettingPortalInstances", (Object[])new String[]{this.psPortalID});
            }
        } else {
            instances = instanceList;
        }
        List hostsList = this.getHostNames(instances);
        Iterator iter = hostsList.iterator();
        while (iter.hasNext()) {
            String hostName = (String)iter.next();
            try {
                if (!AdminUtil.isLocal((String)hostName)) continue;
                this.undeploy(dn, global, warName, verbose, instances, toContinue);
                return;
            }
            catch (UnknownHostException uhe) {
                logger.log(Level.SEVERE, "PSPL_CSPPAM0005", uhe);
                Object[] tokens = new String[]{hostName};
                throw new PSMBeanException("portlet.errorUnknownHost", tokens);
            }
        }
        iter = hostsList.iterator();
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.util.List", "java.lang.Boolean"};
        Object[] params = new Object[]{dn, global, warName, verbose, instances, toContinue};
        JMXConnector connector = null;
        MBeanServerConnection mbsc = null;
        while (iter.hasNext()) {
            Object[] tokens;
            String hostName = (String)iter.next();
            try {
                connector = AdminServerUtil.getJMXConnector((String)hostName);
                mbsc = connector.getMBeanServerConnection();
            }
            catch (IOException ioe) {
                tokens = new String[]{hostName};
                this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
                if (isContinue) continue;
                throw new PSMBeanException("portlet.errorConnectingToHost", tokens);
            }
            try {
                mbsc.invoke(this.myName, "undeploy", params, signature);
                return;
            }
            catch (MBeanException me) {
                tokens = new String[]{warName, hostName};
                this.logMessage("PSPL_CSPPAM0013", tokens, me);
                LogRecord logRecord = new LogRecord(Level.SEVERE, "PSPL_CSPPAM0013");
                if (isContinue) continue;
                PSMBeanException pme = (PSMBeanException)me.getTargetException();
                throw new PSMBeanException(pme.getErrorKey(), pme.getTokens());
            }
            catch (Exception e) {
                tokens = new String[]{warName, hostName};
                this.logMessage("PSPL_CSPPAM0013", tokens, e);
                if (isContinue) continue;
                throw new PSMBeanException("portlet.errorUnDeploy", tokens);
            }
            finally {
                this.closeConnector(connector);
            }
        }
    }

    public void deploy(String dn, Boolean global, String warFile, Properties roles, Properties userinfo, Boolean verbose, List instances, Boolean toContinue, Boolean nodeploy) throws PSMBeanException {
        this.pconfProperties = this.getPortletConfigProperties();
        if (this.pconfProperties == null) {
            throw new PSMBeanException("portlet.errorConfigFile");
        }
        String[] filesModified = null;
        try {
            AdminDPContext adc = this.getAdminDPContext();
            PDDeploy pddeploy = new PDDeploy(this.pconfProperties);
            filesModified = pddeploy.process(adc, dn, global, new File(warFile), roles, userinfo, verbose, logger);
            logger.log(Level.INFO, "PSPL_CSPPAM0003", warFile);
        }
        catch (PortletDeployerException pde) {
            logger.log(Level.SEVERE, "PSPL_CSPPAM0004", pde.getWrapped());
            throw new PSMBeanException(MSG_PREFIX + pde.getKey(), pde.getWrapped(), pde.getTokens());
        }
        if (!nodeploy.booleanValue()) {
            this.deployToContainer(filesModified, instances, toContinue);
        }
    }

    private void deployToContainer(String[] filesModified, List instances, boolean isContinue) throws PSMBeanException {
        ObjectName mBeanName = null;
        JMXConnector connector = null;
        MBeanServerConnection mbsc = null;
        LinkedList instancePath = new LinkedList();
        instancePath.addFirst(this.path.get(2));
        instancePath.addFirst(this.path.get(1));
        List hostsList = this.getHostNames(instances);
        Iterator iter = hostsList.iterator();
        String[] signature = new String[]{"java.lang.String"};
        String dd = filesModified[0];
        String warFile = filesModified[1];
        while (iter.hasNext()) {
            List instancesOnThisHost;
            String hostName;
            block15: {
                Object[] tokens;
                hostName = (String)iter.next();
                instancesOnThisHost = this.getInstancesOnHost(hostName, instances);
                try {
                    if (AdminServerUtil.isLocal((String)hostName)) {
                        mbsc = PASModule.getMBeanServer();
                        break block15;
                    }
                    this.closeConnector(connector);
                    connector = AdminServerUtil.getJMXConnector((String)hostName);
                    mbsc = connector.getMBeanServerConnection();
                    try {
                        String[] warFileId = AdminClientUtil.uploadFile((MBeanServerConnection)mbsc, (String)this.psDomainID, (File)new File(warFile), (int)0);
                        String[] ddId = AdminClientUtil.uploadFile((MBeanServerConnection)mbsc, (String)this.psDomainID, (File)new File(dd), (int)0);
                        dd = ddId[1];
                        warFile = warFileId[1];
                        String destFileName = this.getFullyQualifiedDestinationFileName(warFile, WAR_SUFFIX);
                        Object[] params1 = new Object[]{warFile, destFileName};
                        String[] signature1 = new String[]{"java.lang.String", "java.lang.String"};
                        mbsc.invoke(this.myName, "copyFile", params1, signature1);
                        destFileName = this.getFullyQualifiedDestinationFileName(dd, DD_SUFFIX);
                        Object[] params2 = new Object[]{dd, destFileName};
                        String[] signature2 = new String[]{"java.lang.String", "java.lang.String"};
                        mbsc.invoke(this.myName, "copyFile", params2, signature2);
                        try {
                            AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)warFileId[0]);
                            AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.psDomainID, (String)ddId[0]);
                        }
                        catch (UploadDownloadException upe) {}
                    }
                    catch (Exception e) {
                        tokens = new String[]{warFile + "," + dd, hostName};
                        this.logMessage("PSPL_CSPPAM0011", tokens, e);
                        this.closeConnector(connector);
                        if (isContinue) continue;
                        throw new PSMBeanException("portlet.errorUploadingToHost", tokens);
                    }
                }
                catch (UnknownHostException uhe) {
                    logger.log(Level.SEVERE, "PSPL_CSPPAM0005", uhe);
                    throw new PSMBeanException("portlet.errorUnknownHost");
                }
                catch (IOException ioe) {
                    tokens = new String[]{hostName};
                    this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
                    this.closeConnector(connector);
                    if (isContinue) continue;
                    throw new PSMBeanException("portlet.errorConnectingToHost", tokens);
                }
            }
            String warFileURI = warFile.substring(warFile.lastIndexOf(fs), warFile.length());
            warFileURI = warFileURI.substring(0, warFileURI.indexOf(WAR_SUFFIX));
            Object[] params = new Object[]{warFileURI};
            Iterator instIter = instancesOnThisHost.iterator();
            String instanceName = null;
            while (instIter.hasNext()) {
                try {
                    Object[] tokens;
                    instanceName = (String)instIter.next();
                    mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath(instancePath, (String)instanceName));
                    if (!mbsc.isRegistered(mBeanName)) {
                        tokens = new String[]{instanceName};
                        if (!isContinue) {
                            this.closeConnector(connector);
                            throw new PSMBeanException("portlet.errorIncorrectInstance", tokens);
                        }
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        tokens = new Object[]{warFile, instanceName};
                        logger.log(Level.INFO, "PSPL_CSPPAM0006", tokens);
                    }
                    mbsc.invoke(mBeanName, "deploy", params, signature);
                }
                catch (Exception e) {
                    Object[] tokens = new String[]{warFile, instanceName, hostName};
                    this.logMessage("PSPL_CSPPAM0013", tokens, e);
                    if (isContinue) continue;
                    this.closeConnector(connector);
                    throw new PSMBeanException("portlet.errorDeployOnInstance", tokens);
                }
            }
        }
        this.closeConnector(connector);
    }

    public void undeploy(String dn, Boolean global, String warName, Boolean verbose, List instances, Boolean toContinue) throws PSMBeanException {
        this.pconfProperties = this.getPortletConfigProperties();
        if (this.pconfProperties == null) {
            throw new PSMBeanException("portlet.errorConfigFile");
        }
        try {
            AdminDPContext adc = this.getAdminDPContext();
            PDUNDeploy pdundeploy = new PDUNDeploy(this.pconfProperties);
            pdundeploy.process(adc, dn, global, warName, verbose, logger);
        }
        catch (PortletDeployerException pde) {
            logger.log(Level.INFO, "PSPL_CSPPAM0004", pde);
            throw new PSMBeanException(MSG_PREFIX + pde.getKey(), pde.getWrapped(), pde.getTokens());
        }
        this.undeployFromContainer(warName, instances, toContinue);
    }

    private void undeployFromContainer(String warName, List instances, boolean isContinue) throws PSMBeanException {
        ObjectName mBeanName = null;
        JMXConnector connector = null;
        MBeanServerConnection mbsc = null;
        LinkedList instancePath = new LinkedList();
        instancePath.addFirst(this.path.get(2));
        instancePath.addFirst(this.path.get(1));
        List hostsList = this.getHostNames(instances);
        Iterator iter = hostsList.iterator();
        String[] signature = new String[]{"java.lang.String"};
        Object[] params = new Object[]{fs + warName};
        while (iter.hasNext()) {
            String hostName = (String)iter.next();
            List instancesOnThisHost = this.getInstancesOnHost(hostName, instances);
            try {
                if (AdminServerUtil.isLocal((String)hostName)) {
                    mbsc = PASModule.getMBeanServer();
                } else {
                    this.closeConnector(connector);
                    connector = AdminServerUtil.getJMXConnector((String)hostName);
                    mbsc = connector.getMBeanServerConnection();
                }
            }
            catch (UnknownHostException uhe) {
                logger.log(Level.SEVERE, "PSPL_CSPPAM0005", uhe);
                throw new PSMBeanException("portlet.errorUnknownHost");
            }
            catch (IOException ioe) {
                Object[] tokens = new String[]{hostName};
                this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
                this.closeConnector(connector);
                if (isContinue) continue;
                throw new PSMBeanException("portlet.errorConnectingToHost", tokens);
            }
            Iterator instIter = instancesOnThisHost.iterator();
            String instanceName = null;
            while (instIter.hasNext()) {
                try {
                    Object[] tokens;
                    instanceName = (String)instIter.next();
                    mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath(instancePath, (String)instanceName));
                    if (!mbsc.isRegistered(mBeanName)) {
                        tokens = new String[]{instanceName};
                        if (isContinue) continue;
                        this.closeConnector(connector);
                        throw new PSMBeanException("portlet.errorIncorrectInstance", tokens);
                    }
                    if (logger.isLoggable(Level.INFO)) {
                        tokens = new Object[]{warName, instanceName};
                        logger.log(Level.INFO, "PSPL_CSPPAM0008", tokens);
                    }
                    mbsc.invoke(mBeanName, "undeploy", params, signature);
                }
                catch (Exception e) {
                    Object[] tokens = new String[]{warName, instanceName, hostName};
                    this.logMessage("PSPL_CSPPAM0015", tokens, e);
                    if (isContinue) continue;
                    this.closeConnector(connector);
                    throw new PSMBeanException("portlet.errorUnDeployFromInstance", tokens);
                }
            }
        }
        this.closeConnector(connector);
    }

    private void closeConnector(JMXConnector connector) {
        if (connector != null) {
            try {
                connector.close();
            }
            catch (Exception e) {
                String message = "Can't close JMX connector";
                logger.log(Level.WARNING, message, e);
            }
        }
    }

    public void registerPortletApp(String dn, Boolean global, String earFile, Properties roles, Properties userinfo, Boolean verbose) throws PSMBeanException {
        Properties pconfProperties = this.getPortletConfigProperties();
        if (pconfProperties == null) {
            throw new PSMBeanException("portlet.errorConfigFile");
        }
        try {
            AdminDPContext adc = this.getAdminDPContext();
            DPRegister dpRegister = new DPRegister(pconfProperties);
            dpRegister.process(adc, dn, global, new File(earFile), roles, userinfo, verbose, logger);
        }
        catch (PortletDeployerException pde) {
            logger.log(Level.SEVERE, "PSPL_CSPPAM0004", pde.getWrapped());
            throw new PSMBeanException(MSG_PREFIX + pde.getKey(), pde.getWrapped(), pde.getTokens());
        }
    }

    public void unregisterPortletApp(String dn, Boolean global, String earAppName, Boolean verbose) throws PSMBeanException {
        Properties pconfProperties = this.getPortletConfigProperties();
        if (pconfProperties == null) {
            throw new PSMBeanException("portlet.errorConfigFile");
        }
        try {
            AdminDPContext adc = this.getAdminDPContext();
            DPUNRegister dpUNRegister = new DPUNRegister(pconfProperties);
            dpUNRegister.process(adc, dn, global, earAppName, verbose, logger);
        }
        catch (PortletDeployerException pde) {
            throw new PSMBeanException(MSG_PREFIX + pde.getKey(), pde.getWrapped(), pde.getTokens());
        }
    }

    private void logMessage(String msgId, Object[] tokens, Exception e) {
        LogRecord logRecord = new LogRecord(Level.SEVERE, msgId);
        logRecord.setParameters(tokens);
        logRecord.setThrown(e);
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
    }

    private String getFullyQualifiedDestinationFileName(String filePath, String ext) {
        String fileName = new File(filePath).getName();
        fileName = fileName.substring(0, fileName.indexOf(".")) + ext;
        fileName = this.pconfProperties.getProperty(DD_LOCATION) + File.separator + fileName;
        return fileName;
    }

    public void copyFile(String sourceFileName, String destFileName) throws PSMBeanException {
        try {
            File sourceFile = new File(sourceFileName);
            File destFile = new File(destFileName);
            if (!destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
                File parent;
                if (destFile.exists() && destFile.isFile()) {
                    destFile.delete();
                }
                if (!(parent = new File(destFile.getParent())).exists()) {
                    parent.mkdirs();
                }
                FileInputStream in = new FileInputStream(sourceFile);
                FileOutputStream out = new FileOutputStream(destFile);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                in.close();
                out.close();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSPL_CSPPAM0005", ioe);
            throw new PSMBeanException("portlet.errorInCopyingFile");
        }
    }

    public void copyModifiedPortletWar(String tempLocation) {
        String newLocation = this.getPortletConfigProperties().getProperty(DD_LOCATION);
    }

    public void createPortletChannel(String baseDN, String channelName, String portletName) throws PSMBeanException {
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            pta.createPortletChannel(channelName, portletName);
            pta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException("desktop." + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public Set getExistingPortlets(String baseDN) throws PSMBeanException {
        Set portlets = null;
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            portlets = pta.getExistingPortlets();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException("desktop." + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return portlets;
    }

    public Set getPortletPreferenceNames(String baseDN, String portletName) throws PSMBeanException {
        Set portletPrefs = null;
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            portletPrefs = pta.getPortletPreferenceNames(portletName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(" ");
        }
        return portletPrefs;
    }

    public String getPortletPreference(String baseDN, String portletName, String prefName) throws PSMBeanException {
        String portletPref = null;
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            portletPref = pta.getPortletPreferenceStringValue(portletName, prefName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(" ");
        }
        return portletPref;
    }

    public List getPortletPreferenceValues(String baseDN, String portletName, String prefName) throws PSMBeanException {
        List portletPrefs = null;
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            portletPrefs = pta.getPortletPreferenceValues(portletName, prefName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(" ");
        }
        return portletPrefs;
    }

    public void setPortletPreference(String baseDN, String portletName, String prefName, String value) throws PSMBeanException {
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            pta.setPortletPreferenceStringValue(portletName, prefName, value);
            pta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(" ");
        }
    }

    public void setPortletPreferenceValues(String baseDN, String portletName, String prefName, String[] values) throws PSMBeanException {
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            pta.setPortletPreferenceValues(portletName, prefName, values);
            pta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(" ");
        }
    }

    public Boolean isPortletChannel(String baseDN, String channelName) throws PSMBeanException {
        boolean isPortlet = false;
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            isPortlet = pta.isPortletChannel(channelName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException("tae");
        }
        return new Boolean(isPortlet);
    }

    public Map getPortletPreferenceMap(String baseDN, String portletName) throws PSMBeanException {
        Map prefMap = new HashMap();
        try {
            PortletTaskAdmin pta = new PortletTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            prefMap = pta.getPortletPreferenceMap(portletName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException("tae");
        }
        return prefMap;
    }

    private Set getInstanceObjectNames(String portalId) throws IOException, Exception {
        ObjectName instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalId);
        MBeanServer mbs = PASModule.getMBeanServer();
        Set<ObjectName> objNames = mbs.queryNames(instancePat, null);
        return objNames;
    }

    private List getInstanceNames() throws Exception {
        ArrayList<String> iNames = new ArrayList<String>();
        Set objNames = this.getInstanceObjectNames(this.psPortalID);
        Iterator iter = objNames.iterator();
        while (iter.hasNext()) {
            iNames.add(((ObjectName)iter.next()).getKeyProperty("name"));
        }
        return iNames;
    }

    private Set getInstanceObjectNamesForInstances(Set instanceObjs, List instanceNames) {
        HashSet<ObjectName> instanceObjects = null;
        if (instanceNames == null) {
            instanceObjects = instanceObjs;
        } else {
            instanceObjects = new HashSet<ObjectName>();
            ObjectName objectName = null;
            String instanceName = null;
            Iterator i = instanceNames.iterator();
            while (i.hasNext()) {
                instanceName = (String)i.next();
                Iterator j = instanceObjs.iterator();
                while (j.hasNext()) {
                    objectName = (ObjectName)j.next();
                    if (!objectName.getKeyProperty("name").equalsIgnoreCase(instanceName)) continue;
                    instanceObjects.add(objectName);
                }
            }
        }
        return instanceObjects;
    }

    private List getHostNames(List instanceNames) throws PSMBeanException {
        ArrayList<String> hostNames = new ArrayList<String>();
        JMXConnector connector = null;
        MBeanServerConnection mbsc = null;
        Set instanceObjs = null;
        try {
            connector = AdminServerUtil.getJMXConnector((String)"localhost");
            mbsc = connector.getMBeanServerConnection();
            instanceObjs = this.getInstanceObjectNamesForInstances(this.getInstanceObjectNames(this.psPortalID), instanceNames);
            if (instanceObjs.isEmpty()) {
                throw new Exception("");
            }
            Iterator j = instanceObjs.iterator();
            while (j.hasNext()) {
                ObjectName iObj = (ObjectName)j.next();
                String host = (String)mbsc.getAttribute(iObj, "Host");
                if (hostNames.contains(host)) continue;
                hostNames.add(host);
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new String[]{"localhost"};
            this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
        }
        catch (Exception e) {
            throw new PSMBeanException("portlet.errorGettingPortalInstances", (Object[])new String[]{this.psPortalID});
        }
        return hostNames;
    }

    private List getInstancesOnHost(String hostName, List instanceNames) throws PSMBeanException {
        ArrayList<String> instances = new ArrayList<String>();
        JMXConnector connector = null;
        MBeanServerConnection mbsc = null;
        try {
            connector = AdminServerUtil.getJMXConnector((String)"localhost");
            mbsc = connector.getMBeanServerConnection();
            Set instanceObjs = this.getInstanceObjectNamesForInstances(this.getInstanceObjectNames(this.psPortalID), instanceNames);
            Iterator iter = instanceObjs.iterator();
            while (iter.hasNext()) {
                ObjectName iObj = (ObjectName)iter.next();
                String host = (String)mbsc.getAttribute(iObj, "Host");
                if (!host.equals(hostName)) continue;
                instances.add(iObj.getKeyProperty("name"));
            }
        }
        catch (IOException ioe) {
            Object[] tokens = new String[]{"localhost"};
            this.logMessage("PSPL_CSPPAM0010", tokens, ioe);
        }
        catch (Exception e) {
            throw new PSMBeanException("portlet.errorGettingPortalInstances", (Object[])new String[]{this.psPortalID});
        }
        return instances;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

