/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.theme;

import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.theme.ThemeConfigurationException;
import com.sun.web.ui.theme.ThemeManager;
import com.sun.web.ui.util.ClassLoaderFinder;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.ExternalContext;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class ThemeFactory {
    public static final String DEFAULT_THEME = "com.sun.web.ui.DEFAULT_THEME";
    public static final String MESSAGES_PARAM = "com.sun.web.ui.MESSAGES";
    private static String messageOverride = null;
    private static final String WARNING_LOAD = "WARNING: the Sun Web Components could not load any themes.";
    private static final String WARNING_BADFILE = "WARNING: the Sun Web Components detected a corrupted theme configuration file:\n\t";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String FILENAME = "manifest-file";
    public static final String COMPONENTS_SECTION = "com/sun/web/ui/";
    public static final String THEME_SECTION = "com/sun/web/ui/theme/";
    public static final String THEME_VERSION_REQUIRED = "X-SJWUIC-Theme-Version-Required";
    public static final String THEME_VERSION = "X-SJWUIC-Theme-Version";
    public static final String NAME = "X-SJWUIC-Theme-Name";
    public static final String PREFIX = "X-SJWUIC-Theme-Prefix";
    public static final String DEFAULT = "X-SJWUIC-Theme-Default";
    public static final String STYLESHEETS = "X-SJWUIC-Theme-Stylesheets";
    public static final String JSFILES = "X-SJWUIC-Theme-JavaScript";
    public static final String CLASSMAPPER = "X-SJWUIC-Theme-ClassMapper";
    public static final String IMAGES = "X-SJWUIC-Theme-Images";
    public static final String MESSAGES = "X-SJWUIC-Theme-Messages";
    private static final boolean DEBUG = false;

    private ThemeFactory(String messageOverride) {
        ThemeFactory.messageOverride = messageOverride;
    }

    public static ThemeManager initializeThemeManager(ServletContext context, Set locales) {
        if (context.getAttribute("com.sun.web.ui.ThemeManager") != null) {
            return null;
        }
        String defaultThemeName = ThemeFactory.processInitParameter(context.getInitParameter(DEFAULT_THEME));
        String messageOverride = ThemeFactory.processInitParameter(context.getInitParameter(MESSAGES_PARAM));
        ThemeFactory themeFactory = new ThemeFactory(messageOverride);
        ThemeManager manager = null;
        manager = locales == null ? themeFactory.createThemeManager(defaultThemeName) : themeFactory.createThemeManager(defaultThemeName, locales, null);
        if (manager == null) {
            return null;
        }
        context.setAttribute("com.sun.web.ui.ThemeManager", (Object)manager);
        return manager;
    }

    protected static void initializeThemeManager(PortletContext context) {
        if (context.getAttribute("com.sun.web.ui.ThemeManager") != null) {
            // empty if block
        }
        String defaultThemeName = ThemeFactory.processInitParameter(context.getInitParameter(DEFAULT_THEME));
        String messageOverride = ThemeFactory.processInitParameter(context.getInitParameter(MESSAGES_PARAM));
        ThemeFactory themeFactory = new ThemeFactory(messageOverride);
        ThemeManager manager = themeFactory.createThemeManager(defaultThemeName);
        context.setAttribute("com.sun.web.ui.ThemeManager", (Object)manager);
    }

    public static ThemeManager initializeThemeManager(ExternalContext context) {
        String defaultThemeName = ThemeFactory.processInitParameter(context.getInitParameter(DEFAULT_THEME));
        String messageOverride = ThemeFactory.processInitParameter(context.getInitParameter(MESSAGES_PARAM));
        ThemeFactory themeFactory = new ThemeFactory(messageOverride);
        ThemeManager manager = themeFactory.createThemeManager(defaultThemeName);
        context.getApplicationMap().put("com.sun.web.ui.ThemeManager", manager);
        return manager;
    }

    private ThemeManager createThemeManager(String defaultThemeName) {
        Application app = ThemeFactory.getApplication();
        if (app == null) {
            return null;
        }
        return this.createThemeManager(defaultThemeName, ThemeFactory.getLocales(app), app.getDefaultLocale());
    }

    private ThemeManager createThemeManager(String defaultThemeName, Set localeSet, Locale defaultLocale) {
        String requiredThemeVersion = this.getRequiredThemeVersion();
        ThemeManager manager = new ThemeManager();
        manager.setDefaultLocale(defaultLocale);
        Iterator themeAttributesIterator = this.getThemeAttributes();
        if (!themeAttributesIterator.hasNext()) {
            throw new ThemeConfigurationException(WARNING_LOAD);
        }
        Attributes themeAttributes = null;
        Iterator locales = null;
        Locale locale = null;
        Object theme = null;
        String defaultName = defaultThemeName;
        while (themeAttributesIterator.hasNext()) {
            String isDefault;
            themeAttributes = (Attributes)themeAttributesIterator.next();
            String name = this.readAttribute(themeAttributes, NAME);
            String version = this.readAttribute(themeAttributes, THEME_VERSION);
            if (requiredThemeVersion != null && requiredThemeVersion.compareTo(version) > 0) {
                this.throwVersionException(name, version, requiredThemeVersion);
            }
            HashMap<Locale, Theme> map = new HashMap<Locale, Theme>();
            locales = localeSet.iterator();
            while (locales.hasNext()) {
                locale = (Locale)locales.next();
                map.put(locale, this.createTheme(themeAttributes, locale));
            }
            manager.addThemeMap(name, map);
            if (defaultName != null || (isDefault = themeAttributes.getValue(DEFAULT)) == null || !isDefault.equals("true")) continue;
            defaultName = name;
        }
        manager.setDefaultThemeName(defaultThemeName);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getThemeAttributes() {
        Enumeration manifests = this.getManifests();
        if (!manifests.hasMoreElements()) {
            String msg = "No Themes in the classpath!";
            throw new ThemeConfigurationException(msg);
        }
        URL url = null;
        URLConnection conn = null;
        InputStream in = null;
        Manifest manifest = null;
        Attributes themeAttributes = null;
        ArrayList<Attributes> themeProps = new ArrayList<Attributes>();
        while (manifests.hasMoreElements()) {
            url = (URL)manifests.nextElement();
            try {
                conn = url.openConnection();
                in = conn.getInputStream();
                manifest = new Manifest(in);
                themeAttributes = manifest.getAttributes(THEME_SECTION);
                if (themeAttributes == null) continue;
                themeAttributes.putValue(FILENAME, url.toString());
                themeProps.add(themeAttributes);
            }
            catch (IOException ioex) {}
            continue;
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
        }
        return themeProps.iterator();
    }

    private Theme createTheme(Attributes themeAttributes, Locale locale) throws ThemeConfigurationException {
        Theme theme = new Theme(locale);
        ResourceBundle bundle = null;
        String prefix = this.readAttribute(themeAttributes, PREFIX);
        if (!prefix.startsWith("/")) {
            prefix = "/".concat(prefix);
        }
        theme.setPrefix(prefix);
        bundle = this.createResourceBundle(themeAttributes, MESSAGES, locale);
        if (messageOverride != null) {
            try {
                ResourceBundle override = ResourceBundle.getBundle(messageOverride, locale);
                theme.configureMessages(bundle, override);
            }
            catch (MissingResourceException mre) {
                StringBuffer errorMessage = new StringBuffer("The message resource file ");
                errorMessage.append(messageOverride);
                errorMessage.append(" specified by context parameter ");
                errorMessage.append(MESSAGES_PARAM);
                errorMessage.append(" does not exist.");
                throw new ThemeConfigurationException(errorMessage.toString());
            }
        } else {
            theme.configureMessages(bundle, null);
        }
        bundle = this.createResourceBundle(themeAttributes, IMAGES, locale);
        theme.configureImages(bundle);
        bundle = this.createResourceBundle(themeAttributes, JSFILES, locale);
        String jsFiles = this.readAttribute(themeAttributes, JSFILES);
        theme.configureJSFiles(bundle);
        bundle = this.createResourceBundle(themeAttributes, STYLESHEETS, locale);
        theme.configureStylesheets(bundle);
        String classMapper = themeAttributes.getValue(CLASSMAPPER);
        if (classMapper != null && classMapper.length() > 0) {
            bundle = this.createResourceBundle(themeAttributes, CLASSMAPPER, locale);
            theme.configureClassMapper(bundle);
        }
        return theme;
    }

    private ResourceBundle createResourceBundle(Attributes themeAttributes, String propName, Locale locale) {
        String bundleName = this.readAttribute(themeAttributes, propName);
        try {
            ClassLoader loader = ClassLoaderFinder.getCurrentLoader(ThemeFactory.class);
            return ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException mre) {
            StringBuffer msgBuffer = new StringBuffer(300);
            msgBuffer.append("Invalid theme configuration file for theme ");
            msgBuffer.append(themeAttributes.getValue(NAME));
            msgBuffer.append(".\nThemeFactory could not locate resource bundle at ");
            msgBuffer.append(bundleName);
            msgBuffer.append(".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
    }

    private String readAttribute(Attributes themeAttributes, String propName) {
        String name = themeAttributes.getValue(propName);
        if (name == null || name.length() == 0) {
            String propFile = themeAttributes.getValue(FILENAME);
            StringBuffer msgBuffer = new StringBuffer(300);
            msgBuffer.append("ThemeConfiguration file ");
            if (propFile != null) {
                msgBuffer.append(propFile);
                msgBuffer.append(" ");
            }
            msgBuffer.append("does not contain required property \"");
            msgBuffer.append(propName);
            msgBuffer.append("\".");
            throw new ThemeConfigurationException(msgBuffer.toString());
        }
        return name;
    }

    private void throwVersionException(String name, String version, String requiredThemeVersion) {
        StringBuffer msgBuffer = new StringBuffer(300);
        msgBuffer.append("\n\nTheme \"");
        msgBuffer.append(name);
        msgBuffer.append("\" is not up to date with the component library.\n");
        msgBuffer.append("Its version is ");
        msgBuffer.append(version);
        msgBuffer.append(". Version ");
        msgBuffer.append(requiredThemeVersion);
        msgBuffer.append(" or higher required.\n");
        throw new ThemeConfigurationException(msgBuffer.toString());
    }

    private static Application getApplication() {
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        if (factory == null) {
            return null;
        }
        return factory.getApplication();
    }

    private static Set getLocales(Application application) {
        Iterator localeIterator;
        HashSet<Locale> localeSet = new HashSet<Locale>();
        Locale locale = application.getDefaultLocale();
        if (locale != null) {
            localeSet.add(locale);
        }
        if ((localeIterator = application.getSupportedLocales()) != null) {
            while (localeIterator.hasNext()) {
                Object localeObject = localeIterator.next();
                localeSet.add((Locale)localeObject);
            }
        }
        if (localeSet.isEmpty()) {
            localeSet.add(Locale.getDefault());
        }
        return localeSet;
    }

    private String missingResourceBundleMessage(Attributes themeAttributes, String bundleName) {
        String propFile = themeAttributes.getValue(FILENAME);
        StringBuffer msgBuffer = new StringBuffer("Invalid theme configuration file for theme ");
        msgBuffer.append(themeAttributes.getValue(NAME));
        if (propFile != null) {
            msgBuffer.append(" configured by property file ");
            msgBuffer.append(propFile);
            msgBuffer.append(".");
        }
        msgBuffer.append("ThemeFactory could not locate resource bundle at ");
        msgBuffer.append(bundleName);
        msgBuffer.append(".");
        return msgBuffer.toString();
    }

    private static String processInitParameter(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequiredThemeVersion() {
        Enumeration manifests = this.getManifests();
        if (!manifests.hasMoreElements()) {
            return null;
        }
        URL url = null;
        InputStream in = null;
        Manifest manifest = null;
        String themeVersion = null;
        while (themeVersion == null && manifests.hasMoreElements()) {
            url = (URL)manifests.nextElement();
            if (url.toString().indexOf("webui") == -1) continue;
            try {
                in = url.openConnection().getInputStream();
                manifest = new Manifest(in);
                Attributes attr = manifest.getAttributes(COMPONENTS_SECTION);
                if (attr == null) continue;
                themeVersion = attr.getValue(THEME_VERSION_REQUIRED);
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
        }
        return themeVersion;
    }

    private Enumeration getManifests() {
        Enumeration<URL> manifests = null;
        ClassLoader loader = ClassLoaderFinder.getCurrentLoader(ThemeFactory.class);
        if (Beans.isDesignTime() && loader instanceof URLClassLoader) {
            Vector<URL> v = new Vector<URL>();
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                try {
                    URL manifest = new URL(url, MANIFEST);
                    InputStream is = manifest.openStream();
                    v.addElement(manifest);
                    is.close();
                    continue;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            return v.elements();
        }
        try {
            manifests = loader.getResources(MANIFEST);
        }
        catch (IOException ioex) {
            // empty catch block
        }
        if (!manifests.hasMoreElements()) {
            try {
                manifests = loader.getResources(MANIFEST);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return manifests;
    }

    private static void log(String s) {
        System.out.println("ThemeFactory::" + s);
    }
}

