/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.portletSetup;

import com.sun.web.ui.portletSetup.SessionDataStrategy;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.theme.ThemeFactory;
import com.sun.web.ui.theme.ThemeManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class SetupThemeTag
extends TagSupport {
    public static final String LOCALE_ATTRIBUTE = "com.sun.web.ui.locale";
    public static final String DEFAULT_SESSION_DATA_STRATEGY_CLASS = "com.sun.web.ui.portletSetup.DefaultSessionDataStrategy";
    private static final boolean DEBUG = false;
    private String themeName;
    private String supportedLocales;
    private SessionDataStrategy sessionDataStrategy;
    private String sessionDataStrategyClass;

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        String string;
        this.initializeSessionDataStrategy();
        Theme theme = this.getTheme();
        theme.initializePath(this.pageContext.getServletContext(), (HttpServletRequest)this.pageContext.getRequest());
        JspWriter jspWriter = this.pageContext.getOut();
        String string2 = this.getClientType();
        String string3 = theme.getPathToMasterStylesheet();
        if (string3 != null) {
            this.writeStyleSheet(string3, jspWriter);
        }
        if ((string = theme.getPathToStylesheet(string2)) != null) {
            this.writeStyleSheet(string, jspWriter);
        }
        String[] stringArray = theme.getGlobalStylesheets();
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeStyleSheet(stringArray[i], jspWriter);
        }
        String[] stringArray2 = theme.getGlobalJSFiles();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.writeJavaScript(stringArray2[i], jspWriter);
        }
        return 6;
    }

    private void writeStyleSheet(String string, JspWriter jspWriter) throws JspException {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" />\n");
        try {
            jspWriter.print(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
    }

    private void writeJavaScript(String string, JspWriter jspWriter) throws JspException {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<script type=\"text/javascript\" src=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"></script>\n");
        try {
            jspWriter.print(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Theme getTheme() throws JspException {
        Set set = this.getLocales();
        ThemeManager themeManager = null;
        ServletContext servletContext = this.pageContext.getServletContext();
        Object object = servletContext.getAttribute("com.sun.web.ui.ThemeManager");
        if (object != null) {
            if (!(object instanceof ThemeManager)) {
                StringBuffer stringBuffer = new StringBuffer("ERROR WHILE RETRIEVING THEME: ");
                stringBuffer.append(" Session attribute of name ");
                stringBuffer.append("com.sun.web.ui.Theme");
                stringBuffer.append(" is not of type Theme");
                throw new RuntimeException(stringBuffer.toString());
            }
            themeManager = (ThemeManager)object;
        } else {
            themeManager = ThemeFactory.initializeThemeManager(servletContext, set);
        }
        if (this.themeName == null) {
            throw new JspException("No theme name configured for this application");
        }
        Object object2 = this.getSessionDataStrategy().getSessionData(this.pageContext, LOCALE_ATTRIBUTE);
        Locale locale = null;
        if (object2 == null) {
            locale = this.calculateLocale(set);
            this.getSessionDataStrategy().setSessionData(this.pageContext, LOCALE_ATTRIBUTE, locale);
            return themeManager.getTheme(this.themeName, locale);
        }
        if (!(object2 instanceof Locale)) {
            throw new JspException("Session attribute com.sun.web.ui.locale is not a Locale");
        }
        locale = (Locale)object2;
        return themeManager.getTheme(this.themeName, locale);
    }

    private Set getLocales() throws JspException {
        if (this.supportedLocales == null) {
            String string = "You must specify the supported locales";
            throw new JspException(string);
        }
        String[] stringArray = this.supportedLocales.split(",");
        HashSet<Locale> hashSet = new HashSet<Locale>();
        Object var3_4 = null;
        Object var4_5 = null;
        Object var5_6 = null;
        String[] stringArray2 = null;
        Locale locale = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i].trim();
            if (string.length() == 0) continue;
            stringArray2 = string.split("_");
            if (stringArray2.length > 2) {
                locale = new Locale(stringArray2[0], stringArray2[1], stringArray2[2]);
            } else if (stringArray2.length > 1) {
                locale = new Locale(stringArray2[0], stringArray2[1]);
            } else if (stringArray2.length > 0) {
                locale = new Locale(stringArray2[0]);
            }
            hashSet.add(locale);
        }
        return hashSet;
    }

    private Locale calculateLocale(Set set) {
        Locale locale = null;
        Enumeration enumeration = this.pageContext.getRequest().getLocales();
        Locale locale2 = null;
        while (enumeration.hasMoreElements()) {
            locale2 = (Locale)enumeration.nextElement();
            locale = this.getMatchingLocale(locale2, set);
            if (locale == null) continue;
            return locale;
        }
        return (Locale)set.iterator().next();
    }

    private Locale getMatchingLocale(Locale locale, Set set) {
        Iterator iterator = set.iterator();
        Locale locale2 = null;
        while (iterator.hasNext()) {
            locale2 = (Locale)iterator.next();
            if (locale.equals(locale2)) {
                return locale2;
            }
            if (!locale.getLanguage().equals(locale2.getLanguage()) || locale2.getCountry().length() != 0) continue;
            return locale2;
        }
        return null;
    }

    public String getClientType() {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
        String string = httpServletRequest.getHeader("USER-AGENT").toLowerCase();
        if (string == null) {
            return "default";
        }
        if (string.indexOf("gecko") != -1) {
            return "gecko";
        }
        if (string.indexOf("msie 6") != -1) {
            return "ie6";
        }
        if (string.indexOf("msie 5.5") != -1) {
            return "ie5.5";
        }
        return "default";
    }

    private void log(String string) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + string);
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String string) {
        this.themeName = string;
    }

    public String getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(String string) {
        this.supportedLocales = string;
    }

    private SessionDataStrategy getSessionDataStrategy() {
        return this.sessionDataStrategy;
    }

    private void setSessionDataStrategy(SessionDataStrategy sessionDataStrategy) {
        this.sessionDataStrategy = sessionDataStrategy;
    }

    private void initializeSessionDataStrategy() throws JspException {
        String string = this.sessionDataStrategyClass != null ? this.sessionDataStrategyClass : DEFAULT_SESSION_DATA_STRATEGY_CLASS;
        Class<?> clazz = null;
        try {
            ((Object)((Object)this)).getClass();
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Classname: " + string + ", not found");
            throw new JspException("Unable to instantiate Session Data Strategy.");
        }
        try {
            this.sessionDataStrategy = (SessionDataStrategy)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JspException("Unable to instantiate SessionDataStrategy, " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JspException("Unable to instantiate SessionDataStrategy, " + string + ", Illegal Access Exception.");
        }
    }

    public String getSessionDataStrategyClass() {
        return this.sessionDataStrategyClass;
    }

    public void setSessionDataStrategyClass(String string) {
        this.sessionDataStrategyClass = string;
    }
}

