/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.jwsdetect;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RegReader {
    public static final int ERROR_FILE_NOT_FOUND = 2;
    private String tempDirectory;
    public static boolean dllLoaded = false;
    boolean binit = false;
    private static final RegReader THEINSTANCE = new RegReader();
    static /* synthetic */ Class class$com$sun$portal$proxylet$client$jwsdetect$RegReader;

    public native String getJWSVersion();

    public native String getBrowserInstallPath(String var1, String var2);

    private RegReader() {
    }

    public static synchronized RegReader getInstance() {
        if (!RegReader.THEINSTANCE.binit) {
            try {
                THEINSTANCE.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RegReader.THEINSTANCE.binit = true;
        }
        return THEINSTANCE;
    }

    void init() throws Exception {
        try {
            if (!dllLoaded) {
                System.out.println("Loading library explicitly");
                this.loadExplicitly();
            }
            if (this.tempDirectory != null && new File(this.tempDirectory).isDirectory()) {
                return;
            }
            this.tempDirectory = this.getTempDirectory();
        }
        catch (IOException e) {
            System.out.println("Unable to create temp file");
            throw e;
        }
    }

    public void loadExplicitly() throws Exception {
        System.out.println("In loadExplicitly");
        String location = this.extractResource("RegReader.dll");
        System.out.println("RegReader.dll file location = " + location);
        try {
            System.load(location);
            dllLoaded = true;
            System.out.println("loaded library 'RegReader.dll' explicitly");
        }
        catch (Exception e) {
            System.out.println("Exception occured in loadExplicityly");
            dllLoaded = false;
            throw e;
        }
    }

    public String extractResource(String resourceName) throws Exception {
        String tempDirectory = this.getTempDirectory();
        File registryReaderDLLFile = new File(tempDirectory + resourceName);
        ClassLoader c1 = (class$com$sun$portal$proxylet$client$jwsdetect$RegReader == null ? (class$com$sun$portal$proxylet$client$jwsdetect$RegReader = RegReader.class$("com.sun.portal.proxylet.client.jwsdetect.RegReader")) : class$com$sun$portal$proxylet$client$jwsdetect$RegReader).getClassLoader();
        InputStream is = c1.getResourceAsStream(resourceName);
        if (is != null) {
            BufferedOutputStream ostream = null;
            try {
                ostream = new BufferedOutputStream(new FileOutputStream(registryReaderDLLFile));
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
            if (ostream != null) {
                BufferedInputStream istream = new BufferedInputStream(is);
                if (registryReaderDLLFile.exists()) {
                    registryReaderDLLFile.delete();
                    registryReaderDLLFile.createNewFile();
                }
                System.out.println("Extracting resource " + resourceName + " to directory " + tempDirectory);
                int bsize = 2048;
                int n = 0;
                byte[] buffer = new byte[bsize];
                while ((n = istream.read(buffer, 0, bsize)) != -1) {
                    ostream.write(buffer, 0, n);
                }
                istream.close();
                ostream.close();
            }
        }
        registryReaderDLLFile.deleteOnExit();
        System.out.println("dllFilePath = " + registryReaderDLLFile.getAbsolutePath());
        System.out.println("dllFilePath = " + registryReaderDLLFile.getAbsolutePath());
        return registryReaderDLLFile.getAbsolutePath();
    }

    public String getTempDirectory() {
        block3: {
            if (this.tempDirectory != null && this.tempDirectory.trim().length() == 0) break block3;
            try {
                this.tempDirectory = System.getProperty("java.io.tmpdir");
                this.tempDirectory = this.tempDirectory + File.separator + "proxylet001" + File.separator;
                File f = new File(this.tempDirectory);
                if (!f.isDirectory()) {
                    f.mkdir();
                }
            }
            catch (Exception e) {
                this.tempDirectory = System.getProperty("java.io.tmpdir");
            }
        }
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDir) {
        this.tempDirectory = tempDir;
    }

    public String getBrowserLaunchCommand(String browserName, String browserVersion) {
        String brName = browserName.trim().toLowerCase();
        System.out.println("browser name " + brName);
        System.out.println("browser version " + browserVersion);
        String command = this.getBrowserInstallPath(this.getBrowserRegistryKeyName(brName), browserVersion.trim());
        System.out.println("launch url " + command);
        if (brName.indexOf("msie") != -1) {
            command = command + "\\iexplore.exe";
        }
        return command;
    }

    private String getBrowserRegistryKeyName(String browserName) {
        if ((browserName = browserName.trim().toLowerCase()).equals("mozilla")) {
            return "mozilla.org";
        }
        if (browserName.indexOf("firefox") != -1) {
            return "mozilla";
        }
        if (browserName.indexOf("netscape") != -1) {
            return "netscape";
        }
        return browserName;
    }

    public boolean detectJWSInstallation() {
        String value = this.getJWSVersion();
        System.out.println("detect jws installation " + value);
        float jwsVer = 0.0f;
        jwsVer = new Float(value.substring(0, 3)).floatValue();
        return new Float(jwsVer).compareTo(new Float(1.4)) >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            System.out.println("trying to load library... ");
            System.loadLibrary("RegReader");
            System.out.println("loaded library..");
            dllLoaded = true;
        }
        catch (Throwable e) {
            System.out.println("could not load library in static block - " + e.getMessage());
            dllLoaded = false;
        }
    }
}

