/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.FilterRule;

public class StringFilter {
    int op;
    public String filter;
    boolean doCase = false;
    public String directive;
    public int method;

    public StringFilter(String dir, int method, String text) {
        this.directive = dir;
        this.method = method;
        this.filter = text;
    }

    String escapeString(String s) {
        char[] line = s.toCharArray();
        StringBuffer outStr = new StringBuffer();
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == '\\' || line[i] == '\"') {
                outStr.append('\\');
                outStr.append(line[i]);
                continue;
            }
            outStr.append(line[i]);
        }
        return outStr.toString();
    }

    public String toXMLString() {
        return "<Filter src=\"" + this.directive + "\" " + this.method + "=\"" + this.filter + "\"/>\n";
    }

    public String toConfigString() {
        return "Filter src=" + this.directive + " " + FilterRule.getMethodText(this.method) + "=\"" + this.escapeString(this.filter) + "\"\n";
    }

    boolean do_prefix(String s) {
        if (this.doCase) {
            return s.startsWith(this.filter);
        }
        return s.toLowerCase().startsWith(this.filter.toLowerCase());
    }

    boolean do_suffix(String s) {
        if (this.doCase) {
            return s.endsWith(this.filter);
        }
        return s.toLowerCase().endsWith(this.filter.toLowerCase());
    }

    boolean do_exact(String s) {
        if (this.doCase) {
            return s.equals(this.filter);
        }
        return s.equalsIgnoreCase(this.filter);
    }

    boolean do_substr(String s) {
        if (this.doCase) {
            return s.indexOf(this.filter) > 0;
        }
        return s.toLowerCase().indexOf(this.filter.toLowerCase()) > 0;
    }

    public boolean isMatch(String s) {
        switch (this.op) {
            case 0: {
                return this.do_exact(s);
            }
            case 1: {
                return this.do_prefix(s);
            }
            case 2: {
                return this.do_suffix(s);
            }
            case 3: {
                return this.do_substr(s);
            }
        }
        return false;
    }
}

