/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.ConverterConfig;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.ProcessConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RobotConfig {
    HashMap rules = null;
    HashMap rulesets = null;
    int lastRulesetID = 0;
    public int lastRuleID = 0;
    public static final int ALLOW = 1;
    public static final int DENY = 2;
    public static final int GO_NEXT = 3;
    public String filterrules_conf = null;
    public String process_conf = null;
    StringBuffer frs_header_comment = null;
    ArrayList pre_comment = null;
    String[] RulesetIDs = null;
    String[] RuleIDs = null;
    String[] RuleNicknames = null;
    public ProcessConfig processConf = null;
    ArrayList filterConf = null;
    int extractSizeNdx = -1;
    int extractSize = -1;
    static final int full_text_size = 32000;
    public ConverterConfig convertConf = null;

    public static void main(String[] args) {
        RobotConfig rc = new RobotConfig(args[0]);
        if (args.length == 3) {
            rc.newRuleset(args[1], Integer.parseInt(args[2]), false, null);
        }
        System.out.println("ROBOT.CONF:\n" + rc.processConf.toString());
    }

    public RobotConfig(String conf_dir) {
        this.filterrules_conf = conf_dir + File.separator + "filterrules.conf";
        this.process_conf = conf_dir + File.separator + "robot.conf";
        this.rules = new HashMap();
        this.rulesets = new HashMap();
        this.parse_filterrules(this.filterrules_conf);
        try {
            this.processConf = ProcessConfig.parseProcessConf(this.process_conf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parse_filterConf(conf_dir + File.separator + "filter.conf");
        this.convertConf = new ConverterConfig(conf_dir);
    }

    void parse_filterConf(String file) {
        BufferedReader in = null;
        String line = null;
        this.filterConf = new ArrayList();
        try {
            in = new BufferedReader(new FileReader(file));
            line = in.readLine();
            while (line != null) {
                this.filterConf.add(line);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            return;
        }
    }

    int getExtractSize() {
        if (this.filterConf == null) {
            return 32000;
        }
        if (this.extractSize > 0) {
            return this.extractSize;
        }
        for (int i = 0; i < this.filterConf.size(); ++i) {
            int end;
            int ndx;
            String line = (String)this.filterConf.get(i);
            if (line == null || !line.startsWith("Generate") || line.indexOf("fn=extract-full-text") <= 0 || (ndx = line.indexOf("truncate=")) <= 0 || (end = line.indexOf(32, ndx + 9)) <= 0) continue;
            String value = line.substring(ndx + 9, end);
            this.extractSizeNdx = i;
            return Integer.parseInt(value);
        }
        return 32000;
    }

    void parse_filterrules(String file) {
        int status = 0;
        FilterRule curr_fr = null;
        FilterRuleset curr_frset = null;
        String line = null;
        BufferedReader in = null;
        String ruleTag = "";
        String rulesetTag = "";
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            line = in.readLine();
        }
        catch (IOException e) {
            return;
        }
        boolean afterComment = false;
        while (line != null) {
            String nline = line.trim();
            if (nline.length() == 0) {
                try {
                    line = in.readLine();
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (nline.startsWith("#")) {
                switch (status) {
                    case 0: {
                        if (nline.startsWith("#FR#")) {
                            afterComment = true;
                            break;
                        }
                        if (!afterComment) {
                            this.addComment(nline);
                            break;
                        }
                        this.addPreComment(nline);
                        break;
                    }
                    case 2: {
                        curr_fr.addComment(line.substring(1));
                        break;
                    }
                    case 4: {
                        curr_frset.addComment(line.substring(1));
                    }
                }
                try {
                    line = in.readLine();
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
            switch (status) {
                case 0: {
                    if (nline.startsWith("<Rule ")) {
                        ruleTag = ruleTag + " " + nline;
                        if (nline.endsWith(">")) {
                            curr_fr = new FilterRule(ruleTag);
                            curr_fr.addPreComment(this.pre_comment);
                            this.pre_comment = null;
                            this.rules.put(curr_fr.id, curr_fr);
                            if (Integer.parseInt(curr_fr.id) > this.lastRuleID) {
                                this.lastRuleID = Integer.parseInt(curr_fr.id);
                            }
                            ruleTag = "";
                            status = 2;
                        } else {
                            status = 1;
                        }
                    } else if (nline.startsWith("<Ruleset ")) {
                        rulesetTag = rulesetTag + " " + nline;
                        if (nline.endsWith(">")) {
                            curr_frset = new FilterRuleset(rulesetTag);
                            curr_frset.addPreComment(this.pre_comment);
                            this.pre_comment = null;
                            this.rulesets.put(curr_frset.id, curr_frset);
                            if (Integer.parseInt(curr_frset.id) > this.lastRulesetID) {
                                this.lastRulesetID = Integer.parseInt(curr_frset.id);
                            }
                            rulesetTag = "";
                            status = 4;
                        } else {
                            status = 3;
                        }
                    } else {
                        System.out.println("Invalid statement:" + nline);
                    }
                    afterComment = true;
                    break;
                }
                case 1: {
                    ruleTag = ruleTag + " " + nline;
                    if (!nline.endsWith(">")) break;
                    curr_fr = new FilterRule(ruleTag);
                    curr_fr.addPreComment(this.pre_comment);
                    this.pre_comment = null;
                    this.rules.put(curr_fr.id, curr_fr);
                    if (Integer.parseInt(curr_fr.id) > this.lastRuleID) {
                        this.lastRuleID = Integer.parseInt(curr_fr.id);
                    }
                    ruleTag = "";
                    status = 2;
                    break;
                }
                case 2: {
                    if (nline.startsWith("</Rule>")) {
                        status = 0;
                        break;
                    }
                    if (!nline.startsWith("Filter")) break;
                    curr_fr.addFilter(nline);
                    break;
                }
                case 3: {
                    rulesetTag = rulesetTag + " " + nline;
                    if (!nline.endsWith(">")) break;
                    curr_frset = new FilterRuleset(rulesetTag);
                    curr_frset.addPreComment(this.pre_comment);
                    this.pre_comment = null;
                    this.rulesets.put(curr_frset.id, curr_frset);
                    if (Integer.parseInt(curr_frset.id) > this.lastRulesetID) {
                        this.lastRulesetID = Integer.parseInt(curr_frset.id);
                    }
                    rulesetTag = "";
                    status = 4;
                    break;
                }
                case 4: {
                    if (nline.startsWith("</Ruleset>")) {
                        status = 0;
                        break;
                    }
                    if (!nline.startsWith("Rule")) break;
                    curr_frset.AddFilterbyString(nline);
                }
            }
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                break;
            }
        }
        this.getRuleIDs();
        this.getRulsetIDs();
    }

    public void updateFile() {
        PrintWriter out = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.filterrules_conf);
            out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF-8")), true);
        }
        catch (Exception e) {
            System.out.println("[updateFile]Exception:" + e.getMessage());
            return;
        }
        if (this.frs_header_comment != null) {
            out.print(this.frs_header_comment);
        }
        out.print("#FR###########################################################################\n");
        out.print("#FR# Rules\n");
        out.print("#FR###########################################################################\n\n");
        this.printRules(out);
        out.print("#FR###########################################################################\n");
        out.print("#FR# Rulesets\n");
        out.print("#FR###########################################################################\n\n");
        this.printRuleSets(out);
        out.print("#FR######################################################\n");
        out.print("#FR# Nothing after the last </ruleset> is saved.\n");
        out.print("#FR######################################################\n");
        out.close();
    }

    public String newPathFilterRule(String path) {
        String pathNick = "pathname " + path;
        for (int i = 0; i < this.RuleNicknames.length; ++i) {
            if (!pathNick.equals(this.RuleNicknames[i])) continue;
            return this.RuleIDs[i];
        }
        String ruleID = Integer.toString(this.lastRuleID + 1);
        FilterRule fr = new FilterRule(ruleID, true, "pathname " + path, true, false);
        if (fr != null) {
            fr.addFilter(FilterRule.filter_srcs[3], FilterRule.filter_methods[2], path);
            this.AddRule(ruleID, fr);
        }
        return ruleID;
    }

    public String getIDByNick(String nick) {
        for (int i = 0; i < this.RuleNicknames.length; ++i) {
            if (!nick.equals(this.RuleNicknames[i])) continue;
            return this.RuleIDs[i];
        }
        return null;
    }

    public FilterRuleset newRuleset(String urlText, int depth, boolean isDomain, String ruleID) {
        FilterRuleset frs = null;
        try {
            URL url = new URL(urlText);
            frs = this.newRuleset(url, depth, isDomain, ruleID);
        }
        catch (Exception e) {
            // empty catch block
        }
        return frs;
    }

    public FilterRuleset findFiletrRulesetHasDomain(String domain) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset frs = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (frs.getType() != 2) continue;
            for (int j = 0; j < frs.numOfDomains(); ++j) {
                String domainname = frs.getDomainByIndex(j);
                if (!domain.equals(domainname)) continue;
                return frs;
            }
        }
        return null;
    }

    public FilterRuleset findFiletrRulesetHasStartingPoint(String urlText) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset frs = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            for (int j = 0; j < frs.numOfStartingPoints(); ++j) {
                String sp = frs.getStartingPointByIndex(j);
                if (!sp.startsWith(urlText.trim() + " ")) continue;
                return frs;
            }
        }
        return null;
    }

    FilterRuleset findFiletrRulesetFor(URL url) {
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset frs = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (!frs.isForMe(url)) continue;
            return frs;
        }
        return null;
    }

    public String[] getFiletrRulesetIDsForFilterRule(String id) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.RulesetIDs.length; ++i) {
            FilterRuleset frs = (FilterRuleset)this.rulesets.get(this.RulesetIDs[i]);
            if (!frs.isFilterInUsed(id)) continue;
            ids.add(frs.id);
        }
        if (ids.size() > 0) {
            String[] a = new String[]{""};
            return ids.toArray(a);
        }
        return null;
    }

    public FilterRuleset newRuleset(URL url, int depth, boolean isDomain, String ruleID) {
        FilterRule fr;
        String s_points = url.toString() + " depth=" + depth;
        FilterRuleset frs = null;
        if (!isDomain && (frs = this.findFiletrRulesetFor(url)) != null) {
            FilterRule fr2;
            frs.addStartingPoint(url, depth);
            if (ruleID != null && (fr2 = (FilterRule)this.rules.get(ruleID)) != null && fr2.enable && !frs.onExit) {
                frs.AddFilter(fr2.id, fr2.default_ad);
            }
            return frs;
        }
        String host = url.getHost();
        String proto = url.getProtocol();
        int port = url.getPort();
        String server = proto + "://" + host + (port > 0 ? ":" + Integer.toString(port) : "") + "/";
        int newID = this.lastRulesetID + 1;
        if (isDomain) {
            String domain = host;
            int ndx = host.indexOf(46);
            if (ndx > 0) {
                domain = host.substring(ndx + 1);
            }
            frs = new FilterRuleset(Integer.toString(newID), true, false, true, domain, domain, "", "http,file,ftp,https", s_points, null);
        } else {
            frs = new FilterRuleset(Integer.toString(newID), true, false, ruleID == null, host, server, s_points, null);
        }
        if (this.RuleIDs == null) {
            this.freshRulesArray();
        }
        for (int i = 0; i < this.RuleIDs.length; ++i) {
            FilterRule fr3 = (FilterRule)this.rules.get(this.RuleIDs[i]);
            if (fr3 == null || !fr3.enable || !fr3.quickcf) continue;
            frs.AddFilter(fr3.id, fr3.default_ad);
        }
        if (ruleID != null && (fr = (FilterRule)this.rules.get(ruleID)) != null && fr.enable) {
            frs.AddFilter(fr.id, fr.default_ad);
        }
        this.rulesets.put(Integer.toString(newID), frs);
        this.RulesetIDs = null;
        this.getRulsetIDs();
        this.lastRulesetID = newID;
        return frs;
    }

    public boolean delRuleset(int index) {
        if (index < 0 || index >= this.RulesetIDs.length) {
            return false;
        }
        return this.delRuleset(this.RulesetIDs[index]);
    }

    void removeAssoicatedPathFilter(String id) {
        int i;
        FilterRuleset frs = this.GetRuleSet(id);
        if (frs == null) {
            return;
        }
        int numOfFilter = frs.numOfFilters();
        ArrayList<String> delIDs = new ArrayList<String>();
        for (i = 0; i < numOfFilter; ++i) {
            String[] frss;
            String ruleID = frs.getFiltersIDByIndex(i);
            FilterRule fr = this.GetRule(ruleID);
            if (!fr.nickname.startsWith("pathname ") || (frss = this.getFiletrRulesetIDsForFilterRule(ruleID)) == null || frss.length != 1 || !frss[0].equals(id)) continue;
            delIDs.add(ruleID);
        }
        for (i = 0; i < delIDs.size(); ++i) {
            this.delRule((String)delIDs.get(i));
        }
    }

    public boolean delRuleset(String id) {
        if (id == null || this.rulesets == null) {
            return false;
        }
        this.removeAssoicatedPathFilter(id);
        if (this.rulesets.remove(id) != null) {
            this.RulesetIDs = null;
            this.getRulsetIDs();
            return true;
        }
        return false;
    }

    public boolean delRule(int index) {
        if (index < 0 || index >= this.RuleIDs.length) {
            return false;
        }
        return this.delRule(this.RuleIDs[index]);
    }

    public boolean delRule(String id) {
        if (id == null || this.rules == null) {
            return false;
        }
        if (this.rules.remove(id) != null) {
            this.freshRulesArray();
            this.rmRuleFromRuleset(id);
            return true;
        }
        return false;
    }

    void rmRuleFromRuleset(String ruleid) {
        Iterator it = this.rulesets.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            FilterRuleset frs = (FilterRuleset)this.rulesets.get(key);
            if (frs == null) continue;
            frs.deleteFilterByID(ruleid);
        }
    }

    public void AddRule(String id, FilterRule fr) {
        this.rules.put(id, fr);
        this.freshRulesArray();
        if (Integer.parseInt(id) > this.lastRuleID) {
            this.lastRuleID = Integer.parseInt(id);
        }
    }

    public int numOfRules() {
        return this.rules.size();
    }

    public FilterRule GetRule(String id) {
        return (FilterRule)this.rules.get(id);
    }

    public FilterRule GetRuleByIndex(int index) {
        if (this.RuleIDs == null) {
            this.freshRulesArray();
        }
        if (index < 0 || index >= this.RuleIDs.length) {
            return null;
        }
        return (FilterRule)this.rules.get(this.RuleIDs[index]);
    }

    public void AddRuleSet(String key, FilterRuleset frs) {
        this.rulesets.put(key, frs);
    }

    public FilterRuleset GetRuleSet(String key) {
        return (FilterRuleset)this.rulesets.get(key);
    }

    public FilterRuleset GetRuleSet(int index) {
        if (index < 0 || index >= this.RulesetIDs.length) {
            return null;
        }
        return (FilterRuleset)this.rulesets.get(this.RulesetIDs[index]);
    }

    public int numRuleset() {
        return this.rulesets.size();
    }

    public int numRule() {
        return this.rules.size();
    }

    public String[] getRulsetIDs() {
        if (this.RulesetIDs != null) {
            return this.RulesetIDs;
        }
        this.RulesetIDs = new String[this.rulesets.size()];
        Iterator it = this.rulesets.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            this.RulesetIDs[i++] = (String)it.next();
        }
        return this.RulesetIDs;
    }

    public void freshRulesArray() {
        FilterRule fr;
        Object key;
        this.RuleIDs = new String[this.rules.size()];
        this.RuleNicknames = new String[this.rules.size()];
        int[] ids = new int[this.rules.size()];
        Iterator it = this.rules.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            key = it.next();
            fr = (FilterRule)this.rules.get(key);
            ids[i++] = Integer.parseInt(fr.id);
        }
        Arrays.sort(ids);
        for (i = 0; i < ids.length; ++i) {
            key = Integer.toString(ids[i]);
            fr = (FilterRule)this.rules.get(key);
            this.RuleIDs[i] = key;
            this.RuleNicknames[i] = fr.nickname;
        }
    }

    public String[] getRuleIDs() {
        if (this.RuleIDs == null || this.RuleNicknames == null) {
            this.freshRulesArray();
        }
        return this.RuleIDs;
    }

    public String[] getRuleNicknames() {
        if (this.RuleIDs == null || this.RuleNicknames == null) {
            this.freshRulesArray();
        }
        return this.RuleNicknames;
    }

    public String getRuleNickname(String ruleID) {
        if (this.RuleIDs == null || this.RuleNicknames == null) {
            this.freshRulesArray();
        }
        int index = 0;
        String[] nicks = this.getRuleNicknames();
        String[] ruleids = this.getRuleIDs();
        for (int i = 0; i < ruleids.length; ++i) {
            if (!ruleID.equalsIgnoreCase(ruleids[i])) continue;
            index = i;
        }
        return nicks[index];
    }

    public boolean FilterURL(String u) {
        String ustring;
        boolean r = false;
        URL url = null;
        try {
            url = new URL(u);
            String portocol = url.getProtocol();
            String host = url.getHost();
            String port = Integer.toString(url.getPort());
            ustring = portocol + "://" + host + ":" + port + "/";
            System.out.println("Finding FRS for url:" + ustring);
        }
        catch (MalformedURLException e) {
            System.out.println("Invalid URL:<" + u + ">");
            return true;
        }
        FilterRuleset frs = this.GetRuleSet(ustring);
        if (frs == null) {
            return true;
        }
        return frs.Filter(u);
    }

    public void printRules(PrintWriter out) {
        for (int i = 0; i < this.RuleIDs.length; ++i) {
            FilterRule fr = (FilterRule)this.rules.get(this.RuleIDs[i]);
            if (fr == null) continue;
            out.println();
            out.print(fr.toConfigString());
        }
    }

    public int numOfStartingPoint(boolean checkEnable) {
        Iterator it = this.rulesets.keySet().iterator();
        int num = 0;
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                FilterRuleset frs = (FilterRuleset)this.rulesets.get(key);
                if (checkEnable && !frs.enable) continue;
                num += frs.starting_points.size();
            }
            catch (NoSuchElementException e) {
                break;
            }
        }
        return num;
    }

    public void printRuleSets(PrintWriter out) {
        Iterator it = this.rulesets.keySet().iterator();
        while (it.hasNext()) {
            try {
                String key = (String)it.next();
                FilterRuleset frs = (FilterRuleset)this.rulesets.get(key);
                out.print(frs.toConfigString());
            }
            catch (NoSuchElementException e) {
                break;
            }
        }
    }

    public boolean RuleMatch(String key, String u) {
        FilterRule fr = (FilterRule)this.rules.get(key);
        if (fr == null) {
            return false;
        }
        return fr.Match(u);
    }

    public static String ADtoString(boolean b) {
        if (b) {
            return "allow";
        }
        return "deny";
    }

    public static boolean ADStringtoBoolean(String ad) {
        return ad.compareToIgnoreCase("allow") == 0;
    }

    public static String BtoString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static boolean StringtoBoolean(String s) {
        return s.compareToIgnoreCase("true") == 0;
    }

    public void addComment(String comm) {
        if (this.frs_header_comment == null) {
            this.frs_header_comment = new StringBuffer(comm + "\n");
        } else {
            this.frs_header_comment.append(comm + "\n");
        }
    }

    public void addPreComment(String comm) {
        if (this.pre_comment == null) {
            this.pre_comment = new ArrayList();
        }
        this.pre_comment.add(comm.substring(1));
    }
}

