/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ProcessConfig {
    Map avs = null;
    ArrayList avsArray = null;
    ArrayList inProcessArray = null;
    String csid = null;
    public String fileName = null;
    ArrayList preComment = null;
    ArrayList afterComment = null;
    long fileLastModified = 0L;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: ProcessConfig inputFileName outputFileName");
        }
        ProcessConfig processConf = ProcessConfig.parseProcessConf(args[0]);
        processConf.updateFile(args[1]);
    }

    public ProcessConfig(String file_name) {
        this.fileName = file_name;
        this.Init();
    }

    private void Init() {
        this.avs = new HashMap();
        this.avsArray = new ArrayList();
        this.inProcessArray = new ArrayList();
        this.preComment = new ArrayList();
        this.afterComment = new ArrayList();
    }

    private void reInit() {
        try {
            File file = new File(this.fileName);
            long lastmodified = file.lastModified();
            if (lastmodified <= this.fileLastModified) {
                return;
            }
            this.Init();
            this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ProcessConfig parseProcessConf(String file) throws Exception {
        ProcessConfig processConf = new ProcessConfig(file);
        processConf.parse();
        return processConf;
    }

    String Quote(String value) {
        boolean needQuote = false;
        StringBuffer outBuffer = new StringBuffer();
        char[] str = (value = value.trim()).toCharArray();
        if (str.length == 0) {
            return "";
        }
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == '\\' || str[i] == '\"') {
                outBuffer.append('\\');
                outBuffer.append(str[i]);
                continue;
            }
            if (Character.isWhitespace(str[i]) || !Character.isLetterOrDigit(str[i])) {
                needQuote = true;
                outBuffer.append(str[i]);
                continue;
            }
            outBuffer.append(str[i]);
        }
        if (needQuote) {
            return "\"" + outBuffer.toString() + "\"";
        }
        return outBuffer.toString();
    }

    AVPair str2AVPair(String line) throws Exception {
        boolean quoted;
        int valstart;
        int end = 0;
        int eos = 0;
        boolean isCommentOut = false;
        if (line.startsWith("#")) {
            isCommentOut = true;
            line = line.substring(1);
        }
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        char[] str = (line = line.trim()).toCharArray();
        if (str.length == 0) {
            return null;
        }
        eos = str.length;
        for (end = 0; end < eos && !Character.isWhitespace(str[end]) && str[end] != '='; ++end) {
        }
        if (end == eos || Character.isWhitespace(str[end])) {
            return null;
        }
        String atr = line.substring(0, end);
        if ((valstart = ++end) == eos) {
            return new AVPair(atr, "", isCommentOut);
        }
        StringBuffer val = new StringBuffer();
        boolean bl = quoted = str[valstart] == '\"';
        if (quoted) {
            ++valstart;
        }
        for (end = valstart; end < eos; ++end) {
            if (quoted) {
                if (str[end] == '\"') {
                    ++end;
                    break;
                }
            } else if (Character.isWhitespace(str[end])) break;
            if (str[end] == '\\') {
                ++end;
            }
            if (end >= eos) continue;
            val.append(str[end]);
        }
        return new AVPair(atr, val.toString(), isCommentOut);
    }

    private void parse() throws Exception {
        File file = new File(this.fileName);
        this.fileLastModified = file.lastModified();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = in.readLine();
        boolean inProcessTag = false;
        boolean inProcess = false;
        boolean afterProcess = false;
        while (line != null) {
            AVPair av;
            line = line.trim();
            if (!afterProcess && inProcessTag) {
                if (line.startsWith(">")) {
                    inProcessTag = false;
                    inProcess = true;
                } else {
                    av = this.str2AVPair(line);
                    this.avs.put(av.name, av);
                    this.avsArray.add(av);
                }
            } else if (!afterProcess && inProcess) {
                if (line.startsWith("</Process")) {
                    afterProcess = true;
                    inProcess = false;
                } else {
                    this.inProcessArray.add(line);
                }
            } else if (line.startsWith("<Process ")) {
                inProcessTag = true;
                line = line.substring(9);
                av = this.str2AVPair(line);
                if (av.name.compareToIgnoreCase("csid") != 0) {
                    throw new Exception("Missing csid=... in <Process ...");
                }
                this.csid = av.valueString;
            } else if (afterProcess) {
                this.afterComment.add(line);
            } else {
                this.preComment.add(line);
            }
            line = in.readLine();
        }
    }

    public void updateFile() {
        this.updateFile(this.fileName);
    }

    public void updateFile(String filename) {
        PrintWriter out = null;
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            out = new PrintWriter(fout, true);
        }
        catch (Exception e) {
            System.out.println("[updateProcessConf]Exception:" + e.getMessage());
            return;
        }
        this.updateFile(out);
    }

    public void updateFile(PrintWriter out) {
        int i;
        for (i = 0; i < this.preComment.size(); ++i) {
            out.println((String)this.preComment.get(i));
        }
        out.println("<Process csid=" + this.Quote(this.csid));
        for (i = 0; i < this.avsArray.size(); ++i) {
            AVPair av = (AVPair)this.avsArray.get(i);
            if (av.comment) {
                out.print("#   ");
            } else {
                out.print("    ");
            }
            out.println(av.name + "=" + this.Quote(av.valueString));
        }
        out.println(">");
        for (i = 0; i < this.inProcessArray.size(); ++i) {
            out.println((String)this.inProcessArray.get(i));
        }
        out.println("</Process>");
        for (i = 0; i < this.afterComment.size(); ++i) {
            out.println((String)this.afterComment.get(i));
        }
        out.close();
    }

    public String get(String name) {
        this.reInit();
        AVPair av = (AVPair)this.avs.get(name);
        if (av != null && !av.comment) {
            return av.valueString;
        }
        return null;
    }

    public void put(String name, String value) {
        AVPair av;
        int index = -1;
        if (name == null || value == null) {
            return;
        }
        if (this.avs.containsKey(name) && (av = (AVPair)this.avs.get(name)) != null) {
            if (!av.comment || value.length() > 0) {
                av = (AVPair)this.avs.remove(name);
                if (av != null) {
                    index = this.avsArray.indexOf(av);
                    this.avsArray.remove(av);
                }
            } else {
                return;
            }
        }
        if (value.length() > 0) {
            av = new AVPair(name, value, false);
            this.avs.put(name, av);
            if (index >= 0) {
                this.avsArray.add(index, av);
            } else {
                this.avsArray.add(av);
            }
        }
    }

    class AVPair {
        String name = null;
        String valueString = null;
        boolean comment = false;

        AVPair(String attribute, String value, boolean isCommentOut) {
            this.name = attribute;
            this.valueString = value;
            this.comment = isCommentOut;
        }
    }
}

