/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.robot.RuleSet;
import com.sun.portal.search.util.PBlock;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FilterRuleset {
    public String id;
    public boolean enable = false;
    public boolean onMatch = false;
    public boolean onExit = false;
    public String nickname;
    public ArrayList servers = null;
    public ArrayList domains = null;
    public String ports = "";
    public ArrayList starting_points = null;
    public ArrayList protocols = null;
    public ArrayList rules = new ArrayList();
    public ArrayList dns_cnames = null;
    public String database = null;
    public ArrayList comments = null;
    public ArrayList pre_comments = null;
    RobotConfig config = null;
    public static final int TYPE_SERVERS = 1;
    public static final int TYPE_DOMAINS = 2;
    public static String[] Types = new String[]{"Site", "http", "https", "ftp", "file", "domain"};
    public static String[] ProtocolTypes = new String[]{"http", "file", "ftp", "https"};
    public static String[] ProtocolType_Labels = new String[]{"Web Server", "File Server", "FTP Server", "Secure Web Server"};

    ArrayList stringToArrayList(String s, String delim) {
        ArrayList<String> ls = null;
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            if (ls == null) {
                ls = new ArrayList<String>();
            }
            ls.add(st.nextToken().trim());
        }
        return ls;
    }

    ArrayList stringToArrayList1(String s, String delim) {
        if (s == null) {
            return null;
        }
        ArrayList<String> ls = new ArrayList<String>();
        int ndx = -1;
        while ((ndx = s.indexOf(delim)) > 0) {
            if (ls == null) {
                // empty if block
            }
            ls.add(s.substring(0, ndx));
            s = s.substring(ndx + delim.length());
        }
        if (s.trim().length() > 0) {
            ls.add(s.trim());
        }
        return ls;
    }

    String arrayListToString(ArrayList ls, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ls.size(); ++i) {
            sb.append(ls.get(i));
            if (i >= ls.size() - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public FilterRuleset(String tag) {
        HashMap avs = new HashMap();
        String valueText = null;
        try {
            PBlock.str2pblock((String)tag, avs);
        }
        catch (Exception e) {
            System.out.println("PBlockstr2pblock:Exception:" + e.getMessage());
        }
        valueText = (String)avs.get("id");
        if (valueText != null) {
            this.id = valueText;
        }
        if ((valueText = (String)avs.get("enable")) != null && valueText.compareToIgnoreCase("TRUE") == 0) {
            this.enable = true;
        }
        if ((valueText = (String)avs.get("onMatch")) != null && valueText.compareToIgnoreCase("ALLOW") == 0) {
            this.onMatch = true;
        }
        if ((valueText = (String)avs.get("onExit")) != null && valueText.compareToIgnoreCase("ALLOW") == 0) {
            this.onExit = true;
        }
        if ((valueText = (String)avs.get("nickname")) != null) {
            this.nickname = valueText;
        }
        if ((valueText = (String)avs.get("servers")) != null) {
            this.servers = this.stringToArrayList(valueText, ",");
        }
        if ((valueText = (String)avs.get("domains")) != null) {
            this.domains = this.stringToArrayList(valueText, ",");
        }
        if ((valueText = (String)avs.get("ports")) != null) {
            this.ports = valueText;
        }
        if ((valueText = (String)avs.get("protocols")) != null) {
            this.protocols = this.stringToArrayList(valueText, ",");
        }
        if ((valueText = (String)avs.get("starting-points")) != null) {
            this.starting_points = this.stringToArrayList1(valueText, ", ");
        }
        if ((valueText = (String)avs.get("dns-alias-to-cname")) != null) {
            this.dns_cnames = this.stringToArrayList(valueText, ",");
        }
        if ((valueText = (String)avs.get("database")) != null) {
            this.database = valueText;
        }
    }

    FilterRuleset(String id, boolean en, boolean onmatch, boolean onexit, String nick, String domain, String ports, String portocols, String starting_point, String targetDatabase) {
        this.id = id;
        this.enable = en;
        this.onMatch = onmatch;
        this.onExit = onexit;
        this.nickname = nick;
        this.domains = new ArrayList();
        this.domains.add(domain);
        this.ports = ports;
        this.protocols = this.stringToArrayList(portocols, ",");
        this.starting_points = new ArrayList();
        this.starting_points.add(starting_point);
        this.database = targetDatabase;
    }

    FilterRuleset(String id, boolean en, boolean onmatch, boolean onexit, String nick, String sname, String starting_point, String targetDatabase) {
        this.id = id;
        this.enable = en;
        this.onMatch = onmatch;
        this.onExit = onexit;
        this.nickname = nick;
        this.servers = new ArrayList();
        this.servers.add(sname);
        this.starting_points = new ArrayList();
        this.starting_points.add(starting_point);
        this.database = targetDatabase;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer("<Ruleset id=\"" + this.id + "\" enable=\"" + RobotConfig.BtoString(this.enable) + "\" onMatch=\"" + RobotConfig.ADtoString(this.onMatch) + "\" onExit=\"" + RobotConfig.ADtoString(this.onExit) + "\" \nnickname=\"" + this.nickname + "\" servers=\"" + this.servers + "\" starting-points=\"" + this.starting_points + "\">\n");
        ListIterator it = this.rules.listIterator(0);
        try {
            while (true) {
                RuleSet rs = (RuleSet)it.next();
                sb.append(rs.toXMLString());
            }
        }
        catch (NoSuchElementException e) {
            return sb.toString();
        }
    }

    public String toConfigString() {
        String comm;
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.pre_comments != null) {
            sb.append("#\n");
            for (i = 0; i < this.pre_comments.size(); ++i) {
                comm = (String)this.pre_comments.get(i);
                sb.append("# " + comm + "\n");
            }
            sb.append("#\n");
        }
        sb.append("<Ruleset id=" + this.id + " enable=" + RobotConfig.BtoString(this.enable) + " onMatch=" + RobotConfig.ADtoString(this.onMatch) + " onExit=" + RobotConfig.ADtoString(this.onExit) + "\n" + "      nickname=\"" + this.nickname + "\"\n");
        if (this.servers != null) {
            sb.append("      servers=\"" + this.servers.toString().substring(1, this.servers.toString().length() - 1) + "\"\n");
        } else if (this.domains != null) {
            sb.append("      domains=\"" + this.domains.toString().substring(1, this.domains.toString().length() - 1) + "\"\n");
            if (this.ports.length() > 0) {
                sb.append("      ports=\"" + this.ports + "\"\n");
            }
            if (this.protocols != null) {
                sb.append("      protocols=\"" + this.protocols.toString().substring(1, this.protocols.toString().length() - 1) + "\"\n");
            }
        }
        if (this.dns_cnames != null && this.dns_cnames.size() > 0) {
            sb.append("      dns-alias-to-cname=\"" + this.dns_cnames.toString().substring(1, this.dns_cnames.toString().length() - 1) + "\"\n");
        }
        if (this.database != null) {
            sb.append("      database=\"" + this.database + "\"\n");
        }
        if (this.starting_points != null) {
            sb.append("      starting-points=\"" + this.arrayListToString(this.starting_points, ", ") + "\"");
        }
        sb.append(">\n");
        if (this.comments != null) {
            sb.append("#\n");
            for (i = 0; i < this.comments.size(); ++i) {
                comm = (String)this.comments.get(i);
                sb.append("# " + comm + "\n");
            }
            sb.append("#\n");
        }
        ListIterator it = this.rules.listIterator(0);
        while (it.hasNext()) {
            try {
                RuleSet rs = (RuleSet)it.next();
                sb.append(rs.toConfigString());
            }
            catch (NoSuchElementException e) {
                // empty catch block
                break;
            }
        }
        sb.append("</Ruleset>\n");
        return sb.toString();
    }

    public void AddFilterbyString(String rules) {
        HashMap avs = new HashMap();
        String r_id = null;
        boolean r_onMatch = false;
        String valueText = null;
        try {
            PBlock.str2pblock((String)rules, avs);
        }
        catch (Exception e) {
            System.out.println("[AddFilterbyString]PBlockstr2pblock:Exception:" + e.getMessage());
        }
        valueText = (String)avs.get("id");
        if (valueText != null) {
            r_id = valueText;
        }
        if ((valueText = (String)avs.get("onMatch")) != null && valueText.compareToIgnoreCase("ALLOW") == 0) {
            r_onMatch = true;
        }
        if (this.id != null) {
            this.AddFilter(r_id, r_onMatch);
        }
    }

    public void AddFilter(String fid, boolean match) {
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleSet ors = (RuleSet)this.rules.get(i);
            if (!ors.rule_id.equals(fid)) continue;
            return;
        }
        RuleSet rs = new RuleSet(fid, match);
        this.rules.add(rs);
    }

    public boolean Filter(String u) {
        ListIterator it = this.rules.listIterator(0);
        try {
            RuleSet rs;
            FilterRule fr;
            do {
                rs = (RuleSet)it.next();
            } while (!(fr = this.config.GetRule(rs.rule_id)).Match(u));
            return rs.onMatch;
        }
        catch (NoSuchElementException e) {
            return !this.onExit;
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean enable) {
        this.enable = enable;
    }

    public void addDNSTranslations(String dnsTrans) {
        ArrayList trans = this.stringToArrayList(dnsTrans, ",");
        for (int i = 0; i < trans.size(); ++i) {
            String item = (String)trans.get(i);
            if (item.trim().length() <= 0) continue;
            this.addDNSTranslation(item.trim());
        }
    }

    public void addDNSTranslation(String dnsTrans) {
        if (this.dns_cnames == null) {
            this.dns_cnames = new ArrayList();
        }
        this.dns_cnames.add(dnsTrans);
    }

    public void addComments(String comm) {
        if (comm == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(comm, "\n");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.length() <= 0) continue;
            this.addComment(t);
        }
    }

    public void addComment(String comm) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comm);
    }

    public void addPreComment(ArrayList comm) {
        this.pre_comments = comm;
    }

    public int numOfServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public int numOfDomains() {
        if (this.domains == null) {
            return 0;
        }
        return this.domains.size();
    }

    public String getDomainByIndex(int index) {
        try {
            String value = (String)this.domains.get(index);
            return value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String getServerByIndex(int index) {
        try {
            String value = (String)this.servers.get(index);
            return value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int numOfStartingPoints() {
        return this.starting_points.size();
    }

    public String getStartingPointByIndex(int index) {
        try {
            String value = (String)this.starting_points.get(index);
            return value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int numOfFilters() {
        return this.rules.size();
    }

    public String getFiltersIDByIndex(int index) {
        try {
            RuleSet rs = (RuleSet)this.rules.get(index);
            return rs.rule_id;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean isFilterInUsed(String id) {
        try {
            for (int i = 0; i < this.rules.size(); ++i) {
                RuleSet rs = (RuleSet)this.rules.get(i);
                if (rs.rule_id.compareTo(id) != 0) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public String getFiltersonMatchByIndex(int index) {
        try {
            RuleSet rs = (RuleSet)this.rules.get(index);
            return RobotConfig.ADtoString(rs.onMatch);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public boolean deleteFilterByIndex(int index) {
        boolean r = false;
        try {
            if (this.rules.remove(index) != null) {
                r = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    public boolean deleteFilterByID(String id) {
        boolean r = false;
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleSet rs = (RuleSet)this.rules.get(i);
            if (rs.rule_id.compareTo(id) != 0) continue;
            this.rules.remove(i);
            return true;
        }
        return false;
    }

    public void removeFilters() {
        this.rules = new ArrayList();
    }

    public void addStartingPoint(URL url, int depth) {
        String newUrlText = url.toString();
        int dupIndex = -1;
        if (this.starting_points == null) {
            this.starting_points = new ArrayList();
        }
        for (int i = 0; i < this.starting_points.size(); ++i) {
            String sp = (String)this.starting_points.get(i);
            String urlText = sp.substring(0, sp.indexOf(" depth="));
            if (!newUrlText.equalsIgnoreCase(urlText)) continue;
            dupIndex = i;
            break;
        }
        if (dupIndex >= 0) {
            this.deleteStartingPointByIndex(dupIndex);
        }
        String s_point = newUrlText + " depth=" + depth;
        this.starting_points.add(s_point);
    }

    public void removeStartingPoints() {
        if (this.starting_points != null) {
            this.starting_points = new ArrayList();
        }
    }

    public boolean deleteStartingPointByIndex(int index) {
        boolean r = false;
        try {
            if (this.starting_points.remove(index) != null) {
                r = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    public void removeProtocol() {
        this.protocols = new ArrayList();
    }

    public void addProtocol(String proto) {
        if (this.protocols == null) {
            this.protocols = new ArrayList();
        }
        this.protocols.add(proto);
    }

    public ArrayList getProtocol() {
        return this.protocols;
    }

    public boolean isProtocolChecked(String proto) {
        if (this.protocols == null) {
            return false;
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            String p = (String)this.protocols.get(i);
            if (p.compareToIgnoreCase(proto) != 0) continue;
            return true;
        }
        return false;
    }

    void addStringToListUnique(ArrayList list, String entry) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                String exist_entry = (String)list.get(i);
                if (exist_entry.compareToIgnoreCase(entry) != 0) continue;
                return;
            }
            list.add(entry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addServer(String server) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        this.addStringToListUnique(this.servers, server);
    }

    public void removeServers() {
        this.servers = new ArrayList();
    }

    public boolean deleteServerByIndex(int index) {
        boolean r = false;
        try {
            if (this.servers.remove(index) != null) {
                r = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    public void addDomain(String domain) {
        if (this.domains == null) {
            this.domains = new ArrayList();
        }
        this.addStringToListUnique(this.domains, domain);
    }

    public void removeDomains() {
        this.domains = new ArrayList();
    }

    public void removeComment() {
        this.comments = new ArrayList();
    }

    public void removeDNSTranslation() {
        this.dns_cnames = new ArrayList();
    }

    public boolean deleteDomainByIndex(int index) {
        boolean r = false;
        try {
            if (this.domains.remove(index) != null) {
                r = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    public int getType() {
        if (this.servers != null) {
            return 1;
        }
        return 2;
    }

    public boolean isForMe(URL url) {
        if (this.servers != null) {
            String serverStr = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + Integer.toString(url.getPort()) : "") + "/";
            for (int i = 0; i < this.servers.size(); ++i) {
                String server = (String)this.servers.get(i);
                if (serverStr.compareToIgnoreCase(server) != 0) continue;
                return true;
            }
        } else {
            for (int i = 0; this.domains != null && i < this.domains.size(); ++i) {
                String domain = (String)this.domains.get(i);
                if (!url.getHost().endsWith(domain)) continue;
                return true;
            }
        }
        return false;
    }

    public String getComments() {
        if (this.comments == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.comments.size(); ++i) {
            sb.append((String)this.comments.get(i) + "\n");
        }
        return sb.toString();
    }

    public String getDNSTranslation() {
        if (this.dns_cnames == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.dns_cnames.size(); ++i) {
            sb.append((String)this.dns_cnames.get(i));
            if (i + 1 >= this.dns_cnames.size()) continue;
            sb.append(",\n");
        }
        return sb.toString();
    }

    public String getDatabase() {
        if (this.database == null) {
            return "";
        }
        return this.database;
    }

    public void setDatabase(String targetDatabase) {
        this.database = targetDatabase;
    }
}

