/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.robot.StringFilter;
import com.sun.portal.search.util.PBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FilterRule {
    public String id;
    public boolean enable = false;
    public String nickname = "";
    public boolean default_ad = false;
    public boolean quickcf = false;
    public static final String[] methods_labels = new String[]{"is", "contains", "begins with", "ends with", "regular expression"};
    public static final String[] filter_methods = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    public static final String[] srcs_labels = new String[]{"URL", "protocol", "host", "path", "MIME type"};
    public static final String[] filter_srcs = new String[]{"url", "protocol", "host", "uri", "type"};
    public ArrayList comments = null;
    public ArrayList pre_comments = null;
    public ArrayList filters = null;

    public FilterRule(String tag) {
        HashMap avs = new HashMap();
        String valueText = null;
        try {
            PBlock.str2pblock((String)tag, avs);
        }
        catch (Exception e) {
            System.out.println("PBlockstr2pblock:Exception:" + e.getMessage());
        }
        valueText = (String)avs.get("id");
        if (valueText != null) {
            this.id = valueText;
        }
        if ((valueText = (String)avs.get("enable")) != null && valueText.compareToIgnoreCase("TRUE") == 0) {
            this.enable = true;
        }
        if ((valueText = (String)avs.get("quikcf")) != null && valueText.compareToIgnoreCase("TRUE") == 0) {
            this.quickcf = true;
        }
        if ((valueText = (String)avs.get("default")) != null && valueText.compareToIgnoreCase("ALLOW") == 0) {
            this.default_ad = true;
        }
        if ((valueText = (String)avs.get("nickname")) != null) {
            this.nickname = valueText;
        }
        this.filters = new ArrayList();
    }

    public FilterRule(String id, boolean ena, String nick, boolean ad, boolean quikcf) {
        this.id = id;
        this.enable = ena;
        this.nickname = nick;
        this.default_ad = ad;
        this.quickcf = quikcf;
        this.filters = new ArrayList();
    }

    public boolean Match(String u) {
        for (int i = 0; i < this.filters.size(); ++i) {
            StringFilter sf = (StringFilter)this.filters.get(i);
            if (!sf.isMatch(u)) continue;
            return true;
        }
        return false;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer("<Rule id=\"" + this.id + "\" enable=\"" + RobotConfig.BtoString(this.enable) + "\" default=\"" + RobotConfig.ADtoString(this.default_ad) + "\" nickname=\"" + this.nickname + "\" >\n");
        for (int i = 0; i < this.filters.size(); ++i) {
            StringFilter sf = (StringFilter)this.filters.get(i);
            sb.append(sf.toXMLString());
        }
        return sb.toString();
    }

    public String toConfigString() {
        String comm;
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.pre_comments != null) {
            for (i = 0; i < this.pre_comments.size(); ++i) {
                comm = (String)this.pre_comments.get(i);
                sb.append("# " + comm + "\n");
            }
        }
        sb.append("<Rule id=" + this.id + " enable=" + RobotConfig.BtoString(this.enable) + " quikcf=" + RobotConfig.BtoString(this.quickcf) + " default=" + RobotConfig.ADtoString(this.default_ad) + " nickname=\"" + this.nickname + "\" >\n");
        if (this.comments != null) {
            for (i = 0; i < this.comments.size(); ++i) {
                comm = (String)this.comments.get(i);
                sb.append("# " + comm + "\n");
            }
        }
        for (i = 0; i < this.filters.size(); ++i) {
            StringFilter sf = (StringFilter)this.filters.get(i);
            sb.append(sf.toConfigString());
        }
        sb.append("</Rule>\n");
        return sb.toString();
    }

    public void addComment(String comm) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comm);
    }

    public void addPreComment(ArrayList comm) {
        this.pre_comments = comm;
    }

    public boolean addFilter(String src, String method, String text) {
        for (int i = 0; i < filter_methods.length; ++i) {
            if (filter_methods[i].compareToIgnoreCase(method) != 0) continue;
            StringFilter sf = new StringFilter(src, i, text);
            this.filters.add(sf);
            return true;
        }
        return false;
    }

    public boolean delFilterByIndex(int index) {
        return index >= 0 && index < this.filters.size() && this.filters.remove(index) != null;
    }

    public void removeAllFilter() {
        this.filters.clear();
    }

    public void addFilter(String s) {
        HashMap avs = new HashMap();
        Object valueText = null;
        try {
            PBlock.str2pblock((String)s, avs);
        }
        catch (Exception e) {
            System.out.println("[addFilter]PBlockstr2pblock:Exception:" + e.getMessage());
        }
        String src = (String)avs.get("src");
        Object method = null;
        int method_ndx = 0;
        while (true) {
            if (method_ndx >= filter_methods.length) break;
            if (avs.containsKey(filter_methods[method_ndx])) break;
            ++method_ndx;
        }
        if (method_ndx == filter_methods.length) {
            return;
        }
        String text = (String)avs.get(filter_methods[method_ndx]);
        StringFilter sf = new StringFilter(src, method_ndx, text);
        this.filters.add(sf);
    }

    public static int StringtoMethodIndex(String method) {
        for (int method_ndx = 0; method_ndx < filter_methods.length; ++method_ndx) {
            if (method.compareToIgnoreCase(filter_methods[method_ndx]) != 0) continue;
            return method_ndx;
        }
        return -1;
    }

    public static String getMethodText(int ndx) {
        if (ndx < 0 && ndx > filter_methods.length) {
            return Integer.toString(ndx);
        }
        return filter_methods[ndx];
    }

    public int numberOfStringFilters() {
        return this.filters.size();
    }

    public String getComments() {
        if (this.comments == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.comments.size(); ++i) {
            sb.append((String)this.comments.get(i) + "\n");
        }
        return sb.toString();
    }

    public void setComments(String comm) {
        if (comm == null) {
            return;
        }
        if (this.comments == null) {
            this.comments = new ArrayList();
        } else {
            this.comments.clear();
        }
        StringTokenizer st = new StringTokenizer(comm, "\n");
        while (st.hasMoreTokens()) {
            String comms = st.nextToken().trim();
            if (comms.length() <= 0) continue;
            this.comments.add(comms);
        }
    }
}

