/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class FilterLog {
    public static DateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss", Locale.US);
    public static DateFormat listdf = new SimpleDateFormat("dd/MMM -  HH:mm:ss");
    protected ArrayList runList = new ArrayList();
    protected PrintWriter debug = null;
    private String dateStr = null;
    private String reasonStr = null;
    private int reasonIndex = -1;
    private Hashtable ExReasons = new Hashtable();
    private ArrayList ExReasonsArray = new ArrayList();
    private ArrayList FilteredList = new ArrayList();
    private int total = 0;

    public static void main(String[] args) {
        FilterLog filterLog = null;
        if (args.length == 1) {
            filterLog = new FilterLog(args[0]);
        } else if (args.length == 2) {
            filterLog = new FilterLog(args[0], args[1]);
        } else if (args.length == 3) {
            filterLog = new FilterLog(args[0], args[1], args[2]);
        } else {
            System.out.println("Usage:FilterLog filterLogPath [selectedDate [selectedReason]]");
            return;
        }
        filterLog.printResult(System.out);
    }

    public FilterLog(String file, PrintWriter out) {
        this.debug = out;
        out.println("FilterLog debug enabled");
        this.parserFilterLog(file);
    }

    public FilterLog(String file, String date, PrintWriter out) {
        this.debug = out;
        this.dateStr = date;
        out.println("FilterLog debug enabled");
        this.parserFilterLog(file);
    }

    public FilterLog(String file, String date, String reason, PrintWriter out) {
        this.debug = out;
        this.dateStr = date;
        this.reasonStr = reason;
        out.println("FilterLog debug enabled");
        this.parserFilterLog(file);
    }

    public FilterLog(String file) {
        this.parserFilterLog(file);
    }

    public FilterLog(String file, String date) {
        this.dateStr = date;
        this.parserFilterLog(file);
    }

    public FilterLog(String file, String date, String reason) {
        this.dateStr = date;
        this.reasonStr = reason;
        this.parserFilterLog(file);
    }

    public FilterLog(String file, String date, int reason) {
        this.dateStr = date;
        this.reasonIndex = reason;
        this.parserFilterLog(file);
    }

    public void parserFilterLog(String filterlog_path) {
        BufferedReader in = null;
        String oldline = null;
        String line = null;
        String preLine = null;
        Date date = null;
        boolean inSelectedDate = false;
        boolean inSelectedReason = false;
        int lineNum = 0;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filterlog_path), "ISO-8859-1"));
            while ((oldline = in.readLine()) != null) {
                ++lineNum;
                try {
                    line = new String(oldline.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (Exception e) {
                    continue;
                }
                if (line.startsWith("[")) {
                    int start = line.indexOf(91);
                    int end = line.indexOf(93);
                    if (start < 0 || end <= start) continue;
                    String datestr = line.substring(start + 1, end);
                    try {
                        date = df.parse(datestr);
                        if (this.debug != null) {
                            this.debug.println("add date : " + df.format(date));
                        }
                        this.runList.add(date);
                        if (this.dateStr != null && datestr.compareTo(this.dateStr) == 0) {
                            inSelectedDate = true;
                            continue;
                        }
                        inSelectedDate = false;
                    }
                    catch (ParseException e) {
                        if (this.debug != null) {
                            this.debug.println("ParseException at position(" + e.getErrorOffset() + ")");
                            this.debug.println(line);
                            continue;
                        }
                        System.out.println("ParseException at position(" + e.getErrorOffset() + ")");
                        System.out.println(line);
                    }
                    continue;
                }
                if (inSelectedDate && line.startsWith("Hint:")) {
                    String hint = line.substring(5).trim();
                    if (hint.startsWith("File Not Found.")) {
                        hint = "File Not Found.";
                    }
                    if (preLine == null) continue;
                    int c = 1;
                    if (this.ExReasons.containsKey(hint)) {
                        Integer count = (Integer)this.ExReasons.get(hint);
                        c = count;
                        this.ExReasons.put(hint, new Integer(++c));
                    } else {
                        this.ExReasons.put(hint, new Integer(c));
                        this.ExReasonsArray.add(hint);
                    }
                    ++this.total;
                    if (this.reasonStr != null && this.reasonStr.compareToIgnoreCase(hint) == 0 || this.reasonIndex >= 0 && this.ExReasonsArray.size() > this.reasonIndex && ((String)this.ExReasonsArray.get(this.reasonIndex)).compareToIgnoreCase(hint) == 0) {
                        this.FilteredList.add(preLine);
                    }
                    preLine = null;
                    continue;
                }
                if (!inSelectedDate) continue;
                preLine = line;
            }
        }
        catch (IOException e) {
            if (this.debug != null) {
                this.debug.println("IOException:" + e.getMessage() + " at line# " + lineNum);
            }
            System.out.println("IOException:" + e.getMessage() + " at line# " + lineNum);
        }
    }

    public void printResult(PrintStream out) {
        for (int i = 0; i < this.runList.size(); ++i) {
            out.println(i + " run - " + listdf.format((Date)this.runList.get(i)));
        }
        if (this.dateStr != null) {
            Enumeration e = this.ExReasons.keys();
            while (e.hasMoreElements()) {
                String reason = (String)e.nextElement();
                Integer count = (Integer)this.ExReasons.get(reason);
                out.println(reason + ":" + count);
            }
            if (this.reasonStr != null) {
                for (int i = 0; i < this.FilteredList.size(); ++i) {
                    out.println((String)this.FilteredList.get(i));
                }
            }
        }
    }

    public Object[] getRunArray() {
        return this.runList.toArray();
    }

    public ArrayList getRunArrayList() {
        return this.runList;
    }

    public void setDebug(PrintWriter out) {
        this.debug = out;
    }

    public String[] getReasons() {
        return this.ExReasonsArray.toArray(new String[0]);
    }

    public int getReasonSubTotal(String reason) {
        if (this.ExReasons != null) {
            Integer count = (Integer)this.ExReasons.get(reason);
            return count;
        }
        return 0;
    }

    public ArrayList getFilteredURL() {
        return this.FilteredList;
    }

    public String getReason() {
        return this.reasonStr;
    }

    public String getReasonByIndex(int index) {
        try {
            return (String)this.ExReasonsArray.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getTotal() {
        return this.total;
    }
}

