/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.DocType;
import com.sun.portal.search.util.SearchLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ConverterConfig {
    ArrayList docs = null;
    String converter_conf = null;
    ArrayList pre_comment = null;

    public static void main(String[] args) {
        ConverterConfig cc = new ConverterConfig(args[0]);
        cc.updateFile();
    }

    public ConverterConfig(String conf_dir) {
        this.converter_conf = conf_dir + File.separator + "convert.conf";
        this.docs = new ArrayList();
        this.parse_converter(this.converter_conf);
    }

    void parse_converter(String file) {
        String line = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            line = in.readLine();
        }
        catch (IOException e) {
            System.out.println("Exception:" + e.getMessage());
            return;
        }
        boolean afterComment = false;
        while (line != null) {
            String nline = line.trim();
            if (nline.length() == 0) {
                try {
                    line = in.readLine();
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (nline.startsWith("#")) {
                this.addPreComment(nline);
                try {
                    line = in.readLine();
                    continue;
                }
                catch (IOException e) {
                    break;
                }
            }
            if (!nline.startsWith("DocType=")) {
                SearchLogger.getLogger().log(Level.FINER, "PSSH_CSPSR0001", nline);
            } else {
                DocType doc = new DocType();
                StringTokenizer st = new StringTokenizer(nline.substring(8), "@@");
                int i = 0;
                while (st.hasMoreTokens()) {
                    switch (i) {
                        case 0: {
                            doc.desc = st.nextToken();
                            break;
                        }
                        case 1: {
                            doc.type_nums = st.nextToken();
                            break;
                        }
                        case 2: {
                            if (st.nextToken().trim().compareTo("1") != 0) break;
                            doc.enabled = true;
                            break;
                        }
                        case 3: {
                            doc.module = st.nextToken();
                            break;
                        }
                        case 4: {
                            doc.args = st.nextToken();
                        }
                    }
                    ++i;
                }
                this.docs.add(doc);
            }
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                break;
            }
        }
    }

    public void updateFile() {
        int i;
        PrintWriter out = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.converter_conf);
            out = new PrintWriter(fout, true);
        }
        catch (Exception e) {
            System.out.println("[updateFile]Exception:" + e.getMessage());
            return;
        }
        for (i = 0; this.pre_comment != null && i < this.pre_comment.size(); ++i) {
            out.println("#" + (String)this.pre_comment.get(i));
        }
        for (i = 0; i < this.docs.size(); ++i) {
            DocType doc = (DocType)this.docs.get(i);
            out.print("DocType=" + doc.desc + "@@" + doc.type_nums + "@@");
            if (doc.enabled) {
                out.print("1@@");
            } else {
                out.print("0@@");
            }
            if (doc.module != null) {
                out.print(doc.module + "@@");
                if (doc.args != null) {
                    out.print(doc.args + "@@");
                }
            }
            out.println("");
        }
        out.close();
    }

    public int numOfDocs() {
        return this.docs.size();
    }

    public void addPreComment(String comm) {
        if (this.pre_comment == null) {
            this.pre_comment = new ArrayList();
        }
        String comment = comm.substring(1);
        this.pre_comment.add(comment);
    }

    public String getDocLabel(int index) {
        if (index >= 0 && index < this.docs.size()) {
            DocType doc = (DocType)this.docs.get(index);
            return doc.desc;
        }
        return null;
    }

    public void setDocEnable(int index, boolean enabled) {
        if (index >= 0 && index < this.docs.size()) {
            DocType doc = (DocType)this.docs.get(index);
            doc.enabled = enabled;
        }
    }

    public boolean getDocEnable(int index) {
        if (index >= 0 && index < this.docs.size()) {
            DocType doc = (DocType)this.docs.get(index);
            return doc.enabled;
        }
        return false;
    }
}

