/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchLogger;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;

public class RemoteSearch {
    String scope = null;
    String viewAttributes = null;
    String queryLanguage = null;
    String database = null;
    String RDMServer = null;
    String user = null;
    String password = null;

    public RemoteSearch(String scope, String viewAttributes, String queryLanguage, String database, String RDMServer, String user, String password) {
        this.scope = scope;
        this.viewAttributes = viewAttributes;
        this.queryLanguage = queryLanguage;
        this.database = database;
        this.RDMServer = RDMServer;
        this.user = user;
        this.password = password;
    }

    public SOIFInputStream getResult() throws Exception {
        SOIFInputStream resultStream = null;
        RDMHeader reqHeader = null;
        RDMQuery qry = new RDMQuery(this.scope);
        String type = "rd-request";
        RDMHeader resHeader = null;
        SOIFBuffer sb = new SOIFBuffer();
        reqHeader = new RDMHeader(type, null, this.queryLanguage, null);
        if (this.user != null) {
            reqHeader.setUser(this.user);
            if (this.password != null) {
                reqHeader.setPassword(this.password);
            }
        }
        qry.setViewHits("1..99999");
        if (this.viewAttributes != null) {
            qry.setViewAttr(this.viewAttributes);
        }
        if (this.database != null) {
            qry.setDatabase(this.database);
        }
        SOIFOutputStream sos = new SOIFOutputStream((OutputStream)sb);
        sos.write(reqHeader.getSOIF());
        sos.write(qry.getSOIF());
        URLConnection rc = new URL(this.RDMServer).openConnection();
        rc.setAllowUserInteraction(true);
        rc.setDoOutput(true);
        rc.getOutputStream().write(sb.toByteArray());
        resultStream = new SOIFInputStream(rc.getInputStream());
        try {
            resHeader = new RDMHeader(resultStream);
        }
        catch (Exception e) {
            throw new Exception("Inavlid response, might not from a search server", e);
        }
        String rdmEMsg = resHeader.getErrorMessage();
        if (rdmEMsg != null && !rdmEMsg.equalsIgnoreCase("0 results")) {
            SearchLogger.getLogger().log(Level.WARNING, rdmEMsg);
            return null;
        }
        return resultStream;
    }
}

