/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.sleepycat.db.Db;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.portal.search.db.Datum;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class RDStore {
    HashMap store = new HashMap();
    Db table = null;
    String dbFileName = null;
    private int cacheSize = 10000;

    public RDStore(int cacheSize, String dbPath) throws Exception {
        this.cacheSize = cacheSize;
        this.dbFileName = dbPath;
        this.table = new Db(null, 0);
        this.table.set_error_stream((OutputStream)System.err);
        this.table.set_errpfx("RDStore:");
        this.table.open(this.dbFileName, null, 1, Db.DB_CREATE | Db.DB_TRUNCATE, 420);
    }

    public void close() {
        try {
            if (this.table != null) {
                this.table.close(0);
            }
            File f = new File(this.dbFileName);
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized SOIF getRD(String urlStr) {
        Datum key = null;
        Datum data = null;
        SOIF s = (SOIF)this.store.get(urlStr);
        if (s == null) {
            key = new Datum(urlStr);
            data = new Datum();
            try {
                int rcode = this.table.get(null, (Dbt)key, (Dbt)data, 0);
                if (rcode == 0) {
                    s = new SOIF(data.get_data(), "UTF-8");
                    this.store.put(urlStr, s);
                }
            }
            catch (Exception e) {
                System.out.println("table.get() throws exception with message: " + e.getMessage());
            }
        }
        return s;
    }

    private void pushToDB() throws Exception {
        Datum key = null;
        Datum data = null;
        Iterator keyIt = this.store.keySet().iterator();
        while (keyIt.hasNext()) {
            String url = (String)keyIt.next();
            SOIF rd = (SOIF)this.store.get(url);
            key = new Datum(url);
            data = new Datum(rd.toByteArray());
            this.table.put(null, (Dbt)key, (Dbt)data, 0);
        }
        this.store.clear();
    }

    public synchronized void putRD(SOIF s) {
        this.store.put(s.getURL(), s);
        if (this.store.size() > this.cacheSize) {
            try {
                this.pushToDB();
            }
            catch (Exception e) {
                System.out.println("Exception throws at pushToDB() with message:" + e.getMessage());
            }
        }
    }

    public int CreateSOIF(String fileName) throws Exception {
        Iterator keyIt = this.store.keySet().iterator();
        SOIFOutputStream sOut = null;
        int rdCount = 0;
        while (keyIt.hasNext()) {
            String url = (String)keyIt.next();
            SOIF rd = (SOIF)this.store.get(url);
            if (sOut == null) {
                sOut = new SOIFOutputStream(fileName);
            }
            sOut.write(rd);
            ++rdCount;
        }
        if (this.table != null) {
            Dbc cursor = this.table.cursor(null, 0);
            Datum key = new Datum();
            Datum data = new Datum();
            while (cursor.get((Dbt)key, (Dbt)data, Db.DB_NEXT) == 0) {
                SOIF rd = new SOIF(data.get_data(), "UTF-8");
                if (this.store.get(rd.getURL()) != null) continue;
                if (sOut == null) {
                    sOut = new SOIFOutputStream(fileName);
                }
                sOut.write(rd);
                ++rdCount;
            }
        }
        if (sOut != null) {
            sOut.close();
        }
        return rdCount;
    }
}

