/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.sun.portal.search.autoclassify.HeartBeatFailureException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class HeartBeat
extends Thread {
    public static long beatTime = 5000L;
    private FileWriter fw = null;
    private boolean shouldStop = false;
    private String lockFileName = null;

    public HeartBeat(String lockFileName) throws HeartBeatFailureException {
        try {
            this.lockFileName = lockFileName;
            File f = new File(lockFileName);
            long now = new Date().getTime();
            long lastModified = 0L;
            if (f.exists() && (lastModified = f.lastModified()) + beatTime * 2L > now) {
                HeartBeat.sleep(beatTime * 2L);
                if (f.lastModified() > lastModified) {
                    throw new HeartBeatFailureException("Another process is running");
                }
            }
            this.fw = new FileWriter(lockFileName);
            this.fw.write(Long.toString(now));
        }
        catch (Exception e) {
            throw new HeartBeatFailureException(e.getMessage());
        }
    }

    public void Stop() {
        this.shouldStop = true;
    }

    public void run() {
        long started = new Date().getTime();
        while (!this.shouldStop) {
            try {
                long now = new Date().getTime();
                if (now - started > beatTime) {
                    this.fw.write(Long.toString(new Date().getTime()) + "\n");
                    this.fw.flush();
                    started = now;
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("HeartBeat Thred being interrupted");
            }
            catch (Exception ioe) {}
        }
        try {
            this.fw.close();
            File f = new File(this.lockFileName);
            f.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

