/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.iplanet.am.util.AdminUtils;
import com.sun.identity.security.EncryptAction;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.autoclassify.AutoclassifyConfig;
import com.sun.portal.search.autoclassify.AutoclassifyContext;
import com.sun.portal.search.autoclassify.HeartBeat;
import com.sun.portal.search.autoclassify.HeartBeatFailureException;
import com.sun.portal.search.autoclassify.RDStore;
import com.sun.portal.search.autoclassify.RemoteSearch;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.DateParser;
import com.sun.portal.search.util.Getopt;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.SearchLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Autoclassify {
    AutoclassifyContext context = null;
    String server_root = ".";
    String logDir = null;
    String taxPath = null;
    String backupTaxPath = null;
    Date since = null;
    Date dbSince = null;
    Date startAt = new Date();
    String rdmServer = null;
    Map newTaxMap = null;
    Map oldTaxMap = null;
    Map results = new HashMap();
    HeartBeat heartbeat = null;
    RDStore rdstore = null;
    public boolean securityMode = false;
    String user = null;
    String password = null;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$autoclassify$Autoclassify == null ? (class$com$sun$portal$search$autoclassify$Autoclassify = Autoclassify.class$("com.sun.portal.search.autoclassify.Autoclassify")) : class$com$sun$portal$search$autoclassify$Autoclassify));
    static /* synthetic */ Class class$com$sun$portal$search$autoclassify$Autoclassify;

    public Autoclassify(AutoclassifyContext appContext, String server_root, Date lastRun, String rdmServer) throws Exception {
        String secMode;
        this.server_root = server_root;
        this.context = appContext;
        this.logDir = server_root + File.separator + "logs";
        this.taxPath = server_root + File.separator + "config" + File.separator + "taxonomy.rdm";
        this.since = lastRun;
        this.rdmServer = rdmServer;
        this.since = lastRun;
        String lockFilePath = SearchConfig.getValue((String)"autoclass-lockfilepath");
        if (lockFilePath == null) {
            lockFilePath = this.logDir + File.separator + "autoclassify.lock";
        }
        if ((secMode = SearchConfig.getValue((String)"security-mode")) != null && secMode.toLowerCase().equals("on")) {
            this.securityMode = true;
            this.user = AdminUtils.getAdminDN();
            this.password = (String)AccessController.doPrivileged(new EncryptAction(new String(AdminUtils.getAdminPassword())));
        }
        this.heartbeat = new HeartBeat(lockFilePath);
        this.heartbeat.start();
        try {
            SearchLogger.init((String)SearchConfig.AUTOCLASSIFY_LOGGER, (String)server_root);
            debugLogger = SearchLogger.getLogger();
        }
        catch (Exception e) {
            Autoclassify.println(Autoclassify.getLocalizedString("loggingInitFailure", new Object[]{e.getMessage()}));
            return;
        }
    }

    public void shutdown() {
        this.heartbeat.Stop();
        while (this.heartbeat.isAlive()) {
        }
    }

    Map readTaxToMap(String path, boolean getLastRun) throws Exception {
        HashMap map = new HashMap();
        try {
            String lastRunStr;
            SOIFInputStream sIn = new SOIFInputStream(path);
            RDMTaxonomy tax = new RDMTaxonomy(sIn);
            if (getLastRun && (lastRunStr = tax.getSOIF().getValue("LastRun")) != null) {
                try {
                    this.dbSince = AutoclassifyConfig.formatter.parse(lastRunStr);
                }
                catch (Exception e) {
                    debugLogger.log(Level.SEVERE, "PSSH_CSPSACY0001", e.getMessage());
                }
            }
            RDMClassification root = tax.find("ROOT");
            CreateClassMap cm = new CreateClassMap(map);
            root.apply(0, (RDMCallback)cm);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSACY0001", e.getMessage());
        }
        return map;
    }

    private void backupTaxonomy(String taxPath, String backupPath) throws Exception {
        SOIFInputStream sis = new SOIFInputStream(taxPath);
        SOIFOutputStream sos = new SOIFOutputStream(backupPath);
        SOIF s = null;
        while ((s = sis.readSOIF()) != null) {
            if (s.getSchemaName().equalsIgnoreCase("TAXONOMY")) {
                s.insert("LastRun", AutoclassifyConfig.formatter.format(this.startAt));
            }
            sos.write(s);
        }
        sis.close();
        sos.close();
    }

    private void resetTaxonomyMap(Map map) {
        if (map == null) {
            return;
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Map nc = (Map)this.newTaxMap.get(key);
            nc.remove("USETIMESTAMP");
        }
    }

    static String getLocalizedString(String key) {
        try {
            return Autoclassify.getLocalizedString(key, AutoclassifyConfig.getResourceBundle());
        }
        catch (Exception exception) {
            return key;
        }
    }

    static String getLocalizedString(String key, Object[] objs) {
        String pattern = Autoclassify.getLocalizedString(key);
        if (objs != null && objs.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.applyPattern(Autoclassify.getLocalizedString(key));
            return mf.format(objs);
        }
        return Autoclassify.getLocalizedString(key);
    }

    String getLocalizedUIString(String key) {
        if (this.context == null) {
            return key;
        }
        return Autoclassify.getLocalizedString(key, this.context.getResourceBundle());
    }

    void indexResult(String dbName, String soifPath) {
        String cmd = this.server_root + File.separator + "run-cs-cli rdmgr -m -q -p stdout -y " + dbName + " " + soifPath;
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(cmd);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                Autoclassify.println(outLine);
            }
        }
        catch (Exception e) {
            Autoclassify.println("rt.exec Exception:" + e.getMessage());
        }
    }

    String indexResults(String dbName, String soifPath) {
        StringBuffer sb = new StringBuffer();
        String cmd = this.server_root + File.separator + "run-cs-cli rdmgr -m -q -p stdout -y " + dbName + " " + soifPath;
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(cmd);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                sb.append(outLine + "\n");
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    public String doAutoclassify(String serverRoot, String dbName, String dbPath, int hashTableSize) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getLocalizedUIString("classify_database") + dbName + "\n");
        this.backupTaxPath = serverRoot + File.separator + "db" + File.separator + dbName + File.separator + "taxonomy.classifed";
        try {
            Map nc;
            Object key;
            if (this.newTaxMap == null) {
                this.newTaxMap = this.readTaxToMap(this.taxPath, false);
            } else {
                this.resetTaxonomyMap(this.newTaxMap);
            }
            this.oldTaxMap = this.readTaxToMap(this.backupTaxPath, true);
            if (this.since != null) {
                sb.append(this.getLocalizedUIString("overridelastrunat") + this.context.dateTimeFormat(this.since) + "\n");
                this.dbSince = this.since;
            } else if (this.dbSince != null) {
                sb.append(this.getLocalizedUIString("lastrunat") + this.context.dateTimeFormat(this.dbSince) + "\n");
            } else {
                sb.append(this.getLocalizedUIString("firsttimerun") + "\n");
            }
            this.rdstore = new RDStore(hashTableSize, dbPath);
            Iterator it = this.oldTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = it.next();
                Map oc = (Map)this.oldTaxMap.get(key);
                Map nc2 = (Map)this.newTaxMap.get(key);
                if (nc2 != null) {
                    String oldRule;
                    String newRule = (String)nc2.get("RULE");
                    if (newRule.compareToIgnoreCase(oldRule = (String)oc.get("RULE")) != 0) {
                        oc.put("DELETED", "true");
                        continue;
                    }
                    nc2.put("USETIMESTAMP", "true");
                    continue;
                }
                oc.put("DELETED", "true");
            }
            sb.append(this.getLocalizedUIString("removeclass") + "\n");
            it = this.oldTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                nc = (Map)this.oldTaxMap.get(key);
                String needDelete = (String)nc.get("DELETED");
                if (needDelete == null || !needDelete.equals("true")) continue;
                this.getRemoveClassificationRDs(dbName, (String)key);
            }
            sb.append(this.getLocalizedUIString("addclass") + "\n");
            it = this.newTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                nc = (Map)this.newTaxMap.get(key);
                String useTimeStamp = (String)nc.get("USETIMESTAMP");
                String Rule2 = (String)nc.get("RULE");
                if (!(Rule2 != null & Rule2.length() > 0)) continue;
                if (useTimeStamp != null && useTimeStamp.equals("true")) {
                    this.getRDs(dbName, (String)key, Rule2, this.dbSince, this.startAt);
                    continue;
                }
                this.getRDs(dbName, (String)key, Rule2, null, this.startAt);
            }
            sb.append(this.getLocalizedUIString("indexingresult") + "\n");
            String tmpsoif = serverRoot + File.separator + "tmp" + File.separator + "result.soif";
            int count = this.rdstore.CreateSOIF(tmpsoif);
            if (count > 0) {
                sb.append(this.indexResults(dbName, tmpsoif));
            }
            this.rdstore.close();
            this.backupTaxonomy(this.taxPath, this.backupTaxPath);
        }
        catch (HeartBeatFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return sb.toString();
    }

    public void doAutoClassify(String dbName, String dbPath, int hashTableSize) throws Exception {
        Autoclassify.println(this.getLocalizedUIString("classify_database") + dbName);
        debugLogger.log(Level.FINEST, "PSSH_CSPSACY0002", new Object[]{this.getLocalizedUIString("classify_database"), dbName});
        this.backupTaxPath = this.server_root + File.separator + "db" + File.separator + dbName + File.separator + "taxonomy.classifed";
        try {
            Map nc;
            Object key;
            if (this.newTaxMap == null) {
                this.newTaxMap = this.readTaxToMap(this.taxPath, false);
            } else {
                this.resetTaxonomyMap(this.newTaxMap);
            }
            this.oldTaxMap = this.readTaxToMap(this.backupTaxPath, true);
            if (this.since != null) {
                Autoclassify.println(this.getLocalizedUIString("overridelastrunat") + this.context.dateTimeFormat(this.since));
                this.dbSince = this.since;
            } else if (this.dbSince != null) {
                Autoclassify.println(this.getLocalizedUIString("lastrunat") + this.context.dateTimeFormat(this.dbSince));
            } else {
                Autoclassify.println(this.getLocalizedUIString("firsttimerun"));
            }
            this.rdstore = new RDStore(hashTableSize, dbPath);
            Iterator it = this.oldTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = it.next();
                Map oc = (Map)this.oldTaxMap.get(key);
                Map nc2 = (Map)this.newTaxMap.get(key);
                if (nc2 != null) {
                    String oldRule;
                    String newRule = (String)nc2.get("RULE");
                    if (newRule.compareToIgnoreCase(oldRule = (String)oc.get("RULE")) != 0) {
                        oc.put("DELETED", "true");
                        continue;
                    }
                    nc2.put("USETIMESTAMP", "true");
                    continue;
                }
                oc.put("DELETED", "true");
            }
            Autoclassify.println(this.getLocalizedUIString("removeclass"));
            it = this.oldTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                nc = (Map)this.oldTaxMap.get(key);
                String needDelete = (String)nc.get("DELETED");
                if (needDelete == null || !needDelete.equals("true")) continue;
                this.getRemoveClassificationRDs(dbName, (String)key);
            }
            Autoclassify.println("");
            Autoclassify.println(this.getLocalizedUIString("addclass"));
            it = this.newTaxMap.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                nc = (Map)this.newTaxMap.get(key);
                String useTimeStamp = (String)nc.get("USETIMESTAMP");
                String Rule2 = (String)nc.get("RULE");
                if (!(Rule2 != null & Rule2.length() > 0)) continue;
                if (useTimeStamp != null && useTimeStamp.equals("true")) {
                    this.getRDs(dbName, (String)key, Rule2, this.dbSince, this.startAt);
                    continue;
                }
                this.getRDs(dbName, (String)key, Rule2, null, this.startAt);
            }
            Autoclassify.println("");
            Autoclassify.println(this.getLocalizedUIString("indexingresult"));
            int count = this.rdstore.CreateSOIF("result.soif");
            if (count > 0) {
                this.indexResult(dbName, "result.soif");
            }
            this.rdstore.close();
            this.backupTaxonomy(this.taxPath, this.backupTaxPath);
            debugLogger.log(Level.FINEST, "PSSH_CSPSACY0001", count + Autoclassify.getLocalizedString("numberrdupdated"));
        }
        catch (HeartBeatFailureException e) {
            throw e;
        }
        catch (Exception e) {
            debugLogger.log(Level.SEVERE, "Error getting document:" + e);
        }
    }

    private void removeAutoClassification(SOIF s, String className) {
        String c;
        int i;
        boolean in_class = false;
        boolean in_rd_auto_class = false;
        AVPair AVs = s.getAVPair("RD-Classified");
        for (i = 0; AVs != null && i <= AVs.getMaxIndex(); ++i) {
            c = AVs.getValue(i);
            if (c == null || c.compareToIgnoreCase(className) != 0) continue;
            in_rd_auto_class = true;
            AVs.remove(i);
            AVs.squeeze();
            if (AVs.getMaxIndex() != 0) break;
            AVs.insert("", 0);
            break;
        }
        if (in_rd_auto_class) {
            AVs = s.getAVPair("CLASSIFICATION");
            for (i = 0; AVs != null && i <= AVs.getMaxIndex(); ++i) {
                c = AVs.getValue(i);
                if (c == null || c.compareToIgnoreCase(className) != 0) continue;
                AVs.remove(i);
                AVs.squeeze();
                if (AVs.getMaxIndex() != 0) break;
                AVs.insert("", 0);
                break;
            }
        }
    }

    private void appendValueToSOIF(SOIF s, String name, String value) {
        AVPair AVs = s.getAVPair(name);
        if (AVs != null) {
            AVs.insert(value, AVs.getMaxIndex() + 1);
        } else {
            s.insert(name, value);
        }
    }

    private void addingAutoClassification(SOIF s, String className) {
        String c;
        int i;
        boolean in_class = false;
        boolean in_rd_auto_class = false;
        AVPair AVs = s.getAVPair("CLASSIFICATION");
        for (i = 0; AVs != null && i <= AVs.getMaxIndex(); ++i) {
            c = AVs.getValue(i);
            if (c == null || c.compareToIgnoreCase(className) != 0) continue;
            in_class = true;
            break;
        }
        AVs = s.getAVPair("RD-Classified");
        for (i = 0; AVs != null && i <= AVs.getMaxIndex(); ++i) {
            c = AVs.getValue(i);
            if (c == null || c.compareToIgnoreCase(className) != 0) continue;
            in_rd_auto_class = true;
            break;
        }
        if (!in_class && !in_rd_auto_class) {
            this.appendValueToSOIF(s, "RD-Classified", className);
            this.appendValueToSOIF(s, "CLASSIFICATION", className);
        }
    }

    void getRemoveClassificationRDs(String dbName, String className) throws Exception {
        String query = "Classification = \"" + className + "\"";
        RemoteSearch search = new RemoteSearch(query, "CLASSIFICATION,RD-Classified", "search", dbName, this.rdmServer, this.user, this.password);
        SOIFInputStream rs = search.getResult();
        int count = 0;
        SOIF soif = rs.readSOIF();
        while (soif != null) {
            String urlStr = soif.getURL();
            SOIF rd = this.rdstore.getRD(urlStr);
            if (rd != null) {
                this.removeAutoClassification(rd, className);
            } else {
                this.removeAutoClassification(soif, className);
                this.rdstore.putRD(soif);
            }
            soif = rs.readSOIF();
            ++count;
        }
        Autoclassify.print("(-" + count + ")");
    }

    void getRDs(String dbName, String className, String rule, Date since, Date till) throws Exception {
        StringBuffer query = new StringBuffer("(" + rule + ")");
        if (since != null) {
            query.append(" <and> RD-Last-Changed >\"");
            query.append(AutoclassifyConfig.formatter.format(since));
            query.append("\"");
        }
        if (till != null) {
            query.append(" <and> RD-Last-Changed <=\"");
            query.append(AutoclassifyConfig.formatter.format(till));
            query.append("\"");
        }
        RemoteSearch search = new RemoteSearch(query.toString(), "CLASSIFICATION,RD-Classified", "search", dbName, this.rdmServer, this.user, this.password);
        SOIFInputStream rs = search.getResult();
        int count = 0;
        SOIF soif = rs.readSOIF();
        while (soif != null) {
            String urlStr = soif.getURL();
            SOIF rd = this.rdstore.getRD(urlStr);
            if (rd != null) {
                this.addingAutoClassification(rd, className);
            } else {
                this.addingAutoClassification(soif, className);
                this.rdstore.putRD(soif);
            }
            soif = rs.readSOIF();
            ++count;
        }
        Autoclassify.print("(+" + count + ")");
    }

    static String[] split(String str, String deli) {
        StringTokenizer st = new StringTokenizer(str, deli);
        ArrayList<String> list = new ArrayList<String>();
        boolean index = false;
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static Locale stringToLocale(String localStr) {
        StringTokenizer st = new StringTokenizer(localStr, "_");
        String[] codes = Autoclassify.split(localStr, "_");
        if (codes.length >= 2) {
            return new Locale(codes[0], codes[1]);
        }
        return Locale.getDefault();
    }

    public static void log(String msg) {
    }

    public static void print(String msg) {
        try {
            byte[] bytes = msg.getBytes("UTF-8");
            System.out.write(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void println(String msg) {
        Autoclassify.print(msg);
        System.out.println();
    }

    public static String getLocalizedString(String key, ResourceBundle rb) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public static void main(String[] args) {
        Autoclassify ac = null;
        Object taxFilePath = null;
        Object configFilePath = null;
        Object backupTaxFilePath = null;
        String runSince = null;
        String serverUrl = null;
        String server_root = ".";
        String[] selectDBs = null;
        Date lastRun = null;
        try {
            ResourceBundle rb;
            ResourceBundle UIrb = rb = AutoclassifyConfig.getResourceBundle();
            AutoclassifyContext context = new AutoclassifyContext();
            context.setResourceBundle(UIrb);
            Getopt opt = new Getopt(args, "t:s:l:d:");
            block10: while (opt.optInd < args.length) {
                char c = (char)opt.getopt();
                switch (c) {
                    case 't': {
                        runSince = opt.optArg;
                        continue block10;
                    }
                    case 's': {
                        serverUrl = opt.optArg;
                        continue block10;
                    }
                    case 'l': {
                        Locale UIlocale = Autoclassify.stringToLocale(opt.optArg);
                        UIrb = ResourceBundle.getBundle("autoclassify", UIlocale);
                        context.setResourceBundle(UIrb);
                        context.setUILocale(UIlocale);
                        continue block10;
                    }
                    case 'd': {
                        selectDBs = Autoclassify.split(opt.optArg, ":");
                        continue block10;
                    }
                }
                Autoclassify.println(Autoclassify.getLocalizedString("usage", rb));
                return;
            }
            if (serverUrl == null) {
                Autoclassify.println(Autoclassify.getLocalizedString("usage", rb));
                return;
            }
            if (runSince != null) {
                lastRun = DateParser.parse(runSince);
            }
            SearchConfig.init((String)(server_root + File.separator + "config" + File.separator + "search.conf"));
            ac = new Autoclassify(context, server_root, lastRun, serverUrl);
            String tempDBPath = SearchConfig.getValue((String)"autoclass-dbfilepath");
            if (tempDBPath == null) {
                tempDBPath = server_root + File.separator + "tmp" + File.separator + "RDStore.db";
            }
            String rdInMemory = SearchConfig.getValue((String)"autoclass-rdsinmemory");
            int hashTableSize = 10000;
            if (rdInMemory != null) {
                try {
                    hashTableSize = Integer.parseInt(rdInMemory);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Autoclassify.println(ac.getLocalizedUIString("prompt_started"));
            debugLogger.log(Level.INFO, "PSSH_CSPSACY0001", Autoclassify.getLocalizedString("prompt_started"));
            debugLogger.log(Level.FINEST, "PSSH_CSPSACY0002", new Object[]{Autoclassify.getLocalizedString("security_mode"), ac.securityMode ? Autoclassify.getLocalizedString("security_on") : Autoclassify.getLocalizedString("security_off")});
            String[] dbs = DBUtil.getDBStringArray(server_root);
            if (selectDBs == null) {
                selectDBs = dbs;
            }
            for (int i = 0; i < selectDBs.length; ++i) {
                ac.doAutoClassify(selectDBs[i], tempDBPath, hashTableSize);
            }
            Autoclassify.println("");
            Autoclassify.println(ac.getLocalizedUIString("prompt_stopped"));
            debugLogger.log(Level.INFO, "PSSH_CSPSACY0001", Autoclassify.getLocalizedString("prompt_stopped"));
        }
        catch (Exception e) {
            Autoclassify.println(e.getMessage());
            debugLogger.log(Level.FINEST, "PSSH_CSPSACY0001", e.getMessage());
            e.printStackTrace();
        }
        if (ac != null) {
            ac.shutdown();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CreateClassMap
    implements RDMCallback {
        Map classMap = null;

        public CreateClassMap(Map classmap) {
            this.classMap = classmap;
        }

        public void callback(Object parm1) throws Exception {
            RDMClassification c = (RDMClassification)parm1;
            if (c.getId() == "ROOT") {
                return;
            }
            String rule = c.getMatchingRule();
            if (rule == null) {
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("RULE", rule.trim());
            this.classMap.put(c.getId(), map);
        }
    }
}

