/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.util;

import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.util.ScheduleFactory;
import com.sun.portal.search.admin.util.Task;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SunOSTask
implements Task {
    public static final String CRON_BEGIN = "# Search cron entries start here. Don't modify this section";
    public static final String CRON_END = "# Search cron entries end here.";
    private static final String CRONTAB = "/bin/crontab";
    private static final String CRONTAB_LINUX = "/usr/bin/crontab";
    private static String crontab = "/bin/crontab";
    HashMap valuesMap = new HashMap();
    String name = null;

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage:CronController action");
            return;
        }
        if (SunOSTask.isLinux()) {
            CSConfig.init("/var/opt/sun/portal/https-server1/portal");
        } else {
            CSConfig.init("/var/opt/SUNWportal/https-server1/portal");
        }
        SunOSTask cron = new SunOSTask();
        cron.init(args[0]);
        cron.setValue("Hours", args[2]);
        cron.setValue("Mins", args[3]);
        cron.setValue("DaysOfWeek", args[4]);
        cron.Update();
    }

    public void init(String name) {
        this.name = name;
        String headerName = CSConfig.getServerRoot() + ":" + name;
        String cmd = CSConfig.getServerRoot() + File.separator + name;
        if (name.compareTo("StartImport") == 0) {
            SearchConfig.getSearchConfig();
            String csid = SearchConfig.getValue((String)"csid");
            cmd = CSConfig.getServerRoot() + File.separator + "run-cs-cli " + "importmgr" + " -c " + CSConfig.getServerRoot() + File.separator + "config" + File.separator + "search.conf" + " " + csid + " run all >>" + CSConfig.getServerRoot() + File.separator + "logs" + File.separator + "import.log";
        } else if (name.compareTo("StartAutoclassify") == 0) {
            cmd = ScheduleFactory.getCmd(name);
        }
        this.setValue("Command", cmd);
        try {
            Process process = Runtime.getRuntime().exec(crontab + " -l");
            InputStream instream = process.getInputStream();
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(instream));
            String temp = null;
            boolean inSection = false;
            boolean gotIt = false;
            String theName = null;
            while ((temp = buffReader.readLine()) != null) {
                if (inSection) {
                    if (!temp.startsWith(CRON_END)) {
                        if (temp.startsWith("#")) {
                            theName = temp.substring(1);
                            continue;
                        }
                        if (theName == null || !theName.equals(headerName)) continue;
                        int i = 0;
                        String[] f = new String[6];
                        StringTokenizer st = new StringTokenizer(temp, " ");
                        while (st.hasMoreTokens()) {
                            f[i] = st.nextToken();
                            if (i == 5) {
                                this.setValue("Hours", f[1]);
                                this.setValue("Mins", f[0]);
                                this.setValue("DaysOfWeek", f[4]);
                                gotIt = true;
                                break;
                            }
                            ++i;
                        }
                        theName = null;
                        if (!gotIt) continue;
                    }
                    break;
                }
                if (!temp.startsWith(CRON_BEGIN)) continue;
                inSection = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void Remove() {
        this.Update(true);
    }

    public void Update() {
        this.Update(false);
    }

    private void Update(boolean isDelete) {
        try {
            String headerName = CSConfig.getServerRoot() + ":" + this.name;
            Process process = Runtime.getRuntime().exec(crontab + " -l");
            InputStream instream = process.getInputStream();
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(instream));
            String tmpFileName = "/tmp/ipscron.txt." + Long.toString(System.currentTimeMillis());
            FileWriter outf = new FileWriter(tmpFileName);
            String temp = null;
            boolean inSection = false;
            boolean gotIt = false;
            String theName = null;
            while ((temp = buffReader.readLine()) != null) {
                if (gotIt) {
                    outf.write(temp + "\n");
                    continue;
                }
                if (inSection) {
                    if (temp.startsWith(CRON_END)) {
                        if (!isDelete) {
                            outf.write("#" + headerName + "\n");
                            outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                        }
                        outf.write("# Search cron entries end here.\n");
                        gotIt = true;
                        continue;
                    }
                    if (temp.startsWith("#")) {
                        theName = temp.substring(1);
                        if (isDelete && theName.equals(headerName)) continue;
                        outf.write(temp + "\n");
                        continue;
                    }
                    if (theName != null && theName.equals(headerName)) {
                        if (!isDelete) {
                            outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                        }
                        gotIt = true;
                        continue;
                    }
                } else if (temp.startsWith(CRON_BEGIN)) {
                    System.out.println("CRON_BEGIN reached");
                    inSection = true;
                }
                outf.write(temp + "\n");
            }
            if (!inSection) {
                outf.write("# Search cron entries start here. Don't modify this section\n");
                outf.write("#" + headerName + "\n");
                outf.write(this.getValue("Mins") + " " + this.getValue("Hours") + " * * " + this.getValue("DaysOfWeek") + " " + this.getValue("Command") + "\n");
                outf.write("# Search cron entries end here.\n");
            }
            outf.close();
            process = Runtime.getRuntime().exec(crontab + " " + tmpFileName);
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            File f = new File(tmpFileName);
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getValue(String param) {
        return (String)this.valuesMap.get(param);
    }

    public void setValue(String key, String value) {
        if (this.valuesMap != null) {
            if (this.valuesMap.containsKey(key)) {
                this.valuesMap.remove(key);
            }
            this.valuesMap.put(key, value);
        }
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    static {
        if (SunOSTask.isLinux()) {
            crontab = CRONTAB_LINUX;
        }
    }
}

