/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.util;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class DBUtil {
    static String getListCmd = "run-cs-cli rdmgr -y root -U";
    static String getRDCountCmd = "/run-cs-cli rdmgr -n -y ";
    static HashMap dbList = null;
    static HashMap lastUpdated = null;
    public static SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    public static final String STAT_LAST_MODIFIED = "DbStat-LastModified";
    public static final String STAT_NB_SERVER = "DbStat-NbServer";
    public static final String STAT_HREF = "DbStat-Href";
    public static final String STAT_HREF_COUNT = "DbStat-Href-count";
    public static final String STAT_NB_PROTOCOL = "DbStat-NbProtocol";
    public static final String STAT_PROTOCOL = "DbStat-Protocol";
    public static final String STAT_PROTOCOL_COUNT = "DbStat-Protocol-count";
    static String RUN_CS_CLI = "run-cs-cli";
    static String RUN_CS_CLI_BAT = "run-cs-cli.bat";

    public static List getDBList(String server_root) throws Exception {
        ArrayList al;
        File f;
        Date d;
        if (dbList == null) {
            dbList = new HashMap();
        }
        if (lastUpdated == null) {
            lastUpdated = new HashMap();
        }
        if ((d = (Date)lastUpdated.get(server_root)) != null && (f = new File(server_root + File.separator + "db" + File.separator + "root" + File.separator + "rd.db")).exists() && d.after(new Date(f.lastModified())) && (al = (ArrayList)dbList.get(server_root)) != null) {
            return al;
        }
        ArrayList<SOIF> al2 = new ArrayList<SOIF>();
        String command = server_root + File.separator + getListCmd;
        Process p = DBUtil.exec(command);
        SOIFInputStream is = new SOIFInputStream(p.getInputStream(), "UTF-8");
        while (!is.isEOS()) {
            SOIF s2;
            SOIF s1 = is.readSOIF();
            if (s1 == null || s1.getURL().equals("root")) continue;
            int i = 0;
            while (i < al2.size() && (s2 = (SOIF)al2.get(i++)).getURL().compareTo(s1.getURL()) <= 0) {
            }
            String dbClass = s1.getValue("class");
            if (dbClass != null && !dbClass.equals("") && !dbClass.equals("com.sun.portal.search.db.IndexedSOIFDb")) continue;
            al2.add(i, s1);
        }
        dbList.put(server_root, al2);
        lastUpdated.put(server_root, new Date());
        return al2;
    }

    public static String[] getDBStringArray(String server_root) throws Exception {
        List dbs = DBUtil.getDBList(server_root);
        String[] names = new String[dbs.size()];
        for (int i = 0; i < dbs.size(); ++i) {
            SOIF s = (SOIF)dbs.get(i);
            names[i] = s.getURL();
        }
        return names;
    }

    public static boolean updateSoif(String server_root, SOIF s) {
        try {
            String tmpFile = server_root + File.separator + "tmp" + File.separator + "_tmpDBUtil." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream so = new SOIFOutputStream(tmpFile);
            so.write(s);
            so.close();
            String cmd = server_root + "/run-cs-cli rdmgr -D -y root -m -P -q " + tmpFile;
            Runtime rt = Runtime.getRuntime();
            Process ps = DBUtil.exec(cmd);
            ps.waitFor();
            if (ps.exitValue() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean replaceSoif(String server_root, SOIF s) {
        try {
            String tmpFile = server_root + File.separator + "tmp" + File.separator + "_tmpDBUtil." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream so = new SOIFOutputStream(tmpFile);
            so.write(s);
            so.close();
            String cmd = server_root + "/run-cs-cli rdmgr -D -y root -u -P -q " + tmpFile;
            Runtime rt = Runtime.getRuntime();
            Process ps = DBUtil.exec(cmd);
            ps.waitFor();
            if (ps.exitValue() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static synchronized boolean isDBExist(String server_root, String dbName) throws Exception {
        List dbs = DBUtil.getDBList(server_root);
        for (int i = 0; i < dbs.size(); ++i) {
            SOIF s = (SOIF)dbs.get(i);
            if (s.getURL().compareToIgnoreCase(dbName) != 0) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean addNewDB(String server_root, String dbName, String dbTitle, String dbDesc) throws Exception {
        List dbs = DBUtil.getDBList(server_root);
        for (int i = 0; i < dbs.size(); ++i) {
            SOIF s = (SOIF)dbs.get(i);
            if (s.getURL().compareToIgnoreCase(dbName) != 0) continue;
            return false;
        }
        String cmd = server_root + "/run-cs-cli rdmgr -y " + dbName + " -n";
        Runtime rt = Runtime.getRuntime();
        Process ps = DBUtil.exec(cmd);
        ps.waitFor();
        if (ps.exitValue() != 0) {
            return false;
        }
        SOIF newDB = new SOIF("Database", dbName);
        newDB.insert("description", dbDesc);
        newDB.insert("Title", dbTitle);
        return DBUtil.updateSoif(server_root, newDB);
    }

    public static SOIF getDBSoif(String server_root, String dbName) {
        try {
            List soifs = DBUtil.getDBList(server_root);
            for (int i = 0; i < soifs.size(); ++i) {
                SOIF s = (SOIF)soifs.get(i);
                if (!s.getURL().equals(dbName)) continue;
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static synchronized boolean updateDB(String server_root, String dbName, String dbTitle, String dbDesc) throws Exception {
        SOIF s = DBUtil.getDBSoif(server_root, dbName);
        if (s != null) {
            s.replace("description", dbDesc);
            s.replace("Title", dbTitle);
            return DBUtil.updateSoif(server_root, s);
        }
        return false;
    }

    public static synchronized boolean updateDB(String server_root, String dbName, Date timeStamp, Hashtable listServer, Hashtable listProtocol) throws Exception {
        SOIF s = DBUtil.getDBSoif(server_root, dbName);
        if (s != null) {
            try {
                int i;
                String count = s.getValue(STAT_NB_SERVER);
                if (count != null) {
                    for (i = 0; i < Integer.parseInt(count); ++i) {
                        s.remove(STAT_HREF, i);
                        s.remove(STAT_HREF_COUNT, i);
                    }
                }
                if ((count = s.getValue(STAT_NB_PROTOCOL)) != null) {
                    for (i = 0; i < Integer.parseInt(count); ++i) {
                        s.remove(STAT_PROTOCOL, i);
                        s.remove(STAT_PROTOCOL_COUNT, i);
                    }
                }
                s.replace(STAT_LAST_MODIFIED, timeStamp != null ? df.format(timeStamp) : df.format(new Date()));
                s.replace(STAT_NB_SERVER, listServer != null ? Integer.toString(listServer.size()) : Integer.toString(0));
                s.replace(STAT_NB_PROTOCOL, listProtocol != null ? Integer.toString(listProtocol.size()) : Integer.toString(0));
                Enumeration<Object> en = null;
                Object attrib = null;
                if (listServer != null) {
                    en = listServer.keys();
                    i = 0;
                    while (en.hasMoreElements()) {
                        s.insert(STAT_HREF, (String)en.nextElement(), i);
                        ++i;
                    }
                    en = listServer.elements();
                    i = 0;
                    while (en.hasMoreElements()) {
                        s.insert(STAT_HREF_COUNT, (String)en.nextElement(), i);
                        ++i;
                    }
                }
                if (listProtocol != null) {
                    en = listProtocol.keys();
                    i = 0;
                    while (en.hasMoreElements()) {
                        s.insert(STAT_PROTOCOL, (String)en.nextElement(), i);
                        ++i;
                    }
                    en = listProtocol.elements();
                    i = 0;
                    while (en.hasMoreElements()) {
                        s.insert(STAT_PROTOCOL_COUNT, (String)en.nextElement(), i);
                        ++i;
                    }
                }
                return DBUtil.replaceSoif(server_root, s);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static int getRDCount(String server_root, String dbname) throws Exception {
        int count = 0;
        String cmd = server_root + File.separator + getRDCountCmd + dbname;
        Runtime rt = Runtime.getRuntime();
        Process ps = DBUtil.exec(cmd);
        BufferedReader buf = new BufferedReader(new InputStreamReader(ps.getInputStream()));
        String line = buf.readLine();
        NumberFormat nf = NumberFormat.getInstance();
        count = nf.parse(line).intValue();
        return count;
    }

    static synchronized boolean executeRDMgr(String cmd, Writer out) {
        boolean res = false;
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(cmd);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                if (out == null) continue;
                out.write(outLine + "\n");
                out.flush();
            }
            res = process.waitFor() == 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    static synchronized BufferedReader executeRDMgr(String cmd) {
        BufferedReader buf = null;
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(cmd);
            buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf;
    }

    public static boolean purgeDatabase(String server_root, String dbname, Writer out) {
        String cmd = server_root + File.separator + "run-cs-cli rdmgr -X -p stdout -y " + dbname;
        return DBUtil.executeRDMgr(cmd, out);
    }

    public static boolean reindexDatabase(String server_root, String dbname, Writer out) {
        String cmd = server_root + File.separator + "run-cs-cli rdmgr -I -p stdout -y " + dbname;
        return DBUtil.executeRDMgr(cmd, out);
    }

    public static boolean expireDatabase(String server_root, String dbname, Writer out) {
        String cmd = server_root + File.separator + "run-cs-cli rdmgr -E -p stdout -y " + dbname;
        return DBUtil.executeRDMgr(cmd, out);
    }

    public static boolean deleteDatabase(String server_root, String dbname, Writer out) {
        String cmd = server_root + File.separator + "run-cs-cli rdmgr -B -p stdout -y " + dbname;
        return DBUtil.executeRDMgr(cmd, out);
    }

    public static BufferedReader urlStatDatabase(String server_root, String dbname) {
        String cmd = server_root + File.separator + "run-cs-cli rdmgr -L -a url -y " + dbname;
        return DBUtil.executeRDMgr(cmd);
    }

    public static boolean dbStatOnFile(String server_root, String dbname) {
        boolean ret = false;
        try {
            ret = DBUtil.getDBSoif(server_root, dbname).getValue(STAT_LAST_MODIFIED) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean indexCategories(String server_root) {
        boolean ret = true;
        String[] cmd = new String[]{server_root + File.separator + "run-cs-cli rdmgr -p stdout -T -X", server_root + File.separator + "run-cs-cli rdmgr -TV -p stdout " + SearchConfig.getValue((String)"taxonomy-description")};
        for (int i = 0; i < 2 && (ret = DBUtil.executeRDMgr(cmd[i], null)); ++i) {
        }
        return ret;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static Process exec(String command) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process process = null;
        if (DBUtil.isWindows()) {
            command = command.replace('\\', '/');
            int idx = command.indexOf(RUN_CS_CLI);
            StringBuffer buf = new StringBuffer(command.substring(0, idx));
            buf.append(RUN_CS_CLI_BAT);
            buf.append(command.substring(idx + RUN_CS_CLI.length()));
            command = buf.toString();
            process = rt.exec(command);
        } else {
            process = rt.exec(command);
        }
        return process;
    }
}

