/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModelBase;
import com.iplanet.jato.model.ValidationException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFException;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaxonomyTreeModel
extends TreeModelBase
implements Serializable {
    public Locale userLocale = Locale.getDefault();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$TaxonomyTreeModel == null ? (class$com$sun$portal$search$admin$model$TaxonomyTreeModel = TaxonomyTreeModel.class$("com.sun.portal.search.admin.model.TaxonomyTreeModel")) : class$com$sun$portal$search$admin$model$TaxonomyTreeModel));
    public static final String FIELD_ID = "Id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CONCEPTS = "concepts";
    public static final String FIELD_FILES = "files";
    public static final String FIELD_VIEWBEAN_CLASS = "viewbean";
    public static final String MODEL_NAME = "TaxonomyTreeModel";
    private String name;
    private RDMTaxonomy tax;
    private RDMClassification root;
    private String errorMsg = null;
    private String editErrorMsg = null;
    private boolean modified;
    private long lastModified;
    private Date lastActionDate;
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$TaxonomyTreeModel;

    public TaxonomyTreeModel() {
        this.load();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void root() throws ModelControlException {
        try {
            this.setCurrentNode(this.root);
            this.setNodeLevel(0);
            this.setIterationComplete(false);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException(this.getLocalizedString("category.edit.error.default"));
        }
    }

    public void beforeRoot() throws ModelControlException {
        try {
            this.setNodeLevel(-1);
            this.setIterationComplete(false);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public String getNodeDesc(String nodeId) throws ModelControlException {
        if (nodeId != null) {
            RDMClassification node = this.tax.find(nodeId);
            try {
                if (node != null) {
                    if (node == this.root) {
                        return this.tax.getDescription();
                    }
                    return node.getDescription();
                }
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0057", nodeId);
                return null;
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeId, e.getMessage()});
                throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
            }
        }
        return null;
    }

    public String getNodeRule(String nodeId) throws ModelControlException {
        if (nodeId != null) {
            RDMClassification node = this.tax.find(nodeId);
            try {
                if (node != null) {
                    if (node == this.root) {
                        return null;
                    }
                    return node.getMatchingRule();
                }
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0057", nodeId);
                return null;
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeId, e.getMessage()});
                throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
            }
        }
        return null;
    }

    public String getNodeName(String nodeId) throws ModelControlException {
        if (nodeId != null) {
            RDMClassification node = this.tax.find(nodeId);
            try {
                if (node != null) {
                    if (node.getParent() == null) {
                        return this.tax.getId();
                    }
                    return node.getId();
                }
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0057", nodeId);
                return null;
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeId, e.getMessage()});
                throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
            }
        }
        return null;
    }

    public String getNodeName() throws ModelControlException {
        RDMClassification node = (RDMClassification)this.getCurrentNode();
        try {
            if (node != null) {
                if (node.getParent() == null) {
                    return this.tax.getId();
                }
                return node.getId();
            }
            return null;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public String getNodeType() throws ModelControlException {
        try {
            String ret = null;
            ret = this.isParentNode() ? "Parent" : "Leaf";
            return ret;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public RDMClassification getNode(String nodeID) {
        try {
            RDMClassification rc = this.tax.find(nodeID);
            return rc;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeID, e.getMessage()});
            return null;
        }
    }

    public Object getCurrentNode() {
        try {
            Object obj = super.getCurrentNode();
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setCurrentNode(String nodeID) throws ModelControlException {
        try {
            this.setCurrentNode(this.getNode(nodeID));
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeID, e.getMessage()});
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public String getNodeID() {
        RDMClassification node = (RDMClassification)this.getCurrentNode();
        try {
            if (node != null) {
                return TaxonomyTreeModel.hashNodeId(node.getId());
            }
            return null;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            return null;
        }
    }

    public boolean isParentNode(String nodeId) {
        if (nodeId != null) {
            try {
                RDMClassification node = this.tax.find(nodeId);
                if (node != null) {
                    return node.nChildren() > 0;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isParentNode() {
        try {
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null) {
                return node.nChildren() > 0;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            return false;
        }
    }

    public boolean isChildNode() {
        RDMClassification node = (RDMClassification)this.getCurrentNode();
        try {
            if (node != null) {
                return node.getParent() != null;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            return false;
        }
    }

    public boolean isLastChild(RDMClassification parent, RDMClassification child) throws ModelControlException {
        try {
            int lastChild = parent.nChildren() - 1;
            return parent.nthChild(lastChild) == child;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0060", new String[]{parent.toString(), child.toString(), e.getMessage()});
            throw new ModelControlException("failed to verify if currentNode is last child");
        }
    }

    public boolean isLastChild() throws ModelControlException {
        return this.isLastChild(((RDMClassification)this.getCurrentNode()).getParent(), (RDMClassification)this.getCurrentNode());
    }

    public boolean firstChild() throws ModelControlException {
        try {
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null && this.isParentNode()) {
                this.setCurrentNode(node.getChildren().get(0));
                this.incrementNodeLevel();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public List getChildren(String nodeId) {
        if (nodeId != null) {
            try {
                RDMClassification parent = this.tax.find(nodeId);
                return parent.getChildren();
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSAM0062", e.getMessage());
                return null;
            }
        }
        return null;
    }

    public boolean parent() throws ModelControlException {
        try {
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null && this.isChildNode()) {
                this.setCurrentNode(node.getParent());
                this.decrementNodeLevel();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public boolean nextSibling() throws ModelControlException {
        try {
            RDMClassification parent;
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null && (parent = node.getParent()) != null) {
                int index = parent.getChildren().indexOf(node);
                if (++index < parent.nChildren()) {
                    this.setCurrentNode(parent.nthChild(index));
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            throw new ModelControlException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public Object getValue(String name) {
        try {
            Object[] values = this.getValues(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0059", new String[]{name, e.getMessage()});
            return null;
        }
    }

    public void setValue(String name, Object value) throws ValidationException {
        try {
            this.setValues(name, new Object[]{value});
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0060", new Object[]{name, value, e.getMessage()});
            throw new ValidationException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public Object[] getValues(String name) {
        try {
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null) {
                String value = null;
                value = name.compareTo(FIELD_NAME) == 0 ? (node.getParent() == null ? this.tax.getId() : node.getSubcategory()) : node.getSOIF().getValue(name);
                return new Object[]{value};
            }
            return null;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0059", new String[]{name, e.getMessage()});
            throw new ValidationException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public void setValues(String name, Object[] values) throws ValidationException {
        try {
            RDMClassification node = (RDMClassification)this.getCurrentNode();
            if (node != null) {
                if (node.getParent() == null) {
                    this.tax.getSOIF().replace(name, (String)values[0]);
                } else {
                    node.getSOIF().replace(name, (String)values[0]);
                }
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0059", new String[]{name, e.getMessage()});
            throw new ValidationException("TaxonomyTreeModel exception e=" + e.getMessage());
        }
    }

    public void deleteNode(String nodeID) throws ModelControlException {
        try {
            RDMClassification node = this.tax.find(nodeID);
            if (node != null) {
                RDMClassification parent = node.getParent();
                if (parent != null) {
                    int nodeNbDescendant = node.getNumDescendant();
                    int parentNbChildren = parent.nChildren();
                    int childIndex = parent.getChildren().indexOf(node);
                    parent.getChildren().remove(childIndex);
                    Collections.sort(parent.getChildren());
                    boolean i = false;
                    for (RDMClassification asc = parent; asc != null; asc = asc.getParent()) {
                        int cur = asc.getNumDescendant();
                        asc.setNumDescendant(cur - (nodeNbDescendant + 1));
                    }
                } else {
                    try {
                        this.tax = new RDMTaxonomy(this.getLocalizedString("category.edit.default_taxonomy_name"));
                        this.root = this.tax.find("ROOT");
                    }
                    catch (Exception e) {
                        throw new ModelControlException(this.getLocalizedString("category.edit.error.delete") + " " + nodeID + " " + this.getLocalizedString("category.edit.error.delete_not_found"));
                    }
                }
            } else {
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0057", nodeID);
                throw new ModelControlException(this.getLocalizedString("category.edit.error.delete_default"));
            }
            this.setModifiedState(true);
        }
        catch (NullPointerException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeID, e.getMessage()});
            throw new ModelControlException(this.getLocalizedString("category.edit.error.delete_default"));
        }
    }

    public int nChildren(String nodeId) {
        try {
            RDMClassification node = this.tax.find(nodeId);
            return node.nChildren();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeId, e.getMessage()});
            return -1;
        }
    }

    public int getNumDescendant(String nodeId) {
        try {
            RDMClassification node = this.tax.find(nodeId);
            return node.getNumDescendant();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeId, e.getMessage()});
            return -1;
        }
    }

    public void insertChildNode(String parentId, String childId, String childDesc, String childRule) throws ModelControlException {
        try {
            if (this.tax == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add_child") + " " + childId);
            }
            RDMClassification nodeTax = this.tax.find(parentId);
            this.insertChildNode(nodeTax, childId, childDesc, childRule);
        }
        catch (ModelControlException mce) {
            throw mce;
        }
        catch (NullPointerException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0061", new String[]{parentId, childId, childDesc, e.getMessage()});
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_default"));
        }
    }

    public void insertSiblingNode(String nodeId, String siblingId, String childDesc, String childRule) throws ModelControlException {
        try {
            if (this.tax == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add_sibling") + " " + siblingId);
            }
            RDMClassification nodeTax = this.tax.find(nodeId).getParent();
            this.insertChildNode(nodeTax, siblingId, childDesc, childRule);
        }
        catch (ModelControlException mce) {
            throw mce;
        }
        catch (NullPointerException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0061", new String[]{nodeId, siblingId, childDesc, e.getMessage()});
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_sibling") + " " + siblingId + " " + this.getLocalizedString("category.edit.error.add_sibling_to") + " " + nodeId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertChildNode(RDMClassification rc, String childId, String childDesc, String childRule) throws ModelControlException {
        try {
            String childAbsolutID = null;
            childAbsolutID = rc == this.root ? childId : rc.getId() + ":" + childId;
            if (rc == null) throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + childAbsolutID + " " + this.getLocalizedString("category.edit.error.add_no_parent"));
            if (rc == this.root && (childId.equals("ROOT") || childId.equals(this.tax.getId()))) {
                if (!childId.equals("ROOT")) throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_top_classification"));
                throw new ModelControlException(this.getLocalizedString("category.edit.error.root_child"));
            }
            if (this.tax.find(childAbsolutID) != null) throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + childAbsolutID + " " + this.getLocalizedString("category.edit.error.add_exists"));
            RDMClassification newRc = this.newChild(rc, childId, childDesc, childRule, rc.getTaxonomyId());
            if (newRc == null) {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.add") + " " + childAbsolutID + " " + this.getLocalizedString("category.edit.error.add_cannot_create"));
            }
            this.tax.insert(newRc);
            this.setModifiedState(true);
            return;
        }
        catch (NullPointerException npe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0063", new String[]{childId, rc.getId(), npe.getMessage()});
            throw new ModelControlException(this.getLocalizedString("category.edit.error.add_default"));
        }
    }

    public void updateNode(String currentId, String newId, String newDesc, String newRule) throws ModelControlException {
        block12: {
            try {
                if (newId.trim() != "") {
                    RDMClassification node = this.tax.find(currentId);
                    StringBuffer sb = new StringBuffer();
                    if (node.getParentId() == null) {
                        this.updateTaxonomy(newId, newDesc);
                    } else {
                        if (node.getParent() == this.root && (newId.equals(this.tax.getId()) || newId.equals("ROOT"))) {
                            if (newId.equals("ROOT")) {
                                throw new ModelControlException(this.getLocalizedString("category.edit.error.root_child"));
                            }
                            throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_taxonomy"));
                        }
                        if (currentId.indexOf(58) != -1) {
                            sb.append(currentId.substring(0, currentId.lastIndexOf(":")));
                            sb.append(":" + newId);
                        } else {
                            sb.append(newId);
                        }
                        boolean reject = false;
                        if (!newId.equals(TaxonomyTreeModel.lastNode(currentId))) {
                            RDMClassification parentRc = node.getParent();
                            for (int i = 0; i < parentRc.nChildren(); ++i) {
                                if (!parentRc.nthChild(i).getId().equals(sb.toString())) continue;
                                reject = true;
                                break;
                            }
                        }
                        if (reject) {
                            throw new ModelControlException(this.getLocalizedString("category.edit.error.update") + " " + sb.toString() + " " + this.getLocalizedString("category.edit.error.add_exists"));
                        }
                        node.setSubcategory(sb.toString());
                        this.recurseUpdateNode(node, currentId, sb.toString());
                        node.setDescription(newDesc);
                        node.setMatchingRule(newRule);
                        this.setModifiedState(true);
                    }
                    break block12;
                }
                throw new ModelControlException(this.getLocalizedString("category.edit.error.update") + " " + currentId + " " + this.getLocalizedString("category.edit.error.update_blank"));
            }
            catch (NullPointerException npe) {
                debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", npe.getMessage());
                throw new ModelControlException(this.getLocalizedString("category.edit.error.update_default"));
            }
        }
    }

    public String getTaxonomyDescription() {
        if (this.tax != null) {
            return this.tax.getDescription();
        }
        return null;
    }

    public void updateTaxonomy(String newId, String newDesc) throws ModelControlException {
        try {
            if (!newId.trim().equals("")) {
                boolean reject = false;
                for (int i = 0; i < this.root.nChildren(); ++i) {
                    if (!this.root.nthChild(i).getId().equals(newId)) continue;
                    reject = true;
                    break;
                }
                if (reject) {
                    throw new ModelControlException(this.getLocalizedString("category.edit.error.must_differ_from_taxonomy"));
                }
            } else {
                throw new ModelControlException(this.getLocalizedString("category.edit.error.blank_taxonomy"));
            }
            this.recurseUpdateNodeTaxonomy(this.root, newId);
            this.tax.setId(newId);
            this.tax.setDescription(newDesc.trim());
            this.setModifiedState(true);
        }
        catch (NullPointerException e) {
            throw new ModelControlException(this.getLocalizedString("category.edit.error.update_default"));
        }
    }

    public void recurseUpdateNodeTaxonomy(RDMClassification rc, String newId) throws ModelControlException {
        try {
            rc.setTaxonomyId(newId);
            for (int i = 0; i < rc.nChildren(); ++i) {
                this.recurseUpdateNodeTaxonomy(rc.nthChild(i), newId);
            }
        }
        catch (NullPointerException npe) {
            String rcStr = rc != null ? rc.getId() : "(rc is NULL)";
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0064", rcStr);
            throw new ModelControlException("cannot recursively update Taxonomy on children of category " + rcStr);
        }
    }

    public void recurseUpdateNode(RDMClassification node, String currentId, String newId) throws ModelControlException {
        try {
            String parentId;
            String nodeId = node.getId();
            if (nodeId.startsWith(currentId)) {
                StringBuffer newNodeId = new StringBuffer(newId);
                String nodeIdSuffix = nodeId.substring(currentId.length());
                if (nodeIdSuffix.length() > 0) {
                    newNodeId.append(nodeIdSuffix);
                }
                node.setId(newNodeId.toString());
            }
            if ((parentId = node.getParentId()) != null && parentId.startsWith(currentId)) {
                StringBuffer newParentNodeId = new StringBuffer(newId);
                String parentNodeIdSuffix = parentId.substring(currentId.length());
                if (parentNodeIdSuffix.length() > 0) {
                    newParentNodeId.append(parentNodeIdSuffix);
                }
                node.setParentId(newParentNodeId.toString());
            }
            for (int i = 0; i < node.nChildren(); ++i) {
                this.recurseUpdateNode(node.nthChild(i), currentId, newId);
            }
        }
        catch (NullPointerException npe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0065", currentId);
            throw new ModelControlException("cannot recursivly update children of category " + currentId);
        }
    }

    public ArrayList getDescendance(String parentID) throws ModelControlException {
        try {
            RDMClassification node = this.tax.find(parentID);
            ArrayList descendance = new ArrayList();
            this.getDescendance(node, descendance);
            return descendance;
        }
        catch (Exception e) {
            throw new ModelControlException("Cannot get the descendance of node=" + parentID);
        }
    }

    private void getDescendance(RDMClassification rc, ArrayList descendance) {
        for (int i = 0; i < rc.nChildren(); ++i) {
            RDMClassification childRc = rc.nthChild(i);
            descendance.add(childRc.getId());
            this.getDescendance(childRc, descendance);
        }
    }

    public static String lastNode(String nodeID) {
        try {
            int ndx;
            String value = null;
            value = nodeID != null ? ((ndx = nodeID.lastIndexOf(58)) > 0 ? nodeID.substring(ndx + 1) : nodeID) : null;
            return value;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0058", new String[]{nodeID, e.getMessage()});
            return null;
        }
    }

    public void load() {
        try {
            this.setErrorMsg(null);
            this.tax = null;
            this.root = null;
            String s = SearchConfig.getValue((String)"taxonomy-description");
            SOIFInputStream ss = new SOIFInputStream(s, "UTF-8");
            this.tax = new RDMTaxonomy(ss);
            if (this.tax == null) {
                this.root = null;
                debugLogger.finer("PSSH_CSPSAM0066");
            } else {
                this.root = this.tax.find("ROOT");
                if (this.root == null) {
                    debugLogger.finer("PSSH_CSPSAM0067");
                    this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
                }
                this.setErrorMsg(null);
                this.setModifiedState(false);
                this.setTimeStamp();
            }
        }
        catch (FileNotFoundException fnf) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.missing_config_file"));
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", fnf.getMessage());
        }
        catch (UnsupportedEncodingException ue) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", ue.getMessage());
        }
        catch (SOIFException se) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", se.getMessage());
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg != null && exceptionMsg.indexOf(SOIF.INVALIDSOIF) != -1) {
                this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            } else {
                this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
            }
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
        }
    }

    RDMClassification newChild(RDMClassification parent, String childId, String childDesc, String childRule, String taxonomyId) {
        try {
            if (childId.trim() != "") {
                String parentId = parent.getId();
                String newId = parentId.equals("ROOT") ? childId : parentId + ":" + childId;
                RDMClassification rc = new RDMClassification(newId);
                rc.setTaxonomyId(taxonomyId);
                rc.setParentId(parentId);
                rc.setDescription(childDesc);
                rc.setMatchingRule(childRule);
                return rc;
            }
            return null;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            return null;
        }
    }

    public void save() throws ModelControlException {
        String server_root = CSConfig.getServerRoot();
        try {
            SOIFOutputStream sos = new SOIFOutputStream(SearchConfig.getValue((String)"taxonomy-description"), "UTF-8");
            sos.write(this.tax.getSOIF());
            sos.flush();
            this.write(sos);
            sos.flush();
            sos.close();
            if (!DBUtil.indexCategories(CSConfig.getServerRoot())) {
                debugLogger.finer("PSSH_CSPSAM0068");
            }
            this.setErrorMsg(null);
            this.setModifiedState(false);
            this.setTimeStamp();
            CSConfig.loadTaxonomy();
        }
        catch (FileNotFoundException fnf) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.missing_config_file"));
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", fnf.getMessage());
        }
        catch (UnsupportedEncodingException ue) {
            this.setErrorMsg(this.getLocalizedString("category.edit.error.invalid_config_file"));
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", ue.getMessage());
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            this.setErrorMsg(this.getLocalizedString("category.edit.error.default"));
        }
    }

    public boolean getModifiedState() {
        return this.modified;
    }

    private void setModifiedState(boolean modified) {
        this.modified = modified;
        this.lastActionDate = new Date();
    }

    public void write(SOIFOutputStream ss) {
        this.write(ss, this.root);
    }

    private void write(SOIFOutputStream ss, RDMClassification rc) {
        try {
            Object sb = null;
            if (rc != this.root) {
                ss.write(rc.getSOIF());
            }
            if (rc.getNumDescendant() != 0) {
                for (int j = 0; j < rc.nChildren(); ++j) {
                    this.write(ss, rc.nthChild(j));
                }
            }
        }
        catch (IOException ioe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", ioe.getMessage());
        }
    }

    public void dump(RDMClassification rc) {
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0069", this.tax.getId());
        this.dumpChildren(rc, 0);
    }

    public void dumpChildren(RDMClassification rc, int level) {
        try {
            StringBuffer sb = new StringBuffer("level(" + rc.getDepth() + "):");
            for (int i = 0; i < level; ++i) {
                sb.append("  ");
            }
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0070", sb.toString() + new String(rc.getSOIF().toByteArray()));
            if (rc.getNumDescendant() != 0) {
                for (int j = 0; j < rc.nChildren(); ++j) {
                    this.dumpChildren(rc.nthChild(j), level + 1);
                }
            }
        }
        catch (IOException ioe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", ioe.getMessage());
        }
    }

    public RDMClassification getRoot() {
        return this.root;
    }

    public String getLocalizedString(String key) {
        return SearchResource.geti18nString(key, this.userLocale);
    }

    public boolean isConfigNewer() throws ModelControlException {
        try {
            File f = new File(SearchConfig.getValue((String)"taxonomy-description"));
            if (this.getTimeStamp() < f.lastModified() && this.getTimeStamp() != 0L) {
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0071", new String[]{Long.toString(f.lastModified()), Long.toString(this.getTimeStamp())});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.info("PSSH_CSPSAM0072");
            throw new ModelControlException(this.getLocalizedString("category.edit.warning.config_timestamp"));
        }
    }

    public static String hashNodeId(String nodeId) {
        if (nodeId != null) {
            return String.valueOf(nodeId.hashCode());
        }
        debugLogger.info("PSSH_CSPSAM0073");
        return null;
    }

    public void setErrorMsg(String errMsg) {
        this.errorMsg = errMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Date getLastActionDate() {
        return this.lastActionDate;
    }

    private void setLastActionDate(long d) {
        this.lastActionDate = new Date(d);
    }

    private long getTimeStamp() {
        return this.lastModified;
    }

    private void setTimeStamp() {
        try {
            File f = new File(SearchConfig.getValue((String)"taxonomy-description"));
            this.lastModified = f.lastModified();
            this.setLastActionDate(this.lastModified);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0074", e.getMessage());
            this.setErrorMsg(this.getLocalizedString("category.edit.warning.config_timestamp"));
        }
    }

    public boolean isValidName(String catName) throws ModelControlException {
        if (catName != null) {
            String trimmedCatName = catName.trim();
            if (trimmedCatName.length() != 0) {
                if (trimmedCatName.indexOf(58) == -1 && trimmedCatName.indexOf(59) == -1 && trimmedCatName.indexOf(60) == -1 && trimmedCatName.indexOf(62) == -1 && trimmedCatName.indexOf(34) == -1 && trimmedCatName.indexOf(92) == -1) {
                    return true;
                }
                throw new ModelControlException(this.getLocalizedString("category.edit.error.invalid_name"));
            }
            throw new ModelControlException(this.getLocalizedString("category.edit.error.invalid_name"));
        }
        throw new ModelControlException(this.getLocalizedString("category.edit.error.blank_taxonomy"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

