/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.StringFilter;
import java.util.ArrayList;
import java.util.logging.Logger;

public class StringFilterListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String ruleID = null;
    private int delIndex = -1;
    public static final String FIELD_FILTERSRC = "FilterSrc";
    public static final String FIELD_FILTERBY = "FilterBy";
    public static final String FIELD_PATTERN = "Pattern";
    public static final String FIELD_DELETE = "Delete";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$StringFilterListModel == null ? (class$com$sun$portal$search$admin$model$StringFilterListModel = StringFilterListModel.class$("com.sun.portal.search.admin.model.StringFilterListModel")) : class$com$sun$portal$search$admin$model$StringFilterListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$StringFilterListModel;

    public void setID(String id) {
        this.ruleID = id;
    }

    public void setDelIndex(int index) {
        this.delIndex = index;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("insert")) {
            result = this.insert(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_PATTERN) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.beforeFirst();
        FilterRule fr = null;
        if (this.ruleID != null) {
            fr = CSConfig.getRobotConfig().GetRule(this.ruleID);
        }
        if (fr != null) {
            fr.removeAllFilter();
            while (this.next()) {
                String src = (String)this.getValue(FIELD_FILTERSRC);
                String by = (String)this.getValue(FIELD_FILTERBY);
                String p = (String)this.getValue(FIELD_PATTERN);
                if (p == null || p.trim().length() <= 0) continue;
                fr.addFilter(src, by, p.trim());
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        this.setValue(FIELD_FILTERSRC, FilterRule.filter_srcs[0]);
        this.setValue(FIELD_FILTERBY, FilterRule.filter_methods[0]);
        this.setValue(FIELD_PATTERN, "");
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            delObjs.add(this.getCurrentContext().getValueList().get(index));
        }
        for (int i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        FilterRule fr = null;
        if (this.ruleID != null) {
            if (this.ruleID.compareTo("new") == 0) {
                this.clear();
                this.insert(context);
            } else {
                fr = CSConfig.getRobotConfig().GetRule(this.ruleID);
                if (fr != null) {
                    this.clear();
                    int n = fr.numberOfStringFilters();
                    for (int i = 0; i < n; ++i) {
                        StringFilter sf = (StringFilter)fr.filters.get(i);
                        if (sf == null) continue;
                        this.appendRow();
                        this.setValue(FIELD_FILTERSRC, sf.directive);
                        this.setValue(FIELD_FILTERBY, FilterRule.getMethodText(sf.method));
                        this.setValue(FIELD_PATTERN, sf.filter);
                    }
                }
            }
        } else {
            debugLogger.finer("PSSH_CSPSAM0055");
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

