/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRuleset;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StartingGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_URL = "URL";
    public static final String FIELD_DEPTH = "Depth";
    public static final String FIELD_DELETE = "Delete";

    public void setID(String id) {
        this.rulesetID = id;
    }

    public void setDelIndex(int index) {
        this.delIndex = index;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1) {
            if (this.getValue(FIELD_URL) == null) {
                this.getCurrentContext().getValueList().clear();
            }
        }
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("insert")) {
            result = this.insert(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.beforeFirst();
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            frs.removeStartingPoints();
            while (this.next()) {
                String url = (String)this.getValue(FIELD_URL);
                String depth = (String)this.getValue(FIELD_DEPTH);
                if (url == null || depth == null || url.trim().length() <= 0) continue;
                try {
                    URL newUrl = new URL(url);
                    frs.addStartingPoint(newUrl, Integer.parseInt(depth));
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        String defaultDepth = CSConfig.getRobotConfig().processConf.get("depth");
        this.setValue(FIELD_DEPTH, defaultDepth == null ? "-1" : defaultDepth);
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            delObjs.add(this.getCurrentContext().getValueList().get(index));
        }
        for (int i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            this.clear();
            int n = frs.numOfStartingPoints();
            for (int i = 0; i < n; ++i) {
                String ds;
                int ndx;
                String sp = frs.getStartingPointByIndex(i);
                if (sp == null) continue;
                String urlStr = null;
                String depthStr = null;
                StringTokenizer st = new StringTokenizer(sp);
                if (st.hasMoreTokens()) {
                    urlStr = st.nextToken();
                }
                if (st.hasMoreTokens() && (ndx = (ds = st.nextToken()).indexOf("=")) != -1) {
                    depthStr = ds.substring(ndx + 1);
                }
                if (urlStr == null || depthStr == null) continue;
                this.appendRow();
                this.setValue(FIELD_URL, urlStr);
                this.setValue(FIELD_DEPTH, depthStr);
            }
        }
        this.beforeFirst();
        return null;
    }
}

