/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartPointsListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel {
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_STARTPOINT = "startpoint";
    public static final String FIELD_DEPTH = "depth";
    public static final String FIELD_SITENAME = "sitename";
    public static final String FIELD_SITEID = "siteid";
    public Locale userLocale = Locale.getDefault();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$StartPointsListModel == null ? (class$com$sun$portal$search$admin$model$StartPointsListModel = StartPointsListModel.class$("com.sun.portal.search.admin.model.StartPointsListModel")) : class$com$sun$portal$search$admin$model$StartPointsListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$StartPointsListModel;

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        RobotConfig rc = CSConfig.getRobotConfig();
        int size = rc.numRuleset();
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0054", Integer.toString(size));
        for (int i = 0; i < size; ++i) {
            FilterRuleset frs = rc.GetRuleSet(i);
            int numOfSP = frs.numOfStartingPoints();
            for (int j = 0; j < numOfSP; ++j) {
                String sp = frs.getStartingPointByIndex(j);
                StringTokenizer st = new StringTokenizer(sp);
                String url = null;
                int depth = -1;
                for (int t = 0; st.hasMoreTokens() && t < 2; ++t) {
                    String token = st.nextToken();
                    if (t == 0) {
                        url = token;
                        continue;
                    }
                    depth = Integer.parseInt(token.substring(6));
                }
                this.appendRow();
                this.setValue(FIELD_ENABLE, frs.isEnabled() ? this.getLocalizedString("robot.sp.yes") : this.getLocalizedString("robot.sp.no"));
                this.setValue(FIELD_STARTPOINT, url);
                this.setValue(FIELD_DEPTH, depth == -1 ? this.getLocalizedString("robot.sp.unlimited") : Integer.toString(depth));
                this.setValue(FIELD_SITENAME, frs.nickname);
                this.setValue(FIELD_SITEID, frs.id);
            }
        }
        return null;
    }

    public String getLocalizedString(String key) {
        return SearchResource.geti18nString(key, this.userLocale);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

