/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;

public class SitesListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    private RobotConfig rc = CSConfig.getRobotConfig();
    public static final String FIELD_ENABLE = "Enable";
    public static final String FIELD_SITEID = "SiteID";
    public static final String FIELD_TYPEIMAGE = "TypeImage";
    public static final String FIELD_NICKNAME = "NickName";
    public static final String FIELD_DELETE = "Delete";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    static String SECURE_SERVER_IMAGE = "../ps/searchadmin/images/key_on.gif";
    static String OPEN_SERVER_IMAGE = "../ps/searchadmin/images/key_off.gif";
    static String DOMAIN_IMAGE = "../ps/searchadmin/images/domain.gif";
    static String FILE_IMAGE = "../ps/searchadmin/images/file.gif";
    static String BLANK_IMAGE = "../ps/searchadmin/images/blank.gif";

    public String getImage(FilterRuleset frs) {
        if (frs != null) {
            if (frs.getType() == 1 && frs.numOfServers() == 1) {
                if (frs.getServerByIndex(0).startsWith("https")) {
                    return SECURE_SERVER_IMAGE;
                }
                if (frs.getServerByIndex(0).startsWith("file")) {
                    return FILE_IMAGE;
                }
                return OPEN_SERVER_IMAGE;
            }
            return DOMAIN_IMAGE;
        }
        return BLANK_IMAGE;
    }

    public boolean delRuleset(String id) {
        return this.rc.delRuleset(id);
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            FilterRuleset frs = this.rc.GetRuleSet(this.getLocation());
            if (frs == null) continue;
            String enable = (String)this.getValue(FIELD_ENABLE);
            frs.setEnabled(enable.compareTo(ENABLE_VALUES[0]) == 0);
        }
        this.rc.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        String[] ids = new String[this.getSize()];
        while (this.next()) {
            FilterRuleset frs;
            int index = this.getLocation();
            String isDelete = (String)this.getValue(FIELD_DELETE);
            ids[index] = null;
            if (isDelete.compareTo("true") != 0 || (frs = this.rc.GetRuleSet(index)) == null) continue;
            ids[index] = frs.id;
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            this.rc.delRuleset(ids[i]);
        }
        this.rc.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        int n = this.rc.numRuleset();
        for (int i = 0; i < n; ++i) {
            FilterRuleset frs = this.rc.GetRuleSet(i);
            if (frs == null) continue;
            this.appendRow();
            this.setValue(FIELD_ENABLE, frs.isEnabled() ? ENABLE_VALUES[0] : ENABLE_VALUES[1]);
            this.setValue(FIELD_TYPEIMAGE, this.getImage(frs));
            this.setValue(FIELD_SITEID, frs.id);
            this.setValue(FIELD_NICKNAME, frs.nickname);
            this.setValue(FIELD_DELETE, "false");
        }
        this.beforeFirst();
        return null;
    }
}

