/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRuleset;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_HOST = "Host";
    public static final String FIELD_VERIFIED_TEXT = "VerifiedText";
    public static final String FIELD_PROTOCOL = "Protocol";
    public static final String FIELD_PORT = "Port";
    public static final String FIELD_DELETE = "Delete";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$ServerGroupListModel == null ? (class$com$sun$portal$search$admin$model$ServerGroupListModel = ServerGroupListModel.class$("com.sun.portal.search.admin.model.ServerGroupListModel")) : class$com$sun$portal$search$admin$model$ServerGroupListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$ServerGroupListModel;

    public void setID(String id) {
        this.rulesetID = id;
    }

    public void setDelIndex(int index) {
        this.delIndex = index;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("insert")) {
            result = this.insert(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.beforeFirst();
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            frs.removeServers();
            while (this.next()) {
                String host = (String)this.getValue(FIELD_HOST);
                String protocol = (String)this.getValue(FIELD_PROTOCOL);
                String port = (String)this.getValue(FIELD_PORT);
                if (host == null || protocol == null || port == null || host.trim().length() <= 0) continue;
                try {
                    int portno = -1;
                    try {
                        if (!protocol.equalsIgnoreCase("file")) {
                            portno = Integer.parseInt(port);
                        }
                    }
                    catch (Exception e) {
                        portno = -1;
                    }
                    URL url = new URL(protocol, host, portno, "/");
                    frs.addServer(url.toString());
                }
                catch (MalformedURLException e) {
                    debugLogger.log(Level.INFO, "PSSH_CSPSAM0052", new String[]{host, protocol, port});
                }
            }
        }
        return null;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1) {
            if (this.getValue(FIELD_HOST) == null) {
                this.getCurrentContext().getValueList().clear();
            }
        }
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        this.setValue(FIELD_PROTOCOL, FilterRuleset.ProtocolTypes[0]);
        this.setValue(FIELD_PORT, "");
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            delObjs.add(this.getCurrentContext().getValueList().get(index));
        }
        for (int i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            this.clear();
            int n = frs.numOfServers();
            for (int i = 0; i < n; ++i) {
                String server = frs.getServerByIndex(i);
                if (server == null) continue;
                try {
                    URL url = new URL(server);
                    this.appendRow();
                    this.setValue(FIELD_HOST, url.getHost());
                    this.setValue(FIELD_VERIFIED_TEXT, url.getHost());
                    this.setValue(FIELD_PROTOCOL, url.getProtocol());
                    if (!url.getProtocol().equalsIgnoreCase("file") && url.getPort() > 0) {
                        this.setValue(FIELD_PORT, Integer.toString(url.getPort()));
                    } else {
                        this.setValue(FIELD_PORT, "");
                    }
                    this.setValue(FIELD_DELETE, "false");
                    continue;
                }
                catch (MalformedURLException e) {
                    debugLogger.log(Level.INFO, "PSSH_CSPSAM0053", server);
                }
            }
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

