/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.model.SearchModel;
import com.sun.portal.search.util.OrderedMap;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class SearchModelImpl
extends AMModelBase
implements SearchModel {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$SearchModelImpl == null ? (class$com$sun$portal$search$admin$model$SearchModelImpl = SearchModelImpl.class$("com.sun.portal.search.admin.model.SearchModelImpl")) : class$com$sun$portal$search$admin$model$SearchModelImpl));
    private static boolean needSrvRestart = false;
    private static final String COMMENT = "__configComment_";
    public static Map csidMap;
    public static final String csidFileRelativPath;
    public String ServerStatus;
    public String ServerInstanceName;
    public String ServerName;
    public String ServerPort;
    public String ServerRoot;
    public String ServerErrorLog;
    public String ServerTmpFiles;
    private OrderedMap config;
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$SearchModelImpl;

    public SearchModelImpl(HttpServletRequest req, String rbName) {
        super(req, rbName);
        this.init(req);
    }

    protected void init(HttpServletRequest req) {
        this.load();
    }

    public String getServerStatus() {
        return "ON";
    }

    public void setServerStatus(String value) {
    }

    public String getServerInstanceName() {
        return (String)this.config.get((Object)"instance-name");
    }

    public void setServerInstanceName(String value) {
        this.config.put((Object)"instance-name", (Object)value);
    }

    public String getServerRoot() {
        return (String)this.config.get((Object)"server-root");
    }

    private void checkFileAccess(String name, String value) throws Exception {
        if (value.trim().length() == 0) {
            throw new Exception(name + this.getLocalizedString("server.error.not_empty"));
        }
        File f = new File(value);
        if (f.exists()) {
            if (!f.isFile()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_file"));
            }
            if (!f.canRead()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_readible"));
            }
            if (!f.canWrite()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_writable"));
            }
        } else {
            File p = f.getParentFile();
            if (p != null) {
                String absPath = p.getAbsolutePath();
                this.checkDirectoryAccess(name, absPath);
            }
        }
    }

    private void checkDirectoryAccess(String name, String value) throws Exception {
        if (value.trim().length() == 0) {
            throw new Exception(name + " " + this.getLocalizedString("server.error.not_empty"));
        }
        File f = new File(value);
        if (f.exists()) {
            if (!f.isDirectory()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_directory"));
            }
            if (!f.canRead()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_readible"));
            }
            if (!f.canWrite()) {
                throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.not_writable"));
            }
        } else {
            throw new Exception(name + " : '" + value + "' " + this.getLocalizedString("server.error.inexistant"));
        }
    }

    public void setServerRoot(String value) throws Exception {
        this.checkDirectoryAccess(this.getLocalizedString("server.error.root_path"), value);
        this.config.put((Object)"server-root", (Object)value);
    }

    public String getServerTmpFiles() {
        return (String)this.config.get((Object)"tmpdir");
    }

    public void setServerTmpFiles(String value) throws Exception {
        this.checkDirectoryAccess(this.getLocalizedString("server.error.tmp_files"), value);
        this.config.put((Object)"tmpdir", (Object)value);
    }

    public String getServerDocSecurityMode() {
        return (String)this.config.get((Object)"security-mode");
    }

    public void setServerDocSecurityMode(String value) {
        this.config.put((Object)"security-mode", (Object)value);
    }

    public String getServerDocSecurityMgr() {
        return (String)this.config.get((Object)"security-manager");
    }

    public void setServerDocSecurityMgr(String value) throws Exception {
        Class.forName(value);
        this.config.put((Object)"security-manager", (Object)value);
    }

    public String getSearchRDMLog() {
        return (String)this.config.get((Object)"logfile");
    }

    public void setSearchRDMLog(String value) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.searchLog"), value);
        this.config.put((Object)"logfile", (Object)value);
    }

    public boolean getSearchLogState() {
        String stateStr = (String)this.config.get((Object)"disable-rdm-log");
        return stateStr != null && stateStr.equals("true");
    }

    public void setSearchLogState(boolean value) {
        if (value) {
            this.config.put((Object)"disable-rdm-log", (Object)"true");
        } else {
            this.config.put((Object)"disable-rdm-log", (Object)"false");
        }
    }

    public String getIndexMaintenanceLog() {
        return (String)this.config.get((Object)"search-logfile");
    }

    public void setIndexMaintenanceLog(String value) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.indexMaintenance"), value);
        this.config.put((Object)"search-logfile", (Object)value);
    }

    public String getRdMgrLog() {
        return (String)this.config.get((Object)"rdmgr-logfile");
    }

    public void setRdMgrLog(String value) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.rdManager"), value);
        this.config.put((Object)"rdmgr-logfile", (Object)value);
    }

    public String getRdmDebugLog() {
        return (String)this.config.get((Object)"debug-logfile");
    }

    public void setRdmDebugLog(String value) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.rdmDebug"), value);
        this.config.put((Object)"debug-logfile", (Object)value);
    }

    public String getRdmDebugLevel() {
        return (String)this.config.get((Object)"debug-loglevel");
    }

    public void setRdmDebugLevel(String value) {
        this.config.put((Object)"debug-loglevel", (Object)value);
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.load();
        return null;
    }

    public void load() {
        String serverRoot = CSConfig.getServerRoot();
        if (serverRoot == null) {
            serverRoot = ".";
        }
        String csidFilePath = serverRoot + csidFileRelativPath;
        try {
            String line;
            this.config = new OrderedMap();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csidFilePath), "UTF-8"));
            int commentNb = 1;
            while ((line = r.readLine()) != null) {
                if (line.length() != 0) {
                    String value;
                    String key;
                    if (line.charAt(0) == '#') {
                        this.config.put((Object)(COMMENT + String.valueOf(commentNb)), (Object)line);
                        ++commentNb;
                        continue;
                    }
                    int pos = line.indexOf("=");
                    if (pos != -1) {
                        key = line.substring(0, pos);
                        value = line.substring(pos + 1).trim();
                        if (value.startsWith("\"") && value.endsWith("\"")) {
                            value = value.substring(1, value.length() - 1);
                        }
                    } else {
                        key = line;
                        value = null;
                    }
                    this.config.put((Object)key, value);
                    continue;
                }
                this.config.put((Object)(COMMENT + String.valueOf(commentNb)), (Object)line);
                ++commentNb;
            }
            ++commentNb;
        }
        catch (IOException ioe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", ioe.getMessage());
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
        }
    }

    public void store() {
        String serverRoot = CSConfig.getServerRoot();
        String csidFilePath = serverRoot + csidFileRelativPath;
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csidFilePath), "UTF-8")));
            String[] keysArray = this.config.getOrderedKeys();
            String key = null;
            String value = null;
            for (int i = 0; i < keysArray.length; ++i) {
                key = keysArray[i];
                value = (String)this.config.get((Object)key);
                if (!key.startsWith(COMMENT)) {
                    pw.print(key + "=" + PBlock.quotedString((String)value) + "\n");
                    continue;
                }
                pw.print(value + "\n");
            }
            pw.close();
            SearchConfig.init((String)csidFilePath);
            needSrvRestart = true;
        }
        catch (IOException ioe) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0051", new String[]{csidFilePath, ioe.getMessage()});
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0011", csidFilePath);
        }
    }

    public boolean needSrvRestart() {
        return needSrvRestart;
    }

    public String getStringValue(String key) {
        return (String)this.config.get((Object)key);
    }

    public void setStringValue(String key, String value) {
        this.config.put((Object)key, (Object)value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        csidFileRelativPath = File.separator + "config" + File.separator + "search.conf";
    }
}

