/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SchemaModel
extends DefaultModel {
    private String name = "";
    private String oldName = "";
    private String description = "";
    private String multiplier = null;
    private String aliases = "";
    private boolean editable = false;
    private boolean indexable = false;
    private String dataType = "";
    private static RDMSchema schema;
    private String edit = "";
    private String index = "";
    private String schfn = "";
    private String errMsg = null;
    public final String DEFAULT_TYPE = "string";
    public static final String[] DATA_TYPES;
    private static Logger debugLogger;
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$SchemaModel;

    public SchemaModel() {
        this.loadSchema();
        this.name = "New";
    }

    public SchemaModel(String name) {
        super(name);
        this.loadSchema();
        this.name = name;
        this.oldName = name;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public void initializeValues() {
        String[] arr = schema.schema_nonInternal_attrs();
        if (arr.length > 0) {
            this.name = arr[0];
        }
    }

    public boolean doAdd() {
        int col = schema.getColumnNumber(this.name);
        if (col == -1) {
            int num = schema.getNumEntriesInt();
            col = schema.getMaxIndex() + 1;
            schema.setSOIFAttribute(col, this.name);
            schema.setColumnName(col, this.name);
            schema.setSysColumnName(col, this.name);
            schema.setTableName(col, "Documents");
            schema.setSysTableName(col, "doctbl");
            schema.setDescription(col, this.description);
            schema.setAliases(col, this.aliases);
            schema.setEditAttribute(col, this.edit);
            schema.setIndexAttribute(col, this.index);
            schema.setNumEntries(String.valueOf(num + 1));
            if (this.multiplier != null) {
                schema.setValue(this.name, "score-multiplier", this.multiplier);
            }
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0043", new String[]{Integer.toString(col), this.name, this.description, this.aliases, this.edit, this.index});
            this.saveSchema();
            return true;
        }
        this.errMsg = "schema.error.duplicate";
        return false;
    }

    public boolean validateSchema() {
        if (this.name.trim().equals("")) {
            this.errMsg = "schema.error.emptyname";
            return false;
        }
        for (int i = 0; i < this.name.length(); ++i) {
            char c = this.name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '_' || c == '-') continue;
            this.errMsg = "schema.error.invalidcharinname";
            return false;
        }
        if (this.indexable && this.multiplier != null) {
            try {
                Float f = new Float(this.multiplier);
                if (f.doubleValue() < 0.0) {
                    this.errMsg = "schema.error.negativemultiplier";
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.errMsg = "schema.error.invalidmultiplier";
                return false;
            }
        }
        return true;
    }

    public boolean doUpdate() {
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0044", new String[]{this.name, this.description, this.aliases, this.edit, this.index});
        if (!this.validateSchema()) {
            return false;
        }
        try {
            int col = schema.getColumnNumber(this.oldName);
            if (col == -1) {
                return this.doAdd();
            }
            int newcol = schema.getColumnNumber(this.name);
            if (this.oldName.equals(this.name) || newcol == -1) {
                schema.setSOIFAttribute(col, this.name);
                schema.setColumnName(col, this.name);
                schema.setSysColumnName(col, this.name);
                schema.setDescription(col, this.description);
                schema.setAliases(col, this.aliases);
                schema.setEditAttribute(col, this.edit);
                schema.setIndexAttribute(col, this.index);
                schema.setDataType(col, this.dataType);
                schema.setValue(this.name, "score-multiplier", this.multiplier);
                this.saveSchema();
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0045", new String[]{this.oldName, this.name});
                return true;
            }
            this.errMsg = "schema.error.duplicate";
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void doDelete() {
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0044", new String[]{this.name, this.description, this.aliases, this.edit, this.index});
        schema.deleteColumn(this.name);
        this.saveSchema();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDescription() {
        if (this.name.equals("")) {
            return "";
        }
        this.description = schema.getValue(this.name, "description");
        return this.description == null ? "" : this.description;
    }

    public String getMultiplier() {
        if (this.name.equals("")) {
            return "";
        }
        this.multiplier = schema.getValue(this.name, "score-multiplier");
        return this.multiplier == null ? "" : this.multiplier;
    }

    public String getAliases() {
        if (this.name.equals("")) {
            return "";
        }
        this.aliases = schema.getValue(this.name, "aliases");
        return this.aliases == null ? "" : this.aliases;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setMultiplier(String multip) {
        if (multip.trim().length() > 0) {
            this.multiplier = multip;
        }
    }

    public void setAliases(String desc) {
        this.aliases = desc;
    }

    public boolean getEditable() {
        if (this.name.equals("")) {
            return false;
        }
        this.edit = schema.getValue(this.name, "edit-attribute");
        return this.edit != null && this.edit.equals("1");
    }

    public void setEditable(boolean b) {
        this.editable = b;
        this.edit = this.editable ? "1" : "0";
    }

    public boolean getIndexable() {
        if (this.name.equals("")) {
            return false;
        }
        this.index = schema.getValue(this.name, "index-attribute");
        return this.index != null && this.index.equals("1");
    }

    public void setIndexable(boolean b) {
        this.indexable = b;
        this.index = this.indexable ? "1" : "0";
    }

    public String getDataType() {
        String type = schema.getValue(this.name, "data-type");
        if (type != null) {
            return type;
        }
        return "string";
    }

    public void setDataType(String type) {
        this.dataType = type;
    }

    public void saveSchema() {
        block2: {
            try {
                SOIFOutputStream ss = new SOIFOutputStream(this.schfn);
                ss.write(schema.getSOIF());
            }
            catch (Exception e) {
                if (!debugLogger.isLoggable(Level.INFO)) break block2;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSSH_CSPSAM0046");
                logRecord.setParameters(new String[]{this.schfn});
                logRecord.setThrown(e);
                logRecord.setLoggerName(debugLogger.getName());
                debugLogger.log(logRecord);
            }
        }
    }

    public void loadSchema() {
        String csidfn = CSConfig.getServerRoot() + File.separator + "config" + File.separator + "search.conf";
        try {
            SearchConfig.init((String)csidfn);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0047", csidfn);
        }
        this.schfn = SearchConfig.getValue((String)"schema-description");
        if (this.schfn == null) {
            debugLogger.finer("PSSH_CSPSAM0048");
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0041", this.schfn);
        SOIFInputStream ss = null;
        try {
            ss = new SOIFInputStream(this.schfn);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0042", this.schfn);
        }
        try {
            schema = new RDMSchema(ss.readSOIF());
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0049", this.schfn);
        }
    }

    public static void printSchema() {
        String[] arr = schema.schema_nonInternal_attrs();
        for (int i = 0; i < arr.length; ++i) {
            String s = arr[i];
            int col = schema.getColumnNumber(s);
            String d = schema.getDescription(col);
            String aliases = schema.getAliases(col);
            String edit = schema.getEditAttribute(col);
            String index = schema.getIndexAttribute(col);
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0043", new String[]{Integer.toString(col), s, d, aliases, edit, index});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DATA_TYPES = new String[]{"blob", "date", "int", "string"};
        debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$SchemaModel == null ? (class$com$sun$portal$search$admin$model$SchemaModel = SchemaModel.class$("com.sun.portal.search.admin.model.SchemaModel")) : class$com$sun$portal$search$admin$model$SchemaModel));
    }
}

