/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.Encoder;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchemaListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
DeletingModel {
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_DELNAME = "DelName";
    public static final String FIELD_DESC = "Desc";
    public static final String FIELD_ALIAS = "Alias";
    public static final String FIELD_DATATYPE = "Datatype";
    public static final String FIELD_EDITABLE = "Editable";
    public static final String FIELD_INDEXABLE = "Indexable";
    public static final String FIELD_DELETE = "Delete";
    public static final String FIELD_ENCODED_NAME = "EncodedName";
    static final String[] FIELDS = new String[]{"Name", "Desc", "Alias"};
    public Locale userLocale = Locale.getDefault();
    public static final String[] DATA_TYPES = new String[]{"date", "int", "string"};
    public boolean showInternal = false;
    private String schfn = "";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$SchemaListModel == null ? (class$com$sun$portal$search$admin$model$SchemaListModel = SchemaListModel.class$("com.sun.portal.search.admin.model.SchemaListModel")) : class$com$sun$portal$search$admin$model$SchemaListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$SchemaListModel;

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        RDMSchema schema = null;
        try {
            schema = this.loadSchema();
        }
        catch (Exception e) {
            throw new ModelControlException((Throwable)e);
        }
        if (schema == null) {
            throw new ModelControlException("Error on loading Schema");
        }
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || !isDelete.equalsIgnoreCase("true")) continue;
            String delName = (String)this.getValue(FIELD_DELNAME);
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0040", delName);
            if (delName == null) continue;
            String name = null;
            try {
                name = new String(Encoder.decodeBase64((String)delName), "UTF-8");
                schema.deleteColumn(name);
            }
            catch (Exception e) {
                throw new ModelControlException("Schema failed to delete column: " + name + ": " + e);
            }
        }
        try {
            SOIFOutputStream outss = new SOIFOutputStream(this.schfn);
            outss.write(schema.getSOIF());
            outss.close();
        }
        catch (Exception e) {
            throw new ModelControlException("Unable to write SOIF to " + this.schfn + ": " + e);
        }
        return null;
    }

    private RDMSchema loadSchema() throws Exception {
        RDMSchema schema = null;
        String csidfn = CSConfig.getServerRoot() + File.separator + "config" + File.separator + "search.conf";
        try {
            SearchConfig.init((String)csidfn);
        }
        catch (Exception e) {
            throw new Exception("Unable to initialize SearchConfig: " + csidfn);
        }
        this.schfn = SearchConfig.getValue((String)"schema-description");
        if (this.schfn == null) {
            throw new Exception("Missing SearchConfig.SCHEMA parameter");
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0041", this.schfn);
        SOIFInputStream ss = null;
        try {
            ss = new SOIFInputStream(this.schfn);
            schema = new RDMSchema(ss.readSOIF());
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0042", this.schfn);
        }
        return schema;
    }

    public String[] getSchemaList() {
        try {
            RDMSchema schema = this.loadSchema();
            return schema.schema_nonInternal_attrs();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        try {
            int i;
            RDMSchema schema = this.loadSchema();
            String[] arr = new String[]{};
            if (this.showInternal) {
                boolean nmv = false;
                ArrayList<String> attrs = new ArrayList<String>();
                Object iflg = null;
                int n = schema.getMaxIndex();
                for (i = 0; i <= n; ++i) {
                    String attr = schema.getSOIFAttribute(i);
                    if (attr == null) continue;
                    attrs.add(attr);
                }
                arr = attrs.toArray(new String[0]);
            } else {
                arr = schema.schema_nonInternal_attrs();
            }
            for (i = 0; i < arr.length; ++i) {
                this.appendRow();
                String name = arr[i];
                this.setValue(FIELD_NAME, name);
                try {
                    String encodedName = Encoder.encodeBase64((byte[])name.getBytes("UTF-8"));
                    this.setValue(FIELD_ENCODED_NAME, encodedName);
                    this.setValue(FIELD_DELNAME, encodedName);
                }
                catch (Exception e) {
                    debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
                    this.setValue(FIELD_ENCODED_NAME, name);
                    this.setValue(FIELD_DELNAME, name);
                }
                int col = schema.getColumnNumber(name);
                this.setValue(FIELD_DESC, schema.getDescription(col));
                String value = schema.getAliases(col);
                if (value != null) {
                    this.setValue(FIELD_ALIAS, value);
                }
                if ((value = schema.getDataType(col)) != null) {
                    this.setValue(FIELD_DATATYPE, value);
                }
                if ((value = schema.getEditAttribute(col)) != null && value.equals("1")) {
                    this.setValue(FIELD_EDITABLE, "true");
                } else {
                    this.setValue(FIELD_EDITABLE, "false");
                }
                value = schema.getIndexAttribute(col);
                if (value != null && value.equals("1")) {
                    this.setValue(FIELD_INDEXABLE, "true");
                    continue;
                }
                this.setValue(FIELD_INDEXABLE, "false");
            }
        }
        catch (Exception e) {
            throw new ModelControlException((Throwable)e);
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

