/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.view.html.OptionList;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CnConfig;
import com.sun.portal.search.admin.Rule;
import com.sun.portal.search.admin.model.SchemaListModel;
import com.sun.portal.search.admin.resources.SearchResource;
import java.util.ArrayList;
import java.util.Locale;

public class RobotClassRuleListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
DeletingModel {
    public static final String MODEL_NAME = "RobotClassRuleListModel";
    public static final String FIELD_SRC = "Src";
    public static final String FIELD_METHOD = "Method";
    public static final String FIELD_CRITERIA = "Criteria";
    public static final String FIELD_CLASSIFICATION = "Classification";
    public static final String FIELD_DELETE = "Delete";
    static final String[] FIELDS = new String[]{"Src", "Method", "Criteria", "Classification"};
    public Locale userLocale = Locale.getDefault();
    static final String[] methodValues = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    private CnConfig cnconfig = new CnConfig(CSConfig.getServerRoot());

    private void ValidateList() throws ModelControlException {
        int i;
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        block0: while (this.next()) {
            for (i = 0; i < FIELDS.length; ++i) {
                if (this.getValue(FIELDS[i]) != null) continue;
                delObjs.add(this.getCurrentContext().getValueList().get(this.getRowIndex()));
                continue block0;
            }
        }
        for (i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        int deltaIndex = 0;
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            this.cnconfig.delete(index - deltaIndex);
            ++deltaIndex;
        }
        if (deltaIndex > 0) {
            this.cnconfig.save();
        }
        return null;
    }

    public int getNumOfRules() {
        return this.cnconfig.getNumberOfRules();
    }

    private void loadRules() {
        String server_root = CSConfig.getServerRoot();
        this.cnconfig = new CnConfig(server_root);
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        OptionList srcOptions = RobotClassRuleListModel.getSrcLst(this.userLocale);
        OptionList methodOptions = RobotClassRuleListModel.getMethodLst(this.userLocale);
        this.clear();
        ArrayList rules = this.cnconfig.getRulesList();
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            Rule rule = (Rule)rules.get(i);
            this.appendRow();
            String label = srcOptions.getValueLabel(rule.getSrc());
            this.setValue(FIELD_SRC, label == null ? rule.getSrc() : label);
            label = methodOptions.getValueLabel(rule.getMethod());
            this.setValue(FIELD_METHOD, label == null ? rule.getMethod() : label);
            this.setValue(FIELD_CRITERIA, rule.getName());
            this.setValue(FIELD_CLASSIFICATION, rule.getAction());
        }
        this.beforeFirst();
        return null;
    }

    public static OptionList getSrcLst(Locale userLocale) {
        OptionList srcLst = new OptionList(SearchResource.geti18nArray("classrules.src.options", ",", userLocale), SearchResource.geti18nArray("classrules.src.values", ",", userLocale));
        String[] schLst = new SchemaListModel().getSchemaList();
        if (schLst != null) {
            for (int i = 0; i < schLst.length; ++i) {
                srcLst.add(i, schLst[i], schLst[i]);
            }
        }
        return srcLst;
    }

    public static OptionList getMethodLst(Locale userLocale) {
        OptionList methodLst = new OptionList(SearchResource.geti18nArray("classrules.method.options", ",", userLocale), methodValues);
        return methodLst;
    }
}

