/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.Encoder;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.RDSearch;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RDListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
DeletingModel {
    public static final String MODEL_NAME = "RDListModel";
    public static final String FIELD_URL = "Url";
    public static final String FIELD_TITLE = "Title";
    public static final String FIELD_DESC = "Desc";
    public static final String FIELD_DELETE = "Delete";
    public static final String FIELD_ENCODED_URL = "EncodedName";
    public Locale userLocale = Locale.getDefault();
    public int numPerPage = 25;
    public int currPage = 1;
    public int totalHits = 0;
    String queryString = "*";
    String database = null;
    int searchOption = 1;
    private SToken st = null;
    public int RDM_Results = 0;
    public int RDM_Hits = 0;
    public int RDM_Documents = 0;
    private boolean isRetrieved = false;
    private String schfn = "";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$RDListModel == null ? (class$com$sun$portal$search$admin$model$RDListModel = RDListModel.class$("com.sun.portal.search.admin.model.RDListModel")) : class$com$sun$portal$search$admin$model$RDListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$RDListModel;

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        String tmpFile = CSConfig.getServerRoot() + File.separator + "tmp" + File.separator + "tmpRDEditor." + Long.toString(System.currentTimeMillis());
        try {
            SOIFOutputStream so = new SOIFOutputStream(tmpFile);
            this.beforeFirst();
            while (this.next()) {
                String isDelete = (String)this.getValue(FIELD_DELETE);
                if (isDelete == null || !isDelete.equalsIgnoreCase("true")) continue;
                try {
                    String delURL = new String(Encoder.decodeBase64((String)((String)this.getValue(FIELD_ENCODED_URL))), "UTF-8");
                    debugLogger.log(Level.FINER, "PSSH_CSPSAM0035", delURL);
                    SOIF delRD = new SOIF("DOCUMENT", delURL);
                    so.write(delRD);
                }
                catch (Exception e) {
                    debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
                }
            }
            so.close();
            Runtime rt = Runtime.getRuntime();
            String db_option = this.database != null ? "-y " + this.database + " " : " ";
            String runCsCli = null;
            runCsCli = RDListModel.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String rdmgr = CSConfig.getServerRoot() + File.separator + runCsCli + " rdmgr -d -q " + db_option + tmpFile;
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0033", rdmgr);
            Process p = rt.exec(rdmgr);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int exitValue = p.exitValue();
            if (exitValue == 1) {
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0033", Integer.toString(exitValue));
            }
        }
        catch (Exception e) {
            throw new ModelControlException((Throwable)e);
        }
        return null;
    }

    private ArrayList actionSearch() {
        debugLogger.log(Level.FINER, "PSSH_CSPSAM0037", new String[]{Integer.toString(this.searchOption), this.queryString});
        try {
            RDSearch rdSearch = new RDSearch();
            ArrayList resultList = rdSearch.search(this.database, this.queryString, this.searchOption, (this.currPage - 1) * this.numPerPage + 1, this.numPerPage, this.st);
            this.RDM_Results = rdSearch.RDM_Results;
            if (this.searchOption == 5 && this.RDM_Results == 1) {
                this.RDM_Hits = 1;
                this.RDM_Documents = 1;
            } else {
                this.RDM_Hits = rdSearch.RDM_Hits;
                this.RDM_Documents = rdSearch.RDM_Documents;
            }
            return resultList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        if (this.isRetrieved) {
            return null;
        }
        this.clear();
        ArrayList hits = this.actionSearch();
        if (hits != null) {
            for (int i = 0; i < hits.size(); ++i) {
                String url;
                SOIF s = (SOIF)hits.get(i);
                this.appendRow();
                String base64url = url = s.getURL();
                try {
                    base64url = new String(Encoder.encodeBase64((byte[])url.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setValue(FIELD_URL, url);
                this.setValue(FIELD_TITLE, s.getValue("title"));
                this.setValue(FIELD_ENCODED_URL, base64url);
            }
        }
        this.beforeFirst();
        this.isRetrieved = true;
        return null;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public int doSearch(String database, int numPerPage, int currPage, String queryString, int searchOption, SToken st) {
        this.numPerPage = numPerPage;
        this.currPage = currPage;
        this.queryString = queryString;
        this.searchOption = searchOption;
        this.database = database;
        this.st = st;
        try {
            this.retrieve(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.totalHits;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

