/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PopularSearchModel
extends DefaultModel {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$PopularSearchModel == null ? (class$com$sun$portal$search$admin$model$PopularSearchModel = PopularSearchModel.class$("com.sun.portal.search.admin.model.PopularSearchModel")) : class$com$sun$portal$search$admin$model$PopularSearchModel));
    String serverRoot = null;
    Date firstDate = null;
    Date lastUpdated = null;
    HashMap logs = new HashMap();
    ArrayList sortedSearch = new ArrayList();
    int numberOfQuery = 0;
    public Locale userLocale = Locale.getDefault();
    static final String DELIMITER = " -->  ";
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$PopularSearchModel;

    public static void main(String[] args) {
        CSConfig.init(args[0]);
        PopularSearchModel ps = new PopularSearchModel();
        SearchConfig csidConf = SearchConfig.getSearchConfig();
        if (csidConf == null) {
            try {
                SearchConfig.init((String)(ps.serverRoot + File.separator + "config" + File.separator + "search.conf"));
                csidConf = SearchConfig.getSearchConfig();
            }
            catch (Exception e) {
                System.out.println("Error on SearchConfig.init():" + e.getMessage());
                return;
            }
        }
        ps.execute(true);
        System.out.println(ps.getReport());
    }

    public PopularSearchModel() {
        this.serverRoot = CSConfig.getServerRoot();
        try {
            this.readFromCache();
        }
        catch (Exception e) {
            debugLogger.finer("PSSH_CSPSAM0031");
            this.execute(false);
        }
    }

    public PopularSearchModel(String name) {
        this.serverRoot = CSConfig.getServerRoot();
    }

    public void execute(boolean skipBrowse) {
        String fileName = SearchConfig.getValue((String)"logfile");
        BufferedReader in = null;
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                boolean isSearch;
                HashMap pb = new HashMap();
                try {
                    PBlock.str2pblock((String)line, pb);
                }
                catch (Exception e) {
                    continue;
                }
                String scopeStr = (String)pb.get("scope");
                if (scopeStr == null) continue;
                String RDMValue = (String)pb.get("RDM");
                String qlValue = (String)pb.get("ql");
                boolean searchOnTax = RDMValue != null && RDMValue.equalsIgnoreCase("tax");
                boolean searchOnRD = RDMValue != null && RDMValue.equalsIgnoreCase("RD");
                boolean isBrowsing = qlValue != null && qlValue.equalsIgnoreCase("taxonomy-basic");
                boolean bl = isSearch = qlValue != null && qlValue.equalsIgnoreCase("search");
                if (skipBrowse && isBrowsing) continue;
                int rdmTaxIndex = line.indexOf("RDM=tax");
                int rdmRDIndex = -1;
                int qlCompassIndex = line.indexOf("ql=search");
                int qlTaxBasicIndex = line.indexOf("ql=taxonomy-basic");
                if (rdmTaxIndex < 0) {
                    rdmRDIndex = line.indexOf("RDM=rd");
                }
                if (rdmTaxIndex > 0 && (qlCompassIndex > 0 || skipBrowse && qlTaxBasicIndex > 0)) continue;
                if (this.firstDate == null) {
                    int ds = line.indexOf(91);
                    int de = line.indexOf(93);
                    if (ds >= 0 && de > 0) {
                        SimpleDateFormat df = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
                        String dstr = line.substring(ds + 1, de);
                        try {
                            this.firstDate = df.parse(dstr);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                String browse = null;
                String search = null;
                String upScopeStr = scopeStr.toUpperCase();
                if (rdmRDIndex > 0 && qlCompassIndex > 0 && (upScopeStr.startsWith("(CLASSIFICATION") || upScopeStr.startsWith("<NOT> (CLASSIFICATION"))) continue;
                if (isBrowsing && scopeStr.startsWith("children* ")) {
                    String classNodeName = scopeStr.substring(10);
                    if (classNodeName.equals("ROOT")) continue;
                    browse = SearchResource.geti18nString("popsearch.browse", this.userLocale) + " " + classNodeName;
                } else if (qlCompassIndex > 0 && scopeStr.startsWith("(Classification <STARTS> ")) {
                    int andIndex;
                    int firstRB = scopeStr.indexOf(41);
                    if (firstRB > 0 && (andIndex = scopeStr.indexOf("<AND>", firstRB)) > 0) {
                        int secondLB = scopeStr.indexOf(40, andIndex);
                        int secondRB = scopeStr.lastIndexOf(41);
                        if (secondRB > secondLB) {
                            search = scopeStr.substring(secondLB + 1, secondRB) + SearchResource.geti18nString("within", this.userLocale) + scopeStr.substring(25, firstRB);
                        }
                    }
                } else if (qlCompassIndex > 0) {
                    search = scopeStr;
                }
                String key = null;
                if (browse != null) {
                    key = browse;
                } else if (search != null) {
                    key = search;
                }
                if (key == null) continue;
                SearchFreq value = (SearchFreq)this.logs.get(key);
                if (value == null) {
                    value = new SearchFreq(key, 1, browse != null);
                    this.logs.put(key, value);
                    continue;
                }
                value.inc();
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
        }
        this.sortedSearch.clear();
        this.numberOfQuery = 0;
        Iterator it = this.logs.keySet().iterator();
        while (it.hasNext()) {
            int i;
            String key = (String)it.next();
            SearchFreq sf = (SearchFreq)this.logs.get(key);
            this.numberOfQuery += sf.freq;
            for (i = 0; i < this.sortedSearch.size(); ++i) {
                SearchFreq curr = (SearchFreq)this.sortedSearch.get(i);
                if (sf.freq > curr.freq) break;
            }
            this.sortedSearch.add(i, sf);
        }
        this.lastUpdated = new Date();
        try {
            this.writeToCache();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void readFromCache() throws Exception {
        String line;
        String fileName = this.serverRoot + File.separator + "logs" + File.separator + "popularsearch.cache";
        File file = new File(fileName);
        long lastmodified = file.lastModified();
        this.lastUpdated = new Date(lastmodified);
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        boolean gotSince = false;
        this.sortedSearch.clear();
        while ((line = in.readLine()) != null) {
            String name = null;
            String value = null;
            int ndx = line.indexOf(DELIMITER);
            if (ndx < 0) continue;
            name = line.substring(0, ndx);
            value = line.substring(ndx + DELIMITER.length());
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0032", new String[]{name, value});
            if (!gotSince && name.equals("firstDate")) {
                this.firstDate = DateFormat.getDateInstance().parse(value);
                gotSince = true;
                continue;
            }
            SearchFreq sf = new SearchFreq(name, Integer.parseInt(value), false);
            this.numberOfQuery += Integer.parseInt(value);
            this.sortedSearch.add(sf);
        }
    }

    private void writeToCache() throws Exception {
        String fileName = this.serverRoot + File.separator + "logs" + File.separator + "popularsearch.cache";
        FileOutputStream fout = new FileOutputStream(fileName);
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF-8")), true);
        out.println("firstDate -->  " + DateFormat.getDateInstance().format(this.firstDate));
        for (int i = 0; i < this.getSize(); ++i) {
            out.println(this.getScope(i) + DELIMITER + this.getFreq(i));
        }
        out.close();
    }

    public String getReport() {
        StringBuffer sb = new StringBuffer();
        sb.append("<p><pre>\n");
        sb.append("Most popular user searches. \n");
        if (this.numberOfQuery == 1) {
            sb.append("1 query");
        } else if (this.numberOfQuery > 1) {
            sb.append(Integer.toString(this.numberOfQuery) + " queries");
        } else {
            sb.append("No queries");
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        if (this.firstDate != null) {
            String dateString = df.format(this.firstDate);
            sb.append(" examined since " + dateString);
        }
        sb.append("\n\n");
        for (int i = 0; i < this.sortedSearch.size(); ++i) {
            SearchFreq sf = (SearchFreq)this.sortedSearch.get(i);
            sb.append(Integer.toString(sf.freq) + "- " + sf.scope + "\n");
        }
        sb.append("</pre>");
        return sb.toString();
    }

    public int getSize() {
        return this.sortedSearch.size();
    }

    public int getFreq(int index) {
        try {
            SearchFreq sf = (SearchFreq)this.sortedSearch.get(index);
            if (sf != null) {
                return sf.freq;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public String getScope(int index) {
        try {
            SearchFreq sf = (SearchFreq)this.sortedSearch.get(index);
            if (sf != null) {
                return sf.scope;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public int getNumberOfQuery() {
        return this.numberOfQuery;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SearchFreq {
        String scope;
        int freq;
        boolean isBrowse;

        SearchFreq(String scopeStr, int initFreq, boolean browse) {
            this.scope = scopeStr;
            this.freq = initFreq;
            this.isBrowse = browse;
        }

        void inc() {
            ++this.freq;
        }
    }
}

