/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.ImportConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    public static final String FIELD_ENABLE = "FieldEnable";
    public static final String FIELD_ID = "FieldID";
    public static final String FIELD_IMAGE = "FieldImage";
    public static final String FIELD_TYPE = "FieldType";
    public static final String FIELD_NAME = "FieldName";
    public static final String FIELD_DELETE = "Delete";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    public Locale userLocale = Locale.getDefault();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$ImportListModel == null ? (class$com$sun$portal$search$admin$model$ImportListModel = ImportListModel.class$("com.sun.portal.search.admin.model.ImportListModel")) : class$com$sun$portal$search$admin$model$ImportListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$ImportListModel;

    public ImportListModel() {
    }

    public ImportListModel(String name) {
        super(name);
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            String enable = (String)this.getValue(FIELD_ENABLE);
            ImportConfig imp = ImportConfig.getImportConfigByIndex(this.getLocation());
            if (imp == null) continue;
            imp.setValue("enable", enable);
        }
        ImportConfig.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        int numImport = ImportConfig.numOfImportConfig();
        if (numImport == 0) {
            return null;
        }
        String[] ids = new String[numImport];
        while (this.next()) {
            ImportConfig imp;
            int index = this.getLocation();
            String isDelete = (String)this.getValue(FIELD_DELETE);
            ids[index] = null;
            if (isDelete.compareTo("true") != 0 || (imp = ImportConfig.getImportConfigByIndex(index)) == null) continue;
            ids[index] = imp.getID();
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0027", ids[index]);
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            ImportConfig.DeleteImportConfigByID(ids[i]);
        }
        ImportConfig.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        for (int i = 0; i < ImportConfig.numOfImportConfig(); ++i) {
            ImportConfig imp = ImportConfig.getImportConfigByIndex(i);
            this.appendRow();
            this.setValue(FIELD_ID, imp.getValue("id"));
            this.setValue(FIELD_ENABLE, imp.getValue("enable"));
            String csid = imp.getValue("csid");
            String nickname = imp.getValue("nickname");
            if (csid != null) {
                int hostend;
                if (nickname == null) {
                    nickname = csid;
                }
                this.setValue(FIELD_NAME, nickname);
                int hoststart = nickname.indexOf("://");
                if (hoststart > 0 && (hostend = nickname.indexOf(47, hoststart + 3)) > 0) {
                    this.setValue(FIELD_NAME, SearchResource.geti18nString("search.server", this.userLocale) + ":" + nickname.substring(hoststart + 3, hostend) + " [" + nickname.substring(hostend + 1) + "]");
                }
                if (imp.getValue("is-ssl") == "true") {
                    this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/key_on.gif");
                } else {
                    this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/key_off.gif");
                }
            } else {
                String file = imp.getValue("srcfile");
                if (file != null) {
                    this.setValue(FIELD_NAME, nickname == null ? file : nickname);
                }
                this.setValue(FIELD_IMAGE, "../ps/searchadmin/images/file.gif");
            }
            this.setValue(FIELD_DELETE, "false");
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

