/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.ImportConfig;
import com.sun.portal.search.util.SearchConfig;

public class ImportAgentModel
extends DefaultModel
implements RetrievingModel,
UpdatingModel {
    public static final String FIELD_ID = "FieldID";
    public static final String FIELD_IMAGE = "FieldImage";
    public static final String FIELD_TYPE = "FieldType";
    public static final String FIELD_NAME = "FieldName";
    public static final String FIELD_CLEAR_TIME_STAMP = "ClearTimeStamp";
    static final String[] FieldList = new String[]{"id", "agent-type", "srcfile", "server", "instance-name", "search-uri", "search-db", "local-db", "is-ssl", "is-compass", "use-auth", "user", "password", "rdm-query-language", "last-collection-time", "scope", "view-attributes", "view-hits", "nickname", "timeout", "charset"};
    static final String[] UpdateFieldList = new String[]{"srcfile", "user", "password", "rdm-query-language", "scope", "search-db", "local-db", "view-attributes", "view-hits", "nickname", "timeout", "last-collection-time", "charset"};
    private String errorMsg = null;
    protected String id = null;

    public ImportAgentModel() {
    }

    public ImportAgentModel(String name) {
        super(name);
    }

    public void setID(String importID) {
        this.id = importID;
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        String value = null;
        ImportConfig imp = null;
        boolean isNew = false;
        String id = (String)this.getValue("id");
        if (id != null) {
            imp = ImportConfig.getImportConfigByID(id);
        }
        if (imp == null) {
            isNew = true;
            imp = ImportConfig.newImportAgent();
            imp.setValue("enable", "true");
            SearchConfig.getSearchConfig();
            imp.setValue("destination-csid", SearchConfig.getValue((String)"csid"));
        }
        for (int i = 0; i < UpdateFieldList.length; ++i) {
            value = (String)this.getValue(UpdateFieldList[i]);
            if (value != null && value.trim().length() > 0) {
                imp.setValue(UpdateFieldList[i], value.trim());
                continue;
            }
            imp.remove(UpdateFieldList[i]);
        }
        value = (String)this.getValue("agent-type");
        if (value != null) {
            if (value.compareTo("localfile") == 0) {
                value = (String)this.getValue("srcfile");
                imp.setValue("srcfile", value.trim());
                imp.remove("csid");
            } else {
                value = (String)this.getValue("is-ssl");
                String x_cata = null;
                x_cata = value.compareTo("true") == 0 ? "x-catalogs://" : "x-catalog://";
                x_cata = x_cata + (String)this.getValue("server") + "/" + (String)this.getValue("instance-name");
                imp.remove("srcfile");
                imp.setValue("csid", x_cata);
                value = (String)this.getValue("is-compass");
                if (value.compareTo("false") == 0) {
                    value = (String)this.getValue("search-uri");
                    imp.setValue("search-uri", value);
                    imp.remove("use-rdm-incoming");
                } else {
                    imp.remove("search-uri");
                    imp.setValue("use-rdm-incoming", "true");
                    value = imp.getValue("rdm-query-language");
                    if (value != null && value != "gatherer") {
                        imp.setValue("rdm-query-language", "compass");
                    }
                }
            }
        } else {
            ImportConfig.DeleteImportConfigByID(imp.getID());
        }
        if (isNew && !ImportConfig.addImportAgent(imp)) {
            this.errorMsg = "Duplicated";
            return null;
        }
        ImportConfig.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        if (this.id != null || this.id.trim().length() > 0) {
            ImportConfig imp = ImportConfig.getImportConfigByID(this.id);
            if (imp != null) {
                int i = 0;
                while (true) {
                    if (i < FieldList.length) {
                        this.setValue(FieldList[i], imp.getValue(FieldList[i]));
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            this.setValue("id", this.id);
            this.setValue("agent-type", "localfile");
        }
        return null;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

