/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FiltersListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    private RobotConfig rc = null;
    public static final String FIELD_ENABLE = "Enable";
    public static final String FIELD_ID = "FilterID";
    public static final String FIELD_NICKNAME = "NickName";
    public static final String FIELD_DEFAULT = "Default";
    public static final String FIELD_DELETE = "Delete";
    public static final String FIELD_USEDINSITES = "UsedInSites";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    public Locale userLocale = Locale.getDefault();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$FiltersListModel == null ? (class$com$sun$portal$search$admin$model$FiltersListModel = FiltersListModel.class$("com.sun.portal.search.admin.model.FiltersListModel")) : class$com$sun$portal$search$admin$model$FiltersListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$FiltersListModel;

    public FiltersListModel() {
        this.rc = CSConfig.getRobotConfig();
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            FilterRule fr = this.rc.GetRuleByIndex(this.getLocation());
            if (fr == null) continue;
            String enable = (String)this.getValue(FIELD_ENABLE);
            fr.enable = enable.compareTo(ENABLE_VALUES[0]) == 0;
        }
        this.rc.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.beforeFirst();
        String[] ids = new String[this.getSize()];
        while (this.next()) {
            FilterRule fr;
            int index = this.getLocation();
            String isDelete = (String)this.getValue(FIELD_DELETE);
            ids[index] = null;
            if (isDelete.compareTo("true") != 0 || (fr = this.rc.GetRuleByIndex(index)) == null) continue;
            ids[index] = fr.id;
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            this.rc.delRule(ids[i]);
        }
        this.rc.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        this.clear();
        int n = this.rc.numOfRules();
        for (int i = 0; i < n; ++i) {
            FilterRule fr = this.rc.GetRuleByIndex(i);
            if (fr == null) continue;
            this.appendRow();
            this.setValue(FIELD_ENABLE, fr.enable ? ENABLE_VALUES[0] : ENABLE_VALUES[1]);
            this.setValue(FIELD_ID, fr.id);
            this.setValue(FIELD_DEFAULT, fr.quickcf ? SearchResource.geti18nString("filter.quikcf", this.userLocale) : "");
            String localizedValue = SearchResource.geti18nString(fr.nickname, this.userLocale, false);
            if (localizedValue != null) {
                this.setValue(FIELD_NICKNAME, localizedValue);
            } else {
                this.setValue(FIELD_NICKNAME, fr.nickname);
            }
            this.setValue(FIELD_DELETE, "false");
            String[] ids = this.rc.getFiletrRulesetIDsForFilterRule(fr.id);
            if (ids != null) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < ids.length; ++j) {
                    FilterRuleset frs = this.rc.GetRuleSet(ids[j]);
                    buf.append("<a href=\"Site?id=" + frs.id + "\">" + frs.nickname + "</a>");
                    if (j >= ids.length - 1) continue;
                    buf.append(", ");
                }
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0003", new String[]{FIELD_USEDINSITES, buf.toString()});
                this.setValue(FIELD_USEDINSITES, buf.toString());
                continue;
            }
            this.setValue(FIELD_USEDINSITES, "");
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

