/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_MATCH = "Match";
    public static final String FIELD_RULE = "Rule";
    public static final String FIELD_DELETE = "Delete";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$FilterGroupListModel == null ? (class$com$sun$portal$search$admin$model$FilterGroupListModel = FilterGroupListModel.class$("com.sun.portal.search.admin.model.FilterGroupListModel")) : class$com$sun$portal$search$admin$model$FilterGroupListModel));
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$FilterGroupListModel;

    public void setID(String id) {
        this.rulesetID = id;
    }

    public void setDelIndex(int index) {
        this.delIndex = index;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_MATCH) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("insert")) {
            result = this.insert(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.beforeFirst();
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            frs.removeFilters();
            while (this.next()) {
                String ruleID = (String)this.getValue(FIELD_RULE);
                String onMatch = (String)this.getValue(FIELD_MATCH);
                if (ruleID == null || ruleID.trim().length() <= 0) continue;
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0026", new String[]{ruleID, onMatch});
                frs.AddFilter(ruleID, RobotConfig.ADStringtoBoolean(onMatch));
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            this.setValue(FIELD_MATCH, RobotConfig.BtoString(frs.onMatch));
        }
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            delObjs.add(this.getCurrentContext().getValueList().get(index));
        }
        for (int i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            this.clear();
            int n = frs.numOfFilters();
            for (int i = 0; i < n; ++i) {
                String id = frs.getFiltersIDByIndex(i);
                String match = frs.getFiltersonMatchByIndex(i);
                this.appendRow();
                this.setValue(FIELD_RULE, id);
                this.setValue(FIELD_MATCH, match);
            }
        }
        this.beforeFirst();
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

