/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.robot.FilterRuleset;
import java.util.ArrayList;

public class DomainGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_DOMAIN = "DomainAlias";
    public static final String FIELD_VERIFIED_TEXT = "VerifiedText";
    public static final String FIELD_DELETE = "Delete";

    public void setID(String id) {
        this.rulesetID = id;
    }

    public void setDelIndex(int index) {
        this.delIndex = index;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_DOMAIN) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        String operationName = null;
        operationName = context != null ? context.getOperationName() : "retrieve";
        Object result = null;
        if (operationName.equals("retrieve")) {
            result = this.retrieve(context);
        } else if (operationName.equals("insert")) {
            result = this.insert(context);
        } else if (operationName.equals("update")) {
            result = this.update(context);
        } else if (operationName.equals("delete")) {
            result = this.delete(context);
        }
        return result;
    }

    public Object update(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.beforeFirst();
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            frs.removeDomains();
            while (this.next()) {
                String domain = (String)this.getValue(FIELD_DOMAIN);
                if (domain == null || domain.trim().length() <= 0) continue;
                frs.addDomain(domain.trim());
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        return null;
    }

    public Object delete(ModelExecutionContext context) throws ModelControlException {
        this.removeNullList();
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList delObjs = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String isDelete = (String)this.getValue(FIELD_DELETE);
            if (isDelete == null || isDelete.compareTo("true") != 0) continue;
            int index = this.getRowIndex();
            delObjs.add(this.getCurrentContext().getValueList().get(index));
        }
        for (int i = 0; i < delObjs.size(); ++i) {
            this.getCurrentContext().getValueList().remove(delObjs.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext context) throws ModelControlException {
        FilterRuleset frs = null;
        if (this.rulesetID != null) {
            frs = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (frs != null) {
            this.clear();
            int n = frs.numOfDomains();
            for (int i = 0; i < n; ++i) {
                String domain = frs.getDomainByIndex(i);
                if (domain == null) continue;
                this.appendRow();
                this.setValue(FIELD_DOMAIN, frs.getDomainByIndex(i));
                this.setValue(FIELD_VERIFIED_TEXT, frs.getDomainByIndex(i));
                this.setValue(FIELD_DELETE, "false");
            }
        }
        this.beforeFirst();
        return null;
    }
}

