/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class DbStatModelImpl
extends DefaultModel
implements Serializable {
    private SToken st;
    public static final String ON_FILE_DB_ANALYSIS = "onFileDbAnalysis";
    public static final String filePath = SearchConfig.getValue((String)"tmpdir") + File.separator + "sites.html";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$model$DbStatModelImpl == null ? (class$com$sun$portal$search$admin$model$DbStatModelImpl = DbStatModelImpl.class$("com.sun.portal.search.admin.model.DbStatModelImpl")) : class$com$sun$portal$search$admin$model$DbStatModelImpl));
    private Hashtable _listServer = null;
    private Enumeration _serverHref = null;
    private Enumeration _serverRDCounter = null;
    private Hashtable _listProtocol = null;
    private Enumeration _protocolName = null;
    private Enumeration _protocolRDCounter = null;
    private Date _lastUpdated = new Date();
    private int _totalNbRd = 0;
    private String _dbName = null;
    static /* synthetic */ Class class$com$sun$portal$search$admin$model$DbStatModelImpl;

    public DbStatModelImpl() {
    }

    public DbStatModelImpl(String name) {
        super(name);
        this.setDbName(name);
        this.retrieve();
    }

    protected void init(HttpServletRequest new_req) {
        this.retrieve();
    }

    public void setSToken(SToken stoken) {
        this.st = stoken;
    }

    public boolean isCreated() {
        try {
            SOIF dbSoif = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
            if (dbSoif != null) {
                String lastModifiedStr = dbSoif.getValue("DbStat-LastModified");
                if (lastModifiedStr != null) {
                    DBUtil.df.setLenient(true);
                    Date statLastModified = DBUtil.df.parse(lastModifiedStr);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSAM0012", e.getMessage());
            return false;
        }
    }

    public boolean isOld() {
        if (this.isCreated()) {
            SOIF dbSoif = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
            if (dbSoif != null) {
                try {
                    DBUtil.df.setLenient(true);
                    Date statLastModified = DBUtil.df.parse(dbSoif.getValue("DbStat-LastModified"));
                    File rdDbFile = new File(CSConfig.getServerRoot() + File.separator + "db" + File.separator + this.getDbName() + File.separator + "AL");
                    if (rdDbFile.exists()) {
                        Date rdDbDate = new Date(rdDbFile.lastModified());
                        return this.getLastUpdated().before(rdDbDate);
                    }
                    debugLogger.log(Level.FINER, "PSSH_CSPSAM0014", this.getDbName());
                    return false;
                }
                catch (Exception e) {
                    debugLogger.log(Level.FINER, "PSSH_CSPSAM0015", new String[]{this.getDbName(), e.getMessage()});
                    return false;
                }
            }
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0016", this.getDbName());
            return true;
        }
        return true;
    }

    public int getTotalNbServer() {
        if (this._listServer != null) {
            return this._listServer.size();
        }
        return 0;
    }

    public int getTotalNbRd() {
        return this._totalNbRd;
    }

    public void setTotalNbRd(int nbRd) {
        this._totalNbRd = nbRd;
    }

    public Hashtable getListServerRd() {
        return this._listServer;
    }

    public void setListServerRd(Hashtable listServer) {
        this._listServer = listServer;
    }

    public Enumeration getListServerName() {
        return this._serverHref;
    }

    public void setListServerName(Enumeration serverName) {
        this._serverHref = serverName;
    }

    public Enumeration getListServerCounter() {
        return this._serverRDCounter;
    }

    public void setListServerCounter(Enumeration serverCounter) {
        this._serverRDCounter = serverCounter;
    }

    public Hashtable getListProtocolRd() {
        return this._listProtocol;
    }

    public void setListProtocolRd(Hashtable listProtocol) {
        this._listProtocol = listProtocol;
    }

    public Enumeration getListProtocolName() {
        return this._protocolName;
    }

    public void setListProtocolName(Enumeration protocolName) {
        this._protocolName = protocolName;
    }

    public Enumeration getListProtocolCounter() {
        return this._protocolRDCounter;
    }

    public void setListProtocolCounter(Enumeration protocolCounter) {
        this._protocolRDCounter = protocolCounter;
    }

    public void setLastUpdated(Date date) {
        this._lastUpdated = date;
    }

    public Date getLastUpdated() {
        return this._lastUpdated;
    }

    public String getDbName() {
        return this._dbName;
    }

    public void setDbName(String dbName) {
        this._dbName = new String(dbName);
    }

    public void store() {
        try {
            if (!DBUtil.updateDB(CSConfig.getServerRoot(), this.getDbName(), this.getLastUpdated(), this._listServer, this._listProtocol)) {
                debugLogger.finer("PSSH_CSPSAM0017");
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0018", e.getMessage());
        }
    }

    public Object retrieve() {
        return this.retrieve(true);
    }

    public Object retrieve(boolean fromFile) {
        if (fromFile) {
            this._totalNbRd = 0;
            this._listServer = new Hashtable();
            this._listProtocol = new Hashtable();
            try {
                SOIF dbSoif = DBUtil.getDBSoif(CSConfig.getServerRoot(), this.getDbName());
                String attrib = null;
                String attribCount = null;
                int nbServer = Integer.parseInt(dbSoif.getValue("DbStat-NbServer"));
                if (nbServer != 0) {
                    for (int i = 0; i < nbServer; ++i) {
                        attrib = "DbStat-Href";
                        attribCount = "DbStat-Href-count";
                        this._listServer.put(dbSoif.getValue(attrib, i), dbSoif.getValue(attribCount, i));
                    }
                    this._serverHref = this._listServer.keys();
                    this._serverRDCounter = this._listServer.elements();
                } else {
                    this._listServer = null;
                    this._serverHref = null;
                    this._serverRDCounter = null;
                }
                int nbProtocol = Integer.parseInt(dbSoif.getValue("DbStat-NbProtocol"));
                if (nbProtocol != 0) {
                    for (int i = 0; i < nbProtocol; ++i) {
                        attrib = "DbStat-Protocol";
                        attribCount = "DbStat-Protocol-count";
                        this._listProtocol.put(dbSoif.getValue(attrib, i), dbSoif.getValue(attribCount, i));
                        this._totalNbRd += Integer.parseInt(dbSoif.getValue(attribCount, i));
                    }
                    this._protocolName = this._listProtocol.keys();
                    this._protocolRDCounter = this._listProtocol.elements();
                } else {
                    this._listProtocol = null;
                    this._protocolName = null;
                    this._protocolRDCounter = null;
                }
                this.setLastUpdated(DBUtil.df.parse(dbSoif.getValue("DbStat-LastModified")));
                return this;
            }
            catch (Exception e) {
                debugLogger.finer("PSSH_CSPSAM0019");
                return this;
            }
        }
        try {
            BufferedReader buf = DBUtil.urlStatDatabase(CSConfig.getServerRoot(), this.getDbName());
            this.setTotalNbRd(0);
            this.setListServerRd(new Hashtable());
            this.setListProtocolRd(new Hashtable());
            this.setLastUpdated(null);
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                URL rdURL;
                try {
                    rdURL = new URL(outLine);
                }
                catch (MalformedURLException mfe) {
                    rdURL = null;
                }
                if (rdURL != null) {
                    int rdUrlPort = rdURL.getPort();
                    String protocol = rdURL.getProtocol();
                    if (this.getListProtocolRd().containsKey(protocol)) {
                        int serverProtocolCount = Integer.parseInt((String)this._listProtocol.get(protocol));
                        this._listProtocol.remove(protocol);
                        this._listProtocol.put(protocol, Integer.toString(serverProtocolCount + 1));
                    } else {
                        this._listProtocol.put(protocol, "1");
                    }
                    String serverHref = protocol != null ? protocol + "://" : new String();
                    serverHref = serverHref + rdURL.getHost();
                    if (rdUrlPort != -1) {
                        serverHref = serverHref + ":" + rdUrlPort;
                    }
                    if (this._listServer.containsKey(serverHref = serverHref + "/")) {
                        int serverHrefCount = Integer.parseInt((String)this._listServer.get(serverHref));
                        this._listServer.remove(serverHref);
                        this._listServer.put(serverHref, Integer.toString(serverHrefCount + 1));
                    } else {
                        this._listServer.put(serverHref, "1");
                    }
                    this.setTotalNbRd(this.getTotalNbRd() + 1);
                    continue;
                }
                if (outLine != null) {
                    if (outLine.startsWith("comment")) {
                        if (this._listProtocol.containsKey("discussions")) {
                            int discussionProtocolCount = Integer.parseInt((String)this._listProtocol.get("discussions"));
                            this._listProtocol.put("discussions", new Integer(discussionProtocolCount + 1).toString());
                        } else {
                            this._listProtocol.put("discussions", "1");
                        }
                    } else if (this._listProtocol.containsKey("other")) {
                        int otherProtocolCount = Integer.parseInt((String)this._listProtocol.get("other"));
                        this._listProtocol.put("other", new Integer(otherProtocolCount + 1).toString());
                    } else {
                        this._listProtocol.put("other", "1");
                    }
                    this.setTotalNbRd(this.getTotalNbRd() + 1);
                    continue;
                }
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0020", SearchConfig.getValue((String)"database-directory"));
            }
            this.setLastUpdated(new Date());
            this.store();
            return this;
        }
        catch (Exception e) {
            debugLogger.log(Level.FINER, "PSSH_CSPSAM0021", e.getMessage());
            return null;
        }
    }

    public boolean hasMoreServer() {
        if (this._serverHref != null) {
            boolean hasMore = this._serverHref.hasMoreElements();
            return hasMore;
        }
        return false;
    }

    public boolean hasMoreProtocol() {
        if (this._protocolName != null) {
            boolean hasMore = this._protocolName.hasMoreElements();
            return hasMore;
        }
        return false;
    }

    public String nextServerHref() {
        return this.nextElement(this._serverHref, "serverHref");
    }

    public String nextServerRDCounter() {
        return this.nextElement(this._serverRDCounter, "serverRDCounter");
    }

    public String nextProtocolName() {
        return this.nextElement(this._protocolName, "protocolName");
    }

    public String nextProtocolRDCounter() {
        return this.nextElement(this._protocolRDCounter, "protocolRDCounter");
    }

    private String nextElement(Enumeration enumeration, String enumLabel) {
        if (enumLabel == null) {
            enumLabel = "Enumeration";
        }
        if (enumeration != null) {
            String nextElement = null;
            if (enumeration.hasMoreElements()) {
                nextElement = (String)enumeration.nextElement();
            } else {
                debugLogger.log(Level.FINER, "PSSH_CSPSAM0022", enumLabel);
            }
            return nextElement;
        }
        debugLogger.finer("PSSH_CSPSAM0023");
        return null;
    }

    public int nbServers() {
        if (this._listServer != null) {
            return this._listServer.size();
        }
        return 0;
    }

    public int nbProtocols() {
        if (this._listProtocol != null) {
            return this._listProtocol.size();
        }
        return 0;
    }

    public void resetServers() {
        this.setListServerName(null);
        this.setListServerCounter(null);
        if (this.getListServerRd() != null) {
            this.setListServerName(this.getListServerRd().keys());
            this.setListServerCounter(this.getListServerRd().elements());
        } else {
            debugLogger.finer("PSSH_CSPSAM0024");
        }
    }

    public void resetProtocols() {
        this.setListProtocolName(null);
        this.setListProtocolCounter(null);
        if (this.getListProtocolRd() != null) {
            this.setListProtocolName(this.getListProtocolRd().keys());
            this.setListProtocolCounter(this.getListProtocolRd().elements());
        } else {
            debugLogger.finer("PSSH_CSPSAM0025");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

