/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Schema {
    RDMSchema schema = null;
    private String searchServerRoot = null;
    private String defaultSchemaFileName = null;
    private String schemaFileName = null;
    private static Logger logger = null;

    public Schema(String psDir, String searchServerRoot, Logger logger) throws PSMBeanException {
        this.searchServerRoot = searchServerRoot;
        Schema.logger = logger;
        this.defaultSchemaFileName = psDir + File.separator + "samples" + File.separator + "schema" + File.separator + "document.soif";
        this.schemaFileName = searchServerRoot + File.separator + "config" + File.separator + "schema.rdm";
        try {
            this.schema = this.loadSchema();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void create(String name, String description, String aliases, Boolean editable, Boolean indexable, String scoreMultiplier, String dataType) throws PSMBeanException {
        int column = this.schema.getColumnNumber(name);
        if (column != -1) {
            String message = "Schema already exists - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (!this.validateName(name)) {
            String message = "Invalid schema name - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (!this.validateScoreMultiplier(scoreMultiplier)) {
            String message = "Invalid schema score multiplier - " + scoreMultiplier;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        int entries = this.schema.getNumEntriesInt();
        column = this.schema.getMaxIndex() + 1;
        this.schema.setSOIFAttribute(column, name);
        this.schema.setColumnName(column, name);
        this.schema.setSysColumnName(column, name);
        this.schema.setTableName(column, "Documents");
        this.schema.setSysTableName(column, "doctbl");
        this.schema.setDescription(column, description);
        this.schema.setAliases(column, aliases);
        this.schema.setEditAttribute(column, editable != false ? "1" : "0");
        this.schema.setIndexAttribute(column, indexable != false ? "1" : "0");
        this.schema.setDataType(column, dataType);
        if (!scoreMultiplier.equals("")) {
            this.schema.setValue(name, "score-multiplier", scoreMultiplier);
        }
        this.schema.setNumEntries(new Integer(entries + 1).toString());
        try {
            this.saveSchema(this.schema);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void delete(String name) throws PSMBeanException {
        int column = this.schema.getColumnNumber(name);
        if (column == -1) {
            String message = "Schema does not exists - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        this.schema.deleteColumn(name);
        try {
            this.saveSchema(this.schema);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void restore() throws PSMBeanException {
        try {
            this.copyFile(this.defaultSchemaFileName, this.schemaFileName);
            this.schema = this.loadSchema();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public ArrayList getAll() {
        ArrayList<String> data = new ArrayList<String>();
        for (int index = 0; index <= this.schema.getMaxIndex(); ++index) {
            String attribute = this.schema.getSOIFAttribute(index);
            if (attribute == null) continue;
            data.add(attribute);
        }
        return data;
    }

    public Properties getAttributes(String name) throws PSMBeanException {
        int column = this.schema.getColumnNumber(name);
        if (column == -1) {
            String message = "Schema does not exists - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        Properties p = new Properties();
        p.setProperty("name", name);
        String description = this.schema.getValue(name, "description");
        p.setProperty("description", description == null ? "" : description);
        String aliases = this.schema.getValue(name, "aliases");
        p.setProperty("aliases", aliases == null ? "" : aliases);
        String editable = this.schema.getValue(name, "edit-attribute");
        if (editable != null) {
            if (editable.equals("1")) {
                p.setProperty("editable", "true");
            } else {
                p.setProperty("editable", "false");
            }
        } else {
            p.setProperty("editable", "false");
        }
        String indexable = this.schema.getValue(name, "index-attribute");
        if (indexable != null) {
            if (indexable.equals("1")) {
                p.setProperty("indexable", "true");
            } else {
                p.setProperty("indexable", "false");
            }
        } else {
            p.setProperty("indexable", "false");
        }
        String scoreMultiplier = this.schema.getValue(name, "score-multiplier");
        if (scoreMultiplier != null) {
            p.setProperty("score-multiplier", scoreMultiplier);
        } else {
            p.setProperty("score-multiplier", "");
        }
        String dataType = this.schema.getValue(name, "data-type");
        p.setProperty("datatype", dataType == null ? "string" : dataType);
        String internal = this.schema.getValue(name, "is-internal");
        if (internal != null) {
            if (internal.equals("1")) {
                p.setProperty("noninternal", "false");
            } else {
                p.setProperty("noninternal", "true");
            }
        } else {
            p.setProperty("noninternal", "true");
        }
        return p;
    }

    public void setAttributes(String schemaName, String name, String description, String aliases, Boolean editable, Boolean indexable, String scoreMultiplier, String dataType) throws PSMBeanException {
        int column = this.schema.getColumnNumber(schemaName);
        if (column == -1) {
            String message = "Schema does not exists - " + schemaName;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (!this.validateName(name)) {
            String message = "Invalid schema name - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (!this.validateScoreMultiplier(scoreMultiplier)) {
            String message = "Invalid schema score multiplier - " + scoreMultiplier;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        this.schema.setSOIFAttribute(column, name);
        this.schema.setColumnName(column, name);
        this.schema.setSysColumnName(column, name);
        this.schema.setDescription(column, description);
        this.schema.setAliases(column, aliases);
        this.schema.setEditAttribute(column, editable != false ? "1" : "0");
        this.schema.setIndexAttribute(column, indexable != false ? "1" : "0");
        this.schema.setDataType(column, dataType);
        if (!scoreMultiplier.equals("")) {
            this.schema.setValue(name, "score-multiplier", scoreMultiplier);
        }
        try {
            this.saveSchema(this.schema);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    private RDMSchema loadSchema() throws Exception {
        SOIFInputStream is = new SOIFInputStream(this.schemaFileName);
        return new RDMSchema(is.readSOIF());
    }

    private void saveSchema(RDMSchema schema) throws Exception {
        SOIFOutputStream os = new SOIFOutputStream(this.schemaFileName);
        os.write(schema.getSOIF());
    }

    private boolean validateName(String name) {
        if (name.trim().equals("")) {
            return false;
        }
        for (int index = 0; index < name.length(); ++index) {
            char c = name.charAt(index);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '_' || c == '-') continue;
            return false;
        }
        return true;
    }

    private boolean validateScoreMultiplier(String scoreMultiplier) {
        if (!scoreMultiplier.equals("")) {
            try {
                Float f = new Float(scoreMultiplier);
                if (f.doubleValue() < 0.0) {
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    private void copyFile(String fromFileName, String toFileName) throws Exception {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        File parent = toFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileInputStream fis = new FileInputStream(fromFile);
        byte[] b = this.getByteData(fis);
        fis.close();
        FileOutputStream fout = new FileOutputStream(toFile);
        fout.write(b);
        fout.close();
    }

    private byte[] getByteData(InputStream is) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] byteBuf = new byte[1024];
        int num = 0;
        while ((num = is.read(byteBuf)) != -1) {
            os.write(byteBuf, 0, num);
        }
        return os.toByteArray();
    }
}

