/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.iplanet.am.util.AdminUtils;
import com.sun.identity.security.EncryptAction;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceDescription {
    private static final int MAX_RESOURCE_DESCRIPTIONS = 99999;
    private static final String ALL = "all";
    private static final String UNCATEGORIZED = "uncategorized";
    private static final String CATEGORIZED = "categorized";
    private static final String BY_CATEGORY = "by_category";
    private static final String BY_URL = "by_url";
    private static final String BY_QUERY = "by_query";
    private String searchServerRoot = null;
    private String searchServerURL = null;
    private String documentSecurityLevel = null;
    private static Logger logger = null;

    public ResourceDescription(String searchServerRoot, String searchServerURL, String documentSecurityLevel, Logger logger) {
        this.searchServerRoot = searchServerRoot;
        this.searchServerURL = searchServerURL;
        this.documentSecurityLevel = documentSecurityLevel;
        ResourceDescription.logger = logger;
    }

    public ArrayList getAll(String searchType, String query, List viewAttributes, int startPage, int hitsPerPage, String database) throws PSMBeanException {
        if (viewAttributes.size() == 0) {
            try {
                String fileName = this.searchServerRoot + File.separator + "config" + File.separator + "schema.rdm";
                SOIFInputStream is = new SOIFInputStream(fileName);
                RDMSchema schema = new RDMSchema(is.readSOIF());
                for (int index = 0; index <= schema.getMaxIndex(); ++index) {
                    String attribute = schema.getSOIFAttribute(index);
                    if (attribute == null) continue;
                    viewAttributes.add(attribute);
                }
            }
            catch (Exception e) {
                viewAttributes.add("url");
            }
        }
        if (startPage == 0) {
            startPage = 1;
        }
        if (hitsPerPage == 0) {
            hitsPerPage = 99999;
        }
        return this.search(searchType, query, viewAttributes, startPage, hitsPerPage, database);
    }

    public void create(String fileData, String database) throws PSMBeanException {
        try {
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "createrd." + Long.toString(System.currentTimeMillis());
            FileWriter fw = new FileWriter(fileName);
            fw.write(fileData);
            fw.close();
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String option = !database.equals("") ? " -y " + database : "";
            String call = this.searchServerRoot + File.separator + command + " rdmgr" + option + " " + fileName;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            int value = p.exitValue();
            if (value != 0) {
                String message = "Create resource description failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void create(Map attributes, String database) throws PSMBeanException {
        try {
            SOIF soif = new SOIF();
            soif.setSchemaName("DOCUMENT");
            Iterator i = attributes.keySet().iterator();
            while (i.hasNext()) {
                String attribute = (String)i.next();
                ArrayList values = (ArrayList)attributes.get(attribute);
                int valueSize = values.size();
                if (attribute.equals("url")) {
                    if (valueSize == 0) {
                        String message = "No value for attribute: " + attribute;
                        Object[] tokens = new Object[]{message};
                        logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                        throw new PSMBeanException("PSALI_CSPACCSH0001");
                    }
                    String value = (String)values.get(0);
                    if (value.equals("")) {
                        String message = "No value for attribute: " + attribute;
                        Object[] tokens = new Object[]{message};
                        logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                        throw new PSMBeanException("PSALI_CSPACCSH0001");
                    }
                    soif.setURL(value);
                    continue;
                }
                if (valueSize <= 0) continue;
                for (int index = 0; index < valueSize; ++index) {
                    String value = (String)values.get(index);
                    soif.insert(attribute, value, index);
                }
            }
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "createrd." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream so = new SOIFOutputStream(fileName);
            so.write(soif);
            so.close();
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String option = !database.equals("") ? " -y " + database : "";
            String call = this.searchServerRoot + File.separator + command + " rdmgr" + option + " " + fileName;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            int value = p.exitValue();
            if (value != 0) {
                String message = "Create resource description failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void delete(List urls, String database) throws PSMBeanException {
        try {
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "deleterd." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream so = new SOIFOutputStream(fileName);
            for (int index = 0; index < urls.size(); ++index) {
                SOIF soif = new SOIF("DOCUMENT", (String)urls.get(index));
                so.write(soif);
            }
            so.close();
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String option = !database.equals("") ? " -y " + database : "";
            String call = this.searchServerRoot + File.separator + command + " rdmgr -d -q" + option + " " + fileName;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            int value = p.exitValue();
            if (value != 0) {
                String message = "Delete resource description failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void edit(String fileData, String database) throws PSMBeanException {
        try {
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "editrd." + Long.toString(System.currentTimeMillis());
            FileWriter fw = new FileWriter(fileName);
            fw.write(fileData);
            fw.close();
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String option = !database.equals("") ? " -y " + database : "";
            String call = this.searchServerRoot + File.separator + command + " rdmgr -m -P" + option + " " + fileName;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            int value = p.exitValue();
            if (value != 0) {
                String message = "Edit resource description failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void edit(List urls, Map attributes, String database) throws PSMBeanException {
        try {
            String message;
            if (urls.size() == 0) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("url");
                ArrayList data = this.search(ALL, "", list, 1, 99999, database);
                ArrayList al = (ArrayList)data.get(3);
                for (int index = 0; index < al.size(); ++index) {
                    HashMap hm = (HashMap)al.get(index);
                    ArrayList values = (ArrayList)hm.get("url");
                    urls.add((String)values.get(0));
                }
            }
            String fileName = this.searchServerRoot + File.separator + "config" + File.separator + "schema.rdm";
            SOIFInputStream is = new SOIFInputStream(fileName);
            RDMSchema schema = new RDMSchema(is.readSOIF());
            fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "editrd." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream so = new SOIFOutputStream(fileName);
            for (int urlIndex = 0; urlIndex < urls.size(); ++urlIndex) {
                String url = (String)urls.get(urlIndex);
                SOIF soif = new SOIF("DOCUMENT", url);
                Iterator i = attributes.keySet().iterator();
                while (i.hasNext()) {
                    String attribute = (String)i.next();
                    String isEditable = schema.getValue(attribute, "edit-attribute");
                    if (isEditable != null && isEditable.equals("1")) {
                        ArrayList values = (ArrayList)attributes.get(attribute);
                        int valueSize = values.size();
                        if (valueSize == 0) {
                            soif.insert(attribute, "");
                            continue;
                        }
                        for (int valueIndex = 0; valueIndex < valueSize; ++valueIndex) {
                            String value = (String)values.get(valueIndex);
                            soif.insert(attribute, value, valueIndex);
                        }
                        continue;
                    }
                    message = "Attribute is not editable: " + url + " - " + attribute;
                    Object[] tokens = new Object[]{message};
                    logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
                }
                so.write(soif);
            }
            so.close();
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String option = !database.equals("") ? " -y " + database : "";
            String call = this.searchServerRoot + File.separator + command + " rdmgr -m -P" + option + " " + fileName;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            int value = p.exitValue();
            if (value != 0) {
                message = "Edit resource description failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    private ArrayList search(String searchType, String query, List viewAttributes, int startPage, int hitsPerPage, String database) throws PSMBeanException {
        String queryLanguage = "";
        String scope = "";
        if (searchType.equals(ALL)) {
            queryLanguage = "search";
            scope = "*";
        } else if (searchType.equals(UNCATEGORIZED)) {
            queryLanguage = "search";
            scope = "<not> (CLASSIFICATION!=\"\")";
        } else if (searchType.equals(CATEGORIZED)) {
            queryLanguage = "search";
            scope = "(Classification!=\"\")";
        } else if (searchType.equals(BY_CATEGORY)) {
            queryLanguage = "search";
            scope = "(Classification=\"" + query + "\")";
        } else if (searchType.equals(BY_URL)) {
            queryLanguage = "url";
            scope = query;
        } else if (searchType.equals(BY_QUERY)) {
            queryLanguage = "search";
            scope = query;
        } else {
            String message = "Unknown search type - " + searchType;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        RDMHeader rdmh = null;
        try {
            rdmh = new RDMHeader("rd-request", null, queryLanguage, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        if (this.documentSecurityLevel.equals("ON")) {
            String user = AdminUtils.getAdminDN();
            String password = (String)AccessController.doPrivileged(new EncryptAction(new String(AdminUtils.getAdminPassword())));
            rdmh.setUser(user);
            if (password != null) {
                rdmh.setPassword(password);
            }
        }
        RDMQuery rdmq = new RDMQuery(scope);
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < viewAttributes.size(); ++index) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append((String)viewAttributes.get(index));
        }
        rdmq.setViewAttr(sb.toString());
        int startHit = (startPage - 1) * hitsPerPage + 1;
        String viewHits = startHit + ".." + (startHit + hitsPerPage - 1);
        rdmq.setViewHits(viewHits);
        if (!database.equals("")) {
            rdmq.setDatabase(database);
        }
        SOIFInputStream is = null;
        try {
            SOIFBuffer soifb = new SOIFBuffer();
            SOIFOutputStream soifos = new SOIFOutputStream((OutputStream)soifb);
            soifos.write(rdmh.getSOIF());
            soifos.write(rdmq.getSOIF());
            URLConnection urlc = new URL(this.searchServerURL + "/search").openConnection();
            urlc.setAllowUserInteraction(true);
            urlc.setDoOutput(true);
            urlc.getOutputStream().write(soifb.toByteArray());
            is = new SOIFInputStream(urlc.getInputStream());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        ArrayList<Serializable> data = new ArrayList<Serializable>();
        try {
            RDMHeader rdmHeader = new RDMHeader(is);
            String ri = rdmHeader.getResponseInterpret();
            int results = this.getKeyedNumber(ri, "results");
            int totalHits = searchType.equals(BY_URL) && results == 1 ? 1 : this.getKeyedNumber(ri, "hits");
            int totalPages = totalHits / hitsPerPage;
            if (totalPages * hitsPerPage < totalHits) {
                ++totalPages;
            }
            data.add(0, new Integer(totalHits));
            data.add(1, new Integer(startPage));
            data.add(2, new Integer(totalPages));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        ArrayList values = new ArrayList();
        try {
            while (!is.isEOS()) {
                SOIF soif = is.readSOIF();
                if (soif == null || !soif.getSchemaName().equals("DOCUMENT")) continue;
                HashMap hm = new HashMap();
                for (int index1 = 0; index1 < viewAttributes.size(); ++index1) {
                    String attribute = (String)viewAttributes.get(index1);
                    ArrayList<String> al = new ArrayList<String>();
                    if (attribute.equalsIgnoreCase("url")) {
                        al.add(soif.getURL());
                    } else {
                        String[] strings = soif.getStringValues(attribute);
                        if (strings != null) {
                            for (int index2 = 0; index2 < strings.length; ++index2) {
                                al.add(strings[index2]);
                            }
                        }
                    }
                    hm.put(attribute, al);
                }
                values.add(hm);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        data.add(3, values);
        return data;
    }

    private int getKeyedNumber(String str, String key) {
        int endIndex = str.indexOf(" " + key);
        if (endIndex == -1) {
            return 0;
        }
        int startIndex = str.lastIndexOf(32, endIndex - 1);
        String value = str.substring(startIndex + 1, endIndex);
        return new Integer(value);
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }
}

