/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.sun.portal.admin.common.PSMBeanException;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Report {
    public static final String FILTER_LOG = "filter";
    public static final String RD_MANAGER_LOG = "rdmanager";
    public static final String RDM_LOG = "rdm";
    public static final String RDM_SERVER_LOG = "rdmserver";
    public static final String ROBOT_LOG = "robot";
    public static final String SEARCH_ENGINE_LOG = "searchengine";
    private String searchServerRoot = null;
    private static Logger logger = null;

    public Report(String searchServerRoot, Logger logger) {
        this.searchServerRoot = searchServerRoot;
        Report.logger = logger;
    }

    public String get(String logType, int lineLimit) throws PSMBeanException {
        StringBuffer sb = new StringBuffer();
        String logFileName = "";
        if (logType.equals(FILTER_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "filter.log";
        } else if (logType.equals(RD_MANAGER_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "rdmgr.0.0.log";
        } else if (logType.equals(ROBOT_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "robot.log";
        } else if (logType.equals(SEARCH_ENGINE_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "searchengine.log";
        } else if (logType.equals(RDM_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "rdm.0.0.log";
        } else if (logType.equals(RDM_SERVER_LOG)) {
            logFileName = this.searchServerRoot + File.separator + "logs" + File.separator + "rdmserver.0.0.log";
        } else {
            String message = "Unknown log type - " + logType;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            RandomAccessFile raf;
            File f = new File(logFileName);
            if (f.exists() && (raf = new RandomAccessFile(f, "r")).length() > 0L) {
                int length;
                int lines;
                raf.seek(raf.length() - 1L);
                byte[] buffer = new byte[1];
                int n = lines = lineLimit > 0 ? lineLimit : 1;
                while (lines >= 0) {
                    long currentOffset = raf.getFilePointer();
                    raf.readFully(buffer);
                    if (buffer[0] == 10) {
                        if (lineLimit > 0) {
                            --lines;
                        }
                        if (lines >= 0) {
                            sb.insert(0, "\n");
                        }
                    } else if (buffer[0] != 13) {
                        sb.insert(0, (char)buffer[0]);
                    }
                    if (currentOffset == 0L) break;
                    raf.seek(currentOffset - 1L);
                }
                if ((length = sb.length()) > 0 && sb.charAt(length - 1) != '\n') {
                    sb.append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        return sb.toString();
    }
}

