/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.search.admin.mbeans.tasks.SearchFrequency;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PopularSearch {
    private String searchServerRoot = null;
    private static Logger logger = null;

    public PopularSearch(String searchServerRoot, Logger logger) {
        this.searchServerRoot = searchServerRoot;
        PopularSearch.logger = logger;
    }

    public ArrayList get(Boolean cache, Boolean skipBrowse) throws PSMBeanException {
        ArrayList searchs = new ArrayList();
        Date date = null;
        if (cache.booleanValue()) {
            try {
                date = this.read(searchs, skipBrowse);
            }
            catch (Exception e1) {
                try {
                    date = this.generate(searchs, skipBrowse);
                    this.write(searchs, date, skipBrowse);
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e2);
                    throw new PSMBeanException("PSALI_CSPACCSH0001", e2.toString(), (Throwable)e2);
                }
            }
        } else {
            try {
                date = this.generate(searchs, skipBrowse);
                this.write(searchs, date, skipBrowse);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        ArrayList<Properties> list = new ArrayList<Properties>();
        for (int index = 0; index < searchs.size(); ++index) {
            SearchFrequency sf = (SearchFrequency)searchs.get(index);
            Properties p = new Properties();
            p.setProperty("frequency", new Integer(sf.frequency).toString());
            p.setProperty("scope", sf.scope);
            list.add(p);
        }
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(new Integer(this.getQueries(searchs)));
        data.add(date);
        data.add(list);
        return data;
    }

    private Date generate(ArrayList popularSearchs, boolean skipBrowse) throws Exception {
        HashMap<String, SearchFrequency> statistics = new HashMap<String, SearchFrequency>();
        Locale userLocale = Locale.getDefault();
        String fileName = this.searchServerRoot + File.separator + "logs" + File.separator + "rdm.0.0.log";
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        String line = null;
        while ((line = br.readLine()) != null) {
            Map map = this.parseResource(line);
            String scope = (String)map.get("scope");
            String ql = (String)map.get("ql");
            String rdm = (String)map.get("RDM");
            if (scope == null) continue;
            boolean isBrowsing = ql.equalsIgnoreCase("taxonomy-basic");
            if (skipBrowse && isBrowsing || rdm.equals("tax") && (ql.equals("search") || skipBrowse && ql.equals("taxonomy-basic")) || rdm.equals("rd") && ql.equals("search") && (scope.toUpperCase().startsWith("(CLASSIFICATION") || scope.toUpperCase().startsWith("<NOT> (CLASSIFICATION"))) continue;
            String browse = null;
            String search = null;
            if (isBrowsing && scope.startsWith("children* ")) {
                String classNodeName = scope.substring(10);
                if (classNodeName.equals("ROOT")) continue;
                browse = "Browse " + classNodeName;
            } else if (ql.equals("search") && scope.toUpperCase().startsWith("(CLASSIFICATION <STARTS> ")) {
                int andIndex;
                int firstRB = scope.indexOf(41);
                if (firstRB > 0 && (andIndex = scope.toUpperCase().indexOf("<AND>", firstRB)) > 0) {
                    int secondLB = scope.indexOf(40, andIndex);
                    int secondRB = scope.lastIndexOf(41);
                    if (secondRB > secondLB) {
                        search = scope.substring(secondLB + 1, secondRB) + "within" + scope.substring(25, firstRB);
                    }
                }
            } else if (ql.equals("search")) {
                search = scope;
            }
            String key = null;
            if (browse != null) {
                key = browse;
            } else if (search != null) {
                key = search;
            }
            if (key == null) continue;
            SearchFrequency sf = (SearchFrequency)statistics.get(key);
            if (sf == null) {
                sf = new SearchFrequency(key, 1, browse != null);
                statistics.put(key, sf);
                continue;
            }
            sf.increment();
        }
        Iterator i = statistics.keySet().iterator();
        while (i.hasNext()) {
            int index;
            String key = (String)i.next();
            SearchFrequency sf = (SearchFrequency)statistics.get(key);
            for (index = 0; index < popularSearchs.size(); ++index) {
                SearchFrequency testSF = (SearchFrequency)popularSearchs.get(index);
                if (sf.frequency > testSF.frequency) break;
            }
            popularSearchs.add(index, sf);
        }
        try {
            File file = new File(fileName);
            return new Date(file.lastModified());
        }
        catch (Exception e) {
            return new Date();
        }
    }

    private Date read(ArrayList popularSearchs, boolean skipBrowse) throws Exception {
        String line;
        String browse = skipBrowse ? "skipbrowse" : "browse";
        String fileName = this.searchServerRoot + File.separator + "logs" + File.separator + "popularsearch_" + browse + ".cache";
        File file = new File(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while ((line = br.readLine()) != null) {
            int index = line.indexOf("-->");
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 3).trim();
            if (key.equals("") || value.equals("")) continue;
            SearchFrequency sf = new SearchFrequency(key, new Integer(value), false);
            popularSearchs.add(sf);
        }
        Date date = new Date(file.lastModified());
        return date;
    }

    private void write(ArrayList popularSearchs, Date date, boolean skipBrowse) throws Exception {
        String browse = skipBrowse ? "skipbrowse" : "browse";
        String fileName = this.searchServerRoot + File.separator + "logs" + File.separator + "popularsearch_" + browse + ".cache";
        File file = new File(fileName);
        PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")), true);
        for (int index = 0; index < popularSearchs.size(); ++index) {
            SearchFrequency sf = (SearchFrequency)popularSearchs.get(index);
            pw.println(sf.scope + " --> " + sf.frequency);
        }
        pw.close();
        file.setLastModified(date.getTime());
    }

    private int getQueries(ArrayList popularSearchs) {
        int totalQueries = 0;
        for (int index = 0; index < popularSearchs.size(); ++index) {
            SearchFrequency sf = (SearchFrequency)popularSearchs.get(index);
            totalQueries += sf.frequency;
        }
        return totalQueries;
    }

    private Map parseResource(String str) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        int backslashLevel = 0;
        int index = 0;
        while (index < str.length()) {
            char c;
            if ((c = str.charAt(index++)) == '\"') {
                if (backslashLevel > 0) {
                    sb.append("_QUOTES_");
                } else {
                    inQuotes = !inQuotes;
                    sb.append(c);
                }
            } else if (c == ' ') {
                if (inQuotes) {
                    sb.append("_SPACE_");
                } else {
                    sb.append(c);
                }
            } else if (c == '=') {
                if (inQuotes) {
                    sb.append("_EQUALS_");
                } else {
                    sb.append(c);
                }
            } else if (c == '\\') {
                backslashLevel = 2;
            } else {
                sb.append(c);
            }
            if (backslashLevel <= 0) continue;
            --backslashLevel;
        }
        StringTokenizer st1 = new StringTokenizer(sb.toString().trim(), " ");
        while (st1.hasMoreTokens()) {
            String value;
            StringTokenizer st2 = new StringTokenizer(st1.nextToken().trim(), "=");
            String key = st2.hasMoreTokens() ? st2.nextToken().trim() : "";
            String string = value = st2.hasMoreTokens() ? st2.nextToken().trim() : "";
            if (value.equals("") && key.indexOf("[") != -1 && key.indexOf("]") != -1) {
                value = key.replaceAll("\\[", "").replaceAll("\\]", "");
                key = "date";
            }
            map.put(key.trim(), value.replaceAll("^\"", "").replaceAll("\"$", "").replaceAll("_SPACE_", " ").replaceAll("_EQUALS_", "=").replaceAll("_QUOTES_", "\"").trim());
        }
        return map;
    }
}

