/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.search.util.PBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportAgent {
    public static final String CHARACTER_SET = "character-set";
    public static final String DATABASE = "database";
    public static final String DESTINATION_DATABASE = "destination-database";
    public static final String ENABLED = "enabled";
    public static final String ID = "id";
    public static final String INPUT_FILE = "input-file";
    public static final String INPUT_FILE_EXISTS = "input-file-exists";
    public static final String INSTANCE = "instance";
    public static final String IS_COMPASS301X = "is-compass301x";
    public static final String IS_SEARCH_QUERY = "is-search-query";
    public static final String IS_SSL = "is-ssl";
    public static final String LAST_COLLECTION_TIME = "last-collection-time";
    public static final String NAME = "name";
    public static final String NICKNAME = "nickname";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String SCOPE = "scope";
    public static final String SERVER = "server";
    public static final String TIMEOUT = "timeout";
    public static final String URI = "uri";
    public static final String USER = "user";
    public static final String VIEW_ATTRIBUTES = "view-attributes";
    public static final String VIEW_HITS = "view-hits";
    private static final String CSID = "x-catalog://host:port/nickname";
    private static final String INTERNAL_AGENT_TYPE = "agent-type";
    private static final String INTERNAL_CHARSET = "charset";
    private static final String INTERNAL_CSID = "csid";
    private static final String INTERNAL_DESTINATION_CSID = "destination-csid";
    private static final String INTERNAL_EMAIL = "email";
    private static final String INTERNAL_ENABLE = "enable";
    private static final String INTERNAL_ID = "id";
    private static final String INTERNAL_INSTANCE_NAME = "instance-name";
    private static final String INTERNAL_IS_COMPASS = "is-compass";
    private static final String INTERNAL_IS_SSL = "is-ssl";
    private static final String INTERNAL_LOCAL_DB = "local-db";
    private static final String INTERNAL_NAME = "name";
    private static final String INTERNAL_NICKNAME = "nickname";
    private static final String INTERNAL_PASSWORD = "password";
    private static final String INTERNAL_QL_COMPASS = "compass";
    private static final String INTERNAL_QL_GATHERER = "gatherer";
    private static final String INTERNAL_QL_SEARCH = "search";
    private static final String INTERNAL_RDM_QUERY_LANGUAGE = "rdm-query-language";
    private static final String INTERNAL_SCOPE = "scope";
    private static final String INTERNAL_SEARCH_DB = "search-db";
    private static final String INTERNAL_SEARCH_URI = "search-uri";
    private static final String INTERNAL_SERVER_PORT = "server";
    private static final String INTERNAL_SRCFILE = "srcfile";
    private static final String INTERNAL_TIMEOUT = "timeout";
    private static final String INTERNAL_TIME_STAMP = "last-collection-time";
    private static final String INTERNAL_USER = "user";
    private static final String INTERNAL_USE_RDM_INCOMING = "use-rdm-incoming";
    private static final String INTERNAL_US_AUTH = "use-auth";
    private static final String INTERNAL_VIEW_ATTRIBUTES = "view-attributes";
    private static final String INTERNAL_VIEW_HITS = "view-hits";
    private static final String INTERNAL_VIEW_ORDER = "view-order";
    private static final String[] compareFields = new String[]{"csid", "local-db", "srcfile", "rdm-query-language", "view-attributes", "scope"};
    private String searchServerID = null;
    private String psDir = null;
    private String searchServerRoot = null;
    private static Logger logger = null;
    private HashMap importAgents = null;
    private int importAgentID = 0;
    private Process importmgrProcess = null;

    public ImportAgent(String searchServerID, String psDir, String searchServerRoot, Logger logger) {
        this.searchServerID = searchServerID;
        this.psDir = psDir;
        this.searchServerRoot = searchServerRoot;
        ImportAgent.logger = logger;
        this.importAgents = new HashMap();
        this.importAgentID = 0;
        try {
            String fileName = searchServerRoot + File.separator + "config" + File.separator + "import.conf";
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            HashMap agent = null;
            boolean inTag = false;
            String line = "";
            while ((line = br.readLine()) != null) {
                line = line.trim();
                if (inTag) {
                    if (line.startsWith("</Import>")) {
                        String id = (String)agent.get("id");
                        if (id == null) continue;
                        int currentID = Integer.parseInt(id);
                        if (currentID > this.importAgentID) {
                            this.importAgentID = currentID;
                        }
                        this.importAgents.put(id, agent);
                        inTag = false;
                        continue;
                    }
                    if (line.equals("") || line.startsWith("#")) continue;
                    PBlock.str2pblock((String)line, agent);
                    continue;
                }
                if (!line.startsWith("<Import ") || !line.endsWith(">")) continue;
                agent = new HashMap();
                PBlock.str2pblock((String)line.substring(8, line.length() - 1), agent);
                inTag = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        this.importmgrProcess = null;
    }

    public ArrayList getAll(List attributes) throws PSMBeanException {
        ArrayList<Properties> data = new ArrayList<Properties>();
        Iterator i = this.importAgents.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            HashMap map = (HashMap)this.importAgents.get(key);
            try {
                Properties p = this.getAttributes(attributes, map);
                data.add(p);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return data;
    }

    public Properties get(String id, List attributes) throws PSMBeanException {
        HashMap map = (HashMap)this.importAgents.get(id);
        if (map == null) {
            String message = "Unknown import agent: " + id;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            return this.getAttributes(attributes, map);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void create(String fileName, String destinationDatabase) throws PSMBeanException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", Integer.toString(++this.importAgentID));
        map.put(INTERNAL_ENABLE, "true");
        map.put(INTERNAL_DESTINATION_CSID, CSID);
        map.put(INTERNAL_SRCFILE, fileName);
        map.put(INTERNAL_LOCAL_DB, destinationDatabase);
        if (!this.addImportAgent(map)) {
            String message = "Duplicated import agent: " + fileName;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void create(Properties p, String destinationDatabase) throws PSMBeanException {
        String compass301x = this.getCreateValue(p, IS_COMPASS301X, "false");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", Integer.toString(++this.importAgentID));
        map.put(INTERNAL_ENABLE, "true");
        map.put(INTERNAL_DESTINATION_CSID, CSID);
        map.put("nickname", this.getCreateValue(p, "nickname", ""));
        map.put(INTERNAL_LOCAL_DB, destinationDatabase);
        map.put(INTERNAL_CHARSET, this.getCreateValue(p, CHARACTER_SET, ""));
        String id = this.getCreateValue(p, "is-ssl", "false").equals("true") ? "x-catalogs" : "x-catalog";
        id = id + "://" + this.getCreateValue(p, "server", "server");
        id = id + ":" + this.getCreateValue(p, PORT, "80");
        id = id + "/" + this.getCreateValue(p, INSTANCE, INSTANCE);
        map.put(INTERNAL_CSID, id);
        if (compass301x.equals("true")) {
            map.put(INTERNAL_USE_RDM_INCOMING, "true");
        } else {
            map.put(INTERNAL_SEARCH_URI, this.getCreateValue(p, URI, ""));
            map.put(INTERNAL_SEARCH_DB, this.getCreateValue(p, DATABASE, ""));
        }
        map.put("user", this.getCreateValue(p, "user", ""));
        map.put("password", this.getCreateValue(p, "password", ""));
        if (this.getCreateValue(p, IS_SEARCH_QUERY, "false").equals("true")) {
            if (compass301x.equals("true")) {
                map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_COMPASS);
            } else {
                map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_SEARCH);
            }
            map.put("scope", this.getCreateValue(p, "scope", ""));
            map.put("view-attributes", this.getCreateValue(p, "view-attributes", ""));
            map.put("view-hits", this.getCreateValue(p, "view-hits", ""));
        } else {
            map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_GATHERER);
        }
        map.put("last-collection-time", this.getCreateValue(p, "last-collection-time", ""));
        map.put("timeout", this.getCreateValue(p, "timeout", ""));
        if (!this.addImportAgent(map)) {
            String message = "Duplicated import agent: " + id;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void delete(List ids) throws PSMBeanException {
        for (int index = 0; index < ids.size(); ++index) {
            this.importAgents.remove((String)ids.get(index));
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void edit(String id, String fileName, String destinationDatabase) throws PSMBeanException {
        HashMap map = (HashMap)this.importAgents.get(id);
        if (map == null) {
            String message = "Import agent " + id + " not found";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        map.remove(INTERNAL_CSID);
        map.remove("nickname");
        map.remove("password");
        map.remove(INTERNAL_RDM_QUERY_LANGUAGE);
        map.remove("scope");
        map.remove(INTERNAL_SEARCH_DB);
        map.remove(INTERNAL_SEARCH_URI);
        map.remove("timeout");
        map.remove("last-collection-time");
        map.remove("user");
        map.remove(INTERNAL_USE_RDM_INCOMING);
        map.remove("view-attributes");
        map.remove("view-hits");
        map.put(INTERNAL_SRCFILE, fileName);
        if (destinationDatabase != null) {
            map.put(INTERNAL_LOCAL_DB, destinationDatabase);
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void edit(String id, Properties p, String destinationDatabase) throws PSMBeanException {
        String compass301x = p.containsKey(IS_COMPASS301X) ? p.getProperty(IS_COMPASS301X) : "false";
        HashMap map = (HashMap)this.importAgents.get(id);
        if (map == null) {
            String message = "Import agent " + id + " not found";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        map.remove(INTERNAL_SRCFILE);
        this.setEditValue(map, "nickname", p, "nickname");
        map.put(INTERNAL_LOCAL_DB, destinationDatabase);
        this.setEditValue(map, INTERNAL_CHARSET, p, CHARACTER_SET);
        String protocol = "";
        String server = "";
        String port = "";
        String instance = "";
        String currentValue = (String)map.get(INTERNAL_CSID);
        if (currentValue != null && !currentValue.equals("")) {
            try {
                URL url = new URL(currentValue.replaceFirst("x-catalog", "http"));
                protocol = url.getProtocol().equals("https") ? "x-catalogs" : "x-catalog";
                server = url.getHost();
                port = new Integer(url.getPort()).toString();
                instance = url.getFile();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        boolean needUpdate = false;
        if (p.containsKey("is-ssl")) {
            protocol = p.getProperty("is-ssl").equals("true") ? "x-catalogs" : "x-catalog";
            needUpdate = true;
        }
        if (p.containsKey("server")) {
            server = p.getProperty("server");
            needUpdate = true;
        }
        if (p.containsKey(PORT)) {
            port = p.getProperty(PORT);
            needUpdate = true;
        }
        if (p.containsKey(INSTANCE)) {
            instance = p.getProperty(INSTANCE);
            needUpdate = true;
        }
        if (needUpdate) {
            String csid = protocol + "://" + server;
            if (!port.equals("")) {
                csid = csid + ":" + port;
            }
            if (!instance.equals("")) {
                csid = csid + "/" + instance;
            }
            map.put(INTERNAL_CSID, csid);
        }
        if (compass301x.equals("true")) {
            map.put(INTERNAL_USE_RDM_INCOMING, "true");
            map.remove(INTERNAL_SEARCH_URI);
            map.remove(INTERNAL_SEARCH_DB);
        } else {
            map.remove(INTERNAL_USE_RDM_INCOMING);
            this.setEditValue(map, INTERNAL_SEARCH_URI, p, URI);
            this.setEditValue(map, INTERNAL_SEARCH_DB, p, DATABASE);
        }
        this.setEditValue(map, "user", p, "user");
        this.setEditValue(map, "password", p, "password");
        if (p.containsKey(IS_SEARCH_QUERY)) {
            if (p.getProperty(IS_SEARCH_QUERY).equals("true")) {
                if (compass301x.equals("true")) {
                    map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_COMPASS);
                } else {
                    map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_SEARCH);
                }
                this.setEditValue(map, "scope", p, "scope");
                this.setEditValue(map, "view-attributes", p, "view-attributes");
                this.setEditValue(map, "view-hits", p, "view-hits");
            } else {
                map.put(INTERNAL_RDM_QUERY_LANGUAGE, INTERNAL_QL_GATHERER);
                map.remove("scope");
                map.remove("view-attributes");
                map.remove("view-hits");
            }
        }
        this.setEditValue(map, "last-collection-time", p, "last-collection-time");
        this.setEditValue(map, "timeout", p, "timeout");
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void enable(List ids) throws PSMBeanException {
        for (int index = 0; index < ids.size(); ++index) {
            String id = (String)ids.get(index);
            HashMap map = (HashMap)this.importAgents.get(id);
            if (map == null) {
                String message = "Import agent " + id + " not found";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            map.put(INTERNAL_ENABLE, "true");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void disable(List ids) throws PSMBeanException {
        for (int index = 0; index < ids.size(); ++index) {
            String id = (String)ids.get(index);
            HashMap map = (HashMap)this.importAgents.get(id);
            if (map == null) {
                String message = "Import agent " + id + " not found";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            map.put(INTERNAL_ENABLE, "false");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void run() throws PSMBeanException {
        if (this.importmgrProcess != null) {
            try {
                int exitCode = this.importmgrProcess.exitValue();
                this.importmgrProcess = null;
            }
            catch (IllegalThreadStateException itse) {
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (this.importmgrProcess == null) {
            try {
                String[] commands = new String[]{this.psDir + File.separator + "lib" + File.separator + "importmgr", "-c", this.searchServerRoot + File.separator + "config" + File.separator + "search.conf", CSID, "run", "all"};
                String[] envs = null;
                envs = this.isWindows() ? new String[6] : new String[]{"PATH=" + this.psDir + File.separator + "lib" + ":" + this.psDir + File.separator + "bin", "LD_LIBRARY_PATH=" + this.psDir + File.separator + "lib:" + this.psDir + File.separator + "lib" + File.separator + "filter:" + File.separator + "usr" + File.separator + "lib" + File.separator + "mps:" + File.separator + "usr" + File.separator + "lib" + File.separator + "lwp", "CAT_SERVER_ROOT=" + this.searchServerRoot, "CS_CONFIG_PATH=" + this.searchServerRoot + File.separator + "config", "CS_LOGDIR=" + this.searchServerRoot + File.separator + "logs"};
                if (this.isWindows()) {
                    String key = "COMSPEC";
                    String value = System.getProperty(key);
                    if (value == null || value.trim().equals("")) {
                        String winDir = System.getProperty("os.name").equals("Windows XP") ? "C:\\WINDOWS" : "C:\\WINNT";
                        value = winDir + "\\system32\\cmd.exe";
                    }
                    envs[5] = key + "=" + value;
                }
                Runtime rt = Runtime.getRuntime();
                this.importmgrProcess = rt.exec(commands, envs);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            String message = "Import agents are already running";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
    }

    public boolean stillRunning() throws PSMBeanException {
        if (this.importmgrProcess != null) {
            try {
                int exitCode = this.importmgrProcess.exitValue();
                this.importmgrProcess = null;
                return false;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return false;
    }

    private void update() throws Exception {
        String fileName = this.searchServerRoot + File.separator + "config" + File.separator + "import.conf";
        FileOutputStream fos = new FileOutputStream(fileName);
        PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")), true);
        pw.println("# Written automatically by importmgr -- DO NOT EDIT");
        Iterator i1 = this.importAgents.keySet().iterator();
        while (i1.hasNext()) {
            HashMap map = (HashMap)this.importAgents.get((String)i1.next());
            pw.println("<Import id=" + (String)map.get("id") + ">");
            Iterator i2 = map.keySet().iterator();
            while (i2.hasNext()) {
                String key = (String)i2.next();
                if (key.compareToIgnoreCase("id") == 0) continue;
                pw.println(key + "=" + PBlock.quotedString((String)((String)map.get(key))) + "");
            }
            pw.println("</Import>");
            pw.println();
        }
        pw.close();
    }

    private boolean addImportAgent(HashMap map) {
        Iterator i = this.importAgents.keySet().iterator();
        while (i.hasNext()) {
            HashMap m = (HashMap)this.importAgents.get((String)i.next());
            boolean match = true;
            for (int index = 0; index < compareFields.length; ++index) {
                String key = compareFields[index];
                String value1 = (String)map.get(key);
                String value2 = (String)m.get(key);
                if (!(value1 == null && value1 != null || value1 != null && value2 == null) && (value1 == null || value2 == null || value1.equals(value2))) continue;
                match = false;
            }
            if (!match) continue;
            return false;
        }
        ArrayList<String> al = new ArrayList<String>();
        i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            if (value != null && !value.equals("") && !value.equals("\"\"")) continue;
            al.add(key);
        }
        for (int index = 0; index < al.size(); ++index) {
            map.remove(al.get(index));
        }
        this.importAgents.put((String)map.get("id"), map);
        return true;
    }

    private String getCreateValue(Properties p, String key, String defaultValue) {
        if (p.containsKey(key)) {
            return p.getProperty(key);
        }
        return defaultValue;
    }

    private void setEditValue(HashMap map, String field, Properties p, String key) {
        if (p.containsKey(key)) {
            map.put(field, p.getProperty(key));
        }
    }

    private Properties getAttributes(List attributes, HashMap map) throws Exception {
        if (attributes.size() == 0) {
            attributes.add(CHARACTER_SET);
            attributes.add(DATABASE);
            attributes.add(DESTINATION_DATABASE);
            attributes.add(ENABLED);
            attributes.add("id");
            attributes.add(INPUT_FILE);
            attributes.add(INPUT_FILE_EXISTS);
            attributes.add(INSTANCE);
            attributes.add(IS_COMPASS301X);
            attributes.add(IS_SEARCH_QUERY);
            attributes.add("is-ssl");
            attributes.add("last-collection-time");
            attributes.add("name");
            attributes.add("nickname");
            attributes.add("password");
            attributes.add(PORT);
            attributes.add("scope");
            attributes.add("server");
            attributes.add("timeout");
            attributes.add(URI);
            attributes.add("user");
            attributes.add("view-attributes");
            attributes.add("view-hits");
        }
        Properties p = new Properties();
        for (int index = 0; index < attributes.size(); ++index) {
            Object[] tokens;
            String message;
            URL url;
            String value;
            String value2;
            String attribute = (String)attributes.get(index);
            if (attribute.equals(CHARACTER_SET)) {
                value2 = (String)map.get(INTERNAL_CHARSET);
                p.setProperty(CHARACTER_SET, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(DATABASE)) {
                value2 = (String)map.get(INTERNAL_SEARCH_DB);
                p.setProperty(DATABASE, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(DESTINATION_DATABASE)) {
                value2 = (String)map.get(INTERNAL_LOCAL_DB);
                p.setProperty(DESTINATION_DATABASE, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(ENABLED)) {
                value2 = (String)map.get(INTERNAL_ENABLE);
                p.setProperty(ENABLED, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("id")) {
                value2 = (String)map.get("id");
                p.setProperty("id", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(INPUT_FILE)) {
                value2 = (String)map.get(INTERNAL_SRCFILE);
                p.setProperty(INPUT_FILE, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(INPUT_FILE_EXISTS)) {
                value2 = (String)map.get(INTERNAL_SRCFILE);
                if (value2 != null) {
                    File f = new File(value2);
                    if (f.exists()) {
                        p.setProperty(INPUT_FILE_EXISTS, "true");
                        continue;
                    }
                    p.setProperty(INPUT_FILE_EXISTS, "false");
                    continue;
                }
                p.setProperty(INPUT_FILE_EXISTS, "");
                continue;
            }
            if (attribute.equals(INSTANCE)) {
                String instance = "";
                value = (String)map.get(INTERNAL_CSID);
                if (value != null && !value.equals("")) {
                    value = value.replaceFirst("x-catalog", "http");
                    try {
                        url = new URL(value);
                        instance = url.getFile().replaceFirst("/", "");
                    }
                    catch (Exception e) {
                        message = "Badly formed CSID: " + value + ", " + e.toString();
                        tokens = new Object[]{message};
                        logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
                    }
                }
                p.setProperty(INSTANCE, instance);
                continue;
            }
            if (attribute.equals(IS_COMPASS301X)) {
                value2 = (String)map.get(INTERNAL_USE_RDM_INCOMING);
                p.setProperty(IS_COMPASS301X, value2 != null ? value2 : "false");
                continue;
            }
            if (attribute.equals(IS_SEARCH_QUERY)) {
                value2 = (String)map.get(INTERNAL_RDM_QUERY_LANGUAGE);
                if (value2 == null || value2.equals("")) {
                    p.setProperty(IS_SEARCH_QUERY, "false");
                    continue;
                }
                p.setProperty(IS_SEARCH_QUERY, value2.equals(INTERNAL_QL_GATHERER) ? "false" : "true");
                continue;
            }
            if (attribute.equals("is-ssl")) {
                String isSSL = "false";
                value = (String)map.get(INTERNAL_CSID);
                if (value != null && !value.equals("")) {
                    isSSL = value.indexOf("x-catalogs") == -1 ? "false" : "true";
                }
                p.setProperty("is-ssl", isSSL);
                continue;
            }
            if (attribute.equals("last-collection-time")) {
                value2 = (String)map.get("last-collection-time");
                p.setProperty("last-collection-time", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("name")) {
                String id = (String)map.get(INTERNAL_CSID);
                String nickName = (String)map.get("nickname");
                if (id != null) {
                    if (nickName == null) {
                        p.setProperty("name", id);
                        continue;
                    }
                    p.setProperty("name", nickName);
                    continue;
                }
                String fileName = (String)map.get(INTERNAL_SRCFILE);
                if (fileName != null) {
                    if (nickName == null) {
                        p.setProperty("name", fileName);
                        continue;
                    }
                    p.setProperty("name", nickName);
                    continue;
                }
                p.setProperty("name", "");
                continue;
            }
            if (attribute.equals("nickname")) {
                value2 = (String)map.get("nickname");
                p.setProperty("nickname", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("password")) {
                value2 = (String)map.get("password");
                p.setProperty("password", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(PORT)) {
                String port = "";
                value = (String)map.get(INTERNAL_CSID);
                if (value != null && !value.equals("")) {
                    value = value.replaceFirst("x-catalog", "http");
                    try {
                        url = new URL(value);
                        port = new Integer(url.getPort()).toString();
                    }
                    catch (Exception e) {
                        message = "Badly formed CSID: " + value + ", " + e.toString();
                        tokens = new Object[]{message};
                        logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
                    }
                }
                p.setProperty(PORT, port);
                continue;
            }
            if (attribute.equals("scope")) {
                value2 = (String)map.get("scope");
                p.setProperty("scope", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("server")) {
                String server = "";
                value = (String)map.get(INTERNAL_CSID);
                if (value != null && !value.equals("")) {
                    value = value.replaceFirst("x-catalog", "http");
                    try {
                        url = new URL(value);
                        server = url.getHost();
                    }
                    catch (Exception e) {
                        message = "Badly formed CSID: " + value + ", " + e.toString();
                        tokens = new Object[]{message};
                        logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
                    }
                }
                p.setProperty("server", server);
                continue;
            }
            if (attribute.equals("timeout")) {
                value2 = (String)map.get("timeout");
                p.setProperty("timeout", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals(URI)) {
                value2 = (String)map.get(INTERNAL_SEARCH_URI);
                p.setProperty(URI, value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("user")) {
                value2 = (String)map.get("user");
                p.setProperty("user", value2 != null ? value2 : "");
                continue;
            }
            if (attribute.equals("view-attributes")) {
                value2 = (String)map.get("view-attributes");
                p.setProperty("view-attributes", value2 != null ? value2 : "");
                continue;
            }
            if (!attribute.equals("view-hits")) continue;
            value2 = (String)map.get("view-hits");
            p.setProperty("view-hits", value2 != null ? value2 : "");
        }
        return p;
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }
}

