/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;

public class FilterSimulator {
    static String[] h_errmsg = new String[]{"robot.simulator.successdns", "robot.simulator.namenotfound", "robot.simulator.dnsserverfail", "robot.simulator.norecovery", "robot.simulator.dns.noaddress", "robot.simulator.unknownerror"};

    String trim_fr(String s) {
        if ((s = s.trim()).startsWith("<URL:")) {
            String host;
            s = host = s.substring(5, s.length() - 1);
        } else {
            int h = s.indexOf("<URL:");
            if (h > 0) {
                String host;
                s = host = s.substring(0, h - 1) + " " + s.substring(h + 5, s.length() - 1);
            } else {
                int i = s.indexOf(" -- ");
                if (i > 0) {
                    s = s.substring(0, i);
                }
            }
        }
        return s;
    }

    int getInt(BufferedReader in) throws Exception {
        String s = in.readLine();
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    String[] increaseArray(String[] src) {
        if (src == null) {
            return new String[10];
        }
        String[] tmp = new String[src.length + 10];
        System.arraycopy(src, 0, tmp, 0, src.length);
        return tmp;
    }

    public HashMap runProb(boolean isSmartHostHeuristics, String root, boolean showDNS, String url) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String host = "";
        String protocol = "";
        String uri = "";
        int port = 0;
        try {
            URL urlo = new URL(url);
            host = urlo.getHost();
            protocol = urlo.getProtocol();
            uri = urlo.getFile();
            port = urlo.getPort();
        }
        catch (Exception e) {
            result.put("URLMalformed", "");
            return result;
        }
        if (port < 1) {
            port = 80;
        }
        HostResult hr = this.doGetHostByName(root, host);
        LinkedList<Object> host_result = new LinkedList<Object>();
        host_result.addLast(hr.h_cname);
        host_result.addLast(new Integer(hr.h_type));
        host_result.addLast(new Integer(hr.h_errno));
        host_result.addLast(new Integer(hr.h_length));
        host_result.addLast(hr.h_ips);
        host_result.addLast(hr.h_aliases);
        host_result.addLast(hr.org_url);
        result.put("HostResult", host_result);
        if (!protocol.startsWith("http")) {
            return result;
        }
        RedirectResult r = this.doRedirect(root, false, url);
        LinkedList<Object> r_result = new LinkedList<Object>();
        r_result.addLast(r.redirect_url);
        r_result.addLast(r.server_type);
        r_result.addLast(new Integer(r.content_length));
        r_result.addLast(new Integer(r.return_code));
        result.put("RedirectResult", r_result);
        if (r.return_code >= 0) {
            RedirectResult r1 = this.doRedirect(root, true, url);
            LinkedList<Object> r1_result = new LinkedList<Object>();
            r1_result.addLast(r1.redirect_url);
            r1_result.addLast(r1.server_type);
            r1_result.addLast(new Integer(r1.content_length));
            r1_result.addLast(new Integer(r1.return_code));
            result.put("RedirectResult1", r1_result);
            String url2 = protocol + "://" + hr.h_cname + ":" + port + uri;
            RedirectResult r2 = this.doRedirect(root, true, url2);
            LinkedList<Object> r2_result = new LinkedList<Object>();
            r2_result.addLast(r2.redirect_url);
            r2_result.addLast(r2.server_type);
            r2_result.addLast(new Integer(r2.content_length));
            r2_result.addLast(new Integer(r2.return_code));
            result.put("RedirectResult2", r2_result);
            result.put("RedirectResult2URL", url2);
        } else {
            result.put("RedirectResult1", null);
            result.put("RedirectResult2", null);
        }
        return result;
    }

    public String getHostByName(String root, String host) throws Exception {
        HostResult r = this.doGetHostByName(root, host);
        if (r.h_errno != 0) {
            if (r.h_errno > 0 && r.h_errno < h_errmsg.length) {
                throw new Exception(h_errmsg[r.h_errno]);
            }
            throw new Exception("simulator.unknownerror");
        }
        return r.h_cname;
    }

    public HostResult doGetHostByName(String root, String host) throws Exception {
        String s;
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " hostinfo " + host;
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String cname = null;
        String[] aliases = null;
        String[] ps = null;
        int h_type = 0;
        int h_len = 0;
        int code = -1;
        boolean is_ok = false;
        code = this.getInt(in);
        if (code != 0) {
            String s2;
            if (code == 4) {
                cname = host;
            }
            while ((s2 = in.readLine()) != null) {
            }
            in.close();
            return new HostResult(host, code, cname, 0, 0, null, null);
        }
        cname = in.readLine();
        h_type = this.getInt(in);
        h_len = this.getInt(in);
        int count = 0;
        int len = 0;
        while ((s = in.readLine()) != null && !s.equalsIgnoreCase("ALIASES")) {
            if (len < ++count) {
                ps = this.increaseArray(ps);
                len = ps.length;
            }
            ps[count - 1] = s;
        }
        if (s == null) {
            return new HostResult(host, code, cname, h_type, h_len, ps, null);
        }
        count = 0;
        len = 0;
        while ((s = in.readLine()) != null) {
            if (len < ++count) {
                aliases = this.increaseArray(aliases);
                len = aliases.length;
            }
            aliases[count - 1] = s;
        }
        return new HostResult(host, code, cname, h_type, h_len, ps, aliases);
    }

    public RedirectResult doRedirect(String root, boolean is_visual_server, String url) throws Exception {
        String s;
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " ufetch ";
        if (!is_visual_server) {
            cmd = cmd + "-d ";
        }
        cmd = cmd + url;
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String host = null;
        String type = null;
        int comp_len = 0;
        int len = 0;
        boolean is_ok = false;
        boolean isredirect = false;
        while ((s = in.readLine()) != null) {
            is_ok = true;
            if (!is_visual_server) {
                if (s.length() > 7 && s.substring(0, 7).equalsIgnoreCase("Server:")) {
                    type = s.substring(7).trim();
                }
                if (s.length() > 15 && s.substring(0, 15).equalsIgnoreCase("Content-length:")) {
                    try {
                        len = Integer.parseInt(s.substring(7).trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (s.length() > 9 && s.substring(0, 9).equalsIgnoreCase("Location:") && !(host = s.substring(9).trim()).equals(url + "/") && !url.equals(host + "/")) {
                    isredirect = true;
                }
            }
            comp_len += s.length();
        }
        in.close();
        if (len == 0) {
            len = comp_len;
        }
        if (!is_ok) {
            return new RedirectResult(-1, "", "", len);
        }
        if (isredirect) {
            return new RedirectResult(1, host, type, len);
        }
        return new RedirectResult(0, null, type, len);
    }

    public HashMap runSimu(boolean isSmartHostHeuristics, String root, String url, boolean do_dns, boolean do_redirect) throws Exception {
        String s;
        HashMap result_map = new HashMap();
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " frsim -l " + root + File.separator + "config" + File.separator + "filterrules.conf";
        String result = "";
        boolean is_ok = false;
        result_map = this.runProb(isSmartHostHeuristics, root, do_dns, url);
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        PrintWriter out = new PrintWriter(proc.getOutputStream());
        out.println(url);
        out.flush();
        out.close();
        while ((s = in.readLine()) != null) {
            result = result + this.trim_fr(s);
            result = result + "\n";
        }
        in.close();
        result_map.put("frsimResult", result);
        return result_map;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    class RedirectResult {
        String redirect_url;
        String server_type;
        int content_length;
        int return_code;

        public RedirectResult(int code, String host, String type, int length) {
            this.redirect_url = host;
            this.server_type = type;
            this.content_length = length;
            this.return_code = code;
        }
    }

    class HostResult {
        String h_cname;
        int h_type;
        int h_errno;
        int h_length;
        String[] h_ips;
        String[] h_aliases;
        String org_url;

        public HostResult(String url, int code, String host, int length, int type, String[] ps, String[] aliases) {
            this.org_url = url;
            this.h_cname = host;
            this.h_length = length;
            this.h_type = type;
            this.h_ips = ps;
            this.h_aliases = aliases;
            this.h_errno = code;
        }
    }
}

