/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans.tasks;

import com.sun.portal.search.admin.mbeans.tasks.Rule;
import com.sun.portal.search.util.PBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassConfig {
    public static final String SRC_URL = "URL";
    public static final String SRC_HOST = "host";
    public static final String SRC_PROTOCOL = "protocol";
    public static final String SRC_URI = "uri";
    public static final String SRC_IP = "ip";
    public static final String SRC_TYPE = "type";
    public static final String SRC_ATTRIBUTE = "attribute";
    public static final String METHOD_EXACT = "by-exact";
    public static final String METHOD_PREFIX = "by-prefix";
    public static final String METHOD_SUFFIX = "by-suffix";
    public static final String METHOD_SUBSTR = "by-substr";
    public static final String METHOD_REGEX = "by-regex";
    public static final String[] METHOD_LIST = new String[]{"by-exact", "by-prefix", "by-suffix", "by-substr", "by-regex"};
    private String filename;
    private StringBuffer rulesHeader = new StringBuffer();
    private StringBuffer rulesFooter = new StringBuffer();
    ArrayList rulesList = new ArrayList();

    public ClassConfig(String class_conf_file) {
        this.filename = class_conf_file;
        this.parseClassificationFile(class_conf_file);
    }

    public ArrayList getRulesList() {
        return this.rulesList;
    }

    public boolean isExist(String src, String method, String name, String action) {
        return this.isExist(src, method, name, action, -1);
    }

    public boolean isExist(String src, String method, String name, String action, int exceptIndex) {
        for (int i = 0; i < this.rulesList.size(); ++i) {
            Rule r;
            if (i == exceptIndex || !(r = (Rule)this.rulesList.get(i)).getSrc().equalsIgnoreCase(src) || !r.getMethod().equalsIgnoreCase(method) || !r.getName().equals(name) || !r.getAction().equals(action)) continue;
            return true;
        }
        return false;
    }

    public boolean add(String src, String method, String name, String action, boolean isCase) {
        if (this.isExist(src, method, name, action)) {
            return false;
        }
        Rule r = new Rule(src, method, name, action, isCase);
        this.addSortedBySrc(r);
        return true;
    }

    void addSortedBySrc(Rule r) {
        for (int i = 0; i < this.rulesList.size(); ++i) {
            Rule element = (Rule)this.rulesList.get(i);
            if (r.getSrc().compareTo(element.getSrc()) >= 0) continue;
            this.rulesList.add(i, r);
            return;
        }
        this.rulesList.add(r);
    }

    public void delete(int index) {
        this.rulesList.remove(index);
    }

    public void removeAll() {
        this.rulesList.clear();
    }

    public void update(int index, Rule rule) {
        this.rulesList.set(index, rule);
    }

    public void update(int index, String src, String method, String name, String action) {
        Rule r = (Rule)this.rulesList.get(index);
        r.setSrc(src);
        r.setMethod(method);
        r.setName(name);
        r.setAction(action);
    }

    public void update(int index, String src, String method, String name, String action, boolean isCase) {
        Rule r = (Rule)this.rulesList.get(index);
        r.setSrc(src);
        r.setMethod(method);
        r.setName(name);
        r.setAction(action);
        r.setCaseSensitive(isCase);
    }

    public void save() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF8")), true);
            pw.println(this.rulesHeader);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.rulesList.size(); ++i) {
                Rule r = (Rule)this.rulesList.get(i);
                buf.append("Classification");
                buf.append(" ");
                buf.append("src=");
                buf.append("\"" + r.getSrc() + "\"");
                buf.append(" ");
                buf.append(r.getMethod());
                buf.append("=");
                buf.append(PBlock.quotedString((String)r.getName()));
                buf.append(" ");
                if (!r.isCaseSensitive()) {
                    buf.append("case=" + (r.isCaseSensitive() ? "true" : "false"));
                }
                buf.append(" ");
                buf.append("action=");
                buf.append(PBlock.quotedString((String)r.getAction()));
                buf.append("\n");
            }
            pw.println(buf.toString());
            pw.print(this.rulesFooter);
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseClassificationFile(String fname) {
        this.rulesHeader = new StringBuffer("");
        this.rulesFooter = new StringBuffer("");
        boolean inHeader = true;
        boolean inFooter = false;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fname), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("Classification")) {
                    this.addRule(line);
                    continue;
                }
                if (line.startsWith("<Preprocess directive=\"Generate\">")) {
                    this.rulesHeader.append(line + "\n");
                    inHeader = false;
                    continue;
                }
                if (line.startsWith("</Preprocess>")) {
                    this.rulesFooter.append(line + "\n");
                    inFooter = true;
                    continue;
                }
                if (inHeader) {
                    this.rulesHeader.append(line + "\n");
                    continue;
                }
                if (!inFooter) continue;
                this.rulesFooter.append(line + "\n");
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void addRule(String rule) {
        HashMap map = new HashMap();
        try {
            PBlock.str2pblock((String)rule, map);
            Rule r = new Rule();
            String value = (String)map.get("src");
            if (value != null) {
                int methodIndex;
                r.setSrc(value);
                for (methodIndex = 0; methodIndex < METHOD_LIST.length && (value = (String)map.get(METHOD_LIST[methodIndex])) == null; ++methodIndex) {
                }
                if (value != null) {
                    r.setMethod(METHOD_LIST[methodIndex]);
                    r.setName(value);
                    value = (String)map.get("action");
                    if (value != null) {
                        r.setAction(value);
                        value = (String)map.get("case");
                        if (value != null && value.equals("false")) {
                            r.setCaseSensitive(false);
                        }
                        if (!this.isExist(r.getSrc(), r.getMethod(), r.getName(), r.getAction())) {
                            this.addSortedBySrc(r);
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumberOfRules() {
        return this.rulesList.size();
    }
}

