/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.SiteProbeMBean;
import com.sun.portal.search.admin.mbeans.tasks.FilterSimulator;
import com.sun.portal.search.robot.ProcessConfig;
import com.sun.portal.search.robot.RobotConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class SiteProbe
extends PSResource
implements SiteProbeMBean {
    private ObjectName objectName = null;
    private String host = null;
    public String serverRoot = null;
    public String configDir = null;
    public RobotConfig robotConfig = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$SiteProbe == null ? (class$com$sun$portal$search$admin$mbeans$SiteProbe = SiteProbe.class$("com.sun.portal.search.admin.mbeans.SiteProbe")) : class$com$sun$portal$search$admin$mbeans$SiteProbe));
    static final String SEARCH_CONF = "search.conf";
    static final String FILTER_CONF = "filterrules.conf";
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$SiteProbe;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer.SiteProbe", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer.SiteProbe", path, "Host");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        try {
            if (AdminUtil.isLocal((String)this.host)) {
                this.initConfig(path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public void initConfig(List path) throws PSMBeanException {
        try {
            MBeanServer ms = PASModule.getMBeanServer();
            LinkedList serverpath = new LinkedList();
            serverpath.addFirst(path.get(2));
            serverpath.addFirst(path.get(1));
            ObjectName searchServer = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
            this.serverRoot = (String)ms.getAttribute(searchServer, "SearchServerRoot");
            this.configDir = (String)ms.getAttribute(searchServer, "ConfigDir");
            if (this.serverRoot == null || this.configDir == null) {
                throw new PSMBeanException("SiteProbe.initConfig(): initialization failed with null server root or config directory");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("SiteProbe.initConfig()", e.toString(), (Throwable)e);
        }
    }

    public HashMap runSiteProbe(String url, Boolean showDNS) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{url, showDNS};
                String[] signatures = new String[]{"java.lang.String", "java.lang.Boolean"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "runSiteProbe", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("SiteProbe:runSiteProbe", e.toString(), (Throwable)e);
            }
        }
        HashMap result_map = null;
        boolean showdns = showDNS;
        FilterSimulator frsim = new FilterSimulator();
        this.robotConfig = new RobotConfig(this.configDir);
        if (this.robotConfig == null) {
            throw new PSMBeanException("SiteProbe.runSiteProbe(): cannot get robot configurations");
        }
        String urlstring = this.getValidatedURLString(url);
        if (urlstring == null) {
            throw new PSMBeanException("SiteProbe.runSiteProbe(): cannot validate the url " + url.toString());
        }
        ProcessConfig pconf = this.robotConfig.processConf;
        String shh = pconf.get("smart-host-heuristics");
        boolean is_shh = shh.equalsIgnoreCase("true");
        try {
            result_map = frsim.runProb(is_shh, this.serverRoot, showdns, urlstring);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("SiteProbe.runSiteProbe()", e.toString(), (Throwable)e);
        }
        if (result_map != null) {
            result_map.put("smart-host-heuristics", shh);
        }
        return result_map;
    }

    public String getValidatedURLString(String sitename) {
        URL url = null;
        String urlstring = sitename = sitename.replace('\\', '/');
        int i = sitename.indexOf("://");
        if (i < 0) {
            if (sitename.startsWith("file:")) {
                int j = sitename.indexOf(":/");
                urlstring = "file://localhost" + sitename.substring(j + 1);
            } else {
                urlstring = sitename.startsWith("//") ? "file:" + sitename : (sitename.startsWith("/") ? "file://localhost" + sitename : "http://" + sitename);
            }
        }
        if (sitename.startsWith("file:///")) {
            int k = sitename.indexOf(":///");
            urlstring = "file://localhost" + sitename.substring(k + 3);
        }
        try {
            url = new URL(urlstring);
            int port = url.getPort();
            String host = url.getHost();
            String path = url.getPath();
            if (port < 0 && !url.getProtocol().equalsIgnoreCase("file")) {
                port = url.getDefaultPort();
            }
            if (path == null || path.length() == 0) {
                path = "/";
            }
            if (host == null || host.length() == 0) {
                host = "localhost";
            }
            if (!url.getProtocol().equals("file")) {
                url = new URL(url.getProtocol(), host, port, path);
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return null;
        }
        return url.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

