/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.SearchServerMBean;
import com.sun.portal.search.admin.mbeans.tasks.ImportAgent;
import com.sun.portal.search.admin.mbeans.tasks.PopularSearch;
import com.sun.portal.search.admin.mbeans.tasks.Report;
import com.sun.portal.search.admin.mbeans.tasks.ResourceDescription;
import com.sun.portal.search.admin.mbeans.tasks.Schema;
import com.sun.portal.search.util.OrderedMap;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class SearchServer
extends PSResource
implements SearchServerMBean {
    private ObjectName objectName = null;
    private String host = null;
    private String port = null;
    private String instance = null;
    private String searchServerID = null;
    private String searchServerURL = null;
    private String psDir = null;
    private String searchServerRoot = null;
    private OrderedMap searchConfig = null;
    private ImportAgent importAgent = null;
    private Schema schema = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$SearchServer == null ? (class$com$sun$portal$search$admin$mbeans$SearchServer = SearchServer.class$("com.sun.portal.search.admin.mbeans.SearchServer")) : class$com$sun$portal$search$admin$mbeans$SearchServer));
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$SearchServer;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.searchServerID = this.getID();
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", (List)path);
            String protocol = pdc.getAttributeValue("PortalDomain.SearchServer", path, "Protocol");
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer", path, "Host");
            this.port = pdc.getAttributeValue("PortalDomain.SearchServer", path, "Port");
            this.instance = pdc.getAttributeValue("PortalDomain.SearchServer", path, "Instance");
            this.searchServerURL = protocol + "://" + this.host + ":" + this.port + "/" + this.searchServerID;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        this.psDir = cc.getPSBaseDir();
        this.searchServerRoot = cc.getPSDataDir() + File.separator + "searchservers" + File.separator + this.searchServerID;
        try {
            if (AdminUtil.isLocal((String)this.host)) {
                this.loadConfig();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getSearchServerID() {
        return this.searchServerID;
    }

    public String getSearchServerRoot() {
        return this.searchServerRoot;
    }

    public String getSearchServerURL() {
        return this.searchServerURL;
    }

    public String getBinDir() {
        return (String)this.searchConfig.get((Object)"bindir");
    }

    public String getLibDir() {
        return (String)this.searchConfig.get((Object)"libdir");
    }

    public String getConfigDir() {
        return this.getSearchServerRoot() + File.separator + "config";
    }

    public String getLogDir() {
        return this.getSearchServerRoot() + File.separator + "logs";
    }

    public String getTmpDir() {
        return this.getSearchServerRoot() + File.separator + "tmp";
    }

    public String getLibPath() {
        return (String)this.searchConfig.get((Object)"libpath");
    }

    public HashMap getConfigMap() {
        return this.searchConfig;
    }

    public String getConfigValue(String key) {
        return (String)this.searchConfig.get((Object)key);
    }

    public void setConfigValue(String key, String value) {
        this.searchConfig.put((Object)key, (Object)value);
        this.storeConfig();
    }

    public void removeConfigValue(String key) {
        this.searchConfig.remove((Object)key);
        this.storeConfig();
    }

    public void loadConfig() {
        this.searchConfig = new OrderedMap();
        try {
            String line;
            String path = this.getSearchServerRoot() + File.separator + "config" + File.separator + "search.conf";
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            int comments = 1;
            while ((line = br.readLine()) != null) {
                if (line.length() != 0) {
                    if (line.charAt(0) == '#') {
                        this.searchConfig.put((Object)("__configComment_" + String.valueOf(comments++)), (Object)line);
                        continue;
                    }
                    int index = line.indexOf("=");
                    if (index != -1) {
                        String key = line.substring(0, index);
                        String value = line.substring(index + 1).trim();
                        if (value.startsWith("\"")) {
                            value = value.substring(1, value.length());
                        }
                        if (value.endsWith("\"")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        this.searchConfig.put((Object)key, (Object)value);
                        continue;
                    }
                    this.searchConfig.put((Object)line, null);
                    continue;
                }
                this.searchConfig.put((Object)("__configComment_" + String.valueOf(comments++)), (Object)line);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public void storeConfig() {
        try {
            String path = this.getSearchServerRoot() + File.separator + "config" + File.separator + "search.conf";
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8")));
            String[] keys = this.searchConfig.getOrderedKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = (String)this.searchConfig.get((Object)key);
                if (!key.startsWith("__configComment_")) {
                    pw.print(key + "=" + PBlock.quotedString((String)value) + "\n");
                    continue;
                }
                pw.print(value + "\n");
            }
            pw.close();
            SearchConfig.init((String)path);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public Properties getVitals() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Properties result = (Properties)msc.getAttribute(this.objectName, "Vitals");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        Properties result = new Properties();
        result.setProperty("url", this.searchServerURL);
        result.setProperty("root", this.searchServerRoot);
        return result;
    }

    public Boolean getDocumentLevelSecurity() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Boolean result = (Boolean)msc.getAttribute(this.objectName, "DocumentLevelSecurity");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        String value = this.getConfigValue("security-mode");
        if (value.equals("OFF")) {
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public void enableDocumentLevelSecurity() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                msc.invoke(this.objectName, "enableDocumentLevelSecurity", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            this.setConfigValue("security-mode", "ON");
        }
    }

    public void disableDocumentLevelSecurity() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                msc.invoke(this.objectName, "disableDocumentLevelSecurity", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            this.setConfigValue("security-mode", "OFF");
        }
    }

    public void createImportAgent(String fileName, String destinationDatabase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{fileName, destinationDatabase};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "createImportAgent", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (fileName == null) {
                String message = "No import agent SOIF file specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (destinationDatabase == null) {
                String message = "No import agent destination database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.create(fileName, destinationDatabase);
        }
    }

    public void createImportAgent(Properties p, String destinationDatabase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{p, destinationDatabase};
                String[] signatures = new String[]{"java.util.Properties", "java.lang.String"};
                msc.invoke(this.objectName, "createImportAgent", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (p == null) {
                String message = "No import agent properties specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (destinationDatabase == null) {
                String message = "No import agent destination database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.create(p, destinationDatabase);
        }
    }

    public void deleteImportAgents(List ids) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.List"};
                msc.invoke(this.objectName, "deleteImportAgents", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (ids == null) {
                ids = new ArrayList();
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.delete(ids);
        }
    }

    public ArrayList getAllImportAgents(List attributes) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{attributes};
                String[] signatures = new String[]{"java.util.List"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getAllImportAgents", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (attributes == null) {
            String message = "No import agent attributes specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (this.importAgent == null) {
            this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
        }
        return this.importAgent.getAll(attributes);
    }

    public Properties getImportAgent(String id, List attributes) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id, attributes};
                String[] signatures = new String[]{"java.lang.String", "java.util.List"};
                Properties result = (Properties)msc.invoke(this.objectName, "getImportAgent", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (id == null) {
            String message = "No import agent specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (attributes == null) {
            String message = "No import agent attributes specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (this.importAgent == null) {
            this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
        }
        return this.importAgent.get(id, attributes);
    }

    public void editImportAgent(String id, String fileName, String destinationDatabase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id, fileName, destinationDatabase};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "editImportAgent", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (id == null) {
                String message = "No import agent ID specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (fileName == null) {
                String message = "No import agent SOIF file specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.edit(id, fileName, destinationDatabase);
        }
    }

    public void editImportAgent(String id, Properties p, String destinationDatabase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id, p, destinationDatabase};
                String[] signatures = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
                msc.invoke(this.objectName, "editImportAgent", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (id == null) {
                String message = "No import agent ID specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (p == null) {
                String message = "No import agent properties specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.edit(id, p, destinationDatabase);
        }
    }

    public void enableImportAgents(List ids) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.List"};
                msc.invoke(this.objectName, "enableImportAgents", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (ids == null) {
                String message = "No import agent IDs specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.enable(ids);
        }
    }

    public void disableImportAgents(List ids) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.List"};
                msc.invoke(this.objectName, "disableImportAgents", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (ids == null) {
                String message = "No import agent IDs specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.disable(ids);
        }
    }

    public void runImportAgents() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                msc.invoke(this.objectName, "runImportAgents", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (this.importAgent == null) {
                this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
            }
            this.importAgent.run();
        }
    }

    public Boolean isImportAgentsRunning() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "isImportAgentsRunning", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (this.importAgent == null) {
            this.importAgent = new ImportAgent(this.searchServerID, this.psDir, this.searchServerRoot, logger);
        }
        return new Boolean(this.importAgent.stillRunning());
    }

    public void createResourceDescription(String fileData, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{fileData, database};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "createResourceDescription", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (fileData == null) {
                String message = "No resource description SOIF file specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (database == null) {
                String message = "No resource description database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
            resourceDescription.create(fileData, database);
        }
    }

    public void createResourceDescription(Map attributes, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{attributes, database};
                String[] signatures = new String[]{"java.util.Map", "java.lang.String"};
                msc.invoke(this.objectName, "createResourceDescription", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (attributes == null) {
                String message = "No resource description attributes specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (database == null) {
                String message = "No resource description database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
            resourceDescription.create(attributes, database);
        }
    }

    public void deleteResourceDescriptions(List urls, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{urls, database};
                String[] signatures = new String[]{"java.util.List", "java.lang.String"};
                msc.invoke(this.objectName, "deleteResourceDescriptions", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (urls == null) {
                String message = "No resource description URLs specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (database == null) {
                String message = "No resource description database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
            resourceDescription.delete(urls, database);
        }
    }

    public ArrayList getAllResourceDescriptions(String searchType, String query, List viewAttributes, Integer startPage, Integer hitsPerPage, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{searchType, query, viewAttributes, startPage, hitsPerPage, database};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.util.List", "java.lang.Integer", "java.lang.Integer", "java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getAllResourceDescriptions", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (searchType == null) {
            searchType = "";
        }
        if (query == null) {
            query = "";
        }
        if (viewAttributes == null) {
            viewAttributes = new ArrayList();
        }
        if (startPage == null) {
            startPage = new Integer(0);
        }
        if (hitsPerPage == null) {
            hitsPerPage = new Integer(0);
        }
        if (database == null) {
            String message = "No resource description database specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
        return resourceDescription.getAll(searchType, query, viewAttributes, startPage, hitsPerPage, database);
    }

    public void editResourceDescriptions(String fileData, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{fileData, database};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "editResourceDescriptions", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (fileData == null) {
                String message = "No resource description SOIF file specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (database == null) {
                String message = "No resource description database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
            resourceDescription.edit(fileData, database);
        }
    }

    public void editResourceDescriptions(List urls, Map attributes, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{urls, attributes, database};
                String[] signatures = new String[]{"java.util.List", "java.util.Map", "java.lang.String"};
                msc.invoke(this.objectName, "editResourceDescriptions", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (urls == null) {
                String message = "No resource description URLs specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (attributes == null) {
                String message = "No resource description attributes specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (database == null) {
                String message = "No resource description database specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            ResourceDescription resourceDescription = new ResourceDescription(this.searchServerRoot, this.searchServerURL, this.getConfigValue("security-mode"), logger);
            resourceDescription.edit(urls, attributes, database);
        }
    }

    public void createSchema(String name, String description, String aliases, Boolean editable, Boolean indexable, String scoreMultiplier, String dataType) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, description, aliases, editable, indexable, scoreMultiplier, dataType};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "createSchema", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (name == null) {
                String message = "No schema attribute specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (description == null) {
                description = "";
            }
            if (aliases == null) {
                aliases = "";
            }
            if (editable == null) {
                editable = new Boolean(false);
            }
            if (indexable == null) {
                indexable = new Boolean(false);
            }
            if (scoreMultiplier == null) {
                scoreMultiplier = "";
            }
            if (dataType == null) {
                dataType = "";
            }
            if (this.schema == null) {
                this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
            }
            this.schema.create(name, description, aliases, editable, indexable, scoreMultiplier, dataType);
        }
    }

    public void deleteSchema(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                msc.invoke(this.objectName, "deleteSchema", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (name == null) {
                String message = "No schema attribute specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (this.schema == null) {
                this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
            }
            this.schema.delete(name);
        }
    }

    public ArrayList getAllSchema() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                ArrayList result = (ArrayList)msc.getAttribute(this.objectName, "AllSchema");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (this.schema == null) {
            this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
        }
        return this.schema.getAll();
    }

    public Properties getSchemaAttributes(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                Properties result = (Properties)msc.invoke(this.objectName, "getSchemaAttributes", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No schema attribute specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (this.schema == null) {
            this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
        }
        return this.schema.getAttributes(name);
    }

    public void setSchemaAttributes(String schemaName, String name, String description, String aliases, Boolean editable, Boolean indexable, String scoreMultiplier, String dataType) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{schemaName, name, description, aliases, editable, indexable, scoreMultiplier, dataType};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
                msc.invoke(this.objectName, "setSchemaAttributes", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (schemaName == null) {
                String message = "No schema attribute specified";
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            if (name == null) {
                name = "";
            }
            if (description == null) {
                description = "";
            }
            if (aliases == null) {
                aliases = "";
            }
            if (editable == null) {
                editable = new Boolean(false);
            }
            if (indexable == null) {
                indexable = new Boolean(false);
            }
            if (scoreMultiplier == null) {
                scoreMultiplier = "";
            }
            if (dataType == null) {
                dataType = "";
            }
            if (this.schema == null) {
                this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
            }
            this.schema.setAttributes(schemaName, name, description, aliases, editable, indexable, scoreMultiplier, dataType);
        }
    }

    public void restoreSchema() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                msc.invoke(this.objectName, "restoreSchema", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        } else {
            if (this.schema == null) {
                this.schema = new Schema(this.psDir, this.getSearchServerRoot(), logger);
            }
            this.schema.restore();
        }
    }

    public String getReport(String logType, Integer lineLimit) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{logType, lineLimit};
                String[] signatures = new String[]{"java.lang.String", "java.lang.Integer"};
                String result = (String)msc.invoke(this.objectName, "getReport", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (logType == null) {
            String message = "Log type not specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (lineLimit == null) {
            lineLimit = new Integer(0);
        }
        Report report = new Report(this.getSearchServerRoot(), logger);
        return report.get(logType, lineLimit);
    }

    public ArrayList getPopularSearch(Boolean cache, Boolean skipBrowse) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{cache, skipBrowse};
                String[] signatures = new String[]{"java.lang.Boolean", "java.lang.Boolean"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getPopularSearch", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (cache == null) {
            cache = new Boolean(false);
        }
        if (skipBrowse == null) {
            skipBrowse = new Boolean(false);
        }
        PopularSearch ps = new PopularSearch(this.getSearchServerRoot(), logger);
        return ps.get(cache, skipBrowse);
    }

    public String runRDManager(String arguments) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{arguments};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "runRDManager", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (arguments == null) {
            String message = "No arguments specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            String command = this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
            String call = this.searchServerRoot + File.separator + command + " rdmgr " + arguments;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(call);
            p.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            int value = p.exitValue();
            if (value != 0) {
                String message = "rdmgr failed with " + value;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public String getStartRobotCommand() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "StartRobotCommand");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return this.searchServerRoot + File.separator + "StartRobot";
    }

    public String getStopRobotCommand() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "StopRobotCommand");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return this.searchServerRoot + File.separator + "StopRobot";
    }

    public String getStartImportAgentCommand() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "StartImportAgentCommand");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return this.searchServerRoot + File.separator + "run-cs-cli importmgr -c " + this.getConfigDir() + File.separator + "search.conf" + " " + this.getConfigValue("csid") + " run all";
    }

    public String getStartAutoclassifyCommand() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "StartAutoclassifyCommand");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        return this.searchServerRoot + File.separator + "run-cs-cli autoclassify -s " + this.searchServerURL + File.separator + "search";
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.startsWith("Windows");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

