/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.RobotMBean;
import com.sun.portal.search.admin.mbeans.tasks.FilterConfigurator;
import com.sun.portal.search.admin.mbeans.tasks.FilterSimulator;
import com.sun.portal.search.robot.ConverterConfig;
import com.sun.portal.search.robot.FilterLog;
import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.ProcessConfig;
import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.robot.StringFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import sun.misc.BASE64Decoder;

public class Robot
extends PSResource
implements RobotMBean {
    public String serverRoot = null;
    public String binDir = null;
    public String libDir = null;
    public String libPath = null;
    public String configDir = null;
    public String logDir = null;
    public String statusDir = "robot";
    private ObjectName objectName = null;
    private String host = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$Robot == null ? (class$com$sun$portal$search$admin$mbeans$Robot = Robot.class$("com.sun.portal.search.admin.mbeans.Robot")) : class$com$sun$portal$search$admin$mbeans$Robot));
    private RobotConfig robotConfig = null;
    private FilterConfigurator filterConfig = null;
    private String[] r_env = null;
    private FilterLog flog = null;
    private String statestring = "";
    private String[] states = new String[]{"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"};
    private boolean isRunning = false;
    static final String SEARCH_CONF = "search.conf";
    static final String ROBOT_CMD = "robot";
    static final String CATPING_CMD = "catping";
    static final String RDREGISTER_CMD = "rdregister";
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    static String[] filtersource = new String[]{"url", "protocol", "host", "path", "MIME"};
    static String[] filtersource_rule = new String[]{"url", "protocol", "host", "uri", "type"};
    static String[] filtermethod = new String[]{"is", "contains", "begins with", "ends with", "regular"};
    static String[] filtermethod_rule = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    private static final String[] crawling_conf = new String[]{"server-delay", "max-connections", "site-max-connections", "index-after-ngenerated", "cmd-Hook", "onCompletion", "email", "loglevel", "user-agent", "enable-robots-txt", "perform-authentication", "username", "password", "proxy-username", "proxy-password", "proxy-type", "proxy-loc", "auto_serv", "http_proxy", "https_proxy", "ftp_proxy", "enable-cookie", "enable-ip", "smart-host-heuristics", "use-dns-cname", "depth", "tmpdir", "robot-state-dir", "remote-access"};
    public static String[] reportLabels = new String[]{"version", "dnscachedump", "performance", "allserversfound", "rdmserverfound", "configuration", "databasestatus", "libnetstatus", "modulesstatus", "overview", "urlreadyforextraction", "urlreadyforindexing", "urlwaitingforfiltering", "urlwaitingforindexing", "all"};
    public static String[] reportQuerys = new String[]{"query?fn=version", "query?fn=dns-mapping", "query?fn=performance", "query?fn=sites-status", "query?fn=rdm-server", "query?fn=run-status", "query?fn=database", "query?fn=libnet", "query?fn=status", "query?fn=robot-states", "query?fn=enum-ready", "query?fn=rdgen-ready", "query?fn=enum-pool", "query?fn=rdgen-pool", "all"};
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$Robot;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer.Robot", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer.Robot", path, "Host");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        try {
            if (AdminUtil.isLocal((String)this.host)) {
                this.initConfig(path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    private void initConfig(List path) throws PSMBeanException {
        try {
            MBeanServer ms = PASModule.getMBeanServer();
            LinkedList serverpath = new LinkedList();
            serverpath.addFirst(path.get(2));
            serverpath.addFirst(path.get(1));
            ObjectName searchServer = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
            this.serverRoot = (String)ms.getAttribute(searchServer, "SearchServerRoot");
            this.binDir = (String)ms.getAttribute(searchServer, "BinDir");
            this.libDir = (String)ms.getAttribute(searchServer, "LibDir");
            this.libPath = (String)ms.getAttribute(searchServer, "LibPath");
            this.configDir = (String)ms.getAttribute(searchServer, "ConfigDir");
            this.logDir = (String)ms.getAttribute(searchServer, "LogDir");
            if (this.serverRoot == null || this.configDir == null) {
                String message = "Robot.init(): fail to initialize robot configuration; either server root is null or config directory is null";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("Robot.initConfig(): initialization failed");
            }
            this.robotConfig = new RobotConfig(this.configDir);
            this.statusDir = this.robotConfig.processConf.get("robot-state-dir");
            if (this.statusDir == null) {
                this.statusDir = this.serverRoot + File.separator + ROBOT_CMD;
            }
            this.filterConfig = new FilterConfigurator(this.serverRoot);
            this.filterConfig.readFilterToArray();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("Robot.initConfig()", e.toString(), (Throwable)e);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String COMSPEC;
            String comSpecVal;
            String winDir = "C:\\WINNT";
            if (System.getProperty("os.name").equals("Windows XP")) {
                winDir = "C:\\WINDOWS";
            }
            this.r_env = new String[6];
            this.r_env[0] = "LD_LIBRARY_PATH=" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ";" + this.binDir;
            String SYSTEMROOT = "SYSTEMROOT";
            String sysRootVal = System.getProperty(SYSTEMROOT);
            if (sysRootVal == null) {
                sysRootVal = winDir;
            }
            if ((comSpecVal = System.getProperty(COMSPEC = "COMSPEC")) == null) {
                comSpecVal = winDir + "\\system32\\cmd.exe";
            }
            this.r_env[4] = SYSTEMROOT + "=" + sysRootVal;
            this.r_env[5] = COMSPEC + "=" + comSpecVal;
        } else {
            this.r_env = new String[4];
            String jss_nss_nspr_cert7_lib = "/usr/lib/mps";
            if (System.getProperty("os.name").startsWith("Linux")) {
                jss_nss_nspr_cert7_lib = "/opt/sun/private/lib";
            }
            this.r_env[0] = "LD_LIBRARY_PATH=/usr/lib:" + jss_nss_nspr_cert7_lib + ":" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ":" + this.binDir;
        }
        this.isRunning = this.isRunning();
    }

    public Boolean start() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "start", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (this.isRunning()) {
            this.isRunning = true;
            return Boolean.TRUE;
        }
        if (this.robotConfig.numRuleset() <= 0) {
            String message = "Robot.start(): there is no robot site set up";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            return Boolean.FALSE;
        }
        if (!this.generate_filter_conf_run(this.configDir + File.separator + "filter.conf", this.configDir + File.separator + "filter.conf.run")) {
            String message = "Robot.start(): failed to create filter.conf.run";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            return Boolean.FALSE;
        }
        if (!this.start_rdregister()) {
            String message = "Robot.start(): failed to start rdregister";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            return Boolean.FALSE;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            String[] cmds = new String[]{this.libDir + File.separator + ROBOT_CMD};
            rt.exec(cmds, this.r_env, new File(this.serverRoot));
            for (int i = 0; i < 10; ++i) {
                try {
                    this.wait(1000L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.isRunning = true;
            return Boolean.TRUE;
        }
        catch (IOException e) {
            String message = "Robot.start(): rt.exec exception: " + e.getMessage();
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            return Boolean.FALSE;
        }
    }

    public Boolean stop() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "stop", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        byte[] result = this.robotURLGet(rCmd, "stop");
        for (int i = 0; i < 10; ++i) {
            try {
                this.wait(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isRunning = false;
        return Boolean.TRUE;
    }

    public Boolean refresh() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "refresh", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        this.states[2] = "0";
        this.states[3] = "0";
        this.states[4] = "0";
        this.states[5] = "0";
        this.states[6] = "0";
        this.states[7] = "0";
        this.states[8] = "0";
        this.states[9] = "0";
        this.states[10] = "0";
        this.states[11] = "0";
        this.states[12] = "0";
        return this.remove_status_files();
    }

    public Boolean pause() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "pause", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        byte[] result = this.robotURLGet(rCmd, "pause");
        return Boolean.TRUE;
    }

    public Boolean resume() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "resume", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        byte[] result = this.robotURLGet(rCmd, "resume");
        return Boolean.TRUE;
    }

    public Boolean isRobotRunning() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "isRobotRunning", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (this.isRunning()) {
            this.isRunning = true;
            return Boolean.TRUE;
        }
        this.isRunning = false;
        return Boolean.FALSE;
    }

    public String[] getRobotStatus() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String[] result = (String[])msc.getAttribute(this.objectName, "RobotStatus");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getRobotStatus()", e.toString(), (Throwable)e);
            }
        }
        if (!this.isRunning && !this.isRunning()) {
            this.states[0] = "Off";
            this.states[1] = Integer.toString(this.robotConfig.numOfStartingPoint(true));
        } else {
            this.states[0] = !this.isRunning ? "Off" : "Running";
            this.states[1] = Integer.toString(this.robotConfig.numOfStartingPoint(true));
            int url_waiting = 0;
            int processed = 0;
            int retrieved = 0;
            int rej_filter = 0;
            int rej_error = 0;
            int generated = 0;
            long generated_bytes = 0L;
            long run_time = 0L;
            byte[] result = this.robotURLGet(rQuery, "robot-states");
            if (result != null) {
                String rs = new String(result);
                StringTokenizer st = new StringTokenizer(rs, "\n");
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (t.startsWith("Robot Status:")) {
                        this.states[0] = t.substring(13).trim();
                        continue;
                    }
                    if (t.startsWith("url-waiting=")) {
                        url_waiting = Integer.parseInt(t.substring(12));
                        continue;
                    }
                    if (t.startsWith("processed=")) {
                        processed = Integer.parseInt(t.substring(10));
                        continue;
                    }
                    if (t.startsWith("retrieved=")) {
                        retrieved = Integer.parseInt(t.substring(10));
                        continue;
                    }
                    if (t.startsWith("reject-by-filter=")) {
                        rej_filter = Integer.parseInt(t.substring(17));
                        continue;
                    }
                    if (t.startsWith("reject-by-error=")) {
                        rej_error = Integer.parseInt(t.substring(16));
                        continue;
                    }
                    if (t.startsWith("generated=")) {
                        generated = Integer.parseInt(t.substring(10));
                        continue;
                    }
                    if (t.startsWith("generated-bytes=")) {
                        generated_bytes = Long.parseLong(t.substring(16));
                        continue;
                    }
                    if (!t.startsWith("run-time=")) continue;
                    run_time = Long.parseLong(t.substring(9));
                }
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(2);
                this.states[2] = nf.format(url_waiting);
                if (run_time > 0L) {
                    this.states[3] = nf.format((float)retrieved / (float)run_time);
                    this.states[5] = nf.format((float)generated / (float)run_time);
                }
                this.states[4] = nf.format(rej_filter + rej_error);
                this.states[6] = nf.format(rej_filter);
                this.states[7] = nf.format(rej_error);
                this.states[8] = nf.format(generated);
                this.states[9] = Long.toString(generated_bytes);
                this.states[10] = nf.format(retrieved);
                if (generated > 0) {
                    this.states[11] = nf.format((float)generated_bytes / (float)generated);
                }
                this.states[12] = Long.toString(run_time);
            }
        }
        return this.states;
    }

    public String getRobotStatusString() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "RobotStatusString");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getRobotStatusString()", e.toString(), (Throwable)e);
            }
        }
        byte[] result = this.robotURLGet(rQuery, "robot-states");
        if (result != null) {
            this.statestring = new String(result);
        }
        return this.statestring;
    }

    public HashMap getSiteRule(FilterRuleset frs) {
        String id = frs.id;
        HashMap<String, Object> robotSite = new HashMap<String, Object>();
        robotSite.put("SiteName", frs.nickname);
        robotSite.put("State", frs.isEnabled());
        robotSite.put("Comments", frs.getComments());
        robotSite.put("DNSTrans", frs.getDNSTranslation());
        robotSite.put("Database", frs.getDatabase());
        LinkedList<String> dgroup = new LinkedList<String>();
        int d = frs.numOfDomains();
        for (int i = 0; i < d; ++i) {
            String domainstring = frs.getDomainByIndex(i);
            if (domainstring == null) continue;
            dgroup.addLast(domainstring);
        }
        robotSite.put("DomainGroup", dgroup);
        robotSite.put("DomainPort", frs.ports);
        robotSite.put("DomainProtocol", frs.getProtocol());
        LinkedList sgroup = new LinkedList();
        int n = frs.numOfServers();
        for (int i = 0; i < n; ++i) {
            String serverstring = frs.getServerByIndex(i);
            if (serverstring == null) continue;
            HashMap<String, String> server = new HashMap<String, String>();
            String host = "";
            try {
                URL url = new URL(serverstring);
                host = url.getHost();
                server.put("Server", url.getHost());
                server.put("Protocol", url.getProtocol());
                if (!url.getProtocol().equalsIgnoreCase("file") && url.getPort() > 0) {
                    server.put("Port", Integer.toString(url.getPort()));
                } else {
                    server.put("Port", "");
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            }
            if (host.trim().length() > 0) {
                FilterSimulator frsim = new FilterSimulator();
                try {
                    String cname = frsim.getHostByName(this.serverRoot, host);
                    server.put("Status", "verified");
                    server.put("RealName", cname);
                }
                catch (Exception e) {
                    server.put("Status", e.getMessage());
                    server.put("RealName", "");
                }
            }
            sgroup.addLast(server);
        }
        robotSite.put("ServerGroup", sgroup);
        LinkedList startpoints = new LinkedList();
        int m = frs.numOfStartingPoints();
        for (int i = 0; i < m; ++i) {
            String sp = frs.getStartingPointByIndex(i);
            if (sp == null) continue;
            HashMap<String, String> start = new HashMap<String, String>();
            start.put("URLString", sp);
            startpoints.addLast(start);
        }
        robotSite.put("StartingPoints", startpoints);
        LinkedList fgroup = new LinkedList();
        int l = frs.numOfFilters();
        for (int i = 0; i < l; ++i) {
            HashMap<String, String> filter = new HashMap<String, String>();
            String fid = frs.getFiltersIDByIndex(i);
            String match = frs.getFiltersonMatchByIndex(i);
            filter.put("FilterID", fid);
            filter.put("FilterNickname", this.robotConfig.getRuleNickname(fid));
            filter.put("FilterMatch", match);
            fgroup.addLast(filter);
        }
        robotSite.put("FilterGroup", fgroup);
        robotSite.put("FilterAllFiles", RobotConfig.ADtoString(frs.onExit));
        return robotSite;
    }

    public HashMap listSites(String id) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id};
                String[] signatures = new String[]{"java.lang.String"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "listSites", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.listSites()", e.toString(), (Throwable)e);
            }
        }
        HashMap<String, HashMap> robotSites = new HashMap<String, HashMap>();
        FilterRuleset frs = null;
        int n = this.robotConfig.numRuleset();
        if (n <= 0) {
            String message = "Robot.listSites(): no robot site has been set up";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
            return null;
        }
        if (!id.equals("") && !id.equals("0")) {
            frs = this.robotConfig.GetRuleSet(id);
            if (frs != null) {
                robotSites.put(id, this.getSiteRule(frs));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                frs = this.robotConfig.GetRuleSet(i);
                if (frs == null) continue;
                robotSites.put(frs.id, this.getSiteRule(frs));
            }
        }
        return robotSites;
    }

    public String createSite(Boolean domain, String sitename, String depthString, String database) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{domain, sitename, depthString, database};
                String[] signatures = new String[]{"java.lang.Boolean", "java.lang.String", "java.lang.String", "java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "createSite", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.createSite()", e.toString(), (Throwable)e);
            }
        }
        if (depthString == null || depthString.equals("")) {
            depthString = "10";
        }
        boolean isDomain = domain;
        int depth = Integer.parseInt(depthString);
        String newRuleID = null;
        String newCreatedID = null;
        try {
            FilterRuleset frs;
            URL url = null;
            if (isDomain) {
                String domainname = this.getValidatedDomain(sitename);
                FilterRuleset frs2 = this.robotConfig.findFiletrRulesetHasDomain(domainname);
                if (frs2 != null) {
                    String message = "Robot.createSite(): domain site " + sitename + " already exists";
                    Object[] tokens = new Object[]{message};
                    logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                    return null;
                }
                url = !(sitename.startsWith("http") || sitename.startsWith("https") || sitename.startsWith("ftp") || sitename.startsWith("file") || sitename.startsWith("gopher")) ? new URL("http", "www." + domainname, 80, "/") : this.getValidatedURL(sitename);
            } else {
                url = this.getValidatedURL(sitename);
                FilterRuleset frs3 = this.robotConfig.findFiletrRulesetHasStartingPoint(url.toString());
                if (frs3 != null) {
                    String message = "Robot.createSite(): the site " + sitename + " already exists";
                    Object[] tokens = new Object[]{message};
                    logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                    return null;
                }
            }
            String path = url.getPath();
            int n = path.lastIndexOf(47);
            if (n >= 0 && path.length() > 1) {
                String path_filter = path.substring(0, n + 1);
                String file_name = path.substring(n + 1);
                if (file_name.indexOf(46) < 0) {
                    path_filter = path;
                }
                newRuleID = this.robotConfig.newPathFilterRule(path_filter);
            }
            if ((frs = this.robotConfig.newRuleset(url, depth, isDomain, newRuleID)) != null) {
                if (database != null && !database.equals("")) {
                    frs.setDatabase(database);
                }
                newCreatedID = frs.id;
            }
            this.robotConfig.updateFile();
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        return newCreatedID;
    }

    public Boolean deleteSite(String id) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteSite", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        boolean b = this.robotConfig.delRuleset(id);
        if (b) {
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean deleteSites(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteSites", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                this.robotConfig.delRuleset(id);
            }
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean enableSites(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "enableSites", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                FilterRuleset frs = this.robotConfig.GetRuleSet(id);
                frs.setEnabled(true);
            }
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean disableSites(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "disableSites", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                FilterRuleset frs = this.robotConfig.GetRuleSet(id);
                frs.setEnabled(false);
            }
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean editSite(String id, String name, String desc, String dns, String database, ArrayList domainGroup, String port, ArrayList protocols, ArrayList serverGroup, ArrayList startPoints, ArrayList defRules, String allfile) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id, name, desc, dns, database, domainGroup, port, protocols, serverGroup, startPoints, defRules, allfile};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.ArrayList", "java.lang.String", "java.util.ArrayList", "java.util.ArrayList", "java.util.ArrayList", "java.util.ArrayList", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "editSite", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        FilterRuleset frs = this.robotConfig.GetRuleSet(id);
        if (frs != null) {
            int i;
            if (name != null && !name.equals("")) {
                frs.nickname = name;
            }
            if (desc != null && !desc.equals("")) {
                frs.removeComment();
                frs.addComments(desc);
            }
            if (dns != null && !dns.equals("")) {
                frs.removeDNSTranslation();
                frs.addDNSTranslation(dns);
            }
            if (database != null && !database.equals("")) {
                frs.setDatabase(database);
            }
            if (domainGroup != null && domainGroup.size() > 0) {
                frs.removeDomains();
                for (i = 0; i < domainGroup.size(); ++i) {
                    String domain = (String)domainGroup.get(i);
                    frs.addDomain(domain.trim());
                }
                if (port != null && !port.equals("")) {
                    frs.ports = port;
                }
                if (protocols != null && protocols.size() > 0) {
                    frs.removeProtocol();
                    for (i = 0; i < protocols.size(); ++i) {
                        frs.addProtocol((String)protocols.get(i));
                    }
                }
            }
            if (serverGroup != null && serverGroup.size() > 0) {
                frs.removeServers();
                for (i = 0; i < serverGroup.size(); ++i) {
                    HashMap server = (HashMap)serverGroup.get(i);
                    String host = (String)server.get("Host");
                    String protocol = (String)server.get("Protocol");
                    String p = (String)server.get("Port");
                    if (host == null || protocol == null || host.trim().length() <= 0) continue;
                    try {
                        int portno = -1;
                        if (p != null && !p.equals("")) {
                            portno = Integer.parseInt(p);
                        }
                        URL url = new URL(protocol, host, portno, "/");
                        frs.addServer(url.toString());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                    }
                }
            }
            if (startPoints.size() > 0) {
                frs.removeStartingPoints();
                for (i = 0; i < startPoints.size(); ++i) {
                    HashMap sp = (HashMap)startPoints.get(i);
                    String startURL = (String)sp.get("URL");
                    String depth = (String)sp.get("Depth");
                    URL url = this.getValidatedURL(startURL);
                    frs.addStartingPoint(url, Integer.parseInt(depth));
                }
            }
            if (defRules.size() > 0) {
                frs.removeFilters();
                for (i = 0; i < defRules.size(); ++i) {
                    HashMap def = (HashMap)defRules.get(i);
                    String ruleID = (String)def.get("Rule");
                    String match = (String)def.get("Match");
                    boolean on_match = false;
                    on_match = match.equalsIgnoreCase("allow");
                    if (ruleID == null || ruleID.trim().length() <= 0) continue;
                    frs.AddFilter(ruleID, on_match);
                }
            }
            if (allfile != null && !allfile.equals("")) {
                frs.onExit = RobotConfig.ADStringtoBoolean(allfile);
            }
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public HashMap getFilterRule(FilterRule fr) {
        String id = fr.id;
        HashMap<String, Object> robotFilter = new HashMap<String, Object>();
        robotFilter.put("FilterId", fr.id);
        robotFilter.put("FilterName", fr.nickname);
        robotFilter.put("FilterDesc", fr.getComments());
        robotFilter.put("State", fr.enable);
        ArrayList defs = new ArrayList();
        int m = fr.numberOfStringFilters();
        for (int i = 0; i < m; ++i) {
            StringFilter sf = (StringFilter)fr.filters.get(i);
            if (sf == null) continue;
            HashMap<String, String> def = new HashMap<String, String>();
            String source = sf.directive;
            int match = 0;
            for (int j = 0; j < filtersource_rule.length; ++j) {
                if (!source.equalsIgnoreCase(filtersource_rule[j])) continue;
                match = j;
            }
            def.put("FilterSource", filtersource[match]);
            String method = FilterRule.getMethodText(sf.method);
            for (int j = 0; j < filtermethod_rule.length; ++j) {
                if (!method.equalsIgnoreCase(filtermethod_rule[j])) continue;
                match = j;
            }
            def.put("FilterMethod", filtermethod[match]);
            def.put("FilterString", sf.filter);
            defs.add(def);
        }
        robotFilter.put("FilterDef", defs);
        robotFilter.put("NewSite", fr.quickcf);
        robotFilter.put("Include", fr.default_ad);
        String[] ids = this.robotConfig.getFiletrRulesetIDsForFilterRule(id);
        int j = 0;
        if (ids != null) {
            StringBuffer buf = new StringBuffer();
            for (j = 0; j < ids.length; ++j) {
                FilterRuleset frs = this.robotConfig.GetRuleSet(ids[j]);
                buf.append(frs.nickname);
                if (j >= ids.length - 1) continue;
                buf.append(",");
            }
            robotFilter.put("DeploymentNum", Integer.toString(j));
            robotFilter.put("Deployment", buf.toString());
        } else {
            robotFilter.put("Deployment", "");
        }
        return robotFilter;
    }

    public ArrayList listFilters(String id) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id};
                String[] signatures = new String[]{"java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "listFilters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.listFilters", e.toString(), (Throwable)e);
            }
        }
        FilterRule fr = null;
        ArrayList<HashMap> robotFilters = new ArrayList<HashMap>();
        int n = this.robotConfig.numOfRules();
        if (n <= 0) {
            String message = "Robot.listFilters(): no robot filter has been set up";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
            return null;
        }
        if (!id.equals("") && !id.equals("0")) {
            fr = this.robotConfig.GetRule(id);
            if (fr != null) {
                robotFilters.add(this.getFilterRule(fr));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fr = this.robotConfig.GetRuleByIndex(i);
                if (fr == null) continue;
                robotFilters.add(this.getFilterRule(fr));
            }
        }
        return robotFilters;
    }

    public String createFilter(String name, String desc, Boolean isDefault, Boolean includeMatch, ArrayList defrules) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, desc, isDefault, includeMatch, defrules};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.util.ArrayList"};
                String result = (String)msc.invoke(this.objectName, "createFilter", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.createFilter", e.toString(), (Throwable)e);
            }
        }
        String existID = this.robotConfig.getIDByNick(name);
        if (existID != null) {
            String message = "Robot.createFilter(): filter name " + name + " already exists";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        boolean isdefault = isDefault != null ? isDefault : true;
        boolean include = includeMatch != null ? includeMatch : false;
        String filterID = Integer.toString(this.robotConfig.lastRuleID + 1);
        FilterRule fr = new FilterRule(filterID, true, name, include, isdefault);
        fr.setComments(desc);
        for (int j = 0; j < defrules.size(); ++j) {
            HashMap def = (HashMap)defrules.get(j);
            String source = (String)def.get("FilterSource");
            String method = (String)def.get("FilterMethod");
            String pattern = (String)def.get("FilterString");
            boolean validsource = false;
            int match = 0;
            for (int i = 0; i < filtersource.length; ++i) {
                if (!source.equalsIgnoreCase(filtersource[i])) continue;
                validsource = true;
                match = i;
            }
            if (!validsource) {
                throw new PSMBeanException("Robot.createFilter(): Invalid filter source type.");
            }
            source = filtersource_rule[match];
            boolean validmethod = false;
            for (int i = 0; i < filtermethod.length; ++i) {
                if (!method.equalsIgnoreCase(filtermethod[i])) continue;
                validmethod = true;
                match = i;
            }
            if (!validmethod) {
                throw new PSMBeanException("Robot.createFilter(): Invalid filter method type.");
            }
            method = filtermethod_rule[match];
            if (pattern == null || pattern.trim().length() <= 0) continue;
            fr.addFilter(source, method, pattern.trim());
        }
        this.robotConfig.AddRule(filterID, fr);
        this.robotConfig.updateFile();
        this.robotConfig.freshRulesArray();
        return filterID;
    }

    public Boolean deleteFilter(String id) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteFilter", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        boolean b = this.robotConfig.delRule(id);
        if (b) {
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean deleteFilters(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteFilters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                this.robotConfig.delRule(id);
            }
            this.robotConfig.updateFile();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean enableFilters(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "enableFilters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                FilterRule fr = this.robotConfig.GetRule(id);
                fr.enable = true;
            }
            this.robotConfig.updateFile();
            this.robotConfig.freshRulesArray();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean disableFilters(ArrayList ids) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteFilters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                FilterRule fr = this.robotConfig.GetRule(id);
                fr.enable = false;
            }
            this.robotConfig.updateFile();
            this.robotConfig.freshRulesArray();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean editFilter(String id, String name, String desc, Boolean isDefault, Boolean includeMatch, ArrayList defrules) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{id, name, desc, isDefault, includeMatch, defrules};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "editFilter", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        FilterRule fr = null;
        fr = this.robotConfig.GetRule(id);
        if (!name.equals("")) {
            fr.nickname = name;
        }
        if (!desc.equals("")) {
            fr.setComments(desc);
        }
        fr.quickcf = isDefault != null ? isDefault : true;
        fr.default_ad = includeMatch != null ? includeMatch : false;
        if (defrules.size() > 0) {
            fr.removeAllFilter();
            for (int j = 0; j < defrules.size(); ++j) {
                HashMap def = (HashMap)defrules.get(j);
                String source = (String)def.get("FilterSource");
                String method = (String)def.get("FilterMethod");
                String pattern = (String)def.get("FilterString");
                boolean validsource = false;
                int match = 0;
                for (int i = 0; i < filtersource.length; ++i) {
                    if (!source.equalsIgnoreCase(filtersource[i])) continue;
                    validsource = true;
                    match = i;
                }
                if (!validsource) {
                    throw new PSMBeanException("Robot.editFilter(): Invalid filter source type.");
                }
                source = filtersource_rule[match];
                boolean validmethod = false;
                for (int i = 0; i < filtermethod.length; ++i) {
                    if (!method.equalsIgnoreCase(filtermethod[i])) continue;
                    validmethod = true;
                    match = i;
                }
                if (!validmethod) {
                    throw new PSMBeanException("Robot.editFilter(): Invalid filter method type.");
                }
                method = filtermethod_rule[match];
                if (pattern == null || pattern.trim().length() <= 0) continue;
                fr.addFilter(source, method, pattern.trim());
            }
        }
        this.robotConfig.updateFile();
        this.robotConfig.freshRulesArray();
        return Boolean.TRUE;
    }

    public String getCrawlingConfig(String attrname) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{attrname};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getCrawlingConfig", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return null;
            }
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        return processConf.get(attrname);
    }

    public Boolean setCrawlingConfig(String attrname, String attrvalue) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{attrname, attrvalue};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setCrawlingConfig", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        processConf.put(attrname, attrvalue);
        processConf.updateFile();
        return Boolean.TRUE;
    }

    public HashMap getCrawlingConfigMap() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                HashMap result = (HashMap)msc.getAttribute(this.objectName, "CrawlingConfigMap");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getCrawlingConfigMap()", e.toString(), (Throwable)e);
            }
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        BASE64Decoder dec = new BASE64Decoder();
        HashMap<String, String> configmap = new HashMap<String, String>();
        configmap.put("server-delay", processConf.get("server-delay"));
        configmap.put("max-connections", processConf.get("max-connections"));
        configmap.put("site-max-connections", processConf.get("site-max-connections"));
        configmap.put("index-after-ngenerated", processConf.get("index-after-ngenerated"));
        configmap.put("cmd-Hook", processConf.get("cmd-Hook"));
        configmap.put("onCompletion", processConf.get("onCompletion"));
        configmap.put("email", processConf.get("email"));
        String loglevel = processConf.get("loglevel");
        if (loglevel == null) {
            loglevel = "1";
        }
        configmap.put("loglevel", loglevel);
        configmap.put("user-agent", processConf.get("user-agent"));
        configmap.put("enable-robots-txt", processConf.get("enable-robots-txt"));
        configmap.put("perform-authentication", processConf.get("perform-authentication"));
        configmap.put("username", processConf.get("username"));
        String RobotPassDecoded = null;
        String robotPassword = processConf.get("password");
        if (robotPassword != null) {
            try {
                RobotPassDecoded = new String(dec.decodeBuffer(robotPassword));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            }
        }
        configmap.put("password", RobotPassDecoded);
        configmap.put("proxy-username", processConf.get("proxy-username"));
        String userPassDecoded = null;
        String proxyUserPassword = processConf.get("proxy-password");
        if (proxyUserPassword != null) {
            try {
                userPassDecoded = new String(dec.decodeBuffer(proxyUserPassword));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            }
        }
        configmap.put("proxy-password", userPassDecoded);
        configmap.put("proxy-type", processConf.get("proxy-type"));
        configmap.put("proxy-loc", processConf.get("proxy-loc"));
        configmap.put("auto_serv", processConf.get("auto_serv"));
        configmap.put("http_proxy", processConf.get("http_proxy"));
        configmap.put("https_proxy", processConf.get("https_proxy"));
        configmap.put("ftp_proxy", processConf.get("ftp_proxy"));
        configmap.put("enable-cookie", processConf.get("enable-cookie"));
        configmap.put("enable-ip", processConf.get("enable-ip"));
        configmap.put("smart-host-heuristics", processConf.get("smart-host-heuristics"));
        configmap.put("use-dns-cname", processConf.get("use-dns-cname"));
        configmap.put("depth", processConf.get("depth"));
        configmap.put("tmpdir", processConf.get("tmpdir"));
        configmap.put("robot-state-dir", processConf.get("robot-state-dir"));
        configmap.put("remote-access", processConf.get("remote-access"));
        configmap.put("htmlLink", this.filterConfig.getFilterConfVars("Enumerate", "enumerate-urls", "enable", "true"));
        configmap.put("plainLink", this.filterConfig.getFilterConfVars("Enumerate", "enumerate-urls-from-text", "enable", "false"));
        configmap.put("maxHtmlLink", this.filterConfig.getFilterConfVars("Enumerate", "enumerate-urls", "max", "1024"));
        configmap.put("maxPlainLink", this.filterConfig.getFilterConfVars("Enumerate", "enumerate-urls-from-text", "max", "1024"));
        return configmap;
    }

    public Boolean setCrawlingConfigMap(HashMap configmap) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{configmap};
                String[] signatures = new String[]{"java.util.HashMap"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setCrawlingConfigMap", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        String tp = null;
        String ac = null;
        String as = null;
        String http_proxy = null;
        String https_proxy = null;
        String ftp_proxy = null;
        ProcessConfig processConf = this.robotConfig.processConf;
        Iterator it = configmap.keySet().iterator();
        while (it.hasNext()) {
            String attrname = (String)it.next();
            String attrvalue = (String)configmap.get(attrname);
            if (attrname.equalsIgnoreCase("htmlLink")) {
                this.filterConfig.setFilterConfVars("Enumerate", "enumerate-urls", "enable", attrvalue);
            } else if (attrname.equalsIgnoreCase("plainLink")) {
                this.filterConfig.setFilterConfVars("Enumerate", "enumerate-urls-from-text", "enable", attrvalue);
            } else if (attrname.equalsIgnoreCase("maxHtmlLink")) {
                this.filterConfig.setFilterConfVars("Enumerate", "enumerate-urls", "max", attrvalue);
            } else if (attrname.equalsIgnoreCase("maxPlainLink")) {
                this.filterConfig.setFilterConfVars("Enumerate", "enumerate-urls-from-text", "max", attrvalue);
            } else {
                processConf.put(attrname, attrvalue);
            }
            if (attrname.equals("proxy-type")) {
                tp = attrvalue;
            }
            if (attrname.equals("proxy-loc")) {
                ac = attrvalue;
            }
            if (attrname.equals("auto_serv")) {
                as = attrvalue;
            }
            if (attrname.equals("http_proxy")) {
                http_proxy = attrvalue;
            }
            if (attrname.equals("https_proxy")) {
                https_proxy = attrvalue;
            }
            if (!attrname.equals("ftp_proxy")) continue;
            ftp_proxy = attrvalue;
        }
        String ap = null;
        try {
            ap = this.setRobotPacFile(tp, ac, as, http_proxy, https_proxy, ftp_proxy);
        }
        catch (Exception e) {
            String message = "Robot.setCrawlingConfigMap(): failed to setRobotPacFile";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
        }
        processConf.put("auto-proxy", ap);
        processConf.updateFile();
        this.filterConfig.updateFilterConf();
        return Boolean.TRUE;
    }

    public ArrayList getScriptLaunchOptions() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                ArrayList result = (ArrayList)msc.getAttribute(this.objectName, "ScriptLaunchOptions");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return null;
            }
        }
        ArrayList ScriptLaunchOptions = new ArrayList();
        try {
            File pathName = new File(this.binDir);
            String[] scriptsAvail = pathName.list();
            for (int i = 0; i < scriptsAvail.length; ++i) {
                if (scriptsAvail[i].length() < 7 || !scriptsAvail[i].substring(0, 7).equals("cmdHook")) continue;
                try {
                    BufferedReader br = new BufferedReader(new FileReader(this.binDir + File.separator + scriptsAvail[i]));
                    String line = null;
                    String descLine = null;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("#")) continue;
                        line = line.substring(1);
                        if (!(line = line.trim()).startsWith("description")) continue;
                        descLine = line.substring(12);
                    }
                    br.close();
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("OptionLabel", descLine);
                    option.put("OptionValue", this.binDir + File.separator + scriptsAvail[i]);
                    ScriptLaunchOptions.add(option);
                    continue;
                }
                catch (Exception e) {
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("OptionLabel", "[" + scriptsAvail[i] + "]");
                    option.put("OptionValue", this.binDir + File.separator + scriptsAvail[i]);
                    ScriptLaunchOptions.add(option);
                    String message = "Robot.getScriptLaunchOptions(): cannot open the file " + this.binDir + File.separator + scriptsAvail[i];
                    Object[] tokens = new Object[]{message};
                    logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "PSSH_CSPSAMB0003", e);
        }
        return ScriptLaunchOptions;
    }

    public HashMap getIndexingConfigMap() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                HashMap result = (HashMap)msc.getAttribute(this.objectName, "IndexingConfigMap");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getIndexingConfigMap()", e.toString(), (Throwable)e);
            }
        }
        HashMap<String, String> indexConfig = new HashMap<String, String>();
        String bytesIndex = this.filterConfig.getFilterConfVars("Generate", "extract-html-text", "truncate", "0");
        indexConfig.put("IndexBytes", bytesIndex);
        if (bytesIndex.equals("0")) {
            indexConfig.put("Index", "full");
        } else {
            indexConfig.put("Index", "partial");
        }
        String toc = this.filterConfig.getFilterConfVars("Generate", "extract-html-toc", "enable", "true");
        if (toc.equalsIgnoreCase("true")) {
            indexConfig.put("ExtractTOC", "true");
        } else {
            indexConfig.put("ExtractTOC", "false");
        }
        String meta = this.filterConfig.getFilterConfVars("Generate", "extract-html-meta", "enable", "true");
        if (meta.equalsIgnoreCase("true")) {
            indexConfig.put("ExtractMETA", "true");
        } else {
            indexConfig.put("ExtractMETA", "false");
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        String allowNoClass = processConf.get("allow-nonexist-classification");
        if (allowNoClass != null) {
            if (!allowNoClass.equalsIgnoreCase("true") && !allowNoClass.equalsIgnoreCase("yes")) {
                indexConfig.put("AllowNoClass", "false");
            } else {
                indexConfig.put("AllowNoClass", "true");
            }
        } else {
            indexConfig.put("AllowNoClass", "true");
        }
        indexConfig.put("ConvertTimeout", processConf.get("convert-timeout"));
        return indexConfig;
    }

    public Boolean setIndexingConfigMap(HashMap configmap) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{configmap};
                String[] signatures = new String[]{"java.util.HashMap"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setIndexingConfigMap", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        String indextext = (String)configmap.get("Index");
        if (indextext.equals("full")) {
            this.filterConfig.setFilterConfVars("Generate", "extract-full-text", "truncate", "0");
            this.filterConfig.setFilterConfVars("Generate", "extract-html-text", "truncate", "0");
        } else {
            this.filterConfig.setFilterConfVars("Generate", "extract-full-text", "truncate", (String)configmap.get("IndexBytes"));
            this.filterConfig.setFilterConfVars("Generate", "extract-html-text", "truncate", (String)configmap.get("IndexBytes"));
        }
        this.filterConfig.setFilterConfVars("Generate", "extract-html-toc", "enable", (String)configmap.get("ExtractTOC"));
        this.filterConfig.setFilterConfVars("Generate", "extract-html-meta", "enable", (String)configmap.get("ExtractMETA"));
        this.filterConfig.updateFilterConf();
        ProcessConfig processConf = this.robotConfig.processConf;
        processConf.put("allow-nonexist-classification", (String)configmap.get("AllowNoClass"));
        processConf.put("convert-timeout", (String)configmap.get("ConvertTimeout"));
        processConf.updateFile();
        return Boolean.TRUE;
    }

    public ArrayList listConverters() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "listConverters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.listConverters()", e.toString(), (Throwable)e);
            }
        }
        ConverterConfig cc = this.robotConfig.convertConf;
        ArrayList converters = new ArrayList();
        for (int i = 0; i < cc.numOfDocs(); ++i) {
            LinkedList<Object> converter = new LinkedList<Object>();
            converter.add(cc.getDocLabel(i));
            if (cc.getDocEnable(i)) {
                converter.add(Boolean.TRUE);
            } else {
                converter.add(Boolean.FALSE);
            }
            converters.add(converter);
        }
        return converters;
    }

    public Boolean setConverters(ArrayList converters) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{converters};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setConverters", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        ConverterConfig cc = this.robotConfig.convertConf;
        for (int i = 0; i < converters.size(); ++i) {
            LinkedList converter = (LinkedList)converters.get(i);
            Boolean enable = (Boolean)converter.get(1);
            if (enable.booleanValue()) {
                cc.setDocEnable(i, true);
                continue;
            }
            cc.setDocEnable(i, false);
        }
        cc.updateFile();
        return Boolean.TRUE;
    }

    public Boolean setConverter(String converter, String enable) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{converter, enable};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setConverter", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        int id = Integer.parseInt(converter);
        ConverterConfig cc = this.robotConfig.convertConf;
        if (enable.equalsIgnoreCase("no") || enable.equalsIgnoreCase("false")) {
            cc.setDocEnable(id, false);
        }
        if (enable.equalsIgnoreCase("yes") || enable.equalsIgnoreCase("true")) {
            cc.setDocEnable(id, true);
        }
        cc.updateFile();
        return Boolean.TRUE;
    }

    public String getConverterTimeout() throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "ConverterTimeout");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return "";
            }
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        return processConf.get("convert-timeout");
    }

    public Boolean setConverterTimeout(String timeout) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{timeout};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setConverterTimeout", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        ProcessConfig processConf = this.robotConfig.processConf;
        processConf.put("convert-timeout", timeout);
        processConf.updateFile();
        return Boolean.TRUE;
    }

    public HashMap runSimulator(String siteURL, Boolean checkDNS, Boolean checkRedirect) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{siteURL, checkDNS, checkRedirect};
                String[] signatures = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Boolean"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "runSimulator", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.runSimulator()", e.toString(), (Throwable)e);
            }
        }
        ArrayList<String> alist = new ArrayList<String>();
        if (siteURL.equals("")) {
            int size = this.robotConfig.numRuleset();
            for (int i = 0; i < size; ++i) {
                FilterRuleset frs = this.robotConfig.GetRuleSet(i);
                if (!frs.isEnabled()) continue;
                int numOfServers = frs.numOfServers();
                for (int j = 0; j < numOfServers; ++j) {
                    String s = frs.getServerByIndex(j);
                    alist.add(s);
                }
            }
        } else {
            alist.add(this.getValidatedURL(siteURL).toString());
        }
        return this.runSimulator(alist, checkDNS, checkRedirect);
    }

    public HashMap runSimulator(ArrayList alist, Boolean checkDNS, Boolean checkRedirect) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{alist, checkDNS, checkRedirect};
                String[] signatures = new String[]{"java.util.ArrayList", "java.lang.Boolean", "java.lang.Boolean"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "runSimulator", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.runSimulator()", e.toString(), (Throwable)e);
            }
        }
        if (alist != null) {
            for (int i = 0; i < alist.size(); ++i) {
                String urlstring = (String)alist.get(i);
                alist.set(i, this.getValidatedURL(urlstring).toString());
            }
        }
        String[] urls = alist.toArray(new String[0]);
        HashMap<String, Object> result_map = new HashMap<String, Object>();
        boolean check_dns = checkDNS;
        boolean check_redirect = checkRedirect;
        FilterSimulator frsim = new FilterSimulator();
        ProcessConfig pconf = this.robotConfig.processConf;
        String shh = pconf.get("smart-host-heuristics");
        boolean is_shh = shh.equalsIgnoreCase("true");
        try {
            for (int i = 0; i < urls.length; ++i) {
                HashMap url_map = frsim.runSimu(is_shh, this.serverRoot, urls[i], check_dns, check_redirect);
                result_map.put(urls[i], url_map);
            }
        }
        catch (Exception e) {
            String message = "Robot.runSimulator(): fail to run simulator";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("Robot.runSimulator()", e.toString(), (Throwable)e);
        }
        result_map.put("smart-host-heuristics", shh);
        return result_map;
    }

    public String[] getFilterRuleNames() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String[] result = (String[])msc.getAttribute(this.objectName, "FilterRuleNames");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getFilterRuleNames()", e.toString(), (Throwable)e);
            }
        }
        return this.robotConfig.getRuleNicknames();
    }

    public String[] getFilterRuleIds() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String[] result = (String[])msc.getAttribute(this.objectName, "FilterRuleIds");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getFilterRuleIds()", e.toString(), (Throwable)e);
            }
        }
        return this.robotConfig.getRuleIDs();
    }

    public HashMap verifyServerName(String host) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{host};
                String[] signatures = new String[]{"java.lang.String"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "verifyServerName", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.verifyServerName()", e.toString(), (Throwable)e);
            }
        }
        HashMap<String, String> server = new HashMap<String, String>();
        if (host.trim().length() > 0) {
            FilterSimulator frsim = new FilterSimulator();
            try {
                String cname = frsim.getHostByName(this.serverRoot, host);
                server.put("Status", "verified");
                server.put("RealName", cname);
            }
            catch (Exception e) {
                server.put("Status", e.getMessage());
                server.put("RealName", "");
            }
        }
        return server;
    }

    public String getAdvanceReport(String reportType) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{reportType};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getAdvanceReport", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getAdvanceReport()", e.toString(), (Throwable)e);
            }
        }
        String str = "";
        try {
            if (reportType.compareTo("all") != 0) {
                int match = 0;
                for (int i = 0; i < reportQuerys.length - 1; ++i) {
                    if (!reportType.equalsIgnoreCase(reportLabels[i])) continue;
                    match = i;
                }
                byte[] r = this.robotURLGet(reportQuerys[match] + "&format=i18n");
                str = new String(r, "UTF-8");
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < reportQuerys.length - 1; ++i) {
                    byte[] r = this.robotURLGet(reportQuerys[i] + "&format=i18n");
                    String s = new String(r, "UTF-8");
                    buffer.append(s);
                }
                str = buffer.toString();
            }
        }
        catch (Exception e) {
            String message = "Robot.getAdvancedReport(): failed";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0002", tokens);
        }
        return str;
    }

    public HashMap getExcludedURLsReportDates() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                HashMap result = (HashMap)msc.getAttribute(this.objectName, "ExcludedURLsReportDates");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getExcludedURLsReportDates()", e.toString(), (Throwable)e);
            }
        }
        HashMap<String, Date> datemap = new HashMap<String, Date>();
        this.flog = new FilterLog(this.logDir + File.separator + "filter.log");
        ArrayList dates = this.flog.getRunArrayList();
        for (int i = 0; i < dates.size(); ++i) {
            Date date = (Date)dates.get(i);
            datemap.put(FilterLog.df.format(date), date);
        }
        return datemap;
    }

    public HashMap getExcludedURLsReport(String date) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{date};
                String[] signatures = new String[]{"java.lang.String"};
                HashMap result = (HashMap)msc.invoke(this.objectName, "getExcludedURLsReport", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Robot.getExcludedURLsReport()", e.toString(), (Throwable)e);
            }
        }
        HashMap<String, ArrayList> resultmap = new HashMap<String, ArrayList>();
        this.flog = new FilterLog(this.logDir + File.separator + "filter.log", date);
        String[] reasons = this.flog.getReasons();
        for (int i = 0; i < reasons.length; ++i) {
            this.flog = new FilterLog(this.logDir + File.separator + "filter.log", date, i);
            resultmap.put(reasons[i], this.flog.getFilteredURL());
        }
        return resultmap;
    }

    public boolean isRunning() {
        String robotProcName = "robot.exe";
        if (System.getProperty("os.name").startsWith("Windows")) {
            robotProcName = "robot.exe";
        }
        return this.isRunning("robot.pid", robotProcName);
    }

    public boolean isRunning(String pidFilePath, String cmd) {
        String pid = this.Read1stLine(pidFilePath);
        String catping = null;
        if (pid == null) {
            String message = "Robot.isRunning(): " + pidFilePath + " is null";
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            catping = this.libDir + File.separator + CATPING_CMD + " " + pid + " " + cmd;
            String[] cmds = new String[]{this.libDir + File.separator + CATPING_CMD, pid, cmd};
            Process p = rt.exec(cmds, this.r_env);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            }
            int exitValue = p.exitValue();
            if (exitValue == 1) {
                return false;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return false;
        }
        return true;
    }

    public boolean generate_filter_conf_run(String fc, String fcr) {
        try {
            File file = new File(fc);
            if (!file.exists()) {
                return false;
            }
            Runtime rt = Runtime.getRuntime();
            String cmd = this.libDir + File.separator + "rcpp " + fc + " " + fcr;
            String[] cmds = new String[]{this.libDir + File.separator + "rcpp", fc, fcr};
            try {
                Process ps = rt.exec(cmds, this.r_env, new File(this.serverRoot));
                ps.waitFor();
                if (ps.exitValue() != 0) {
                    return false;
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return false;
        }
        return true;
    }

    public boolean start_rdregister() {
        String rdProcName = RDREGISTER_CMD;
        if (System.getProperty("os.name").startsWith("Windows")) {
            rdProcName = "rdregister.exe";
        }
        if (this.isRunning("rdregister.pid", rdProcName)) {
            return true;
        }
        try {
            File file;
            String robot_path = this.robotConfig.processConf.get("robot-state-dir");
            if (robot_path == null) {
                robot_path = this.serverRoot + File.separator + ROBOT_CMD;
            }
            if (!(file = new File(robot_path)).exists()) {
                String message = "Robot.start_rdregister(): path robot-state-dir does not exist";
                Object[] tokens = new Object[]{message};
                logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
                return false;
            }
            Runtime rt = Runtime.getRuntime();
            String cmd = this.libDir + File.separator + RDREGISTER_CMD + " -f " + this.configDir + File.separator + SEARCH_CONF + " -p " + robot_path;
            String[] cmds = new String[]{this.libDir + File.separator + RDREGISTER_CMD, "-f", this.configDir + File.separator + SEARCH_CONF, "-p", robot_path};
            try {
                Process ps = rt.exec(cmds, this.r_env, new File(this.serverRoot));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return false;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return false;
        }
        return true;
    }

    public byte[] robotURLGet(String cmd, String fn) {
        return this.robotURLGet(cmd + "?fn=" + fn);
    }

    public byte[] robotURLGet(String cmd) {
        try {
            BufferedInputStream in;
            String base = this.Read1stLine("robotbase.cmd");
            if (base == null) {
                return null;
            }
            URL command_url = new URL("http://" + base + "/robot/" + cmd);
            URLConnection url_conn = command_url.openConnection();
            int len = 1024;
            boolean offset = false;
            byte[] buff = new byte[len];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                in = new BufferedInputStream(url_conn.getInputStream());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return null;
            }
            try {
                int n;
                while ((n = ((InputStream)in).read(buff, 0, len)) >= 0) {
                    bos.write(buff, 0, n);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return null;
            }
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return null;
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return null;
        }
    }

    public boolean remove_status_files() {
        boolean status = true;
        if (this.isRunning()) {
            return false;
        }
        File f = new File(this.statusDir);
        if (f.isDirectory()) {
            RobotStatusFileFilter ff = new RobotStatusFileFilter();
            File[] files = f.listFiles(ff);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                status = false;
            }
        }
        return status;
    }

    private String Read1stLine(String filename) {
        try {
            FileReader in = new FileReader(this.serverRoot + File.separator + "logs" + File.separator + filename);
            BufferedReader lr = new BufferedReader(in);
            String firstLine = lr.readLine();
            return firstLine;
        }
        catch (Exception e) {
            String message = "Robot.Read1stLine(): cannot find the file: " + e.getMessage();
            Object[] tokens = new Object[]{message};
            logger.log(Level.INFO, "PSSH_CSPSAMB0001", tokens);
            return null;
        }
    }

    public String setRobotPacFile(String tp, String ac, String as, String http_proxy, String https_proxy, String ftp_proxy) throws IOException {
        String ap = null;
        File robotPac = new File(this.serverRoot + File.separator + "config" + File.separator + "robot.pac");
        if (tp.equals("auto") && ac.equals("local")) {
            ap = "file:" + as;
        }
        if (tp.equals("direct")) {
            robotPac.delete();
            ap = "";
        }
        if (tp.equals("auto") && ac.equals("server")) {
            robotPac.delete();
            ap = as;
        }
        if (tp.equals("manual")) {
            PrintWriter out = null;
            try {
                FileOutputStream rpac = new FileOutputStream(robotPac);
                out = new PrintWriter(rpac, true);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "PSSH_CSPSA0013", e.getMessage());
                return ap;
            }
            out.print("function FindProxyForURL(url, host, method)  {\n");
            out.print("var protocol = url.split(\":\")[0].toLowerCase();\n\n");
            out.print("if(\"http\" == protocol) ");
            if (http_proxy != null) {
                out.print("return \"PROXY " + http_proxy + "\";\n");
            } else {
                out.print("return \"DIRECT\";\n");
            }
            out.print("if(\"https\" == protocol) ");
            if (https_proxy != null) {
                out.print("return \"PROXY " + https_proxy + "\";\n");
            } else {
                out.print("return \"DIRECT\";\n");
            }
            out.print("if(\"ftp\" == protocol) ");
            if (ftp_proxy != null) {
                out.print("return \"PROXY " + ftp_proxy + "\";\n");
            } else {
                out.print("return \"DIRECT\";\n");
            }
            out.print("else return \"DIRECT\";\n}\n");
            out.close();
            ap = "file:" + robotPac;
        }
        return ap;
    }

    public String getValidatedDomain(String sitename) {
        String domainname = sitename;
        if (sitename.startsWith("http") || sitename.startsWith("https") || sitename.startsWith("ftp") || sitename.startsWith("file") || sitename.startsWith("gopher")) {
            String[] t;
            String[] temp;
            String[] tmp = sitename.split(":");
            if (tmp.length > 1) {
                domainname = sitename.substring(tmp[0].length() + 3);
            }
            if ((temp = domainname.split(":")).length > 1) {
                domainname = temp[0];
            }
            if ((t = domainname.split(".")).length > 1) {
                String s1;
                domainname = s1 = domainname.substring(t[0].length() + 1);
            }
        } else {
            domainname = sitename.charAt(0) == '*' ? sitename.substring(2) : sitename;
        }
        return domainname;
    }

    public URL getValidatedURL(String sitename) {
        URL url = null;
        String urlstring = sitename = sitename.replace('\\', '/');
        int i = sitename.indexOf("://");
        if (i < 0) {
            if (sitename.startsWith("file:")) {
                int j = sitename.indexOf(":/");
                urlstring = "file://localhost" + sitename.substring(j + 1);
            } else {
                urlstring = sitename.startsWith("//") ? "file:" + sitename : (sitename.startsWith("/") ? "file://localhost" + sitename : "http://" + sitename);
            }
        }
        if (sitename.startsWith("file://")) {
            if (sitename.startsWith("file:///")) {
                int k = sitename.indexOf(":///");
                urlstring = "file://localhost" + sitename.substring(k + 3);
            } else if (!sitename.substring(7, 15).equalsIgnoreCase("localhost")) {
                urlstring = "file://localhost" + sitename.substring(16);
            }
        }
        try {
            url = new URL(urlstring);
            int port = url.getPort();
            String host = url.getHost();
            String path = url.getPath();
            if (port < 0 && !url.getProtocol().equalsIgnoreCase("file")) {
                port = url.getDefaultPort();
            }
            if (path == null || path.length() == 0) {
                path = "/";
            }
            if (host == null || host.length() == 0) {
                host = "localhost";
            }
            if (!url.getProtocol().equals("file")) {
                url = new URL(url.getProtocol(), host, port, path);
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RobotStatusFileFilter
    implements FileFilter {
        RobotStatusFileFilter() {
        }

        public boolean accept(File path) {
            return path.getName().startsWith("__db.") || path.getName().endsWith(".db");
        }
    }
}

