/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.DatabaseMBean;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class Database
extends PSResource
implements DatabaseMBean {
    private ObjectName objectName = null;
    private String host = null;
    private String searchServerID = null;
    private String searchServerRoot = null;
    private ArrayList databases = null;
    private Date lastUpdated = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$Database == null ? (class$com$sun$portal$search$admin$mbeans$Database = Database.class$("com.sun.portal.search.admin.mbeans.Database")) : class$com$sun$portal$search$admin$mbeans$Database));
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$Database;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.searchServerID = (String)path.get(1);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer.Database", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer.Database", path, "Host");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        this.searchServerRoot = cc.getPSDataDir() + File.separator + "searchservers" + File.separator + this.searchServerID;
        this.databases = new ArrayList();
    }

    public ArrayList getAll() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                ArrayList result = (ArrayList)msc.getAttribute(this.objectName, "All");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        try {
            this.syncDatabase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int index = 0; index < this.databases.size(); ++index) {
            SOIF s = (SOIF)this.databases.get(index);
            result.add(s.getURL());
        }
        return result;
    }

    public Properties getAttributes(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                Properties result = (Properties)msc.invoke(this.objectName, "getAttributes", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.syncDatabase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        Properties p = new Properties();
        for (int index = 0; index < this.databases.size(); ++index) {
            SOIF s = (SOIF)this.databases.get(index);
            if (!s.getURL().equals(name)) continue;
            String[] array = s.getAttributesArray();
            for (int i = 0; i < array.length; ++i) {
                String key;
                String value = s.getValue(key = array[i]);
                p.setProperty(key, value != null ? value : null);
            }
        }
        return p;
    }

    public void setAttributes(String name, Properties attributes) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, attributes};
                String[] signatures = new String[]{"java.lang.String", "java.util.Properties"};
                msc.invoke(this.objectName, "setAttributes", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (attributes == null) {
            String message = "No database attributes specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.syncDatabase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        try {
            for (int index = 0; index < this.databases.size(); ++index) {
                String key;
                SOIF s = (SOIF)this.databases.get(index);
                if (!s.getURL().equals(name)) continue;
                String[] array = s.getAttributesArray();
                for (int i = 0; i < array.length; ++i) {
                    key = array[i];
                    if (attributes.containsKey(key)) continue;
                    s.remove(key);
                }
                Enumeration<?> e = attributes.propertyNames();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    String value = attributes.getProperty(key);
                    if (s.contains(key)) {
                        s.replace(key, value);
                        continue;
                    }
                    s.insert(key, value);
                }
                String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "database." + Long.toString(System.currentTimeMillis());
                SOIFOutputStream os = new SOIFOutputStream(fileName);
                os.write(s);
                os.close();
                Process p = this.execute("rdmgr -D -y root -q " + fileName);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue == 0) continue;
                String message = "Updating database description for " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void deleteAttributes(String name, List attributes) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, attributes};
                String[] signatures = new String[]{"java.lang.String", "java.util.List"};
                msc.invoke(this.objectName, "deleteAttributes", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (attributes == null) {
            String message = "No database attributes specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.syncDatabase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        try {
            for (int index1 = 0; index1 < this.databases.size(); ++index1) {
                SOIF s = (SOIF)this.databases.get(index1);
                if (!s.getURL().equals(name)) continue;
                for (int index2 = 0; index2 < attributes.size(); ++index2) {
                    String key = (String)attributes.get(index2);
                    if (!s.contains(key)) continue;
                    s.remove(key);
                }
                String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "database." + Long.toString(System.currentTimeMillis());
                SOIFOutputStream os = new SOIFOutputStream(fileName);
                os.write(s);
                os.close();
                Process p = this.execute("rdmgr -D -y root -q " + fileName);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue == 0) continue;
                String message = "Updating database description for " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void create(String name, Properties attributes) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, attributes};
                String[] signatures = new String[]{"java.lang.String", "java.util.Properties"};
                msc.invoke(this.objectName, "create", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (attributes == null) {
            attributes = new Properties();
        }
        if (!this.validateName(name)) {
            String message = "Invalid database name - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.syncDatabase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
        for (int index = 0; index < this.databases.size(); ++index) {
            SOIF s = (SOIF)this.databases.get(index);
            if (s.getURL().compareToIgnoreCase(name) != 0) continue;
            String message = "Database already exists - " + name;
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            Process p = this.execute("rdmgr -y " + name + " -n");
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                String message = "Creating database " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
            SOIF s = new SOIF("Database", name);
            Enumeration<?> e = attributes.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = attributes.getProperty(key);
                if (s.contains(key)) {
                    s.replace(key, value);
                    continue;
                }
                s.insert(key, value);
            }
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "database." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream os = new SOIFOutputStream(fileName);
            os.write(s);
            os.close();
            p = this.execute("rdmgr -D -y root -m -q " + fileName);
            p.waitFor();
            exitValue = p.exitValue();
            if (exitValue != 0) {
                String message = "Creating database " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void reindex(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                msc.invoke(this.objectName, "reindex", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            Process p = this.execute("rdmgr -I -p stdout -y " + name);
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                String message = "Reindexing database " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void purge(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                msc.invoke(this.objectName, "purge", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            Process p = this.execute("rdmgr -X -p stdout -y " + name);
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                String message = "Purging database " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public void expire(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                msc.invoke(this.objectName, "expire", params, signatures);
                jmxc.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            Process p = this.execute("rdmgr -E -p stdout -y " + name);
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                String message = "Expiring database " + name + " failed with " + exitValue;
                Object[] tokens = new Object[]{message};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                throw new PSMBeanException("PSALI_CSPACCSH0001");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    public ArrayList getStatistics(String name, Boolean refresh) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name, refresh};
                String[] signatures = new String[]{"java.lang.String", "java.lang.Boolean"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getStatistics", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        if (refresh == null) {
            refresh = new Boolean(false);
        }
        Hashtable protocols = new Hashtable();
        protocols.clear();
        Hashtable servers = new Hashtable();
        servers.clear();
        Date date = null;
        if (refresh.booleanValue()) {
            try {
                date = this.statisticsFromDatabase(name, protocols, servers);
                this.saveStatistics(name, protocols, servers, date);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        try {
            date = this.statisticsFromFile(name, protocols, servers);
        }
        catch (Exception e1) {
            try {
                date = this.statisticsFromDatabase(name, protocols, servers);
                this.saveStatistics(name, protocols, servers, date);
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e2);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e2.toString(), (Throwable)e2);
            }
        }
        ArrayList<Cloneable> result = new ArrayList<Cloneable>();
        result.add(0, date);
        result.add(1, protocols);
        result.add(2, servers);
        return result;
    }

    public Boolean isStatisticsOld(String name) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{name};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "isStatisticsOld", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
            }
        }
        if (name == null) {
            String message = "No database name specified";
            Object[] tokens = new Object[]{message};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            throw new PSMBeanException("PSALI_CSPACCSH0001");
        }
        try {
            this.syncDatabase();
            for (int index = 0; index < this.databases.size(); ++index) {
                SOIF s = (SOIF)this.databases.get(index);
                if (s.getURL().compareToIgnoreCase(name) != 0) continue;
                String lastModified = s.getValue("DbStat-LastModified");
                if (lastModified == null) {
                    return new Boolean(false);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                sdf.setLenient(true);
                Date d = sdf.parse(lastModified);
                File f = new File(this.searchServerRoot + File.separator + "db" + File.separator + name + File.separator + "AL");
                if (f.exists()) {
                    if (d.before(new Date(f.lastModified()))) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            return new Boolean(true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("PSALI_CSPACCSH0001", e.toString(), (Throwable)e);
        }
    }

    private Date statisticsFromFile(String name, Hashtable protocols, Hashtable servers) throws Exception {
        this.syncDatabase();
        for (int index = 0; index < this.databases.size(); ++index) {
            int i;
            SOIF s = (SOIF)this.databases.get(index);
            if (s.getURL().compareToIgnoreCase(name) != 0) continue;
            int count = Integer.parseInt(s.getValue("DbStat-NbServer"));
            for (i = 0; i < count; ++i) {
                servers.put(s.getValue("DbStat-Href", i), s.getValue("DbStat-Href-count", i));
            }
            count = Integer.parseInt(s.getValue("DbStat-NbProtocol"));
            for (i = 0; i < count; ++i) {
                protocols.put(s.getValue("DbStat-Protocol", i), s.getValue("DbStat-Protocol-count", i));
            }
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
            sdf.setLenient(true);
            return sdf.parse(s.getValue("DbStat-LastModified"));
        }
        return new Date();
    }

    private Date statisticsFromDatabase(String name, Hashtable protocols, Hashtable servers) throws Exception {
        String line;
        Process p = this.execute("rdmgr -L -a url -y " + name);
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = br.readLine()) != null) {
            URL url = null;
            try {
                url = new URL(line);
            }
            catch (MalformedURLException murle) {
                url = null;
            }
            if (url != null) {
                String protocol = url.getProtocol();
                if (protocols.containsKey(protocol)) {
                    int count = Integer.parseInt((String)protocols.get(protocol));
                    protocols.remove(protocol);
                    protocols.put(protocol, Integer.toString(count + 1));
                } else {
                    protocols.put(protocol, "1");
                }
                String server = protocol + "://" + url.getHost() + ":" + Integer.toString(url.getPort()) + "/";
                if (servers.containsKey(server)) {
                    int count = Integer.parseInt((String)servers.get(server));
                    servers.remove(server);
                    servers.put(server, Integer.toString(count + 1));
                    continue;
                }
                servers.put(server, "1");
                continue;
            }
            if (line == null) continue;
            if (line.startsWith("comment")) {
                if (protocols.containsKey("discussions")) {
                    int count = Integer.parseInt((String)protocols.get("discussions"));
                    protocols.remove("discussions");
                    protocols.put("discussions", Integer.toString(count + 1));
                    continue;
                }
                protocols.put("discussions", "1");
                continue;
            }
            if (protocols.containsKey("other")) {
                int count = Integer.parseInt((String)protocols.get("other"));
                protocols.remove("other");
                protocols.put("other", Integer.toString(count + 1));
                continue;
            }
            protocols.put("other", "1");
        }
        return new Date();
    }

    private void saveStatistics(String name, Hashtable protocols, Hashtable servers, Date date) throws Exception {
        this.syncDatabase();
        for (int index = 0; index < this.databases.size(); ++index) {
            int i;
            int i2;
            int total;
            SOIF s = (SOIF)this.databases.get(index);
            if (s.getURL().compareToIgnoreCase(name) != 0) continue;
            String str = s.getValue("DbStat-NbServer");
            if (str != null) {
                total = Integer.parseInt(str);
                for (i2 = 0; i2 < total; ++i2) {
                    s.remove("DbStat-Href-count", i2);
                    s.remove("DbStat-Href", i2);
                }
            }
            if ((str = s.getValue("DbStat-NbProtocol")) != null) {
                total = Integer.parseInt(str);
                for (i2 = 0; i2 < total; ++i2) {
                    s.remove("DbStat-Protocol-count", i2);
                    s.remove("DbStat-Protocol", i2);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
            s.replace("DbStat-LastModified", date != null ? sdf.format(date) : sdf.format(new Date()));
            s.replace("DbStat-NbServer", servers != null ? Integer.toString(servers.size()) : Integer.toString(0));
            s.replace("DbStat-NbProtocol", protocols != null ? Integer.toString(protocols.size()) : Integer.toString(0));
            if (servers != null) {
                Enumeration<Object> e = servers.keys();
                i = 0;
                while (e.hasMoreElements()) {
                    s.insert("DbStat-Href", (String)e.nextElement(), i++);
                }
                e = servers.elements();
                i = 0;
                while (e.hasMoreElements()) {
                    s.insert("DbStat-Href-count", (String)e.nextElement(), i++);
                }
            }
            if (protocols != null) {
                Enumeration<Object> e = protocols.keys();
                i = 0;
                while (e.hasMoreElements()) {
                    s.insert("DbStat-Protocol", (String)e.nextElement(), i++);
                }
                e = protocols.elements();
                i = 0;
                while (e.hasMoreElements()) {
                    s.insert("DbStat-Protocol-count", (String)e.nextElement(), i++);
                }
            }
            String fileName = this.searchServerRoot + File.separator + "tmp" + File.separator + "database." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream os = new SOIFOutputStream(fileName);
            os.write(s);
            os.close();
            Process p = this.execute("rdmgr -D -y root -u -P -q " + fileName);
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue == 0) continue;
            throw new Exception("Storing statistics for " + name + " failed with " + exitValue);
        }
    }

    private void syncDatabase() throws Exception {
        String fileName;
        File f;
        boolean needUpdate = true;
        if (this.lastUpdated != null && (f = new File(fileName = this.searchServerRoot + File.separator + "db" + File.separator + "root" + File.separator + "rd.db")).exists() && this.lastUpdated.after(new Date(f.lastModified()))) {
            needUpdate = false;
        }
        if (needUpdate) {
            this.databases = new ArrayList();
            Process p = this.execute("rdmgr -y root -U");
            SOIFInputStream is = new SOIFInputStream(p.getInputStream(), "UTF-8");
            while (!is.isEOS()) {
                SOIF s = is.readSOIF();
                if (s == null || s.getURL().equals("root")) continue;
                this.databases.add(s);
            }
            this.lastUpdated = new Date();
        }
    }

    private Process execute(String options) throws Exception {
        String command = this.searchServerRoot + File.separator + (this.isWindows() ? "run-cs-cli.bat" : "run-cs-cli") + " " + options;
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(command);
        return p;
    }

    private boolean validateName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] c = name.toCharArray();
        for (int index = 0; index < c.length; ++index) {
            if (c[index] >= 'a' && c[index] <= 'z' || c[index] >= 'A' && c[index] <= 'Z' || c[index] >= '0' || c[index] <= '9' || c[index] == '_' || c[index] == '-') continue;
            return false;
        }
        return true;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

