/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.CategoryMBean;
import com.sun.portal.search.admin.mbeans.tasks.ClassConfig;
import com.sun.portal.search.admin.mbeans.tasks.Rule;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.demo.Search;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFException;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class Category
extends PSResource
implements CategoryMBean {
    private ObjectName objectName = null;
    private String host = null;
    private String configDir = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$Category == null ? (class$com$sun$portal$search$admin$mbeans$Category = Category.class$("com.sun.portal.search.admin.mbeans.Category")) : class$com$sun$portal$search$admin$mbeans$Category));
    private RDMTaxonomy tax = null;
    private RDMClassification root = null;
    private boolean modified;
    private long lastModified;
    private Date lastActionDate;
    private String serverRoot = null;
    private String tax_conf_file = null;
    private Search search = null;
    public static String TAXONOMY_CONF = "taxonomy-description";
    private ClassConfig classConfig = null;
    private String class_conf_file = null;
    private long classLastModified;
    public static String CLASSIFICATION_CONF = "classification.conf";
    public static String[] classmethod = new String[]{"is", "contains", "begins with", "ends with", "regular"};
    public static String[] classmethod_string = new String[]{"by-exact", "by-substr", "by-prefix", "by-suffix", "by-regex"};
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$Category;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer.Category", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer.Category", path, "Host");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        this.search = new Search();
        try {
            if (AdminUtil.isLocal((String)this.host)) {
                Object[] tokens;
                MBeanServer ms = PASModule.getMBeanServer();
                LinkedList serverpath = new LinkedList();
                serverpath.addFirst(path.get(2));
                serverpath.addFirst(path.get(1));
                ObjectName searchServer = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
                this.serverRoot = (String)ms.getAttribute(searchServer, "SearchServerRoot");
                if (this.serverRoot == null) {
                    tokens = new Object[]{"Category.init(): failed to get search server root directory"};
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                }
                this.configDir = (String)ms.getAttribute(searchServer, "ConfigDir");
                if (this.configDir == null) {
                    tokens = new Object[]{"Category.init(): failed to get search server config directory"};
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                    this.configDir = this.serverRoot + File.separator + "config";
                }
                this.class_conf_file = this.configDir + File.separator + CLASSIFICATION_CONF;
                this.classConfig = new ClassConfig(this.class_conf_file);
                this.setClassLastModified();
                Object[] params = new Object[]{TAXONOMY_CONF};
                String[] signature = new String[]{"java.lang.String"};
                this.tax_conf_file = (String)ms.invoke(searchServer, "getConfigValue", params, signature);
                if (this.tax_conf_file == null) {
                    Object[] tokens2 = new Object[]{"Category.init(): failed to get search server taxonomy file name"};
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens2);
                } else {
                    this.load();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public ArrayList listClassRules(String ruleID) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ruleID};
                String[] signatures = new String[]{"java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "listClassRules", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:listClassRules", e.toString(), (Throwable)e);
            }
        }
        ArrayList classlist = new ArrayList();
        ArrayList rules = this.classConfig.getRulesList();
        int n = rules.size();
        if (ruleID == null || ruleID.equals("")) {
            for (int i = 0; i < n; ++i) {
                Rule rule = (Rule)rules.get(i);
                HashMap<String, Object> rmap = new HashMap<String, Object>();
                rmap.put("Source", rule.getSrc());
                rmap.put("Method", this.getMethodLabel(rule.getMethod()));
                rmap.put("Criterion", rule.getName());
                rmap.put("Classification", rule.getAction());
                rmap.put("CaseSensitive", rule.isCaseSensitive());
                classlist.add(rmap);
            }
        } else {
            int id = Integer.parseInt(ruleID);
            if (id < 0 || id > this.classConfig.getRulesList().size()) {
                return null;
            }
            Rule rule = (Rule)rules.get(id);
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("Source", rule.getSrc());
            rmap.put("Method", this.getMethodLabel(rule.getMethod()));
            rmap.put("Criterion", rule.getName());
            rmap.put("Classification", rule.getAction());
            rmap.put("CaseSensitive", rule.isCaseSensitive());
            classlist.add(rmap);
        }
        return classlist;
    }

    public Boolean createClassRule(String source, String method_label, String criterion, String category, Boolean isCase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{source, method_label, criterion, category, isCase};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "createClassRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:createClassRule", e.toString(), (Throwable)e);
            }
        }
        String method = this.getMethodString(method_label);
        if (this.classConfig.isExist(source, method, criterion, category)) {
            return Boolean.FALSE;
        }
        boolean iscase = isCase;
        if (this.classConfig.add(source, method, criterion, category, iscase)) {
            this.classConfig.save();
            this.setClassLastModified();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean deleteClassRules(ArrayList ids) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ids};
                String[] signatures = new String[]{"java.util.ArrayList"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteClassRules", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:deleteClassRules", e.toString(), (Throwable)e);
            }
        }
        if (ids != null) {
            for (int i = 0; i < ids.size(); ++i) {
                String ruleId = (String)ids.get(i);
                int id = Integer.parseInt(ruleId);
                if (id < 0 || id >= this.classConfig.getRulesList().size()) continue;
                this.classConfig.delete(id);
            }
            this.classConfig.save();
            this.setClassLastModified();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean deleteClassRule(String ruleId) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ruleId};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteClassRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:deleteClassRule", e.toString(), (Throwable)e);
            }
        }
        int id = Integer.parseInt(ruleId);
        if (id < 0 || id > this.classConfig.getRulesList().size()) {
            return Boolean.FALSE;
        }
        this.classConfig.delete(id);
        this.classConfig.save();
        this.setClassLastModified();
        return Boolean.TRUE;
    }

    public Boolean editClassRule(String ruleId, String source, String method_label, String criterion, String category, Boolean isCase) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{ruleId, source, method_label, criterion, category, isCase};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "editClassRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:editClassRule", e.toString(), (Throwable)e);
            }
        }
        int id = Integer.parseInt(ruleId);
        if (id < 0 || id > this.classConfig.getRulesList().size()) {
            return Boolean.FALSE;
        }
        String method = this.getMethodString(method_label);
        if (this.classConfig.isExist(source, method, criterion, category, id)) {
            return Boolean.FALSE;
        }
        if (isCase == null) {
            isCase = Boolean.TRUE;
        }
        boolean iscase = isCase;
        this.classConfig.update(id, source, method, criterion, category, iscase);
        this.classConfig.save();
        this.setClassLastModified();
        return Boolean.TRUE;
    }

    public Boolean syncClassConfig() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "syncClassConfig", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        try {
            File f = new File(this.class_conf_file);
            if (this.classLastModified != 0L && this.classLastModified < f.lastModified()) {
                this.classConfig = new ClassConfig(this.class_conf_file);
                this.classLastModified = f.lastModified();
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("Failed to verify the current time stamp of the classification.conf file.", "Category.syncClassConfig()", (Throwable)e);
        }
    }

    public Boolean existClassRule(String source, String method_label, String criterion, String category) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{source, method_label, criterion, category};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "existClassRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        String method = this.getMethodString(method_label);
        if (this.classConfig.isExist(source, method, criterion, category)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean existClassRule(String source, String method_label, String criterion, String category, String ruleID) throws UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{source, method_label, criterion, category, ruleID};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "existClassRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                return Boolean.FALSE;
            }
        }
        int exceptindex = Integer.parseInt(ruleID);
        String method = this.getMethodString(method_label);
        if (this.classConfig.isExist(source, method, criterion, category, exceptindex)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getMethodString(String label) {
        int methodIndex = 0;
        for (int i = 0; i < classmethod.length; ++i) {
            if (!label.equalsIgnoreCase(classmethod[i])) continue;
            methodIndex = i;
        }
        return classmethod_string[methodIndex];
    }

    public String getMethodLabel(String methodstring) {
        int methodIndex = 0;
        for (int i = 0; i < classmethod_string.length; ++i) {
            if (!methodstring.equalsIgnoreCase(classmethod_string[i])) continue;
            methodIndex = i;
        }
        return classmethod[methodIndex];
    }

    private void setClassLastModified() throws PSMBeanException {
        try {
            File f = new File(this.class_conf_file);
            this.classLastModified = f.lastModified();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("Failed to verify the current time stamp of the classification.conf file.", "Category.setClassLastModified()", (Throwable)e);
        }
    }

    public void load() {
        try {
            SOIFInputStream ss = new SOIFInputStream(this.tax_conf_file, "UTF-8");
            this.tax = new RDMTaxonomy(ss);
            if (this.tax == null) {
                this.root = null;
                Object[] tokens = new Object[]{"Category.init(): failed to load taxonomy"};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            } else {
                this.root = this.tax.find("ROOT");
                if (this.root == null) {
                    Object[] tokens = new Object[]{"Category.init(): failed to find the root category in the taxonomy"};
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
                }
                this.setTimeStamp();
            }
        }
        catch (FileNotFoundException fnf) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", fnf);
        }
        catch (UnsupportedEncodingException ue) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", ue);
        }
        catch (SOIFException se) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", se);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public RDMClassification getTaxTreeRoot() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                RDMClassification result = (RDMClassification)msc.getAttribute(this.objectName, "TaxTreeRoot");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeRoot", e.toString(), (Throwable)e);
            }
        }
        return this.root;
    }

    public RDMClassification getTaxTreeNode(String nodeID) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeID};
                String[] signatures = new String[]{"java.lang.String"};
                RDMClassification result = (RDMClassification)msc.invoke(this.objectName, "getTaxTreeNode", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeNode", e.toString(), (Throwable)e);
            }
        }
        try {
            RDMClassification rc = this.tax.find(nodeID);
            return rc;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return null;
        }
    }

    public String getTaxName() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "TaxName");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxName", e.toString(), (Throwable)e);
            }
        }
        try {
            return this.getTaxTreeNodeName("ROOT");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.tax.name");
        }
    }

    public String getTaxDesc() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "TaxDesc");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxDesc", e.toString(), (Throwable)e);
            }
        }
        if (this.tax != null) {
            return this.tax.getDescription();
        }
        return null;
    }

    public String getTaxTreeRootName() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "TaxTreeRootName");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeRootName", e.toString(), (Throwable)e);
            }
        }
        if (this.root != null) {
            return this.root.getId();
        }
        return null;
    }

    public String getTaxTreeNodeName(String nodeId) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeId};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getTaxTreeNodeName", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeNodeName", e.toString(), (Throwable)e);
            }
        }
        RDMClassification node = this.tax.find(nodeId);
        try {
            if (node != null) {
                if (node.getParent() == null) {
                    return this.tax.getId();
                }
                return node.getId();
            }
            Object[] tokens = new Object[]{"Category.getTaxTreeNodeName(): can't find the node in the taxonomy tree"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.node", "Category.getTaxTreeNodeName()", (Throwable)e);
        }
    }

    public String getTaxTreeNodeDesc(String nodeId) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeId};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getTaxTreeNodeDesc", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeNodeDesc", e.toString(), (Throwable)e);
            }
        }
        RDMClassification node = this.tax.find(nodeId);
        try {
            if (node != null) {
                if (node == this.root) {
                    return this.tax.getDescription();
                }
                return node.getDescription();
            }
            Object[] tokens = new Object[]{"Category.getTaxTreeNodeDesc(): can't find the node in the taxonomy tree"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.node", "Category.getTaxTreeNodeDesc()", (Throwable)e);
        }
    }

    public String getTaxTreeNodeRule(String nodeId) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeId};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getTaxTreeNodeRule", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeNodeRule", e.toString(), (Throwable)e);
            }
        }
        RDMClassification node = this.tax.find(nodeId);
        try {
            if (node != null) {
                if (node == this.root) {
                    return null;
                }
                return node.getMatchingRule();
            }
            Object[] tokens = new Object[]{"Category.getTaxTreeNodeRule(): can't find the node in the taxonomy tree"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.node", "Category.getTaxTreeNodeRule()", (Throwable)e);
        }
    }

    public ArrayList getTaxTreeDescendance(String parentID) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{parentID};
                String[] signatures = new String[]{"java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getTaxTreeDescendance", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeDescendance", e.toString(), (Throwable)e);
            }
        }
        if (parentID == null) {
            Object[] tokens = new Object[]{"Category.getTaxTreeDescendance(): can't get the descendance because the node is null"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        try {
            RDMClassification node = parentID.equalsIgnoreCase("root") ? this.root : this.tax.find(parentID);
            ArrayList descendance = new ArrayList();
            this.getDescendance(node, descendance);
            return descendance;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.descendance", "Category.getTaxTreeDescendance()", (Throwable)e);
        }
    }

    public ArrayList getTaxTreeChildren(String nodeID) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeID};
                String[] signatures = new String[]{"java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getTaxTreeChildren", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:getTaxTreeChildren", e.toString(), (Throwable)e);
            }
        }
        if (nodeID == null) {
            Object[] tokens = new Object[]{"Category.getTaxTreeChildren(): can't get the children nodes because the node is null"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return null;
        }
        ArrayList<String> children = new ArrayList<String>();
        try {
            RDMClassification parent = this.tax.find(nodeID);
            List childs = parent.getChildren();
            if (childs == null) {
                return children;
            }
            for (int i = 0; i < childs.size(); ++i) {
                RDMClassification childRc = (RDMClassification)childs.get(i);
                children.add(childRc.getId());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.children", "Category.getTaxTreeChildren()", (Throwable)e);
        }
        return children;
    }

    public Boolean deleteTaxTreeNode(String nodeID) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeID};
                String[] signatures = new String[]{"java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "deleteTaxTreeNode", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:deleteTaxTreeNode", e.toString(), (Throwable)e);
            }
        }
        try {
            RDMClassification node = this.tax.find(nodeID);
            RDMClassification parent = node.getParent();
            if (parent != null) {
                int nodeNbDescendant = node.getNumDescendant();
                int parentNbChildren = parent.nChildren();
                int childIndex = parent.getChildren().indexOf(node);
                parent.getChildren().remove(childIndex);
                Collections.sort(parent.getChildren());
                boolean i = false;
                for (RDMClassification asc = parent; asc != null; asc = asc.getParent()) {
                    int cur = asc.getNumDescendant();
                    asc.setNumDescendant(cur - (nodeNbDescendant + 1));
                }
            } else {
                try {
                    this.tax = new RDMTaxonomy("Search");
                    this.root = this.tax.find("ROOT");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                    throw new PSMBeanException("errorcode.search.category.taxtree.delete", "Category.deleteTaxTreeNode()", (Throwable)e);
                }
            }
            this.save();
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.delete.default", "Category.deleteTaxTreeNode()", (Throwable)e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.delete", "Category.deleteTaxTreeNode()", (Throwable)e);
        }
        this.modified = true;
        return Boolean.TRUE;
    }

    public Boolean insertTaxTreeChildNode(String parentId, String childId, String childDesc, String childRule) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{parentId, childId, childDesc, childRule};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "insertTaxTreeChildNode", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:insertTaxTreeChildNode", e.toString(), (Throwable)e);
            }
        }
        if (childDesc == null) {
            childDesc = "";
        }
        if (childRule == null) {
            childRule = "";
        }
        try {
            if (this.tax == null) {
                throw new PSMBeanException("errorcode.search.category.taxtree.insert");
            }
            RDMClassification nodeTax = this.tax.find(parentId);
            this.insertChildNode(nodeTax, childId, childDesc, childRule);
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.insert.default", "Category.insertTaxTreeChildNode()", (Throwable)e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.insert", "Category.insertTaxTreeChildNode()", (Throwable)e);
        }
        this.modified = true;
        return Boolean.TRUE;
    }

    public Boolean insertTaxTreeSiblingNode(String nodeId, String siblingId, String siblingDesc, String siblingRule) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{nodeId, siblingId, siblingDesc, siblingRule};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "insertTaxTreeSiblingNode", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:insertTaxTreeSiblingNode", e.toString(), (Throwable)e);
            }
        }
        try {
            if (this.tax == null) {
                throw new PSMBeanException("errorcode.search.category.taxtree.insert");
            }
            RDMClassification nodeTax = this.tax.find(nodeId).getParent();
            this.insertChildNode(nodeTax, siblingId, siblingDesc, siblingRule);
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.insert.default", "Category.insertTaxTreeSilbingNode()", (Throwable)e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.category.taxtree.insert", "Category.insertTaxTreeSilbingNode()", (Throwable)e);
        }
        this.modified = true;
        return Boolean.TRUE;
    }

    public Boolean updateTaxTreeNode(String currentId, String newId, String newDesc, String newRule) throws PSMBeanException, UnknownHostException {
        block16: {
            if (!AdminUtil.isLocal((String)this.host)) {
                try {
                    JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                    MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                    Object[] params = new Object[]{currentId, newId, newDesc, newRule};
                    String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                    Boolean result = (Boolean)msc.invoke(this.objectName, "updateTaxTreeNode", params, signatures);
                    jmxc.close();
                    return result;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                    throw new PSMBeanException("Category:updateTaxTreeNode", e.toString(), (Throwable)e);
                }
            }
            try {
                if (newId.trim() != "") {
                    RDMClassification node = this.tax.find(currentId);
                    StringBuffer sb = new StringBuffer();
                    if (node.getParentId() == null) {
                        this.updateTaxonomy(newId, newDesc);
                    } else {
                        if (node.getParent() == this.root && (newId.equals(this.tax.getId()) || newId.equals("ROOT"))) {
                            if (newId.equals("ROOT")) {
                                throw new PSMBeanException("errorcode.search.category.taxtree.rootchild");
                            }
                            throw new PSMBeanException("errorcode.search.category.taxtree.differfromtax");
                        }
                        if (currentId.indexOf(58) != -1) {
                            sb.append(currentId.substring(0, currentId.lastIndexOf(":")));
                            sb.append(":" + newId);
                        } else {
                            sb.append(newId);
                        }
                        boolean reject = false;
                        if (!newId.equals(this.lastNode(currentId))) {
                            RDMClassification parentRc = node.getParent();
                            for (int i = 0; i < parentRc.nChildren(); ++i) {
                                if (!parentRc.nthChild(i).getId().equals(sb.toString())) continue;
                                reject = true;
                                break;
                            }
                        }
                        if (reject) {
                            throw new PSMBeanException("errorcode.search.category.taxtree.update.newexist");
                        }
                        node.setSubcategory(sb.toString());
                        this.recurseUpdateNode(node, currentId, sb.toString());
                        node.setDescription(newDesc);
                        node.setMatchingRule(newRule);
                        this.save();
                    }
                    break block16;
                }
                throw new PSMBeanException("errorcode.search.category.taxtree.update");
            }
            catch (NullPointerException npe) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", npe);
                throw new PSMBeanException("errorcode.search.category.taxtree.update.default", "Category.updateTaxTreeNode()", (Throwable)npe);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("errorcode.search.category.taxtree.update", "Category.updateTaxTreeNode()", (Throwable)e);
            }
        }
        this.modified = true;
        return Boolean.TRUE;
    }

    public ArrayList searchTaxTree(String searchserver, String query, String numOfHits, String scope) throws PSMBeanException, UnknownHostException {
        ArrayList<String> results;
        block10: {
            if (!AdminUtil.isLocal((String)this.host)) {
                try {
                    JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                    MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                    Object[] params = new Object[]{searchserver, query, numOfHits, scope};
                    String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
                    ArrayList result = (ArrayList)msc.invoke(this.objectName, "searchTaxTree", params, signatures);
                    jmxc.close();
                    return result;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                    throw new PSMBeanException("Category:searchTaxTree", e.toString(), (Throwable)e);
                }
            }
            results = new ArrayList<String>();
            int count = 0;
            int hits = Integer.parseInt(numOfHits);
            try {
                this.search.setRDMServer(searchserver);
                this.search.setQueryLanguage("search");
                this.search.setRDMType("taxonomy-request");
                this.search.setViewAttributes("id");
                this.search.setViewHits(hits);
                if (scope == null || scope.equals("") || scope.equalsIgnoreCase("all")) {
                    this.search.setScope("category <contains> (<or> " + query + ") <and> (<or> " + query + ")");
                } else {
                    this.search.setScope("category <contains> (<or> " + query + ") <and> (Id <starts> " + scope + ":)");
                }
                this.search.doQuery();
                SOIFInputStream sr = this.search.getResultStream();
                if (sr == null) break block10;
                while (!sr.isEOS()) {
                    SOIF se = sr.readSOIF();
                    if (se == null) continue;
                    String catId = se.getValue("Id");
                    results.add(catId);
                    if (++count != hits) continue;
                    break;
                }
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{"Category.searchTaxTree(): failed to read from SOIFInputStream"};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            }
            catch (NullPointerException npe) {
                Object[] tokens = new Object[]{"Category.searchTaxTree(): null pointer"};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            }
            catch (Exception e) {
                Object[] tokens = new Object[]{"Category.searchTaxTree(): failed to search the taxonomy for server " + searchserver};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            }
        }
        return results;
    }

    public String reindexTaxTree() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                String result = (String)msc.invoke(this.objectName, "reindexTaxTree", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:reindexTaxTree", e.toString(), (Throwable)e);
            }
        }
        String cmd = this.serverRoot + File.separator + "run-cs-cli rdmgr -I -T -p stdout";
        String output = "";
        Runtime rt = Runtime.getRuntime();
        try {
            Process process = rt.exec(cmd);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                output = output + " <BR> " + outLine;
            }
            process.waitFor();
        }
        catch (Exception e) {
            Object[] tokens = new Object[]{"Category.reindexTaxTree(): failed to reindex the taxonomy"};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
        }
        this.modified = false;
        return output;
    }

    public Boolean needReindex() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "needReindex", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:needReindex", e.toString(), (Throwable)e);
            }
        }
        if (this.modified) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isOutOfSync() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "isOutOfSync", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:isOutOfSync", e.toString(), (Throwable)e);
            }
        }
        if (this.isConfigNewer()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean syncTaxFile() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{};
                String[] signatures = new String[]{};
                Boolean result = (Boolean)msc.invoke(this.objectName, "syncTaxFile", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Category:syncTaxFile", e.toString(), (Throwable)e);
            }
        }
        if (this.isConfigNewer()) {
            this.load();
            this.modified = true;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void getDescendance(RDMClassification rc, ArrayList descendance) {
        for (int i = 0; i < rc.nChildren(); ++i) {
            RDMClassification childRc = rc.nthChild(i);
            descendance.add(childRc.getId());
            this.getDescendance(childRc, descendance);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertChildNode(RDMClassification rc, String childId, String childDesc, String childRule) throws Exception {
        try {
            String childAbsolutID = null;
            childAbsolutID = rc == this.root ? childId : rc.getId() + ":" + childId;
            if (rc == null) throw new Exception("Failed to add the category because of no parent category found in the taxonomy");
            if (rc == this.root && (childId.equals("ROOT") || childId.equals(this.tax.getId()))) {
                if (!childId.equals("ROOT")) throw new Exception("The taxonomy Name must differ from all top most Categories name");
                throw new Exception("ROOT is invalid classification name under the root of the taxonomy");
            }
            if (this.tax.find(childAbsolutID) != null) throw new Exception("Failed to add the category because it already exists in the taxonomy");
            RDMClassification newRc = this.newChild(rc, childId, childDesc, childRule, rc.getTaxonomyId());
            if (newRc == null) {
                throw new Exception("Failed to add the category. Cannot create it");
            }
            this.tax.insert(newRc);
            this.save();
            return;
        }
        catch (NullPointerException npe) {
            throw new Exception("Failed to insert the category due to a system error");
        }
    }

    public void updateTaxonomy(String newId, String newDesc) throws Exception {
        try {
            if (!newId.trim().equals("")) {
                boolean reject = false;
                for (int i = 0; i < this.root.nChildren(); ++i) {
                    if (!this.root.nthChild(i).getId().equals(newId)) continue;
                    reject = true;
                    break;
                }
                if (reject) {
                    throw new Exception("The top most Categories name must differ from the Taxonomy name");
                }
            } else {
                throw new Exception("The taxonomy name is blank");
            }
            this.recurseUpdateNodeTaxonomy(this.root, newId);
            this.tax.setId(newId);
            this.tax.setDescription(newDesc.trim());
            this.save();
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new Exception("Failed to update the category in the taxonomy due to a system error.");
        }
    }

    public void recurseUpdateNodeTaxonomy(RDMClassification rc, String newId) throws Exception {
        try {
            rc.setTaxonomyId(newId);
            for (int i = 0; i < rc.nChildren(); ++i) {
                this.recurseUpdateNodeTaxonomy(rc.nthChild(i), newId);
            }
        }
        catch (NullPointerException npe) {
            String rcStr = rc != null ? rc.getId() : "(rc is NULL)";
            throw new Exception("Cannot recursively update Taxonomy on children of category " + rcStr);
        }
    }

    public void recurseUpdateNode(RDMClassification node, String currentId, String newId) throws Exception {
        try {
            String parentId;
            String nodeId = node.getId();
            if (nodeId.startsWith(currentId)) {
                StringBuffer newNodeId = new StringBuffer(newId);
                String nodeIdSuffix = nodeId.substring(currentId.length());
                if (nodeIdSuffix.length() > 0) {
                    newNodeId.append(nodeIdSuffix);
                }
                node.setId(newNodeId.toString());
            }
            if ((parentId = node.getParentId()) != null && parentId.startsWith(currentId)) {
                StringBuffer newParentNodeId = new StringBuffer(newId);
                String parentNodeIdSuffix = parentId.substring(currentId.length());
                if (parentNodeIdSuffix.length() > 0) {
                    newParentNodeId.append(parentNodeIdSuffix);
                }
                node.setParentId(newParentNodeId.toString());
            }
            for (int i = 0; i < node.nChildren(); ++i) {
                this.recurseUpdateNode(node.nthChild(i), currentId, newId);
            }
        }
        catch (NullPointerException npe) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", npe);
            throw new Exception("Cannot recursivly update children of category " + currentId);
        }
    }

    public void save() {
        try {
            SOIFOutputStream sos = new SOIFOutputStream(this.tax_conf_file);
            sos.write(this.tax.getSOIF());
            sos.flush();
            this.write(sos);
            sos.flush();
            sos.close();
            if (!DBUtil.indexCategories(this.serverRoot)) {
                Object[] tokens = new Object[]{"Category.save(): failed to reindex categories"};
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            }
            this.setTimeStamp();
        }
        catch (FileNotFoundException fnf) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", fnf);
        }
        catch (UnsupportedEncodingException ue) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", ue);
        }
        catch (SOIFException se) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", se);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public void write(SOIFOutputStream ss) {
        this.write(ss, this.root);
    }

    private void write(SOIFOutputStream ss, RDMClassification rc) {
        try {
            Object sb = null;
            if (rc != this.root) {
                ss.write(rc.getSOIF());
            }
            if (rc.getNumDescendant() != 0) {
                for (int j = 0; j < rc.nChildren(); ++j) {
                    this.write(ss, rc.nthChild(j));
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", ioe);
        }
    }

    public String lastNode(String nodeID) {
        try {
            int ndx;
            String value = null;
            value = nodeID != null ? ((ndx = nodeID.lastIndexOf(58)) > 0 ? nodeID.substring(ndx + 1) : nodeID) : null;
            return value;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return null;
        }
    }

    public RDMClassification newChild(RDMClassification parent, String childId, String childDesc, String childRule, String taxonomyId) {
        try {
            if (childId.trim() != "") {
                String parentId = parent.getId();
                String newId = parentId.equals("ROOT") ? childId : parentId + ":" + childId;
                RDMClassification rc = new RDMClassification(newId);
                rc.setTaxonomyId(taxonomyId);
                rc.setParentId(parentId);
                rc.setDescription(childDesc);
                rc.setMatchingRule(childRule);
                return rc;
            }
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            return null;
        }
    }

    public boolean isConfigNewer() throws PSMBeanException, UnknownHostException {
        try {
            File f = new File(this.tax_conf_file);
            return this.getTimeStamp() != 0L && this.getTimeStamp() < f.lastModified();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("Failed to verify the current time stamp of the Taxonomy file.", "Category.isConfigNewer()", (Throwable)e);
        }
    }

    private long getTimeStamp() {
        return this.lastModified;
    }

    private void setTimeStamp() throws PSMBeanException, UnknownHostException {
        try {
            File f = new File(this.tax_conf_file);
            this.lastModified = f.lastModified();
            this.setLastActionDate(this.lastModified);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("Failed to verify the current time stamp of the Taxonomy file.", "Category.setTimeStamp()", (Throwable)e);
        }
    }

    public Date getLastActionDate() {
        return this.lastActionDate;
    }

    private void setLastActionDate(long d) {
        this.lastActionDate = new Date(d);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

